/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gregtech.api.enums.GT_Values;
import gregtech.api.util.GT_Recipe;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class GT_OverclockCalculator {
    private static final double LOG2 = Math.log(2.0);
    private long recipeVoltage = 0L;
    private long recipeAmperage = 1L;
    private long machineVoltage = 0L;
    private long machineAmperage = 1L;
    private int duration = 0;
    private int parallel = 1;
    private int recipeHeat = 0;
    private int machineHeat = 0;
    private int durationDecreasePerHeatOC = 2;
    private boolean heatOC;
    private boolean heatDiscount;
    private double heatDiscountExponent = 0.95;
    private double eutDiscount = 1.0;
    private double speedBoost = 1.0;
    private int eutIncreasePerOC = 2;
    private int durationDecreasePerOC = 1;
    private boolean oneTickDiscount;
    private boolean laserOC;
    private double laserOCPenalty = 0.3;
    private boolean amperageOC;
    private boolean limitOverclocks;
    private int maxOverclocks;
    private int overclockCount;
    private int heatOverclockCount;
    private Supplier<Double> durationUnderOneTickSupplier;
    private boolean noOverclock;
    private boolean calculated;
    private static final int HEAT_DISCOUNT_THRESHOLD = 900;
    private static final int HEAT_PERFECT_OVERCLOCK_THRESHOLD = 1800;

    public static GT_OverclockCalculator ofNoOverclock(@Nonnull GT_Recipe recipe) {
        return GT_OverclockCalculator.ofNoOverclock(recipe.mEUt, recipe.mDuration);
    }

    public static GT_OverclockCalculator ofNoOverclock(long eut, int duration) {
        return new GT_OverclockCalculator().setRecipeEUt(eut).setDuration(duration).setEUt(eut).setNoOverclock(true);
    }

    public GT_OverclockCalculator setRecipeEUt(long recipeEUt) {
        this.recipeVoltage = recipeEUt;
        return this;
    }

    public GT_OverclockCalculator setEUt(long machineVoltage) {
        this.machineVoltage = machineVoltage;
        return this;
    }

    public GT_OverclockCalculator setDuration(int duration) {
        this.duration = duration;
        return this;
    }

    public GT_OverclockCalculator setAmperage(long machineAmperage) {
        this.machineAmperage = machineAmperage;
        return this;
    }

    public GT_OverclockCalculator setRecipeAmperage(long recipeAmperage) {
        this.recipeAmperage = recipeAmperage;
        return this;
    }

    public GT_OverclockCalculator enablePerfectOC() {
        this.durationDecreasePerOC = 2;
        return this;
    }

    @Deprecated
    public GT_OverclockCalculator enableHeatOC() {
        return this.setHeatOC(true);
    }

    public GT_OverclockCalculator setHeatOC(boolean heatOC) {
        this.heatOC = heatOC;
        return this;
    }

    @Deprecated
    public GT_OverclockCalculator enableHeatDiscount() {
        return this.setHeatDiscount(true);
    }

    public GT_OverclockCalculator setHeatDiscount(boolean heatDiscount) {
        this.heatDiscount = heatDiscount;
        return this;
    }

    public GT_OverclockCalculator setRecipeHeat(int recipeHeat) {
        this.recipeHeat = recipeHeat;
        return this;
    }

    @Deprecated
    public GT_OverclockCalculator setMultiHeat(int machineHeat) {
        return this.setMachineHeat(machineHeat);
    }

    public GT_OverclockCalculator setMachineHeat(int machineHeat) {
        this.machineHeat = machineHeat;
        return this;
    }

    public GT_OverclockCalculator setEUtDiscount(float aEUtDiscount) {
        this.eutDiscount = aEUtDiscount;
        return this;
    }

    public GT_OverclockCalculator setSpeedBoost(float aSpeedBoost) {
        this.speedBoost = aSpeedBoost;
        return this;
    }

    public GT_OverclockCalculator setParallel(int aParallel) {
        this.parallel = aParallel;
        return this;
    }

    public GT_OverclockCalculator setHeatDiscountMultiplier(float heatDiscountExponent) {
        this.heatDiscountExponent = heatDiscountExponent;
        return this;
    }

    public GT_OverclockCalculator setHeatPerfectOC(int heatPerfectOC) {
        this.durationDecreasePerHeatOC = heatPerfectOC;
        return this;
    }

    public GT_OverclockCalculator setEUtIncreasePerOC(int aEUtIncreasePerOC) {
        this.eutIncreasePerOC = aEUtIncreasePerOC;
        return this;
    }

    public GT_OverclockCalculator setDurationDecreasePerOC(int durationDecreasePerOC) {
        this.durationDecreasePerOC = durationDecreasePerOC;
        return this;
    }

    @Deprecated
    public GT_OverclockCalculator enableOneTickDiscount() {
        return this.setOneTickDiscount(true);
    }

    public GT_OverclockCalculator setOneTickDiscount(boolean oneTickDiscount) {
        this.oneTickDiscount = oneTickDiscount;
        return this;
    }

    public GT_OverclockCalculator limitOverclockCount(int maxOverclocks) {
        this.limitOverclocks = true;
        this.maxOverclocks = maxOverclocks;
        return this;
    }

    public GT_OverclockCalculator setLaserOC(boolean laserOC) {
        this.laserOC = laserOC;
        return this;
    }

    public GT_OverclockCalculator setAmperageOC(boolean amperageOC) {
        this.amperageOC = amperageOC;
        return this;
    }

    public GT_OverclockCalculator setLaserOCPenalty(double laserOCPenalty) {
        this.laserOCPenalty = laserOCPenalty;
        return this;
    }

    public GT_OverclockCalculator setDurationUnderOneTickSupplier(Supplier<Double> supplier) {
        this.durationUnderOneTickSupplier = supplier;
        return this;
    }

    public GT_OverclockCalculator setNoOverclock(boolean noOverclock) {
        this.noOverclock = noOverclock;
        return this;
    }

    public GT_OverclockCalculator calculate() {
        if (this.calculated) {
            throw new IllegalStateException("Tried to calculate overclocks twice");
        }
        this.calculateOverclock();
        this.calculated = true;
        return this;
    }

    private void calculateOverclock() {
        if (this.noOverclock) {
            this.recipeVoltage = this.calculateFinalRecipeEUt(this.calculateHeatDiscountMultiplier());
            return;
        }
        if (this.laserOC && this.amperageOC) {
            throw new IllegalStateException("Tried to calculate overclock with both laser and amperage overclocking");
        }
        double heatDiscountMultiplier = this.calculateHeatDiscountMultiplier();
        this.duration = (int)Math.ceil((double)this.duration * this.speedBoost);
        if (this.heatOC) {
            this.heatOverclockCount = this.calculateAmountOfHeatOverclocks();
        }
        double recipePowerTier = this.calculateRecipePowerTier(heatDiscountMultiplier);
        double machinePowerTier = this.calculateMachinePowerTier();
        this.overclockCount = this.calculateAmountOfNeededOverclocks(machinePowerTier, recipePowerTier);
        if (this.recipeVoltage <= GT_Values.V[0]) {
            this.overclockCount = Math.min(this.overclockCount, this.calculateRecipeToMachineVoltageDifference());
        }
        if (this.overclockCount < 0) {
            this.recipeVoltage = Long.MAX_VALUE;
            this.duration = Integer.MAX_VALUE;
            return;
        }
        this.overclockCount = this.limitOverclocks ? Math.min(this.maxOverclocks, this.overclockCount) : this.overclockCount;
        this.heatOverclockCount = Math.min(this.heatOverclockCount, this.overclockCount);
        this.recipeVoltage <<= this.eutIncreasePerOC * this.overclockCount;
        this.duration >>= this.durationDecreasePerOC * (this.overclockCount - this.heatOverclockCount);
        this.duration >>= this.durationDecreasePerHeatOC * this.heatOverclockCount;
        if (this.oneTickDiscount) {
            this.recipeVoltage >>= this.durationDecreasePerOC * (int)(machinePowerTier - recipePowerTier - (double)this.overclockCount);
            if (this.recipeVoltage < 1L) {
                this.recipeVoltage = 1L;
            }
        }
        if (this.laserOC) {
            this.calculateLaserOC();
        }
        if (this.duration < 1) {
            this.duration = 1;
        }
        this.recipeVoltage = this.calculateFinalRecipeEUt(heatDiscountMultiplier);
    }

    private double calculateRecipePowerTier(double heatDiscountMultiplier) {
        return this.calculatePowerTier((double)(this.recipeVoltage * (long)this.parallel) * this.eutDiscount * heatDiscountMultiplier * (double)this.recipeAmperage);
    }

    private double calculateMachinePowerTier() {
        return this.calculatePowerTier(this.machineVoltage * (this.amperageOC ? this.machineAmperage : Math.min(this.machineAmperage, (long)this.parallel)));
    }

    private int calculateRecipeToMachineVoltageDifference() {
        return (int)(Math.ceil(this.calculatePowerTier(this.machineVoltage)) - Math.ceil(this.calculatePowerTier(this.recipeVoltage)));
    }

    private double calculatePowerTier(double voltage) {
        return 1.0 + Math.max(0.0, Math.log(voltage) / LOG2 - 5.0) / 2.0;
    }

    private long calculateFinalRecipeEUt(double heatDiscountMultiplier) {
        return (long)Math.ceil((double)this.recipeVoltage * this.eutDiscount * heatDiscountMultiplier * (double)this.parallel * (double)this.recipeAmperage);
    }

    private int calculateAmountOfHeatOverclocks() {
        return Math.min((this.machineHeat - this.recipeHeat) / 1800, this.calculateAmountOfOverclocks(this.calculateMachinePowerTier(), this.calculateRecipePowerTier(this.calculateHeatDiscountMultiplier())));
    }

    private int calculateAmountOfOverclocks(double machinePowerTier, double recipePowerTier) {
        return (int)(machinePowerTier - recipePowerTier);
    }

    private int calculateAmountOfNeededOverclocks(double machinePowerTier, double recipePowerTier) {
        return (int)Math.min((double)this.calculateAmountOfOverclocks(machinePowerTier, recipePowerTier), Math.log(this.duration) / Math.log(1 << this.durationDecreasePerOC));
    }

    private double calculateHeatDiscountMultiplier() {
        int heatDiscounts = this.heatDiscount ? (this.machineHeat - this.recipeHeat) / 900 : 0;
        return Math.pow(this.heatDiscountExponent, heatDiscounts);
    }

    private void calculateLaserOC() {
        long inputEut = this.machineVoltage * this.machineAmperage;
        double currentPenalty = (double)(1 << this.eutIncreasePerOC) + this.laserOCPenalty;
        while ((double)inputEut > (double)this.recipeVoltage * currentPenalty && (double)this.recipeVoltage * currentPenalty > 0.0 && this.duration > 1) {
            this.duration >>= this.durationDecreasePerOC;
            this.recipeVoltage = (long)((double)this.recipeVoltage * currentPenalty);
            currentPenalty += this.laserOCPenalty;
        }
    }

    public long getConsumption() {
        if (!this.calculated) {
            throw new IllegalStateException("Tried to get consumption before calculating");
        }
        return this.recipeVoltage;
    }

    public int getDuration() {
        if (!this.calculated) {
            throw new IllegalStateException("Tried to get duration before calculating");
        }
        return this.duration;
    }

    public int getPerformedOverclocks() {
        if (!this.calculated) {
            throw new IllegalStateException("Tried to get performed overclocks before calculating");
        }
        return this.overclockCount;
    }

    public double calculateDurationUnderOneTick() {
        if (this.durationUnderOneTickSupplier != null) {
            return this.durationUnderOneTickSupplier.get();
        }
        if (this.noOverclock) {
            return this.duration;
        }
        int normalOverclocks = this.calculateAmountOfOverclocks(this.calculateMachinePowerTier(), this.calculateRecipePowerTier(this.calculateHeatDiscountMultiplier()));
        normalOverclocks = this.limitOverclocks ? Math.min(normalOverclocks, this.maxOverclocks) : normalOverclocks;
        int heatOverclocks = Math.min(this.calculateAmountOfHeatOverclocks(), normalOverclocks);
        return (double)this.duration * this.speedBoost / (Math.pow(1 << this.durationDecreasePerOC, normalOverclocks - heatOverclocks) * Math.pow(1 << this.durationDecreasePerHeatOC, heatOverclocks));
    }

    public long calculateEUtConsumptionUnderOneTick(int originalMaxParallel, int currentParallel) {
        if (this.noOverclock) {
            return this.recipeVoltage;
        }
        double heatDiscountMultiplier = this.calculateHeatDiscountMultiplier();
        double parallelMultiplierFromOverclocks = (double)currentParallel / (double)originalMaxParallel;
        double amountOfParallelHeatOverclocks = Math.min(Math.log(parallelMultiplierFromOverclocks) / Math.log(1 << this.durationDecreasePerHeatOC), (double)this.calculateAmountOfHeatOverclocks());
        double amountOfParallelOverclocks = Math.log(parallelMultiplierFromOverclocks) / Math.log(1 << this.durationDecreasePerOC) - amountOfParallelHeatOverclocks * (double)(1 << this.durationDecreasePerHeatOC - this.durationDecreasePerOC);
        double machineTier = this.calculateMachinePowerTier();
        double recipeTier = this.calculateRecipePowerTier(heatDiscountMultiplier);
        double amountOfTotalOverclocks = this.calculateAmountOfOverclocks(machineTier, recipeTier);
        return (long)Math.ceil((double)this.recipeVoltage * Math.pow(1 << this.eutIncreasePerOC, amountOfParallelOverclocks + amountOfParallelHeatOverclocks) * Math.pow(1 << this.eutIncreasePerOC, amountOfTotalOverclocks - (amountOfParallelOverclocks + amountOfParallelHeatOverclocks)) * (double)originalMaxParallel * this.eutDiscount * (double)this.recipeAmperage * heatDiscountMultiplier);
    }
}

