/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.structure.AutoPlaceEnvironment;
import com.gtnewhorizon.structurelib.structure.IItemSource;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.IStructureElementChain;
import com.gtnewhorizon.structurelib.structure.IStructureElementNoPlacement;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizon.structurelib.util.ItemStackPredicate;
import gnu.trove.TIntCollection;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.set.hash.TIntHashSet;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.IGT_HatchAdder;
import gregtech.common.blocks.GT_Item_Machines;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class GT_HatchElementBuilder<T> {
    private IGT_HatchAdder<? super T> mAdder;
    private int mCasingIndex = -1;
    private int mDot = -1;
    private BiPredicate<? super T, ? super IGregTechTileEntity> mShouldSkip;
    private BiFunction<? super T, ItemStack, ? extends Predicate<ItemStack>> mHatchItemFilter;
    private Supplier<String> mHatchItemType;
    private Predicate<? super T> mReject;
    private boolean mCacheHint;
    private boolean mNoStop;
    private EnumSet<ForgeDirection> mDisallowedDirection = EnumSet.noneOf(ForgeDirection.class);

    private GT_HatchElementBuilder() {
    }

    public static <T> GT_HatchElementBuilder<T> builder() {
        return new GT_HatchElementBuilder<T>();
    }

    @SafeVarargs
    public final GT_HatchElementBuilder<T> anyOf(IHatchElement<? super T> ... elements) {
        if (elements == null || elements.length == 0) {
            throw new IllegalArgumentException();
        }
        return this.adder(Arrays.stream(elements).map(e -> e.adder().rebrand()).reduce(IGT_HatchAdder::orElse).get()).hatchClasses(Arrays.stream(elements).map(IHatchElement::mteClasses).flatMap(Collection::stream).collect(Collectors.toList())).cacheHint(() -> Arrays.stream(elements).map(IHatchElement::name).sorted().collect(Collectors.joining(" or ", "of type ", "")));
    }

    @SafeVarargs
    public final GT_HatchElementBuilder<T> atLeast(IHatchElement<? super T> ... elements) {
        if (elements == null || elements.length == 0) {
            throw new IllegalArgumentException();
        }
        return this.atLeast(Arrays.stream(elements).collect(Collectors.groupingBy(Function.identity(), LinkedHashMap::new, Collectors.counting())));
    }

    public final GT_HatchElementBuilder<T> atLeastList(List<IHatchElement<? super T>> elements) {
        if (elements == null || elements.isEmpty()) {
            throw new IllegalArgumentException();
        }
        return this.atLeast(elements.stream().collect(Collectors.groupingBy(Function.identity(), LinkedHashMap::new, Collectors.counting())));
    }

    public final GT_HatchElementBuilder<T> atLeast(Map<IHatchElement<? super T>, ? extends Number> elements) {
        if (elements == null || elements.isEmpty() || elements.containsKey(null) || elements.containsValue(null)) {
            throw new IllegalArgumentException();
        }
        List list = elements.keySet().stream().map(IHatchElement::mteClasses).flatMap(Collection::stream).collect(Collectors.toList());
        return this.adder(elements.keySet().stream().map(e -> e.adder().rebrand()).reduce(IGT_HatchAdder::orElse).orElseThrow(AssertionError::new)).hatchItemFilter((? super T obj) -> GT_StructureUtility.filterByMTEClass(elements.entrySet().stream().filter(entry -> ((IHatchElement)entry.getKey()).count(obj) < ((Number)entry.getValue()).longValue()).flatMap(entry -> ((IHatchElement)entry.getKey()).mteClasses().stream()).collect(Collectors.toList()))).shouldReject(obj -> elements.entrySet().stream().allMatch(e -> ((IHatchElement)e.getKey()).count(obj) >= ((Number)e.getValue()).longValue())).shouldSkip((BiPredicate<Object, IGregTechTileEntity> & Builtin)(c, t) -> t != null && list.stream().anyMatch(clazz -> clazz.isInstance(t.getMetaTileEntity()))).cacheHint(() -> elements.keySet().stream().map(IHatchElement::name).sorted().collect(Collectors.joining(" or ", "of type ", "")));
    }

    public GT_HatchElementBuilder<T> adder(IGT_HatchAdder<? super T> aAdder) {
        if (aAdder == null) {
            throw new IllegalArgumentException();
        }
        this.mAdder = aAdder;
        return this;
    }

    public GT_HatchElementBuilder<T> casingIndex(int aCasingIndex) {
        if (aCasingIndex <= 0) {
            throw new IllegalArgumentException();
        }
        this.mCasingIndex = aCasingIndex;
        return this;
    }

    public GT_HatchElementBuilder<T> dot(int aDot) {
        if (aDot <= 0) {
            throw new IllegalArgumentException();
        }
        this.mDot = aDot;
        return this;
    }

    public GT_HatchElementBuilder<T> shouldSkip(BiPredicate<? super T, ? super IGregTechTileEntity> aShouldSkip) {
        if (!(aShouldSkip instanceof Builtin) || this.mShouldSkip != null) {
            if (!(this.mShouldSkip instanceof Builtin) && this.mShouldSkip != null) {
                throw new IllegalStateException();
            }
            if (aShouldSkip == null) {
                throw new IllegalArgumentException();
            }
        }
        this.mShouldSkip = aShouldSkip;
        return this;
    }

    public GT_HatchElementBuilder<T> shouldReject(Predicate<? super T> aShouldReject) {
        if (aShouldReject == null) {
            throw new IllegalArgumentException();
        }
        this.mReject = aShouldReject;
        return this;
    }

    public GT_HatchElementBuilder<T> hatchItemFilter(Function<? super T, ? extends Predicate<ItemStack>> aHatchItemFilter) {
        if (aHatchItemFilter == null) {
            throw new IllegalArgumentException();
        }
        this.mHatchItemFilter = (t, s) -> (Predicate)aHatchItemFilter.apply(t);
        return this;
    }

    public GT_HatchElementBuilder<T> hatchItemFilterAnd(Function<? super T, ? extends Predicate<ItemStack>> aHatchItemFilter) {
        if (aHatchItemFilter == null) {
            throw new IllegalArgumentException();
        }
        BiFunction tOldFilter = this.mHatchItemFilter;
        this.mHatchItemFilter = (t, s) -> ((Predicate)tOldFilter.apply((Object)t, (ItemStack)s)).and((Predicate)aHatchItemFilter.apply(t));
        return this;
    }

    public GT_HatchElementBuilder<T> hatchItemFilter(BiFunction<? super T, ItemStack, ? extends Predicate<ItemStack>> aHatchItemFilter) {
        if (aHatchItemFilter == null) {
            throw new IllegalArgumentException();
        }
        this.mHatchItemFilter = aHatchItemFilter;
        return this;
    }

    public GT_HatchElementBuilder<T> hatchItemFilterAnd(BiFunction<? super T, ItemStack, ? extends Predicate<ItemStack>> aHatchItemFilter) {
        if (aHatchItemFilter == null) {
            throw new IllegalArgumentException();
        }
        BiFunction tOldFilter = this.mHatchItemFilter;
        this.mHatchItemFilter = (t, s) -> ((Predicate)tOldFilter.apply((Object)t, (ItemStack)s)).and((Predicate)aHatchItemFilter.apply((Object)t, (ItemStack)s));
        return this;
    }

    public GT_HatchElementBuilder<T> hint(Supplier<String> aSupplier) {
        if (aSupplier == null) {
            throw new IllegalArgumentException();
        }
        this.mHatchItemType = aSupplier;
        this.mCacheHint = false;
        return this;
    }

    public GT_HatchElementBuilder<T> cacheHint(Supplier<String> aSupplier) {
        if (aSupplier == null) {
            throw new IllegalArgumentException();
        }
        this.mHatchItemType = aSupplier;
        this.mCacheHint = true;
        return this;
    }

    public GT_HatchElementBuilder<T> cacheHint() {
        if (this.mHatchItemType == null) {
            throw new IllegalStateException();
        }
        this.mCacheHint = true;
        return this;
    }

    public GT_HatchElementBuilder<T> continueIfSuccess() {
        this.mNoStop = true;
        return this;
    }

    public GT_HatchElementBuilder<T> stopIfSuccess() {
        this.mNoStop = false;
        return this;
    }

    public GT_HatchElementBuilder<T> disallowOnly(ForgeDirection ... facings) {
        if (facings == null) {
            throw new IllegalArgumentException();
        }
        this.mDisallowedDirection = EnumSet.copyOf(Arrays.asList(facings));
        return this;
    }

    public GT_HatchElementBuilder<T> allowOnly(ForgeDirection ... facings) {
        if (facings == null) {
            throw new IllegalArgumentException();
        }
        this.mDisallowedDirection = EnumSet.complementOf(EnumSet.copyOf(Arrays.asList(facings)));
        this.mDisallowedDirection.remove(ForgeDirection.UNKNOWN);
        return this;
    }

    public GT_HatchElementBuilder<T> hatchClass(Class<? extends IMetaTileEntity> clazz) {
        return this.hatchItemFilter((? super T c) -> is -> clazz.isInstance(GT_Item_Machines.getMetaTileEntity(is))).cacheHint(() -> "of class " + clazz.getSimpleName()).shouldSkip((BiPredicate<Object, IGregTechTileEntity> & Builtin)(c, t) -> clazz.isInstance(t.getMetaTileEntity()));
    }

    @SafeVarargs
    public final GT_HatchElementBuilder<T> hatchClasses(Class<? extends IMetaTileEntity> ... classes) {
        return this.hatchClasses(Arrays.asList(classes));
    }

    public final GT_HatchElementBuilder<T> hatchClasses(List<? extends Class<? extends IMetaTileEntity>> classes) {
        ArrayList<? extends Class<? extends IMetaTileEntity>> list = new ArrayList<Class<? extends IMetaTileEntity>>(classes);
        return this.hatchItemFilter((? super T obj) -> GT_StructureUtility.filterByMTEClass(list)).cacheHint(() -> list.stream().map(Class::getSimpleName).sorted().collect(Collectors.joining(" or ", "of class ", ""))).shouldSkip((BiPredicate<Object, IGregTechTileEntity> & Builtin)(c, t) -> t != null && list.stream().anyMatch(clazz -> clazz.isInstance(t.getMetaTileEntity())));
    }

    public GT_HatchElementBuilder<T> hatchId(int aId) {
        return this.hatchItemFilter((? super T c) -> is -> GT_Utility.isStackValid(is) && is.func_77973_b() instanceof GT_Item_Machines && is.func_77960_j() == aId).cacheHint(() -> "of id " + aId).shouldSkip((BiPredicate<Object, IGregTechTileEntity> & Builtin)(c, t) -> t != null && t.getMetaTileID() == aId);
    }

    public GT_HatchElementBuilder<T> hatchIds(int ... aIds) {
        if (aIds == null || aIds.length == 0) {
            throw new IllegalArgumentException();
        }
        if (aIds.length == 1) {
            return this.hatchId(aIds[0]);
        }
        TIntArrayList coll = aIds.length < 16 ? new TIntArrayList(aIds) : new TIntHashSet(aIds);
        return this.hatchItemFilter(arg_0 -> GT_HatchElementBuilder.lambda$hatchIds$27((TIntCollection)coll, arg_0)).cacheHint(() -> GT_HatchElementBuilder.lambda$hatchIds$28((TIntCollection)coll)).shouldSkip((arg_0, arg_1) -> GT_HatchElementBuilder.lambda$hatchIds$29((TIntCollection)coll, arg_0, arg_1));
    }

    @SafeVarargs
    public final IStructureElementChain<T> buildAndChain(IStructureElement<T> ... elements) {
        ArrayList<IStructureElement<T>> l = new ArrayList<IStructureElement<T>>();
        l.add(this.build());
        l.addAll(Arrays.asList(elements));
        IStructureElement[] array = l.toArray(new IStructureElement[0]);
        return () -> array;
    }

    public final IStructureElementChain<T> buildAndChain(Block block, int meta) {
        return this.buildAndChain(StructureUtility.ofBlock((Block)block, (int)meta));
    }

    public IStructureElement<T> build() {
        if (this.mAdder == null || this.mCasingIndex == -1 || this.mDot == -1) {
            throw new IllegalArgumentException();
        }
        if (this.mHatchItemFilter == null) {
            return new IStructureElementNoPlacement<T>(){

                public boolean check(T t, World world, int x, int y, int z) {
                    TileEntity tileEntity = world.func_147438_o(x, y, z);
                    return tileEntity instanceof IGregTechTileEntity && GT_HatchElementBuilder.this.mAdder.apply(t, (IGregTechTileEntity)tileEntity, (short)GT_HatchElementBuilder.this.mCasingIndex);
                }

                public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                    StructureLibAPI.hintParticle((World)world, (int)x, (int)y, (int)z, (Block)StructureLibAPI.getBlockHint(), (int)(GT_HatchElementBuilder.this.mDot - 1));
                    return true;
                }
            };
        }
        return new IStructureElement<T>(){
            private String mHint;
            {
                this.mHint = GT_HatchElementBuilder.this.mHatchItemType == null ? "unspecified GT hatch" : (String)GT_HatchElementBuilder.this.mHatchItemType.get();
            }

            public boolean check(T t, World world, int x, int y, int z) {
                TileEntity tileEntity = world.func_147438_o(x, y, z);
                return tileEntity instanceof IGregTechTileEntity && GT_HatchElementBuilder.this.mAdder.apply(t, (IGregTechTileEntity)tileEntity, (short)GT_HatchElementBuilder.this.mCasingIndex);
            }

            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                StructureLibAPI.hintParticle((World)world, (int)x, (int)y, (int)z, (Block)StructureLibAPI.getBlockHint(), (int)(GT_HatchElementBuilder.this.mDot - 1));
                return true;
            }

            public boolean placeBlock(T t, World world, int i, int i1, int i2, ItemStack itemStack) {
                return false;
            }

            private String getHint() {
                if (this.mHint != null) {
                    return this.mHint;
                }
                String tHint = (String)GT_HatchElementBuilder.this.mHatchItemType.get();
                if (tHint == null) {
                    return "?";
                }
                tHint = GT_LanguageManager.addStringLocalization("Hatch_Type_" + tHint.replace(' ', '_'), tHint);
                if (GT_HatchElementBuilder.this.mCacheHint) {
                    this.mHint = tHint;
                    if (this.mHint != null) {
                        GT_HatchElementBuilder.this.mHatchItemType = null;
                    }
                }
                return tHint;
            }

            public IStructureElement.BlocksToPlace getBlocksToPlace(T t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                return IStructureElement.BlocksToPlace.create((Predicate)((Predicate)GT_HatchElementBuilder.this.mHatchItemFilter.apply(t, trigger)));
            }

            @Deprecated
            public IStructureElement.PlaceResult survivalPlaceBlock(T t, World world, int x, int y, int z, ItemStack trigger, IItemSource s, EntityPlayerMP actor, Consumer<IChatComponent> chatter) {
                return this.survivalPlaceBlock(t, world, x, y, z, trigger, AutoPlaceEnvironment.fromLegacy((IItemSource)s, (EntityPlayer)actor, chatter));
            }

            public IStructureElement.PlaceResult survivalPlaceBlock(T t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                TileEntity tileEntity;
                TileEntity tileEntity2;
                if (GT_HatchElementBuilder.this.mShouldSkip != null && (tileEntity2 = world.func_147438_o(x, y, z)) instanceof IGregTechTileEntity && GT_HatchElementBuilder.this.mShouldSkip.test(t, (IGregTechTileEntity)tileEntity2)) {
                    return IStructureElement.PlaceResult.SKIP;
                }
                if (!StructureLibAPI.isBlockTriviallyReplaceable((World)world, (int)x, (int)y, (int)z, (EntityPlayer)env.getActor())) {
                    return IStructureElement.PlaceResult.REJECT;
                }
                if (GT_HatchElementBuilder.this.mReject != null && GT_HatchElementBuilder.this.mReject.test(t)) {
                    return IStructureElement.PlaceResult.REJECT;
                }
                ItemStack taken = env.getSource().takeOne((Predicate)GT_HatchElementBuilder.this.mHatchItemFilter.apply(t, trigger), true);
                if (GT_Utility.isStackInvalid(taken)) {
                    String type = this.getHint();
                    env.getChatter().accept(new ChatComponentTranslation("GT5U.autoplace.error.no_hatch", new Object[]{type}));
                    return IStructureElement.PlaceResult.REJECT;
                }
                if (StructureUtility.survivalPlaceBlock((ItemStack)taken, (ItemStackPredicate.NBTMode)ItemStackPredicate.NBTMode.IGNORE, null, (boolean)true, (World)world, (int)x, (int)y, (int)z, (IItemSource)env.getSource(), (EntityPlayer)env.getActor()) != IStructureElement.PlaceResult.ACCEPT) {
                    return IStructureElement.PlaceResult.REJECT;
                }
                EnumSet<ForgeDirection> allowed = EnumSet.noneOf(ForgeDirection.class);
                if (env.getAPILevel() == AutoPlaceEnvironment.APILevel.Legacy) {
                    allowed.addAll(Arrays.asList(ForgeDirection.VALID_DIRECTIONS));
                } else {
                    for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                        if (env.isContainedInPiece(direction.offsetX, -direction.offsetY, direction.offsetZ) || GT_HatchElementBuilder.this.mDisallowedDirection.contains(direction)) continue;
                        ForgeDirection rotated = env.getFacing().getWorldDirection((direction.flag & (ForgeDirection.UP.flag | ForgeDirection.DOWN.flag)) != 0 ? direction.getOpposite() : direction);
                        allowed.add(rotated);
                    }
                }
                if (!allowed.isEmpty() && (tileEntity = world.func_147438_o(x, y, z)) instanceof IGregTechTileEntity) {
                    ForgeDirection result = null;
                    Iterator iterator = allowed.iterator();
                    while (iterator.hasNext()) {
                        ForgeDirection facing;
                        result = facing = (ForgeDirection)iterator.next();
                        if ((facing.flag & (ForgeDirection.UP.flag | ForgeDirection.DOWN.flag)) != 0) continue;
                        break;
                    }
                    assert (result != null);
                    ((IGregTechTileEntity)tileEntity).setFrontFacing(result);
                }
                return GT_HatchElementBuilder.this.mNoStop ? IStructureElement.PlaceResult.ACCEPT : IStructureElement.PlaceResult.ACCEPT_STOP;
            }
        };
    }

    private static /* synthetic */ boolean lambda$hatchIds$29(TIntCollection coll, Object c, IGregTechTileEntity t) {
        return t != null && coll.contains(t.getMetaTileID());
    }

    private static /* synthetic */ String lambda$hatchIds$28(TIntCollection coll) {
        return Arrays.stream(coll.toArray()).sorted().mapToObj(String::valueOf).collect(Collectors.joining(" or ", "of id ", ""));
    }

    private static /* synthetic */ Predicate lambda$hatchIds$27(TIntCollection coll, Object c) {
        return is -> GT_Utility.isStackValid(is) && is.func_77973_b() instanceof GT_Item_Machines && coll.contains(is.func_77960_j());
    }

    private static interface Builtin {
    }
}

