/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.implementations;

import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.common.internal.wrapper.BaseSlot;
import com.gtnewhorizons.modularui.common.widget.SlotGroup;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GT_UIInfos;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.modularui.IAddUIWidgets;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.items.GT_MetaBase_Item;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_TieredMachineBlock;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Utility;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class GT_MetaTileEntity_BasicBatteryBuffer
extends GT_MetaTileEntity_TieredMachineBlock
implements IAddUIWidgets {
    public boolean mCharge = false;
    public boolean mDecharge = false;
    public int mBatteryCount = 0;
    public int mChargeableCount = 0;
    private long count = 0L;
    private long mStored = 0L;
    private long mMax = 0L;

    public GT_MetaTileEntity_BasicBatteryBuffer(int aID, String aName, String aNameRegional, int aTier, String aDescription, int aSlotCount) {
        super(aID, aName, aNameRegional, aTier, aSlotCount, aDescription, new ITexture[0]);
    }

    public GT_MetaTileEntity_BasicBatteryBuffer(String aName, int aTier, String aDescription, ITexture[][][] aTextures, int aSlotCount) {
        super(aName, aTier, aSlotCount, aDescription, aTextures);
    }

    public GT_MetaTileEntity_BasicBatteryBuffer(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures, int aSlotCount) {
        super(aName, aTier, aSlotCount, aDescription, aTextures);
    }

    @Override
    public String[] getDescription() {
        String[] desc = new String[this.mDescriptionArray.length + 1];
        System.arraycopy(this.mDescriptionArray, 0, desc, 0, this.mDescriptionArray.length);
        desc[this.mDescriptionArray.length] = this.mInventory.length + " Slots";
        return desc;
    }

    @Override
    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        ITexture[][][] rTextures = new ITexture[2][17][];
        for (int i = -1; i < 16; i = (int)((byte)(i + 1))) {
            rTextures[0][i + 1] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][i + 1]};
            rTextures[1][i + 1] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][i + 1], this.mInventory.length == 16 ? Textures.BlockIcons.OVERLAYS_ENERGY_OUT_POWER[this.mTier] : (this.mInventory.length > 4 ? Textures.BlockIcons.OVERLAYS_ENERGY_OUT_MULTI[this.mTier] : Textures.BlockIcons.OVERLAYS_ENERGY_OUT[this.mTier])};
        }
        return rTextures;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection aFacing, int colorIndex, boolean aActive, boolean redstoneLevel) {
        return this.mTextures[side == aFacing ? 1 : 0][colorIndex + 1];
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_BasicBatteryBuffer(this.mName, (int)this.mTier, this.mDescriptionArray, this.mTextures, this.mInventory.length);
    }

    @Override
    public boolean isSimpleMachine() {
        return false;
    }

    @Override
    public boolean isElectric() {
        return true;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return true;
    }

    @Override
    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    @Override
    public boolean isEnetInput() {
        return true;
    }

    @Override
    public boolean isEnetOutput() {
        return true;
    }

    @Override
    public boolean isInputFacing(ForgeDirection side) {
        return side != this.getBaseMetaTileEntity().getFrontFacing();
    }

    @Override
    public boolean isOutputFacing(ForgeDirection side) {
        return side == this.getBaseMetaTileEntity().getFrontFacing();
    }

    @Override
    public boolean isTeleporterCompatible() {
        return false;
    }

    @Override
    public long getMinimumStoredEU() {
        return GT_Values.V[this.mTier] * 16L * (long)this.mInventory.length;
    }

    @Override
    public long maxEUStore() {
        return GT_Values.V[this.mTier] * 64L * (long)this.mInventory.length;
    }

    @Override
    public long maxEUInput() {
        return GT_Values.V[this.mTier];
    }

    @Override
    public long maxEUOutput() {
        return GT_Values.V[this.mTier];
    }

    @Override
    public long maxAmperesIn() {
        return (long)this.mChargeableCount * 2L;
    }

    @Override
    public long maxAmperesOut() {
        return this.mBatteryCount;
    }

    @Override
    public int rechargerSlotStartIndex() {
        return 0;
    }

    @Override
    public int dechargerSlotStartIndex() {
        return 0;
    }

    @Override
    public int rechargerSlotCount() {
        return this.mCharge ? this.mInventory.length : 0;
    }

    @Override
    public int dechargerSlotCount() {
        return this.mDecharge ? this.mInventory.length : 0;
    }

    @Override
    public int getProgresstime() {
        return (int)this.getBaseMetaTileEntity().getUniversalEnergyStored();
    }

    @Override
    public int maxProgresstime() {
        return (int)this.getBaseMetaTileEntity().getUniversalEnergyCapacity();
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        GT_UIInfos.openGTTileEntityUI(aBaseMetaTileEntity, aPlayer);
        return true;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide()) {
            this.mCharge = aBaseMetaTileEntity.getStoredEU() / 2L > aBaseMetaTileEntity.getEUCapacity() / 3L;
            this.mDecharge = aBaseMetaTileEntity.getStoredEU() < aBaseMetaTileEntity.getEUCapacity() / 3L;
            this.mBatteryCount = 0;
            this.mChargeableCount = 0;
            for (ItemStack tStack : this.mInventory) {
                if (!GT_ModHandler.isElectricItem(tStack, this.mTier)) continue;
                if (GT_ModHandler.isChargerItem(tStack)) {
                    ++this.mBatteryCount;
                }
                ++this.mChargeableCount;
            }
        }
        ++this.count;
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        String name;
        if (GT_ModHandler.isElectricItem(aStack) && aStack.func_77977_a().startsWith("gt.metaitem.01.") && ((name = aStack.func_77977_a()).equals("gt.metaitem.01.32510") || name.equals("gt.metaitem.01.32511") || name.equals("gt.metaitem.01.32520") || name.equals("gt.metaitem.01.32521") || name.equals("gt.metaitem.01.32530") || name.equals("gt.metaitem.01.32531"))) {
            return ElectricItem.manager.getCharge(aStack) == 0.0;
        }
        return false;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        if (!GT_Utility.isStackValid(aStack)) {
            return false;
        }
        return this.mInventory[aIndex] == null && GT_ModHandler.isElectricItem(aStack, this.mTier);
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    public long[] getStoredEnergy() {
        boolean scaleOverflow = false;
        boolean storedOverflow = false;
        long tScale = this.getBaseMetaTileEntity().getEUCapacity();
        long tStored = this.getBaseMetaTileEntity().getStoredEU();
        long tStep = 0L;
        if (this.mInventory != null) {
            for (ItemStack aStack : this.mInventory) {
                if (!GT_ModHandler.isElectricItem(aStack)) continue;
                if (aStack.func_77973_b() instanceof GT_MetaBase_Item) {
                    Long[] stats = ((GT_MetaBase_Item)aStack.func_77973_b()).getElectricStats(aStack);
                    if (stats == null) continue;
                    if (stats[0] > 0x3FFFFFFFFFFFFFFFL) {
                        scaleOverflow = true;
                    }
                    tScale += stats[0].longValue();
                    tStep = ((GT_MetaBase_Item)aStack.func_77973_b()).getRealCharge(aStack);
                    if (tStep > 0x3FFFFFFFFFFFFFFFL) {
                        storedOverflow = true;
                    }
                    tStored += tStep;
                    continue;
                }
                if (!(aStack.func_77973_b() instanceof IElectricItem)) continue;
                tStored += (long)ElectricItem.manager.getCharge(aStack);
                tScale += (long)((IElectricItem)aStack.func_77973_b()).getMaxCharge(aStack);
            }
        }
        if (scaleOverflow) {
            tScale = Long.MAX_VALUE;
        }
        if (storedOverflow) {
            tStored = Long.MAX_VALUE;
        }
        return new long[]{tStored, tScale};
    }

    @Override
    public String[] getInfoData() {
        this.updateStorageInfo();
        return new String[]{EnumChatFormatting.BLUE + this.getLocalName() + EnumChatFormatting.RESET, "Stored Items:", EnumChatFormatting.GREEN + GT_Utility.formatNumbers(this.mStored) + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers(this.mMax) + EnumChatFormatting.RESET + " EU", "Average input:", GT_Utility.formatNumbers(this.getBaseMetaTileEntity().getAverageElectricInput()) + " EU/t", "Average output:", GT_Utility.formatNumbers(this.getBaseMetaTileEntity().getAverageElectricOutput()) + " EU/t"};
    }

    private void updateStorageInfo() {
        if (this.mMax == 0L || this.count > 20L) {
            long[] tmp = this.getStoredEnergy();
            this.mStored = tmp[0];
            this.mMax = tmp[1];
            this.count = 0L;
        }
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        NBTTagCompound tag = accessor.getNBTData();
        currenttip.add(StatCollector.func_74837_a((String)"GT5U.waila.energy.stored", (Object[])new Object[]{GT_Utility.formatNumbers(tag.func_74763_f("mStored")), GT_Utility.formatNumbers(tag.func_74763_f("mMax"))}));
        long avgIn = tag.func_74763_f("AvgIn");
        long avgOut = tag.func_74763_f("AvgOut");
        currenttip.add(StatCollector.func_74837_a((String)"GT5U.waila.energy.avg_in_with_amperage", (Object[])new Object[]{GT_Utility.formatNumbers(avgIn), GT_Utility.getAmperageForTier(avgIn, (byte)this.getInputTier()), GT_Utility.getColoredTierNameFromTier((byte)this.getInputTier())}));
        currenttip.add(StatCollector.func_74837_a((String)"GT5U.waila.energy.avg_out_with_amperage", (Object[])new Object[]{GT_Utility.formatNumbers(avgOut), GT_Utility.getAmperageForTier(avgOut, (byte)this.getOutputTier()), GT_Utility.getColoredTierNameFromTier((byte)this.getOutputTier())}));
        super.getWailaBody(itemStack, currenttip, accessor, config);
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        this.updateStorageInfo();
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        tag.func_74772_a("mStored", this.mStored);
        tag.func_74772_a("mMax", this.mMax);
        tag.func_74772_a("AvgIn", this.getBaseMetaTileEntity().getAverageElectricInput());
        tag.func_74772_a("AvgOut", this.getBaseMetaTileEntity().getAverageElectricOutput());
    }

    @Override
    public boolean isGivingInformation() {
        return true;
    }

    @Override
    public boolean useModularUI() {
        return true;
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        switch (this.mInventory.length) {
            case 4: {
                builder.widget(SlotGroup.ofItemHandler((IItemHandlerModifiable)this.inventoryHandler, (int)2).startFromSlot(0).endAtSlot(3).slotCreator(index -> new BaseSlot((IItemHandlerModifiable)this.inventoryHandler, (int)index){

                    public int func_75219_a() {
                        return 1;
                    }
                }).background(new IDrawable[]{this.getGUITextureSet().getItemSlot()}).build().setPos(70, 25));
                break;
            }
            case 9: {
                builder.widget(SlotGroup.ofItemHandler((IItemHandlerModifiable)this.inventoryHandler, (int)3).startFromSlot(0).endAtSlot(8).slotCreator(index -> new BaseSlot((IItemHandlerModifiable)this.inventoryHandler, (int)index){

                    public int func_75219_a() {
                        return 1;
                    }
                }).background(new IDrawable[]{this.getGUITextureSet().getItemSlot()}).build().setPos(61, 16));
                break;
            }
            case 16: {
                builder.widget(SlotGroup.ofItemHandler((IItemHandlerModifiable)this.inventoryHandler, (int)4).startFromSlot(0).endAtSlot(15).slotCreator(index -> new BaseSlot((IItemHandlerModifiable)this.inventoryHandler, (int)index){

                    public int func_75219_a() {
                        return 1;
                    }
                }).background(new IDrawable[]{this.getGUITextureSet().getItemSlot()}).build().setPos(52, 7));
                break;
            }
            default: {
                builder.widget(SlotGroup.ofItemHandler((IItemHandlerModifiable)this.inventoryHandler, (int)1).startFromSlot(0).endAtSlot(0).slotCreator(index -> new BaseSlot((IItemHandlerModifiable)this.inventoryHandler, (int)index){

                    public int func_75219_a() {
                        return 1;
                    }
                }).background(new IDrawable[]{this.getGUITextureSet().getItemSlot()}).build().setPos(79, 34));
            }
        }
    }
}

