/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.interfaces.tileentity;

import cofh.api.energy.IEnergyReceiver;
import gregtech.api.GregTech_API;
import gregtech.api.interfaces.tileentity.IColoredTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.logic.PowerLogic;
import gregtech.api.logic.interfaces.PowerLogicHost;
import gregtech.api.util.GT_Utility;
import ic2.api.energy.tile.IEnergySink;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public interface IEnergyConnected
extends IColoredTileEntity {
    public long injectEnergyUnits(ForgeDirection var1, long var2, long var4);

    public boolean inputEnergyFrom(ForgeDirection var1);

    default public boolean inputEnergyFrom(ForgeDirection side, boolean waitForActive) {
        return this.inputEnergyFrom(side);
    }

    public boolean outputsEnergyTo(ForgeDirection var1);

    default public boolean outputsEnergyTo(ForgeDirection side, boolean waitForActive) {
        return this.outputsEnergyTo(side);
    }

    public static final class Util {
        public static long emitEnergyToNetwork(long aVoltage, long aAmperage, IEnergyConnected aEmitter) {
            long rUsedAmperes = 0L;
            if (!(aEmitter instanceof IHasWorldObjectAndCoords)) {
                return 0L;
            }
            IHasWorldObjectAndCoords emitterTile = (IHasWorldObjectAndCoords)((Object)aEmitter);
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                int rfOut;
                IEnergyReceiver receiver;
                if (rUsedAmperes > aAmperage) break;
                if (!aEmitter.outputsEnergyTo(side)) continue;
                ForgeDirection oppositeSide = side.getOpposite();
                TileEntity tTileEntity = emitterTile.getTileEntityAtSide(side);
                if (tTileEntity instanceof PowerLogicHost) {
                    PowerLogicHost host = (PowerLogicHost)tTileEntity;
                    PowerLogic logic = host.getPowerLogic(oppositeSide);
                    if (logic == null || logic.isEnergyReceiver()) continue;
                    rUsedAmperes += logic.injectEnergy(aVoltage, aAmperage - rUsedAmperes);
                    continue;
                }
                if (tTileEntity instanceof IEnergyConnected) {
                    byte tColor;
                    IEnergyConnected energyConnected = (IEnergyConnected)tTileEntity;
                    if (aEmitter.getColorization() >= 0 && (tColor = energyConnected.getColorization()) >= 0 && tColor != aEmitter.getColorization()) continue;
                    rUsedAmperes += energyConnected.injectEnergyUnits(oppositeSide, aVoltage, aAmperage - rUsedAmperes);
                    continue;
                }
                if (tTileEntity instanceof IEnergySink) {
                    IEnergySink sink = (IEnergySink)tTileEntity;
                    if (!sink.acceptsEnergyFrom((TileEntity)aEmitter, oppositeSide)) continue;
                    while (aAmperage > rUsedAmperes && sink.getDemandedEnergy() > 0.0 && sink.injectEnergy(oppositeSide, (double)aVoltage, (double)aVoltage) < (double)aVoltage) {
                        ++rUsedAmperes;
                    }
                    continue;
                }
                if (!GregTech_API.mOutputRF || !(tTileEntity instanceof IEnergyReceiver) || (receiver = (IEnergyReceiver)tTileEntity).receiveEnergy(oppositeSide, rfOut = GT_Utility.safeInt(aVoltage * (long)GregTech_API.mEUtoRF / 100L), true) != rfOut) continue;
                receiver.receiveEnergy(oppositeSide, rfOut, false);
                ++rUsedAmperes;
            }
            return rUsedAmperes;
        }
    }
}

