/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.gravisuiteneo.mixins;

import cofh.api.energy.IEnergyContainerItem;
import com.gtnewhorizons.gravisuiteneo.common.Achievements;
import com.gtnewhorizons.gravisuiteneo.common.Properties;
import com.gtnewhorizons.gravisuiteneo.items.IItemCharger;
import com.gtnewhorizons.gravisuiteneo.items.ItemEpicLappack;
import gravisuite.GraviSuite;
import gravisuite.ItemAdvancedLappack;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ItemAdvancedLappack.class})
public class MixinItemAdvancedLappack
implements IItemCharger {
    @Shadow(remap=false)
    private int transferLimit;
    @Shadow(remap=false)
    private int tier;

    @Overwrite(remap=false)
    public double getDamageAbsorptionRatio() {
        return Properties.ArmorPresets.AdvLapPack.absorptionRatio;
    }

    @Overwrite(remap=false)
    private double getBaseAbsorptionRatio() {
        return 1.0;
    }

    @Inject(at={@At(ordinal=1, remap=false, target="Lgravisuite/ServerProxy;sendPlayerMessage(Lnet/minecraft/entity/player/EntityPlayer;Ljava/lang/String;)V", value="INVOKE")}, locals=LocalCapture.CAPTURE_FAILSOFT, method={"onItemRightClick"})
    private void gravisuiteneo$triggerAchievement(ItemStack itemStack, World world, EntityPlayer player, CallbackInfoReturnable<ItemStack> cir, Integer toolMode) {
        if (itemStack.func_77973_b() instanceof ItemEpicLappack) {
            player.func_71029_a((StatBase)Achievements.EPIC_LAPPACK);
        }
    }

    @Overwrite(remap=false)
    public boolean onTick(EntityPlayer player, ItemStack itemstack) {
        int toolMode = ItemAdvancedLappack.readToolMode((ItemStack)itemstack);
        if (toolMode == 1 && GraviSuite.isSimulating()) {
            ItemStack armorItemStack = player.field_71071_by.field_70460_b[2];
            if (armorItemStack == null) {
                return true;
            }
            if (armorItemStack.func_77973_b() instanceof IElectricItem) {
                this.doChargeItemStack(itemstack, armorItemStack);
            }
            if (armorItemStack.func_77973_b() instanceof IEnergyContainerItem) {
                this.doChargeItemStackRF(itemstack, armorItemStack);
            }
        }
        return true;
    }

    @Override
    public void doChargeItemStack(ItemStack charger, ItemStack chargee) {
        double sentPacket;
        int energyPacket = this.transferLimit;
        int mainCharge = ItemAdvancedLappack.getCharge((ItemStack)charger);
        if (mainCharge <= this.transferLimit) {
            energyPacket = mainCharge;
        }
        if ((sentPacket = ElectricItem.manager.charge(chargee, (double)energyPacket, this.tier, false, false)) > 0.0) {
            ElectricItem.manager.discharge(charger, sentPacket, this.tier, false, false, false);
        }
    }

    @Override
    public void doChargeItemStackRF(ItemStack charger, ItemStack chargee) {
        double sentPacket;
        int energyPacket = this.transferLimit;
        int mainCharge = ItemAdvancedLappack.getCharge((ItemStack)charger);
        if (mainCharge <= this.transferLimit) {
            energyPacket = mainCharge;
        }
        if ((sentPacket = (double)((IEnergyContainerItem)chargee.func_77973_b()).receiveEnergy(chargee, energyPacket * 4, false) / 4.0) > 0.0) {
            ElectricItem.manager.discharge(charger, sentPacket, this.tier, false, false, false);
        }
    }
}

