/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.client.effect;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

class CheckpointingSet<E>
implements Iterable<E> {
    private final Set<E> main = new HashSet();
    private final Set<E> toAdd = Collections.synchronizedSet(new HashSet());
    private final Set<E> toRemove = Collections.synchronizedSet(new HashSet());

    CheckpointingSet() {
    }

    public void add(E elem) {
        this.toAdd.add(elem);
    }

    public void remove(E elem) {
        this.toRemove.add(elem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Set<E> set = this.toAdd;
        synchronized (set) {
            Set<E> set2 = this.toRemove;
            synchronized (set2) {
                this.toAdd.clear();
                this.toRemove.clear();
                this.main.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        Set<E> set = this.toAdd;
        synchronized (set) {
            this.main.addAll(this.toAdd);
            this.toAdd.clear();
        }
        set = this.toRemove;
        synchronized (set) {
            this.main.removeAll(this.toRemove);
            this.toRemove.clear();
        }
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private final Iterator<E> backing;
            private boolean initialized;
            private E cur;
            {
                this.backing = CheckpointingSet.this.main.iterator();
                this.initialized = false;
                this.cur = null;
            }

            @Override
            public boolean hasNext() {
                return this.backing.hasNext();
            }

            @Override
            public E next() {
                this.initialized = true;
                this.cur = this.backing.next();
                return this.cur;
            }

            @Override
            public void remove() {
                if (!this.initialized) {
                    throw new IllegalStateException();
                }
                CheckpointingSet.this.toRemove.add(this.cur);
            }
        };
    }
}

