/*
 * Decompiled with CFR 0.152.
 */
package com.n247s.N2ConfigApi.api.networking;

import com.n247s.N2ConfigApi.api.N2ConfigApi;
import com.n247s.N2ConfigApi.api.core.ConfigFile;
import com.n247s.N2ConfigApi.api.core.ConfigHandler;
import com.n247s.N2ConfigApi.api.core.events.ConfigApiEvents;
import com.n247s.N2ConfigApi.api.networking.N2ConfigApiConfigPacket;
import com.n247s.api.eventapi.EventApi;
import com.n247s.n2core.networking.N2MessageHandler;
import com.n247s.n2core.networking.N2NetworkEventHandler;
import com.n247s.n2core.networking.N2Packet;
import com.n247s.n2core.networking.N2PacketHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import scala.actors.threadpool.Arrays;

public class N2ConfigApiMessageHandler {
    private static final N2ConfigApiMessageHandler instance = new N2ConfigApiMessageHandler();
    private static final Logger log = N2ConfigApi.log;
    public static final Marker securityMarker = MarkerManager.getMarker((String)"SuspiciousPackets");
    public static final int maxByteBuffSize = 25600;
    private static HashMap<String, List<Byte>> ConfigFileClassMap = new HashMap();
    private static HashMap<String, List<Byte>> ConfigFileMap = new HashMap();

    public static void preInitialize() {
        FMLCommonHandler.instance().bus().register((Object)instance);
        MinecraftForge.EVENT_BUS.register((Object)instance);
        N2NetworkEventHandler.registerMessageHandler(N2PacketHandler.class, N2MessageHandler.class, Side.CLIENT);
        N2NetworkEventHandler.registerMessageHandler(N2PacketHandler.class, N2MessageHandler.class, Side.SERVER);
        N2PacketHandler.registerPacket("N2ConfigApi", N2ConfigApiConfigPacket.class);
    }

    public static String getSignature(int i) {
        String[] PacketSignatures = new String[]{"2n4s7t@rD", "2n4s7F!ni$H", "2n4s7&Re@k", "2n4$7Y!zSc", "2n4$7Z@me$", "2n4$7c$cq@e", "2n4s7C0f!q", "2n4$7D6Ite"};
        return PacketSignatures[i];
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        ConfigApiEvents configApiEvents = ConfigApiEvents.instance;
        configApiEvents.getClass();
        EventApi.defaultEventBusInstance.raiseEvent(new ConfigApiEvents.onPreServerJoinConfigRecieve(configApiEvents, event.player));
        if (FMLCommonHandler.instance().getEffectiveSide().isServer() && event.player instanceof EntityPlayerMP) {
            ConfigHandler.forceCompleteSync(event.player.func_110124_au());
        }
        ConfigApiEvents configApiEvents2 = ConfigApiEvents.instance;
        configApiEvents2.getClass();
        EventApi.defaultEventBusInstance.raiseEvent(new ConfigApiEvents.onPostServerJoinConfigRecieve(configApiEvents2, event.player));
    }

    @SubscribeEvent
    public void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        ConfigApiEvents configApiEvents = ConfigApiEvents.instance;
        configApiEvents.getClass();
        EventApi.defaultEventBusInstance.raiseEvent(new ConfigApiEvents.onPreServerLeaveConfigRemove(configApiEvents, event.player));
        if (FMLCommonHandler.instance().getEffectiveSide().isClient() && event.player instanceof EntityPlayerSP) {
            ConfigHandler.cleanUpTempServerFiles();
        }
        ConfigApiEvents configApiEvents2 = ConfigApiEvents.instance;
        configApiEvents2.getClass();
        EventApi.defaultEventBusInstance.raiseEvent(new ConfigApiEvents.onPostServerLeaveConfigRemove(configApiEvents2, event.player));
    }

    public static void syncValues(List<ConfigFile> configFileList, UUID playerID) {
        try {
            ArrayList<N2Packet> packetList = new ArrayList<N2Packet>();
            ByteBuf buff = Unpooled.directBuffer();
            ByteBufOutputStream stream = new ByteBufOutputStream(buff);
            stream.writeUTF(N2ConfigApiMessageHandler.getSignature(3));
            stream.writeUTF(N2ConfigApiMessageHandler.getSignature(0));
            for (ConfigFile currentConfigFile : configFileList) {
                List<ByteBuf> configBuf = currentConfigFile.writeValuesToBuff(stream);
                for (ByteBuf currentBuf : configBuf) {
                    packetList.add(new N2ConfigApiConfigPacket(currentBuf));
                }
                if (configFileList.indexOf(currentConfigFile) == configFileList.size() - 1) {
                    stream.writeUTF(N2ConfigApiMessageHandler.getSignature(1));
                    stream.flush();
                    packetList.add(new N2ConfigApiConfigPacket(buff.copy()));
                }
                stream.flush();
            }
            stream.close();
            buff.release();
            if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
                if (playerID != null) {
                    List playerList = MinecraftServer.func_71276_C().func_71203_ab().field_72404_b;
                    for (EntityPlayerMP player : playerList) {
                        if (!player.func_110124_au().equals(playerID)) continue;
                        N2NetworkEventHandler.sendPacketsToPlayer(packetList, player);
                    }
                } else {
                    N2NetworkEventHandler.sendPacketsToAllPlayers(packetList);
                }
            } else {
                N2NetworkEventHandler.sendPacketsToServer(packetList);
            }
        }
        catch (Exception e) {
            log.catching((Throwable)e);
        }
    }

    public static void syncFullConfigFile(ConfigFile configFile, UUID playerID) {
        try {
            ArrayList<N2Packet> packetList = new ArrayList<N2Packet>();
            ByteBuf buff = Unpooled.directBuffer();
            ByteBufOutputStream stream = new ByteBufOutputStream(buff.copy());
            ObjectOutputStream objectStream = new ObjectOutputStream((OutputStream)new ByteBufOutputStream(buff));
            File file = ConfigHandler.getFileFromConfigFile(configFile).getParentFile();
            String filePath = file.getAbsolutePath().substring(N2ConfigApi.getMCMainDir().getAbsolutePath().length(), file.getAbsolutePath().length());
            String fileID = filePath.equals(N2ConfigApi.getConfigDir().getAbsolutePath().toString()) ? "2N4$7Det@nT" : N2ConfigApi.getFileIDFromFileDir(file);
            stream.writeUTF(N2ConfigApiMessageHandler.getSignature(5));
            stream.writeUTF(N2ConfigApiMessageHandler.getSignature(0));
            stream.writeUTF(fileID);
            stream.writeUTF(filePath);
            stream.writeUTF(configFile.getFileName());
            objectStream.writeObject(configFile);
            objectStream.flush();
            int packetsCount = (int)Math.ceil((float)buff.writerIndex() / 25600.0f);
            for (int i = 0; i < packetsCount; ++i) {
                ByteBuf bufff = buff.copy(i * 25600, (i + 1) * 25600 > buff.writerIndex() ? buff.writerIndex() - i * 25600 : 25600);
                stream.writeInt(bufff.writerIndex());
                stream.buffer().capacity(stream.buffer().capacity() + bufff.writerIndex());
                stream.buffer().setBytes(stream.buffer().writerIndex(), bufff);
                stream.buffer().writerIndex(stream.buffer().writerIndex() + bufff.capacity());
                stream.writeUTF(i - 1 == packetsCount ? N2ConfigApiMessageHandler.getSignature(1) : N2ConfigApiMessageHandler.getSignature(2));
                stream.flush();
                packetList.add(new N2ConfigApiConfigPacket(stream.buffer().copy()));
                stream.buffer().clear();
                stream.writeUTF(N2ConfigApiMessageHandler.getSignature(5));
                stream.writeUTF(configFile.getFileName());
                stream.flush();
            }
            objectStream.flush();
            objectStream.close();
            stream.flush();
            stream.close();
            buff.release();
            if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
                if (playerID != null) {
                    List playerList = MinecraftServer.func_71276_C().func_71203_ab().field_72404_b;
                    for (EntityPlayerMP player : playerList) {
                        if (!player.func_110124_au().equals(playerID)) continue;
                        N2NetworkEventHandler.sendPacketsToPlayer(packetList, player);
                    }
                } else {
                    N2NetworkEventHandler.sendPacketsToAllPlayers(packetList);
                }
            } else {
                N2NetworkEventHandler.sendPacketsToServer(packetList);
            }
        }
        catch (Exception e) {
            log.catching((Throwable)e);
        }
    }

    public static void syncDeleteConfigFile(List<ConfigFile> configFileList, UUID playerID) {
        try {
            ArrayList<N2Packet> packetList = new ArrayList<N2Packet>();
            ByteBuf buff = Unpooled.directBuffer();
            ByteBufOutputStream stream = new ByteBufOutputStream(buff);
            stream.writeUTF(N2ConfigApiMessageHandler.getSignature(7));
            stream.writeUTF(N2ConfigApiMessageHandler.getSignature(0));
            for (ConfigFile currentConfig : configFileList) {
                stream.writeUTF(currentConfig.getFileName());
                if (stream.buffer().capacity() > 25600 && configFileList.indexOf(currentConfig) < configFileList.size() - 3) {
                    stream.writeUTF(N2ConfigApiMessageHandler.getSignature(2));
                    stream.flush();
                    packetList.add(new N2ConfigApiConfigPacket(stream.buffer().copy()));
                    stream.buffer().clear();
                    stream.writeUTF(N2ConfigApiMessageHandler.getSignature(7));
                }
                stream.flush();
            }
            stream.writeUTF(N2ConfigApiMessageHandler.getSignature(1));
            stream.flush();
            packetList.add(new N2ConfigApiConfigPacket(stream.buffer().copy()));
            stream.close();
            buff.release();
            if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
                if (playerID != null) {
                    List playerList = MinecraftServer.func_71276_C().func_71203_ab().field_72404_b;
                    for (EntityPlayerMP player : playerList) {
                        if (!player.func_110124_au().equals(playerID)) continue;
                        N2NetworkEventHandler.sendPacketsToPlayer(packetList, player);
                    }
                } else {
                    N2NetworkEventHandler.sendPacketsToAllPlayers(packetList);
                }
            } else {
                N2NetworkEventHandler.sendPacketsToServer(packetList);
            }
        }
        catch (Exception e) {
            log.catching((Throwable)e);
        }
    }

    public static void processPackage(ByteBuf buf, EntityPlayerMP player) {
        try {
            String ID;
            ByteBufInputStream stream = new ByteBufInputStream(buf);
            switch (ID = stream.readUTF()) {
                case "2n4$7Y!zSc": {
                    N2ConfigApiMessageHandler.updateConfigValues(stream, player);
                    break;
                }
                case "2n4$7c$cq@e": {
                    N2ConfigApiMessageHandler.updateFullConfig(stream, player);
                    break;
                }
                case "2n4$7D6Ite": {
                    N2ConfigApiMessageHandler.updateDeleteConfig(stream, player);
                }
            }
            stream.close();
        }
        catch (Exception e) {
            log.catching((Throwable)e);
        }
    }

    private static void updateConfigValues(ByteBufInputStream stream, EntityPlayerMP player) throws Exception {
        ConfigFile configFile = null;
        String currentString = stream.readUTF();
        if (currentString.equals(N2ConfigApiMessageHandler.getSignature(0))) {
            currentString = stream.readUTF();
            currentString = stream.readUTF();
        }
        block5: while (currentString != null) {
            configFile = ConfigHandler.getConfigFileFromName(currentString);
            if (configFile == null) {
                log.catching((Throwable)new Exception("Tried to update ConfigFile " + currentString + " which Couldn't be found!, continuing without any progress."));
                return;
            }
            if (FMLCommonHandler.instance().getEffectiveSide().isServer() && player != null && !configFile.getPermission(player)) {
                log.warn("Player " + player.getDisplayName() + " requested ConfigFile " + configFile.getFileName() + " to change with no permission!");
                continue;
            }
            ConfigApiEvents configApiEvents = ConfigApiEvents.instance;
            configApiEvents.getClass();
            EventApi.defaultEventBusInstance.raiseEvent(new ConfigApiEvents.OnPreConfigValuesChanged(configApiEvents, configFile));
            switch (configFile.createValuesFromByteBuf(stream)) {
                case 0: {
                    ConfigHandler.loadAndCheckConfigFile(configFile.getFileName());
                }
                case 1: {
                    ConfigHandler.loadAndCheckConfigFile(configFile.getFileName());
                    break block5;
                }
                case 2: {
                    break block5;
                }
                default: {
                    ConfigApiEvents configApiEvents2 = ConfigApiEvents.instance;
                    configApiEvents2.getClass();
                    EventApi.defaultEventBusInstance.raiseEvent(new ConfigApiEvents.OnPostConfigValuesChanged(configApiEvents2, configFile));
                    currentString = stream.readUTF();
                    continue block5;
                }
            }
        }
    }

    private static void updateFullConfig(ByteBufInputStream stream, EntityPlayerMP player) {
        String ID = null;
        try {
            ConfigObjectInputStream objectStream;
            String currentString = stream.readUTF();
            File parentDirectory = null;
            if (currentString.equals(N2ConfigApiMessageHandler.getSignature(0))) {
                String fileID = stream.readUTF();
                if (fileID.equals("2N4$7Det@nT")) {
                    parentDirectory = N2ConfigApi.getConfigDir();
                } else {
                    parentDirectory = N2ConfigApi.getFileDirFromID(fileID);
                    if (parentDirectory != null) {
                        if (!parentDirectory.getAbsolutePath().endsWith(stream.readUTF())) {
                            log.catching((Throwable)new Exception("Directory with ID " + fileID + " Doesn't share the same DirectoryPath as the File found with this same ID"));
                            return;
                        }
                    } else {
                        parentDirectory = N2ConfigApi.registerCustomConfigDirectory(stream.readUTF(), fileID);
                    }
                }
                currentString = ID = stream.readUTF();
                if (player != null) {
                    if (!ConfigFileMap.containsKey(currentString + player.func_110124_au())) {
                        ConfigFileMap.put(currentString + player.func_110124_au(), new ArrayList());
                    } else {
                        log.warn("Found a second packetsStreak while the first isn't processed yet!");
                    }
                } else if (!ConfigFileMap.containsKey(currentString)) {
                    ConfigFileMap.put(currentString, new ArrayList());
                } else {
                    log.warn("Found a second packetsStreak while the first isn't processed yet!");
                }
            }
            int byteLength = stream.readInt();
            byte[] byteArray = new byte[byteLength];
            List<Object> byteList = new ArrayList<Byte>();
            stream.read(byteArray, 0, byteLength);
            for (byte by : byteArray) {
                byteList.add(by);
            }
            ConfigFileMap.get(currentString).addAll(byteList);
            byteList = ConfigFileMap.get(currentString);
            currentString = stream.readUTF();
            if (currentString.equals(N2ConfigApiMessageHandler.getSignature(1))) {
                boolean isNewConfig;
                ByteBuf buff = Unpooled.directBuffer();
                buff.capacity(byteList.size());
                byteArray = new byte[byteList.size()];
                int i = 0;
                for (Byte by : byteList) {
                    byteArray[i++] = by;
                }
                buff.setBytes(0, byteArray);
                objectStream = new ConfigObjectInputStream((InputStream)new ByteBufInputStream(buff), player);
                Object object = objectStream.readObject();
                if (!(object instanceof ConfigFile)) {
                    log.catching((Throwable)new Exception("Sended Object wasn't a ConfigFile!"));
                    objectStream.close();
                    return;
                }
                ConfigFile cfg = (ConfigFile)object;
                if (player != null && !cfg.getPermission(player)) {
                    objectStream.close();
                    return;
                }
                boolean bl = isNewConfig = ConfigHandler.getConfigFileFromName(cfg.getFileName()) == null;
                if (isNewConfig) {
                    ConfigApiEvents configApiEvents = ConfigApiEvents.instance;
                    configApiEvents.getClass();
                    EventApi.defaultEventBusInstance.raiseEvent(new ConfigApiEvents.OnPreConfigAdded(configApiEvents, cfg));
                }
                if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
                    ConfigHandler.backupConfigFile(cfg.getFileName());
                }
                if (ConfigHandler.getConfigFileFromName(cfg.getFileName()) != null) {
                    ConfigHandler.removeConfigFile(ConfigHandler.getConfigFileFromName(cfg.getFileName()));
                }
                if (ConfigHandler.registerConfigFile(cfg, parentDirectory)) {
                    ConfigHandler.loadAndCheckConfigFile(cfg.getFileName());
                } else {
                    log.catching((Throwable)new Exception(" Sync Fialed! Couldn't register ConfigFile " + cfg.getFileName()));
                }
                if (isNewConfig) {
                    ConfigApiEvents configApiEvents = ConfigApiEvents.instance;
                    configApiEvents.getClass();
                    EventApi.defaultEventBusInstance.raiseEvent(new ConfigApiEvents.OnPostConfigAdded(configApiEvents, cfg));
                }
            } else {
                return;
            }
            objectStream.close();
        }
        catch (Exception e) {
            if (ID != null) {
                ConfigFileMap.remove(ID);
            }
            log.catching((Throwable)e);
        }
    }

    private static void updateDeleteConfig(ByteBufInputStream stream, EntityPlayerMP player) throws IOException {
        String currentString = stream.readUTF();
        if (currentString.equals(N2ConfigApiMessageHandler.getSignature(0))) {
            currentString = stream.readUTF();
        }
        while (currentString != null) {
            if (currentString.equals(N2ConfigApiMessageHandler.getSignature(1)) || currentString.equals(N2ConfigApiMessageHandler.getSignature(2))) {
                return;
            }
            ConfigFile configFile = ConfigHandler.getConfigFileFromName(currentString);
            if (configFile == null) {
                log.catching((Throwable)new NullPointerException("Couldn't find ConfigFile " + currentString));
            } else if (player != null) {
                if (!configFile.getPermission(player)) {
                    ConfigApiEvents configApiEvents = ConfigApiEvents.instance;
                    configApiEvents.getClass();
                    EventApi.defaultEventBusInstance.raiseEvent(new ConfigApiEvents.OnPreConfigRemoved(configApiEvents, configFile));
                    ConfigHandler.removeConfigurationFile(currentString);
                    ConfigApiEvents configApiEvents2 = ConfigApiEvents.instance;
                    configApiEvents2.getClass();
                    EventApi.defaultEventBusInstance.raiseEvent(new ConfigApiEvents.OnPostConfigRemoved(configApiEvents2, configFile));
                } else {
                    log.warn("Player " + player.getDisplayName() + " requested to delete ConfigFile " + configFile.getFileName() + " with no permission!");
                }
            } else {
                ConfigApiEvents configApiEvents = ConfigApiEvents.instance;
                configApiEvents.getClass();
                EventApi.defaultEventBusInstance.raiseEvent(new ConfigApiEvents.OnPreConfigRemoved(configApiEvents, configFile));
                ConfigHandler.removeConfigurationFile(currentString);
                ConfigApiEvents configApiEvents3 = ConfigApiEvents.instance;
                configApiEvents3.getClass();
                EventApi.defaultEventBusInstance.raiseEvent(new ConfigApiEvents.OnPostConfigRemoved(configApiEvents3, configFile));
            }
            currentString = stream.readUTF();
        }
    }

    private static boolean getPermission(EntityPlayerMP player) {
        return MinecraftServer.func_71276_C() != null && Arrays.asList((Object[])MinecraftServer.func_71276_C().func_71203_ab().func_152606_n()).contains(player.func_146103_bH().toString()) || MinecraftServer.func_71276_C().func_71203_ab().func_72365_p().func_71214_G().equalsIgnoreCase(player.func_146103_bH().toString()) || Minecraft.func_71410_x().func_71356_B();
    }

    private static class ConfigObjectInputStream
    extends ObjectInputStream {
        private final EntityPlayerMP player;

        public ConfigObjectInputStream(InputStream in, EntityPlayerMP player) throws IOException {
            super(in);
            this.player = player;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            String name = desc.getName();
            if (!name.equals("com.n247s.N2ConfigApi.api.core.DefaultConfigFile")) {
                log.warn(securityMarker, "Player {} tried to send packet that pretend to be config file, but actually: " + name, new Object[]{this.player.func_146103_bH()});
                throw new RuntimeException();
            }
            return super.resolveClass(desc);
        }
    }
}

