/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.gates;

import buildcraft.BuildCraftTransport;
import buildcraft.api.gates.GateExpansionController;
import buildcraft.api.gates.IGate;
import buildcraft.api.gates.IGateExpansion;
import buildcraft.api.statements.IActionInternal;
import buildcraft.api.statements.IStatement;
import buildcraft.transport.gates.GateExpansionBuildcraft;
import buildcraft.transport.statements.ActionEnergyPulsar;
import buildcraft.transport.statements.ActionSingleEnergyPulse;
import cofh.api.energy.IEnergyHandler;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public final class GateExpansionPulsar
extends GateExpansionBuildcraft
implements IGateExpansion {
    public static GateExpansionPulsar INSTANCE = new GateExpansionPulsar();

    private GateExpansionPulsar() {
        super("pulsar");
    }

    @Override
    public GateExpansionController makeController(TileEntity pipeTile) {
        return new GateExpansionControllerPulsar(pipeTile);
    }

    private class GateExpansionControllerPulsar
    extends GateExpansionController {
        private static final int PULSE_PERIOD = 10;
        private boolean isActive;
        private boolean singlePulse;
        private boolean hasPulsed;
        private int tick;
        private int count;

        public GateExpansionControllerPulsar(TileEntity pipeTile) {
            super(GateExpansionPulsar.this, pipeTile);
            this.tick = (int)(Math.random() * 10.0);
        }

        @Override
        public void startResolution() {
            if (this.isActive()) {
                this.disablePulse();
            }
        }

        @Override
        public boolean resolveAction(IStatement action, int count) {
            if (action instanceof ActionEnergyPulsar) {
                this.enablePulse(count);
                return true;
            }
            if (action instanceof ActionSingleEnergyPulse) {
                this.enableSinglePulse(count);
                return true;
            }
            return false;
        }

        @Override
        public void addActions(List<IActionInternal> list) {
            super.addActions(list);
            list.add(BuildCraftTransport.actionEnergyPulser);
            list.add(BuildCraftTransport.actionSingleEnergyPulse);
        }

        @Override
        public void tick(IGate gate) {
            if (!this.isActive && this.hasPulsed) {
                this.hasPulsed = false;
            }
            if (this.tick++ % 10 != 0) {
                return;
            }
            if (!this.isActive) {
                gate.setPulsing(false);
                return;
            }
            if (!(!(this.pipeTile instanceof IEnergyHandler) || this.singlePulse && this.hasPulsed)) {
                gate.setPulsing(true);
                ((IEnergyHandler)this.pipeTile).receiveEnergy(ForgeDirection.UNKNOWN, Math.min(1 << this.count - 1, 64) * 10, false);
                this.hasPulsed = true;
            } else {
                gate.setPulsing(true);
            }
        }

        private void enableSinglePulse(int count) {
            this.singlePulse = true;
            this.isActive = true;
            this.count = count;
        }

        private void enablePulse(int count) {
            this.isActive = true;
            this.singlePulse = false;
            this.count = count;
        }

        private void disablePulse() {
            if (!this.isActive) {
                this.hasPulsed = false;
            }
            this.isActive = false;
            this.count = 0;
        }

        @Override
        public boolean isActive() {
            return this.isActive;
        }

        @Override
        public void writeToNBT(NBTTagCompound nbt) {
            nbt.func_74757_a("singlePulse", this.singlePulse);
            nbt.func_74757_a("isActive", this.isActive);
            nbt.func_74757_a("hasPulsed", this.hasPulsed);
            nbt.func_74774_a("pulseCount", (byte)this.count);
            nbt.func_74768_a("tick", this.tick);
        }

        @Override
        public void readFromNBT(NBTTagCompound nbt) {
            this.isActive = nbt.func_74767_n("isActive");
            this.singlePulse = nbt.func_74767_n("singlePulse");
            this.hasPulsed = nbt.func_74767_n("hasPulsed");
            this.count = nbt.func_74771_c("pulseCount");
            this.tick = nbt.func_74762_e("tick");
        }
    }
}

