/*
 * Decompiled with CFR 0.152.
 */
package jss.bugtorch.features.squidFix;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.List;
import java.util.Random;
import jss.bugtorch.util.StaticUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class FixSquidSound {
    @SubscribeEvent
    public void onSquidLive(LivingEvent.LivingUpdateEvent event) {
        if (this.isPass((LivingEvent)event)) {
            EntitySquid sq = (EntitySquid)event.entityLiving;
            String tag = sq.func_94057_bL();
            if (tag != null && tag.equals("Nelly")) {
                Vec3 a = sq.func_70040_Z().func_72432_b();
                sq.field_70143_R = 0.0f;
                sq.func_70024_g(a.field_72450_a * (double)0.08f, (double)0.08f, a.field_72449_c * (double)0.08f);
                sq.field_70181_x = 0.08f;
                sq.field_70133_I = true;
            }
            if (sq.field_70757_a == 0 && sq.func_70090_H() && StaticUtils.getRandom((Entity)sq, 5.0)) {
                StaticUtils.playSoundAtEntityRng("entity.squid.say", (EntityLivingBase)sq);
            }
        }
    }

    @SubscribeEvent
    public void onSquidDeath(LivingDeathEvent event) {
        if (this.isPass((LivingEvent)event)) {
            EntitySquid sq = (EntitySquid)event.entityLiving;
            StaticUtils.playSoundAtEntityRng("entity.squid.death", (EntityLivingBase)sq);
        }
    }

    @SubscribeEvent
    public void onSquidHurt(LivingHurtEvent event) {
        if (this.isPass((LivingEvent)event)) {
            EntitySquid sq = (EntitySquid)event.entityLiving;
            StaticUtils.playSoundAtEntityRng("entity.squid.hurt", (EntityLivingBase)sq);
            if (StaticUtils.getRandom((Entity)sq, 15.0)) {
                this.doInk(sq);
            }
        }
    }

    private boolean isPass(LivingEvent event) {
        return !event.entity.field_70170_p.field_72995_K && EntitySquid.class.equals(event.entity.getClass());
    }

    private void doInk(EntitySquid sq) {
        World w = sq.field_70170_p;
        if (w instanceof WorldServer && sq.func_70090_H()) {
            WorldServer serverWorld = (WorldServer)w;
            Random r = serverWorld.field_73012_v;
            Vec3 boxC = StaticUtils.findBBCCenter((Entity)sq);
            List around = StaticUtils.getEntitiesAround(boxC, 3, w, EntityLivingBase.class);
            if (around.isEmpty()) {
                return;
            }
            EntityLivingBase target = (EntityLivingBase)around.get(r.nextInt(around.size()));
            if (target != null && target != sq) {
                StaticUtils.addParticles("largesmoke", (World)serverWorld, boxC, 5, 0.08f);
                StaticUtils.playSoundAtEntityRng("entity.squid.shoot", (EntityLivingBase)sq);
                if (target.func_70090_H()) {
                    this.addBlindnessEffect(target, w.field_73012_v.nextInt(300) + 20);
                }
            }
        }
    }

    private void addBlindnessEffect(EntityLivingBase e, int duration) {
        if (e == null || duration == 0) {
            return;
        }
        PotionEffect activeEff = e.func_70660_b(Potion.field_76440_q);
        int extraTime = 0;
        if (activeEff != null) {
            if (activeEff.func_76458_c() > 0) {
                return;
            }
            extraTime = activeEff.func_76459_b();
        }
        e.func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, duration + extraTime));
    }
}

