/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.machine;

import binnie.core.BinnieCore;
import binnie.core.IInitializable;
import binnie.core.Mods;
import binnie.core.machines.MachineGroup;
import binnie.core.machines.inventory.ValidatorIcon;
import binnie.genetics.Genetics;
import binnie.genetics.GeneticsCreativeTab;
import binnie.genetics.item.GeneticsItems;
import binnie.genetics.machine.AdvGeneticMachine;
import binnie.genetics.machine.GeneticMachine;
import binnie.genetics.machine.LaboratoryMachine;
import binnie.genetics.machine.acclimatiser.Acclimatiser;
import binnie.genetics.machine.incubator.Incubator;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ModuleMachine
implements IInitializable {
    public static ValidatorIcon IconDye;
    public static ValidatorIcon IconSequencer;
    public static ValidatorIcon IconSerum;
    public static ValidatorIcon IconEnzyme;
    public static ValidatorIcon IconBacteria;
    public static ValidatorIcon IconNugget;

    @Override
    public void preInit() {
        Genetics.packageGenetic = new MachineGroup(Genetics.instance, "machine", "machine", GeneticMachine.values());
        Genetics.packageGenetic.setCreativeTab(GeneticsCreativeTab.instance);
        Genetics.packageLabMachine = new MachineGroup(Genetics.instance, "labMachine", "labMachine", LaboratoryMachine.values());
        Genetics.packageLabMachine.setCreativeTab(GeneticsCreativeTab.instance);
        Genetics.packageAdvGenetic = new MachineGroup(Genetics.instance, "advMachine", "advMachine", AdvGeneticMachine.values());
        Genetics.packageAdvGenetic.setCreativeTab(GeneticsCreativeTab.instance);
    }

    @Override
    public void init() {
        IconSequencer = new ValidatorIcon(Genetics.instance, "validator/sequencer.0", "validator/sequencer.1");
        IconSerum = new ValidatorIcon(Genetics.instance, "validator/serum.0", "validator/serum.1");
        IconEnzyme = new ValidatorIcon(Genetics.instance, "validator/enzyme.0", "validator/enzyme.1");
        IconDye = new ValidatorIcon(Genetics.instance, "validator/dye.0", "validator/dye.1");
        IconNugget = new ValidatorIcon(Genetics.instance, "validator/nugget.0", "validator/nugget.1");
        IconBacteria = new ValidatorIcon(Genetics.instance, "validator/bacteria.0", "validator/bacteria.1");
        Incubator.addRecipes();
    }

    @Override
    public void postInit() {
        Acclimatiser.setupRecipes();
        Object[] standardCircuit = new Object[]{Mods.forestry.stack("chipsets", 1, 1)};
        Object[] advCircuit = new Object[]{GeneticsItems.IntegratedCircuit.get(1)};
        String ironGear = OreDictionary.getOres((String)"gearIron").isEmpty() ? "gearIron" : "ingotIron";
        String goldGear = OreDictionary.getOres((String)"gearGold").isEmpty() ? "gearIron" : "ingotIron";
        String diamondGear = OreDictionary.getOres((String)"gearDiamond").isEmpty() ? "gearIron" : "ingotIron";
        for (Object circuit : standardCircuit) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(LaboratoryMachine.Incubator.get(1), new Object[]{"gFg", "cCc", "aPa", Character.valueOf('C'), GeneticsItems.LaboratoryCasing.get(1), Character.valueOf('F'), Blocks.field_150460_al, Character.valueOf('c'), circuit, Character.valueOf('g'), Blocks.field_150410_aZ, Character.valueOf('P'), "gearBronze", Character.valueOf('a'), ironGear}));
            Item alyzer = null;
            if (BinnieCore.isApicultureActive()) {
                alyzer = Mods.forestry.item("beealyzer");
            } else if (BinnieCore.isArboricultureActive()) {
                alyzer = Mods.forestry.item("treealyzer");
            } else if (BinnieCore.isArboricultureActive()) {
                alyzer = Mods.forestry.item("flutterlyzer");
            }
            if (alyzer != null) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(LaboratoryMachine.Analyser.get(1), new Object[]{"gBg", "cCc", "aPa", Character.valueOf('C'), GeneticsItems.LaboratoryCasing.get(1), Character.valueOf('B'), alyzer, Character.valueOf('c'), circuit, Character.valueOf('g'), Blocks.field_150410_aZ, Character.valueOf('P'), "gearBronze", Character.valueOf('a'), GeneticsItems.DNADye.get(1)}));
            }
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(LaboratoryMachine.Genepool.get(1), new Object[]{"gBg", "cCc", "aPa", Character.valueOf('C'), GeneticsItems.LaboratoryCasing.get(1), Character.valueOf('B'), "gearBronze", Character.valueOf('c'), circuit, Character.valueOf('g'), Blocks.field_150410_aZ, Character.valueOf('P'), "gearBronze", Character.valueOf('a'), Blocks.field_150359_w}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(LaboratoryMachine.Acclimatiser.get(1), new Object[]{"gBg", "cCc", "aPa", Character.valueOf('C'), GeneticsItems.LaboratoryCasing.get(1), Character.valueOf('B'), Items.field_151129_at, Character.valueOf('c'), circuit, Character.valueOf('g'), Blocks.field_150410_aZ, Character.valueOf('P'), "gearBronze", Character.valueOf('a'), Items.field_151131_as}));
        }
        for (Object circuit : advCircuit) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(GeneticMachine.Isolator.get(1), new Object[]{"gBg", "cCc", "aPa", Character.valueOf('C'), GeneticsItems.LaboratoryCasing.get(1), Character.valueOf('B'), goldGear, Character.valueOf('c'), circuit, Character.valueOf('g'), Items.field_151074_bl, Character.valueOf('P'), "gearBronze", Character.valueOf('a'), GeneticsItems.Enzyme.get(1)}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(GeneticMachine.Polymeriser.get(1), new Object[]{"gBg", "cCc", "gPg", Character.valueOf('C'), GeneticsItems.LaboratoryCasing.get(1), Character.valueOf('B'), ironGear, Character.valueOf('c'), circuit, Character.valueOf('g'), Items.field_151074_bl, Character.valueOf('P'), "gearBronze"}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(GeneticMachine.Sequencer.get(1), new Object[]{"gBg", "cCc", "aPa", Character.valueOf('C'), GeneticsItems.LaboratoryCasing.get(1), Character.valueOf('B'), "gearBronze", Character.valueOf('c'), circuit, Character.valueOf('g'), Items.field_151074_bl, Character.valueOf('P'), "gearBronze", Character.valueOf('a'), GeneticsItems.FluorescentDye.get(1)}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(GeneticMachine.Inoculator.get(1), new Object[]{"gBg", "cCc", "aPa", Character.valueOf('C'), GeneticsItems.LaboratoryCasing.get(1), Character.valueOf('B'), diamondGear, Character.valueOf('c'), circuit, Character.valueOf('g'), Items.field_151074_bl, Character.valueOf('P'), "gearBronze", Character.valueOf('a'), Items.field_151166_bC}));
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(AdvGeneticMachine.Splicer.get(1), new Object[]{"gBg", "cCc", "aPa", Character.valueOf('C'), GeneticsItems.IntegratedCasing.get(1), Character.valueOf('B'), diamondGear, Character.valueOf('c'), GeneticsItems.IntegratedCPU.get(1), Character.valueOf('g'), Items.field_151074_bl, Character.valueOf('P'), "gearBronze", Character.valueOf('a'), Items.field_151072_bj}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(LaboratoryMachine.LabMachine.get(1), new Object[]{"igi", "gCg", "igi", Character.valueOf('C'), GeneticsItems.LaboratoryCasing.get(1), Character.valueOf('i'), "ingotIron", Character.valueOf('g'), Blocks.field_150410_aZ}));
    }
}

