/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.block;

import binnie.core.BinnieCore;
import binnie.core.block.IBlockMetadata;
import binnie.core.block.TileEntityMetadata;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockMetadata
extends BlockContainer
implements IBlockMetadata {
    public BlockMetadata(Material material) {
        super(material);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int blockMeta, int fortune) {
        return BlockMetadata.getBlockDropped(this, world, x, y, z, blockMeta);
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        return BlockMetadata.breakBlock(this, player, world, x, y, z);
    }

    public TileEntity func_149915_a(World world, int i) {
        return new TileEntityMetadata();
    }

    public boolean hasTileEntity(int meta) {
        return true;
    }

    public boolean func_149696_a(World world, int x, int y, int z, int par5, int par6) {
        super.func_149696_a(world, x, y, z, par5, par6);
        TileEntity tileentity = world.func_147438_o(x, y, z);
        return tileentity != null && tileentity.func_145842_c(par5, par6);
    }

    public IIcon func_149673_e(IBlockAccess block, int x, int y, int z, int par5) {
        int metadata = TileEntityMetadata.getTileMetadata(block, x, y, z);
        return this.func_149691_a(par5, metadata);
    }

    @Override
    public String getBlockName(ItemStack itemStack) {
        return this.func_149732_F();
    }

    @Override
    public void addBlockTooltip(ItemStack itemStack, List tooltip) {
    }

    @Override
    public int getPlacedMeta(ItemStack itemStack, World world, int x, int y, int z, ForgeDirection direction) {
        return TileEntityMetadata.getItemDamage(itemStack);
    }

    @Override
    public int getDroppedMeta(int blockMeta, int tileMeta) {
        return blockMeta;
    }

    public static ArrayList<ItemStack> getBlockDropped(IBlockMetadata block, World world, int x, int y, int z, int blockMeta) {
        ArrayList<ItemStack> array = new ArrayList<ItemStack>();
        TileEntityMetadata tile = TileEntityMetadata.getTile((IBlockAccess)world, x, y, z);
        if (tile != null && !tile.hasDroppedBlock()) {
            int meta = block.getDroppedMeta(world.func_72805_g(x, y, z), tile.getTileMetadata());
            array.add(TileEntityMetadata.getItemStack((Block)block, meta));
        }
        return array;
    }

    public static boolean breakBlock(IBlockMetadata block, EntityPlayer player, World world, int i, int j, int k) {
        boolean hasBeenBroken;
        ArrayList drops = new ArrayList();
        Block block2 = (Block)block;
        TileEntityMetadata tile = TileEntityMetadata.getTile((IBlockAccess)world, i, j, k);
        if (tile != null && !tile.hasDroppedBlock()) {
            drops = block2.getDrops(world, i, j, k, world.func_72805_g(i, j, k), 0);
        }
        if ((hasBeenBroken = world.func_147468_f(i, j, k)) && BinnieCore.proxy.isSimulating(world) && drops.size() > 0 && (player == null || !player.field_71075_bZ.field_75098_d)) {
            for (ItemStack drop : drops) {
                block.dropAsStack(world, i, j, k, drop);
            }
            tile.dropBlock();
        }
        return hasBeenBroken;
    }

    @Override
    public void dropAsStack(World world, int x, int y, int z, ItemStack itemStack) {
        this.func_149642_a(world, x, y, z, itemStack);
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        super.func_149749_a(world, x, y, z, block, meta);
        world.func_147475_p(x, y, z);
    }

    public static ItemStack getPickBlock(World world, int x, int y, int z) {
        IBlockMetadata block = (IBlockMetadata)world.func_147439_a(x, y, z);
        ArrayList<ItemStack> list = BlockMetadata.getBlockDropped(block, world, x, y, z, world.func_72805_g(x, y, z));
        return list.isEmpty() ? null : (ItemStack)list.get(0);
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        return BlockMetadata.getPickBlock(world, x, y, z);
    }
}

