/*
 * Decompiled with CFR 0.152.
 */
package binnie.botany.farm;

import binnie.Binnie;
import binnie.botany.Botany;
import binnie.botany.api.EnumAcidity;
import binnie.botany.api.EnumMoisture;
import binnie.botany.api.EnumSoilType;
import binnie.botany.api.gardening.IBlockSoil;
import binnie.botany.farm.FarmLogic;
import binnie.botany.farm.FarmableFlower;
import binnie.botany.farm.FarmableVanillaFlower;
import binnie.botany.flower.TileEntityFlower;
import binnie.botany.gardening.Gardening;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.farming.FarmDirection;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmable;
import forestry.core.access.IOwnable;
import forestry.core.utils.vect.IVect;
import forestry.core.utils.vect.Vect;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.FluidStack;

public class GardenLogic
extends FarmLogic {
    protected EnumMoisture moisture;
    protected EnumAcidity acidity;
    protected boolean fertilised;
    protected String name;
    protected ArrayList<ItemStack> produce = new ArrayList();
    protected List<IFarmable> farmables = new ArrayList<IFarmable>();
    private ItemStack icon;

    public GardenLogic(IFarmHousing housing) {
        super(housing);
        this.farmables.add(new FarmableFlower());
        this.farmables.add(new FarmableVanillaFlower());
    }

    public int getFertilizerConsumption() {
        return this.fertilised ? 8 : 2;
    }

    public int getWaterConsumption(float hydrationModifier) {
        return (int)((float)(this.moisture.ordinal() * 40) * hydrationModifier);
    }

    public boolean isAcceptedResource(ItemStack stack) {
        Item item = stack.func_77973_b();
        return Gardening.isSoil(item) || item == Item.func_150898_a((Block)Blocks.field_150354_m) || item == Item.func_150898_a((Block)Blocks.field_150346_d) || Gardening.isAcidFertiliser(stack) || Gardening.isAlkalineFertiliser(stack);
    }

    public Collection<ItemStack> collect() {
        ArrayList<ItemStack> products = this.produce;
        this.produce = new ArrayList();
        return products;
    }

    public boolean cultivate(int x, int y, int z, FarmDirection direction, int extent) {
        this.world = this.housing.getWorld();
        return this.maintainSoil(x, y, z, direction, extent) || !this.isManual && this.maintainWater(x, y, z, direction, extent) || this.maintainCrops(x, y + 1, z, direction, extent);
    }

    private boolean isWaste(ItemStack stack) {
        return stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150346_d);
    }

    private boolean maintainSoil(int x, int y, int z, FarmDirection direction, int extent) {
        for (int i = 0; i < extent; ++i) {
            IBlockSoil soil;
            Block block;
            Vect position = this.translateWithOffset(x, y, z, direction, i);
            boolean isSoil = Gardening.isSoil(this.world.func_147439_a(position.x, position.y, position.z));
            if (!(this.isManual || isSoil || this.isAirBlock(position))) {
                block = this.world.func_147439_a(position.x, position.y, position.z);
                if (this.moisture == EnumMoisture.DAMP) {
                    if (block != Blocks.field_150355_j) {
                        this.dropBlockAsProduction(position);
                    }
                } else if (this.moisture == EnumMoisture.DRY) {
                    if (block != Blocks.field_150354_m) {
                        this.dropBlockAsProduction(position);
                    }
                } else {
                    this.dropBlockAsProduction(position);
                }
            }
            if (this.fertilised && isSoil && (soil = (IBlockSoil)this.world.func_147439_a(position.x, position.y, position.z)).fertilise(this.world, position.x, position.y, position.z, EnumSoilType.FLOWERBED)) continue;
            if (this.world.func_147439_a(position.x, position.y + 1, position.z) == Botany.plant) {
                this.world.func_147468_f(position.x, position.y + 1, position.z);
                continue;
            }
            if (this.acidity != null && isSoil) {
                ItemStack stack;
                soil = (IBlockSoil)this.world.func_147439_a(position.x, position.y, position.z);
                EnumAcidity pH = soil.getPH(this.world, position.x, position.y, position.z);
                if (pH.ordinal() < this.acidity.ordinal() && (stack = this.getAvailableAlkaline()) != null && soil.setPH(this.world, position.x, position.y, position.z, EnumAcidity.values()[pH.ordinal() + 1])) {
                    this.housing.getFarmInventory().removeResources(new ItemStack[]{stack});
                    continue;
                }
                if (pH.ordinal() > this.acidity.ordinal() && (stack = this.getAvailableAcid()) != null && soil.setPH(this.world, position.x, position.y, position.z, EnumAcidity.values()[pH.ordinal() - 1])) {
                    this.housing.getFarmInventory().removeResources(new ItemStack[]{stack});
                    continue;
                }
            }
            if (!this.isAirBlock(position) && !this.world.func_147439_a(position.x, position.y, position.z).isReplaceable((IBlockAccess)this.world, position.x, position.y, position.z)) {
                block = this.getAsItemStack(position);
                ItemStack loam = this.getAvailableLoam();
                if (!this.isWaste((ItemStack)block) || loam == null) continue;
                this.produce.addAll(Blocks.field_150346_d.getDrops(this.world, position.x, position.y, position.z, block.func_77960_j(), 0));
                this.setBlock(position, Blocks.field_150350_a, 0);
                return this.trySetSoil(position, loam);
            }
            if (this.isManual || this.isWaterBlock(position)) continue;
            if (i % 2 == 0) {
                return this.trySetSoil(position);
            }
            FarmDirection cclock = FarmDirection.EAST;
            if (direction == FarmDirection.EAST) {
                cclock = FarmDirection.SOUTH;
            } else if (direction == FarmDirection.SOUTH) {
                cclock = FarmDirection.EAST;
            } else if (direction == FarmDirection.WEST) {
                cclock = FarmDirection.SOUTH;
            }
            Vect previous = this.translateWithOffset(position.x, position.y, position.z, cclock, 1);
            ItemStack soil2 = this.getAsItemStack(previous);
            if (Gardening.isSoil(soil2.func_77973_b())) continue;
            this.trySetSoil(position);
        }
        return false;
    }

    private boolean maintainWater(int x, int y, int z, FarmDirection direction, int extent) {
        for (int i = 0; i < extent; ++i) {
            Vect position = this.translateWithOffset(x, y, z, direction, i);
            if (!this.isAirBlock(position) && !this.world.func_147439_a(x, y, z).isReplaceable((IBlockAccess)this.world, position.x, position.y, position.z) || this.isWaterBlock(position)) continue;
            boolean isEnclosed = true;
            if (this.world.func_147437_c(position.x + 1, position.y, position.z)) {
                isEnclosed = false;
            } else if (this.world.func_147437_c(position.x - 1, position.y, position.z)) {
                isEnclosed = false;
            } else if (this.world.func_147437_c(position.x, position.y, position.z + 1)) {
                isEnclosed = false;
            } else if (this.world.func_147437_c(position.x, position.y, position.z - 1)) {
                isEnclosed = false;
            }
            boolean bl = isEnclosed = isEnclosed || this.moisture != EnumMoisture.DAMP;
            if (!isEnclosed) continue;
            return this.trySetWater(position);
        }
        return false;
    }

    private ItemStack getAvailableLoam() {
        EnumMoisture[] moistures = this.moisture == EnumMoisture.DAMP ? new EnumMoisture[]{EnumMoisture.DAMP, EnumMoisture.NORMAL, EnumMoisture.DRY} : (this.moisture == EnumMoisture.DRY ? new EnumMoisture[]{EnumMoisture.DRY, EnumMoisture.DAMP, EnumMoisture.DRY} : new EnumMoisture[]{EnumMoisture.DRY, EnumMoisture.NORMAL, EnumMoisture.DAMP});
        EnumAcidity[] acidities = new EnumAcidity[]{EnumAcidity.NEUTRAL, EnumAcidity.ACID, EnumAcidity.ALKALINE};
        for (EnumMoisture moist : moistures) {
            for (EnumAcidity acid : acidities) {
                for (Block type : new Block[]{Botany.flowerbed, Botany.loam, Botany.soil}) {
                    int meta = acid.ordinal() * 3 + moist.ordinal();
                    ItemStack[] resource = new ItemStack[]{new ItemStack(type, 1, meta)};
                    if (!this.housing.getFarmInventory().hasResources(resource)) continue;
                    return resource[0];
                }
            }
        }
        if (this.housing.getFarmInventory().hasResources(new ItemStack[]{new ItemStack(Blocks.field_150346_d)})) {
            return new ItemStack(Blocks.field_150346_d);
        }
        return null;
    }

    private boolean trySetSoil(Vect position) {
        return this.trySetSoil(position, this.getAvailableLoam());
    }

    private boolean trySetSoil(Vect position, ItemStack loam) {
        ItemStack copy = loam;
        if (loam == null) {
            return false;
        }
        if (loam.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150346_d)) {
            loam = new ItemStack((Block)Botany.soil, 0, 4);
        }
        this.setBlock(position, ((ItemBlock)loam.func_77973_b()).field_150939_a, loam.func_77960_j());
        this.housing.getFarmInventory().removeResources(new ItemStack[]{copy});
        return true;
    }

    private boolean trySetWater(Vect position) {
        FluidStack water = Binnie.Liquid.getLiquidStack("water", 1000);
        if (this.moisture == EnumMoisture.DAMP) {
            if (!this.housing.hasLiquid(water)) {
                return false;
            }
            this.setBlock(position, Blocks.field_150355_j, 0);
            this.housing.removeLiquid(water);
            return true;
        }
        if (this.moisture != EnumMoisture.DRY) {
            return this.trySetSoil(position);
        }
        ItemStack[] sand = new ItemStack[]{new ItemStack((Block)Blocks.field_150354_m, 1)};
        if (!this.housing.getFarmInventory().hasResources(sand)) {
            return false;
        }
        this.setBlock(position, (Block)Blocks.field_150354_m, 0);
        this.housing.getFarmInventory().removeResources(sand);
        return true;
    }

    private void dropBlockAsProduction(Vect position) {
        ItemStack stack = new ItemStack(this.world.func_147439_a(position.x, position.y, position.z));
        if (stack.func_77973_b() == null) {
            return;
        }
        this.produce.add(stack);
        this.world.func_147468_f(position.x, position.y, position.z);
    }

    public boolean isAcceptedGermling(ItemStack stack) {
        for (IFarmable farmable : this.farmables) {
            if (!farmable.isGermling(stack)) continue;
            return true;
        }
        return false;
    }

    public Collection<ICrop> harvest(int x, int y, int z, FarmDirection direction, int extent) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon() {
        return this.icon.func_77954_c();
    }

    public void setIcon(ItemStack icon) {
        this.icon = icon;
    }

    public ResourceLocation getSpriteSheet() {
        return TextureMap.field_110575_b;
    }

    public String getName() {
        return this.name;
    }

    protected boolean maintainCrops(int x, int y, int z, FarmDirection direction, int extent) {
        for (int i = 0; i < extent; ++i) {
            ItemStack below;
            Vect position = this.translateWithOffset(x, y, z, direction, i);
            if (!this.isAirBlock(position) && !this.world.func_147439_a(x, y, z).isReplaceable((IBlockAccess)this.world, position.x, position.y, position.z) || !Gardening.isSoil((below = this.getAsItemStack(position.add((IVect)new Vect(0, -1, 0)))).func_77973_b())) continue;
            return this.trySetCrop(position);
        }
        return false;
    }

    private boolean trySetCrop(Vect position) {
        for (IFarmable farmable : this.farmables) {
            boolean success = this.housing.plantGermling(farmable, this.world, position.x, position.y, position.z);
            if (!success || !(this.housing instanceof IOwnable)) continue;
            TileEntity tile = this.housing.getWorld().func_147438_o(position.x, position.y, position.z);
            if (!(tile instanceof TileEntityFlower)) {
                return true;
            }
            try {
                IOwnable housing2 = (IOwnable)this.housing;
                GameProfile prof = (GameProfile)IOwnable.class.getMethod("getOwnerProfile", new Class[0]).invoke((Object)housing2, new Object[0]);
                ((TileEntityFlower)tile).setOwner(prof);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    public ItemStack getAvailableAcid() {
        for (ItemStack stack : Gardening.getAcidFertilisers()) {
            if (stack == null || stack.func_77973_b() == null || !this.housing.getFarmInventory().hasResources(new ItemStack[]{stack})) continue;
            return stack;
        }
        return null;
    }

    public ItemStack getAvailableAlkaline() {
        for (ItemStack stack : Gardening.getAlkalineFertilisers()) {
            if (stack == null || stack.func_77973_b() == null || !this.housing.getFarmInventory().hasResources(new ItemStack[]{stack})) continue;
            return stack;
        }
        return null;
    }

    public void setData(EnumMoisture moisture, EnumAcidity acidity, boolean isManual, boolean fertilised, ItemStack icon, String name) {
        this.moisture = moisture;
        this.acidity = acidity;
        this.isManual = isManual;
        this.fertilised = fertilised;
        this.icon = icon;
        this.name = name;
    }
}

