/*
 * Decompiled with CFR 0.152.
 */
package binnie.botany.ceramic;

import binnie.botany.Botany;
import binnie.botany.CreativeTabBotany;
import binnie.botany.genetics.EnumFlowerColor;
import binnie.botany.items.BotanyItems;
import binnie.core.BinnieCore;
import binnie.core.block.BlockMetadata;
import binnie.core.block.IBlockMetadata;
import binnie.core.block.IMultipassBlock;
import binnie.core.block.MultipassBlockRenderer;
import binnie.core.block.TileEntityMetadata;
import binnie.core.util.I18N;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockCeramicBrick
extends Block
implements IBlockMetadata,
IMultipassBlock {
    public BlockCeramicBrick() {
        super(Material.field_151576_e);
        this.func_149711_c(1.0f);
        this.func_149752_b(5.0f);
        this.func_149663_c("ceramicBrick");
        this.func_149647_a(CreativeTabBotany.instance);
    }

    private static BlockType getType(int meta) {
        return new BlockType(meta);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int blockMeta, int fortune) {
        return BlockMetadata.getBlockDropped(this, world, x, y, z, blockMeta);
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        return BlockMetadata.breakBlock(this, player, world, x, y, z);
    }

    public TileEntity func_149915_a(World var1, int i) {
        return new TileEntityMetadata();
    }

    public boolean hasTileEntity(int meta) {
        return true;
    }

    public boolean func_149696_a(World world, int x, int y, int z, int eventId, int eventType) {
        super.func_149696_a(world, x, y, z, eventId, eventType);
        TileEntity tileentity = world.func_147438_o(x, y, z);
        return tileentity != null && tileentity.func_145842_c(eventId, eventType);
    }

    @Override
    public int getPlacedMeta(ItemStack itemStack, World world, int x, int y, int z, ForgeDirection direction) {
        return TileEntityMetadata.getItemDamage(itemStack);
    }

    @Override
    public int getDroppedMeta(int blockMeta, int tileMeta) {
        return tileMeta;
    }

    @Override
    public String getBlockName(ItemStack itemStack) {
        int meta = TileEntityMetadata.getItemDamage(itemStack);
        return BlockCeramicBrick.getType(meta).getName();
    }

    @Override
    public void addBlockTooltip(ItemStack itemStack, List tooltip) {
        int meta = TileEntityMetadata.getItemDamage(itemStack);
        BlockCeramicBrick.getType(meta).addTooltip(tooltip);
    }

    @Override
    public void dropAsStack(World world, int x, int y, int z, ItemStack itemStack) {
        this.func_149642_a(world, x, y, z, itemStack);
    }

    public void func_149666_a(Item item, CreativeTabs tab, List itemList) {
        for (EnumFlowerColor enumFlowerColor : EnumFlowerColor.values()) {
            BlockType type = new BlockType(enumFlowerColor, enumFlowerColor, TileType.Tile);
            itemList.add(TileEntityMetadata.getItemStack(this, type.ordinal()));
        }
        for (Enum enum_ : TileType.values()) {
            if (!((TileType)enum_).canDouble()) continue;
            itemList.add(new BlockType(EnumFlowerColor.BROWN, EnumFlowerColor.GOLD, (TileType)enum_).getStack(1));
        }
        itemList.add(new BlockType(EnumFlowerColor.GOLD, EnumFlowerColor.GOLD, TileType.Split).getStack(1));
        itemList.add(new BlockType(EnumFlowerColor.BROWN, EnumFlowerColor.BROWN, TileType.Chequered).getStack(1));
        itemList.add(new BlockType(EnumFlowerColor.GOLD, EnumFlowerColor.BROWN, TileType.LargeBrick).getStack(1));
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        TileEntityMetadata tile = TileEntityMetadata.getTile(world, x, y, z);
        if (tile != null) {
            return this.func_149691_a(side, tile.getTileMetadata());
        }
        return super.func_149673_e(world, x, y, z, side);
    }

    public IIcon func_149691_a(int side, int meta) {
        return BlockCeramicBrick.getType(meta).getIcon(MultipassBlockRenderer.getLayer());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        for (TileType type : TileType.values()) {
            for (int i = 0; i < 3; ++i) {
                type.icons[i] = Botany.proxy.getIcon(register, "ceramic." + type.id + "." + i);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess world, int x, int y, int z) {
        TileEntityMetadata tile = TileEntityMetadata.getTile(world, x, y, z);
        if (tile != null) {
            return this.func_149741_i(tile.getTileMetadata());
        }
        return 0xFFFFFF;
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int side) {
        super.func_149749_a(world, x, y, z, block, side);
        world.func_147475_p(x, y, z);
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        return BlockMetadata.getPickBlock(world, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149741_i(int meta) {
        return this.colorMultiplier(meta);
    }

    @Override
    public int getNumberOfPasses() {
        return 3;
    }

    @Override
    public int colorMultiplier(int meta) {
        BlockType type = BlockCeramicBrick.getType(meta);
        if (MultipassBlockRenderer.getLayer() == 0) {
            return 0xFFFFFF;
        }
        if (MultipassBlockRenderer.getLayer() == 1) {
            return type.color1.getColor(false);
        }
        return type.color2.getColor(false);
    }

    public int func_149645_b() {
        return BinnieCore.multipassRenderID;
    }

    public static class BlockType {
        protected EnumFlowerColor color1;
        protected EnumFlowerColor color2;
        protected TileType type;

        private BlockType(EnumFlowerColor color1, EnumFlowerColor color2, TileType type) {
            this.color1 = color1;
            this.color2 = color2;
            this.type = type;
        }

        public boolean isTwoColors() {
            return this.type.canDouble() && this.color2 != this.color1;
        }

        public BlockType(ItemStack stack) {
            this(TileEntityMetadata.getItemDamage(stack));
        }

        public ItemStack getStack(int stackSize) {
            ItemStack stack = TileEntityMetadata.getItemStack(Botany.ceramicBrick, this.ordinal());
            stack.field_77994_a = stackSize;
            return stack;
        }

        public BlockType(int id) {
            this.color1 = EnumFlowerColor.get(id & 0xFF);
            this.color2 = EnumFlowerColor.get(id >> 8 & 0xFF);
            this.type = TileType.get(id >> 16 & 0xFF);
        }

        public String getName() {
            return I18N.localise("botany." + this.type.name);
        }

        public void addTooltip(List tooltip) {
            String name = this.color1.getName();
            if (this.type.canDouble() && this.color2 != this.color1) {
                name = I18N.localise("botany.colour.double", name, this.color2.getName());
            }
            tooltip.add(EnumChatFormatting.GRAY + name);
        }

        public int ordinal() {
            return this.color1.ordinal() + this.color2.ordinal() * 256 + this.type.ordinal() * 65536;
        }

        public IIcon getIcon(int layer) {
            return this.type.icons[layer];
        }
    }

    public static enum TileType {
        Tile("tile", "ceramicTile"),
        Brick("brick", "ceramicBricks"),
        StripeBrick("brickstripe", "strippedCeramicBricks"),
        LargeBrick("bricklarge", "largeCeramicBricks"),
        Split("split", "splitCeramicTile"),
        Chequered("cheque", "chequeredCeramicTile"),
        Mixed("mixed", "mixedCeramicTile"),
        VerticalBrick("verticalbrick", "verticalCeramicBricks"),
        VerticalStripeBrick("verticalbrickstripe", "verticalStripedCeramicBricks"),
        VerticalLargeBrick("verticalbricklarge", "largeVerticalCeramicBricks");

        protected String id;
        protected String name;
        protected IIcon[] icons = new IIcon[3];

        private TileType(String id, String name) {
            this.id = id;
            this.name = name;
        }

        public static TileType get(int id) {
            return TileType.values()[id % TileType.values().length];
        }

        public boolean canDouble() {
            return this != Tile;
        }

        public ItemStack getRecipe(List<ItemStack> stacks) {
            switch (this) {
                case Tile: {
                    return this.getTileRecipe(stacks);
                }
                case Split: {
                    return this.getSplitRecipe(stacks);
                }
                case Chequered: {
                    return this.getChequeredRecipe(stacks);
                }
                case Mixed: {
                    return this.getMixedRecipe(stacks);
                }
                case LargeBrick: {
                    return this.getLargeBrickRecipe(stacks);
                }
                case Brick: 
                case StripeBrick: {
                    return this.getBrickRecipe(stacks);
                }
                case VerticalLargeBrick: 
                case VerticalBrick: 
                case VerticalStripeBrick: {
                    return this.getVerticalBrickRecipe(stacks);
                }
            }
            return null;
        }

        private ItemStack getTileRecipe(List<ItemStack> stacks) {
            if (stacks.size() != 4) {
                return null;
            }
            int mortars = 0;
            int blockColor = -1;
            for (ItemStack stack : stacks) {
                if (this.isMortar(stack)) {
                    ++mortars;
                    continue;
                }
                if (stack.func_77973_b() != Item.func_150898_a((Block)Botany.ceramic)) {
                    return null;
                }
                int color = TileEntityMetadata.getItemDamage(stack);
                if (blockColor == -1) {
                    blockColor = color;
                    continue;
                }
                if (blockColor == color) continue;
                return null;
            }
            if (mortars != 1) {
                return null;
            }
            EnumFlowerColor c = EnumFlowerColor.get(blockColor);
            return new BlockType(c, c, Tile).getStack(3);
        }

        private ItemStack getSplitRecipe(List<ItemStack> stacks) {
            if (stacks.size() != 4) {
                return null;
            }
            int[] colors = new int[]{-1, -1};
            int altCounter = 0;
            for (ItemStack stack : stacks) {
                int alt;
                int n = alt = altCounter != 0 && altCounter != 3 ? 1 : 0;
                if (stack.func_77973_b() != Item.func_150898_a((Block)Botany.ceramicBrick)) {
                    return null;
                }
                BlockType type = new BlockType(stack);
                if (type.type != Tile) {
                    return null;
                }
                int color2 = type.color1.ordinal();
                if (colors[alt] == -1) {
                    colors[alt] = color2;
                } else if (colors[alt] != color2) {
                    return null;
                }
                ++altCounter;
            }
            return new BlockType(EnumFlowerColor.get(colors[0]), EnumFlowerColor.get(colors[1]), Split).getStack(4);
        }

        private ItemStack getChequeredRecipe(List<ItemStack> stacks) {
            if (stacks.size() != 4) {
                return null;
            }
            int[] colors = new int[]{-1, -1};
            for (ItemStack stack : stacks) {
                if (stack.func_77973_b() != Item.func_150898_a((Block)Botany.ceramicBrick)) {
                    return null;
                }
                BlockType type2 = new BlockType(stack);
                if (type2.type != Split) {
                    return null;
                }
                int color1 = type2.color1.ordinal();
                int color2 = type2.color2.ordinal();
                if (colors[0] == -1) {
                    colors[0] = color1;
                    colors[1] = color2;
                    continue;
                }
                if (colors[0] == color1 && colors[1] == color2) continue;
                return null;
            }
            return new BlockType(EnumFlowerColor.get(colors[0]), EnumFlowerColor.get(colors[1]), Chequered).getStack(4);
        }

        private ItemStack getMixedRecipe(List<ItemStack> stacks) {
            if (stacks.size() != 4) {
                return null;
            }
            int[] colors = new int[]{-1, -1};
            for (ItemStack stack : stacks) {
                if (stack.func_77973_b() != Item.func_150898_a((Block)Botany.ceramicBrick)) {
                    return null;
                }
                BlockType type2 = new BlockType(stack);
                if (type2.isTwoColors()) {
                    return null;
                }
                int color3 = type2.color1.ordinal();
                if (type2.type == Split) {
                    if (colors[1] != -1) {
                        return null;
                    }
                    colors[1] = color3;
                    continue;
                }
                if (type2.type != Chequered) {
                    return null;
                }
                if (colors[0] == -1) {
                    colors[0] = color3;
                    continue;
                }
                if (colors[0] == color3) continue;
                return null;
            }
            if (colors[0] == -1 || colors[1] == -1) {
                return null;
            }
            return new BlockType(EnumFlowerColor.get(colors[0]), EnumFlowerColor.get(colors[1]), Mixed).getStack(4);
        }

        private ItemStack getLargeBrickRecipe(List<ItemStack> stacks) {
            if (stacks.size() == 1) {
                ItemStack stack3 = stacks.get(0);
                BlockType type3 = new BlockType(stack3);
                if (type3.type == VerticalLargeBrick) {
                    type3.type = this;
                    return type3.getStack(1);
                }
                return null;
            }
            if (stacks.size() != 3) {
                return null;
            }
            int[] colors = new int[]{-1, -1};
            for (ItemStack stack4 : stacks) {
                if (stack4.func_77973_b() != Item.func_150898_a((Block)Botany.ceramicBrick)) {
                    return null;
                }
                BlockType type4 = new BlockType(stack4);
                if (type4.type != Tile) {
                    return null;
                }
                int color5 = type4.color1.ordinal();
                if (colors[0] == -1) {
                    colors[0] = color5;
                    continue;
                }
                if (colors[1] == -1) {
                    colors[1] = color5;
                    continue;
                }
                if (colors[1] == color5) continue;
                return null;
            }
            if (colors[1] == -1) {
                colors[1] = colors[0];
            }
            return new BlockType(EnumFlowerColor.get(colors[0]), EnumFlowerColor.get(colors[1]), LargeBrick).getStack(3);
        }

        private ItemStack getBrickRecipe(List<ItemStack> stacks) {
            if (stacks.size() == 1) {
                ItemStack stack = stacks.get(0);
                BlockType type = new BlockType(stack);
                if (type.type == VerticalBrick) {
                    type.type = this;
                    return type.getStack(1);
                }
                if (type.type == StripeBrick) {
                    type.type = this;
                    return type.getStack(1);
                }
                return null;
            }
            if (stacks.size() != 4) {
                return null;
            }
            int[] colors = new int[]{-1, -1};
            for (int index2 = 0; index2 < stacks.size(); ++index2) {
                int alt2;
                ItemStack stack = stacks.get(index2);
                if (stack.func_77973_b() != Item.func_150898_a((Block)Botany.ceramicBrick)) {
                    return null;
                }
                BlockType type = new BlockType(stack);
                if (type.type != LargeBrick) {
                    return null;
                }
                int color5 = type.color1.ordinal();
                int color6 = type.color2.ordinal();
                int n = alt2 = index2 != 0 && index2 != 3 ? 1 : 0;
                if (this == StripeBrick) {
                    alt2 = 0;
                }
                if (colors[alt2] == -1) {
                    colors[alt2] = color5;
                    colors[1 - alt2] = color6;
                    continue;
                }
                if (colors[alt2] == color5 && colors[1 - alt2] == color6) continue;
                return null;
            }
            return new BlockType(EnumFlowerColor.get(colors[0]), EnumFlowerColor.get(colors[1]), this).getStack(4);
        }

        private ItemStack getVerticalBrickRecipe(List<ItemStack> stacks) {
            if (stacks.size() != 1) {
                return null;
            }
            ItemStack stack5 = stacks.get(0);
            BlockType type = new BlockType(stack5);
            if (type.type == LargeBrick) {
                type.type = VerticalLargeBrick;
                return type.getStack(1);
            }
            if (type.type == Brick) {
                type.type = VerticalBrick;
                return type.getStack(1);
            }
            if (type.type == StripeBrick) {
                type.type = VerticalStripeBrick;
                return type.getStack(1);
            }
            return null;
        }

        private boolean isMortar(ItemStack stack) {
            return stack.func_77973_b() == Botany.misc && stack.func_77960_j() == BotanyItems.Mortar.ordinal();
        }
    }
}

