/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.items;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mods.battlegear2.Battlegear;
import mods.battlegear2.api.heraldry.IHeraldryItem;
import mods.battlegear2.api.heraldry.IHeraldyArmour;
import mods.battlegear2.api.heraldry.PatternStore;
import mods.battlegear2.client.heraldry.HeraldryArmourModel;
import mods.battlegear2.heraldry.SigilHelper;
import mods.battlegear2.utils.BattlegearConfig;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;

public class ItemKnightArmour
extends ItemArmor
implements IHeraldyArmour,
ISpecialArmor {
    private IIcon[] baseIcon;
    private IIcon[] postRenderIcon;
    private IIcon trimRenderIcon;
    private Object modelObject;
    private final float motionFactor;

    public ItemKnightArmour(int armourType) {
        super(Battlegear.knightArmourMaterial, 1, armourType);
        this.func_77637_a(BattlegearConfig.customTab);
        this.func_77655_b("battlegear2:knights_armour." + BattlegearConfig.armourTypes[armourType]);
        this.motionFactor = armourType == 1 ? -0.2f : (armourType == 2 ? -0.15f : -0.05f);
        GameRegistry.registerItem((Item)this, (String)("knights_armour." + BattlegearConfig.armourTypes[armourType]));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        if (this.field_77881_a == 0) {
            this.baseIcon = new IIcon[4];
            this.postRenderIcon = new IIcon[4];
            for (int i = 0; i < 4; ++i) {
                this.baseIcon[i] = par1IconRegister.func_94245_a("battlegear2:armours/knight-base-" + BattlegearConfig.armourTypes[this.field_77881_a] + "-" + i);
                this.postRenderIcon[i] = par1IconRegister.func_94245_a("battlegear2:armours/knight-post-" + BattlegearConfig.armourTypes[this.field_77881_a] + "-" + i);
            }
        } else {
            this.baseIcon = new IIcon[1];
            this.postRenderIcon = new IIcon[1];
            this.baseIcon[0] = par1IconRegister.func_94245_a("battlegear2:armours/knight-base-" + BattlegearConfig.armourTypes[this.field_77881_a]);
            this.postRenderIcon[0] = par1IconRegister.func_94245_a("battlegear2:armours/knight-post-" + BattlegearConfig.armourTypes[this.field_77881_a]);
        }
        if (this.field_77881_a == 2) {
            this.trimRenderIcon = par1IconRegister.func_94245_a("battlegear2:armours/knight-trim-" + BattlegearConfig.armourTypes[this.field_77881_a]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77650_f(ItemStack stack) {
        return this.getPostRenderIcon(stack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getBaseIcon(ItemStack stack) {
        if (this.field_77881_a == 0) {
            return this.baseIcon[SigilHelper.getHelm(((IHeraldryItem)stack.func_77973_b()).getHeraldry(stack))];
        }
        return this.baseIcon[0];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getPostRenderIcon(ItemStack stack) {
        if (this.field_77881_a == 0) {
            return this.postRenderIcon[SigilHelper.getHelm(((IHeraldryItem)stack.func_77973_b()).getHeraldry(stack))];
        }
        return this.postRenderIcon[0];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getTrimIcon(ItemStack stack) {
        return this.trimRenderIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        ItemStack armor = new ItemStack(par1);
        this.setHeraldry(armor, SigilHelper.getDefault());
        par3List.add(armor);
    }

    @Override
    public boolean hasHeraldry(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b("hc1");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack armor, EntityPlayer player, List par3List, boolean par4) {
        super.func_77624_a(armor, player, par3List, par4);
        par3List.add(String.format("%s +%d %s", EnumChatFormatting.BLUE, this.field_77879_b, StatCollector.func_74838_a((String)"tooltip.armour.points")));
        par3List.add(EnumChatFormatting.RED + StatCollector.func_74837_a((String)"attribute.modifier.take.2", (Object[])new Object[]{ItemStack.field_111284_a.format((double)(-this.motionFactor) * 100.0), StatCollector.func_74838_a((String)"attribute.name.generic.movementSpeed")}));
    }

    @Override
    public byte[] getHeraldry(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!stack.func_77978_p().func_74764_b("hc1")) {
            stack.func_77978_p().func_74773_a("hc1", SigilHelper.getDefault());
        }
        return stack.func_77978_p().func_74770_j("hc1");
    }

    @Override
    public void setHeraldry(ItemStack stack, byte[] code) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74773_a("hc1", code);
    }

    @Override
    public void removeHeraldry(ItemStack item) {
        if (item.func_77942_o()) {
            item.func_77978_p().func_74773_a("hc1", SigilHelper.getDefault());
        }
    }

    @Override
    public boolean shouldDoPass(IHeraldryItem.HeraldyRenderPassess pass) {
        return true;
    }

    @Override
    public boolean useDefaultRenderer() {
        return true;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String layer) {
        return "battlegear2:textures/armours/knights/knights-" + (slot == 2 ? 1 : 0) + ".png";
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, int armorSlot) {
        if (this.modelObject == null) {
            this.modelObject = new HeraldryArmourModel(this.field_77881_a);
        }
        HeraldryArmourModel model = (HeraldryArmourModel)((Object)this.modelObject);
        model.setItemStack(itemStack);
        if (armorSlot == 0) {
            model.field_78116_c.field_78806_j = true;
        } else if (armorSlot == 1) {
            model.field_78115_e.field_78806_j = true;
            model.field_78112_f.field_78806_j = true;
            model.field_78113_g.field_78806_j = true;
        } else {
            model.field_78123_h.field_78806_j = true;
            model.field_78124_i.field_78806_j = true;
            boolean bl = model.field_78115_e.field_78806_j = armorSlot == 2;
        }
        if (entityLiving != null) {
            Render renderer;
            ItemStack heldRight = entityLiving.func_70694_bm();
            int n = model.field_78120_m = heldRight == null ? 0 : 1;
            if (entityLiving instanceof EntityPlayer && (renderer = RenderManager.field_78727_a.func_78713_a((Entity)entityLiving)) instanceof RenderPlayer) {
                ModelBiped modelArmor = armorSlot == 2 ? ((RenderPlayer)renderer).field_77111_i : ((RenderPlayer)renderer).field_77108_b;
                model.field_78119_l = modelArmor.field_78119_l;
                model.field_78120_m = modelArmor.field_78120_m;
                model.field_78118_o = modelArmor.field_78118_o;
            }
            model.field_78117_n = entityLiving.func_70093_af();
        }
        return model;
    }

    @Override
    public String getBaseArmourPath(int armourSlot) {
        return "battlegear2:textures/armours/knights/knights-base-" + (armourSlot == 2 ? 1 : 0) + ".png";
    }

    @Override
    public String getPatternArmourPath(PatternStore pattern, int index, int armourSlot) {
        return "battlegear2:textures/armours/knights/patterns/knights-pattern-" + (armourSlot == 2 ? 1 : 0) + "-" + index + ".png";
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        int max = this.getMaxAbsorption(armor);
        if (slot == 1 || slot == 2) {
            return new ISpecialArmor.ArmorProperties(1, 0.8, max);
        }
        if (slot == 0) {
            return new ISpecialArmor.ArmorProperties(0, 0.6, max);
        }
        if (slot == 3) {
            return new ISpecialArmor.ArmorProperties(0, 0.4, max);
        }
        return null;
    }

    public int getMaxAbsorption(ItemStack armor) {
        return armor.func_77958_k() + 1 - armor.func_77960_j();
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        if (slot == 1 && player.func_71124_b(1) != null && player.func_71124_b(1).func_77973_b() instanceof ItemKnightArmour && player.func_71124_b(3) != null && player.func_71124_b(3).func_77973_b() instanceof ItemKnightArmour && player.func_71124_b(4) != null && player.func_71124_b(4).func_77973_b() instanceof ItemKnightArmour) {
            return 9;
        }
        return this.field_77879_b;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        stack.func_77972_a(damage, entity);
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        player.field_70159_w *= (double)(1.0f + this.motionFactor);
        player.field_70179_y *= (double)(1.0f + this.motionFactor);
        if (player.field_70181_x > 0.005) {
            player.field_70181_x *= (double)(1.0f + this.motionFactor);
        }
    }
}

