/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.client.renderer;

import mods.battlegear2.MobHookContainerClass;
import mods.battlegear2.api.quiver.IArrowContainer2;
import mods.battlegear2.api.quiver.QuiverArrowRegistry;
import mods.battlegear2.client.ClientProxy;
import mods.battlegear2.client.utils.BattlegearRenderHelper;
import mods.battlegear2.utils.BattlegearConfig;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class BowRenderer
implements IItemRenderer {
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return type == IItemRenderer.ItemRenderType.EQUIPPED || type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return false;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        switch (type) {
            case EQUIPPED_FIRST_PERSON: {
                this.renderEquippedBow(item, (EntityLivingBase)data[1], true);
                break;
            }
            case EQUIPPED: {
                this.renderEquippedBow(item, (EntityLivingBase)data[1], false);
            }
        }
    }

    private void renderEquippedBow(ItemStack item, EntityLivingBase entityLivingBase, boolean firstPerson) {
        IIcon icon = item.func_77954_c();
        ItemStack arrowStack = new ItemStack(Items.field_151032_g);
        int drawAmount = -2;
        boolean drawArrows = false;
        if (entityLivingBase instanceof EntityPlayer) {
            ItemStack quiver;
            EntityPlayer player = (EntityPlayer)entityLivingBase;
            int timer = player.func_71057_bx();
            if (timer > 0) {
                drawAmount = timer >= 18 ? 2 : (timer > 13 ? 1 : 0);
                drawArrows = true;
            }
            if ((quiver = QuiverArrowRegistry.getArrowContainer(item, (EntityPlayer)entityLivingBase)) != null) {
                arrowStack = ((IArrowContainer2)quiver.func_77973_b()).getStackInSlot(quiver, ((IArrowContainer2)quiver.func_77973_b()).getSelectedSlot(quiver));
            }
            if (drawAmount >= 0) {
                icon = arrowStack != null && QuiverArrowRegistry.isKnownArrow(arrowStack) ? ClientProxy.bowIcons[drawAmount] : Items.field_151031_f.func_94599_c(drawAmount);
            }
        } else if (entityLivingBase instanceof EntitySkeleton) {
            arrowStack = MobHookContainerClass.INSTANCE.getArrowForMob((EntitySkeleton)entityLivingBase);
            drawArrows = true;
        } else if (entityLivingBase == null || entityLivingBase.equals((Object)BattlegearRenderHelper.dummyEntity)) {
            arrowStack = null;
        }
        if (BattlegearConfig.arrowForceRendered) {
            drawArrows = true;
        }
        Tessellator tessellator = Tessellator.field_78398_a;
        ItemRenderer.func_78439_a((Tessellator)tessellator, (float)icon.func_94212_f(), (float)icon.func_94206_g(), (float)icon.func_94209_e(), (float)icon.func_94210_h(), (int)icon.func_94211_a(), (int)icon.func_94216_b(), (float)0.0625f);
        if (drawArrows && QuiverArrowRegistry.isKnownArrow(arrowStack)) {
            assert (arrowStack != null);
            icon = arrowStack.func_77954_c();
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(-(-3.0f + (float)drawAmount) / 16.0f), (float)(-(-2.0f + (float)drawAmount) / 16.0f), (float)(firstPerson ? -0.03125f : 0.03125f));
            ItemRenderer.func_78439_a((Tessellator)tessellator, (float)icon.func_94209_e(), (float)icon.func_94206_g(), (float)icon.func_94212_f(), (float)icon.func_94210_h(), (int)icon.func_94211_a(), (int)icon.func_94216_b(), (float)0.0625f);
            GL11.glPopMatrix();
        }
        if (item.hasEffect(0)) {
            BattlegearRenderHelper.renderEnchantmentEffects(tessellator);
        }
    }
}

