/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.system.material.werkstoff_loaders.recipe;

import com.github.bartimaeusnek.bartworks.system.material.Werkstoff;
import com.github.bartimaeusnek.bartworks.system.material.WerkstoffLoader;
import com.github.bartimaeusnek.bartworks.system.material.werkstoff_loaders.IWerkstoffRunnable;
import com.github.bartimaeusnek.bartworks.util.BWRecipes;
import com.github.bartimaeusnek.bartworks.util.Pair;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.TextureSet;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class DustLoader
implements IWerkstoffRunnable {
    @Override
    public void run(Werkstoff werkstoff) {
        if (werkstoff.hasItemType(OrePrefixes.dust)) {
            ArrayList<FluidStack> flOutputs = new ArrayList<FluidStack>();
            ArrayList<ItemStack> stOutputs = new ArrayList<ItemStack>();
            HashMap tracker = new HashMap();
            int cells = 0;
            if (werkstoff.getGenerationFeatures().hasMixerRecipes() || werkstoff.getStats().isElektrolysis() || werkstoff.getStats().isCentrifuge() || werkstoff.getGenerationFeatures().hasChemicalRecipes()) {
                for (Pair container : werkstoff.getContents().getValue().toArray(new Pair[0])) {
                    FluidStack tmpFl;
                    if (container.getKey() instanceof Materials) {
                        if ((((Materials)container.getKey()).getGas(0L) != null || ((Materials)container.getKey()).getFluid(0L) != null || ((Materials)container.getKey()).mIconSet == TextureSet.SET_FLUID) && ((Materials)container.getKey()).getDust(0) == null) {
                            tmpFl = ((Materials)container.getKey()).getGas(1000L * (long)((Integer)container.getValue()).intValue());
                            if (tmpFl == null || tmpFl.getFluid() == null) {
                                tmpFl = ((Materials)container.getKey()).getFluid(1000L * (long)((Integer)container.getValue()).intValue());
                            }
                            flOutputs.add(tmpFl);
                            if (flOutputs.size() <= 1) continue;
                            if (!tracker.containsKey(container.getKey())) {
                                stOutputs.add(((Materials)container.getKey()).getCells(((Integer)container.getValue()).intValue()));
                                tracker.put(container.getKey(), new Pair(container.getValue(), stOutputs.size() - 1));
                            } else {
                                stOutputs.add(((Materials)container.getKey()).getCells((Integer)((Pair)tracker.get(container.getKey())).getKey() + (Integer)container.getValue()));
                                stOutputs.remove((Integer)((Pair)tracker.get(container.getKey())).getValue() + 1);
                            }
                            cells += ((Integer)container.getValue()).intValue();
                            continue;
                        }
                        if (((Materials)container.getKey()).getDust(((Integer)container.getValue()).intValue()) == null) {
                            if (((Materials)container.getKey()).getCells(((Integer)container.getValue()).intValue()) == null || ((Materials)container.getKey()).getMolten(0L) == null && ((Materials)container.getKey()).getSolid(0L) == null) continue;
                            tmpFl = ((Materials)container.getKey()).getMolten(1000L * (long)((Integer)container.getValue()).intValue());
                            if (tmpFl == null || tmpFl.getFluid() == null) {
                                tmpFl = ((Materials)container.getKey()).getSolid(1000L * (long)((Integer)container.getValue()).intValue());
                            }
                            flOutputs.add(tmpFl);
                            if (flOutputs.size() > 1) {
                                if (!tracker.containsKey(container.getKey())) {
                                    stOutputs.add(((Materials)container.getKey()).getCells(((Integer)container.getValue()).intValue()));
                                    tracker.put(container.getKey(), new Pair(container.getValue(), stOutputs.size() - 1));
                                } else {
                                    stOutputs.add(((Materials)container.getKey()).getCells((Integer)((Pair)tracker.get(container.getKey())).getKey() + (Integer)container.getValue()));
                                    stOutputs.remove((Integer)((Pair)tracker.get(container.getKey())).getValue() + 1);
                                }
                                cells += ((Integer)container.getValue()).intValue();
                            }
                        }
                        if (!tracker.containsKey(container.getKey())) {
                            stOutputs.add(((Materials)container.getKey()).getDust(((Integer)container.getValue()).intValue()));
                            tracker.put(container.getKey(), new Pair(container.getValue(), stOutputs.size() - 1));
                            continue;
                        }
                        stOutputs.add(((Materials)container.getKey()).getDust((Integer)((Pair)tracker.get(container.getKey())).getKey() + (Integer)container.getValue()));
                        stOutputs.remove((Integer)((Pair)tracker.get(container.getKey())).getValue() + 1);
                        continue;
                    }
                    if (!(container.getKey() instanceof Werkstoff)) continue;
                    if (((Werkstoff)container.getKey()).getStats().isGas() || ((Werkstoff)container.getKey()).hasItemType(OrePrefixes.cell)) {
                        tmpFl = ((Werkstoff)container.getKey()).getFluidOrGas(1000 * (Integer)container.getValue());
                        if (tmpFl == null || tmpFl.getFluid() == null) {
                            tmpFl = ((Werkstoff)container.getKey()).getFluidOrGas(1000 * (Integer)container.getValue());
                        }
                        flOutputs.add(tmpFl);
                        if (flOutputs.size() <= 1) continue;
                        if (!tracker.containsKey(container.getKey())) {
                            stOutputs.add(((Werkstoff)container.getKey()).get(OrePrefixes.cell, (Integer)container.getValue()));
                            tracker.put(container.getKey(), new Pair(container.getValue(), stOutputs.size() - 1));
                        } else {
                            stOutputs.add(((Werkstoff)container.getKey()).get(OrePrefixes.cell, (Integer)((Pair)tracker.get(container.getKey())).getKey() + (Integer)container.getValue()));
                            stOutputs.remove((Integer)((Pair)tracker.get(container.getKey())).getValue() + 1);
                        }
                        cells += ((Integer)container.getValue()).intValue();
                        continue;
                    }
                    if (!((Werkstoff)container.getKey()).hasItemType(OrePrefixes.dust)) continue;
                    if (!tracker.containsKey(container.getKey())) {
                        stOutputs.add(((Werkstoff)container.getKey()).get(OrePrefixes.dust, (Integer)container.getValue()));
                        tracker.put(container.getKey(), new Pair(container.getValue(), stOutputs.size() - 1));
                        continue;
                    }
                    stOutputs.add(((Werkstoff)container.getKey()).get(OrePrefixes.dust, (Integer)((Pair)tracker.get(container.getKey())).getKey() + (Integer)container.getValue()));
                    stOutputs.remove((Integer)((Pair)tracker.get(container.getKey())).getValue() + 1);
                }
                ItemStack input = werkstoff.get(OrePrefixes.dust);
                input.field_77994_a = werkstoff.getContents().getKey();
                if (werkstoff.getStats().isElektrolysis()) {
                    BWRecipes.DynamicGTRecipe tRecipe = new BWRecipes.DynamicGTRecipe(true, new ItemStack[]{input, cells > 0 ? Materials.Empty.getCells(cells) : null}, stOutputs.toArray(new ItemStack[0]), null, null, new FluidStack[]{null}, new FluidStack[]{flOutputs.size() > 0 ? (FluidStack)flOutputs.get(0) : null}, (int)Math.max(1L, Math.abs(werkstoff.getStats().getProtons() / (long)werkstoff.getContents().getValue().size())), Math.min(4, werkstoff.getContents().getValue().size()) * 30, 0);
                    GT_Recipe.GT_Recipe_Map.sElectrolyzerRecipes.add((GT_Recipe)tRecipe);
                    GT_Recipe.GT_Recipe_Map.sMultiblockElectrolyzerRecipes.add((GT_Recipe)tRecipe);
                }
                if (werkstoff.getStats().isCentrifuge()) {
                    GT_Recipe.GT_Recipe_Map.sCentrifugeRecipes.add((GT_Recipe)new BWRecipes.DynamicGTRecipe(true, new ItemStack[]{input, cells > 0 ? Materials.Empty.getCells(cells) : null}, stOutputs.toArray(new ItemStack[0]), null, null, new FluidStack[]{null}, new FluidStack[]{flOutputs.size() > 0 ? (FluidStack)flOutputs.get(0) : null}, (int)Math.max(1L, Math.abs(werkstoff.getStats().getMass() / (long)werkstoff.getContents().getValue().size())), Math.min(4, werkstoff.getContents().getValue().size()) * 5, 0));
                    GT_Recipe tRecipe = new GT_Recipe(false, stOutputs.toArray(new ItemStack[0]), new ItemStack[]{input}, null, null, new FluidStack[]{flOutputs.size() > 0 ? (FluidStack)flOutputs.get(0) : null}, null, (int)Math.max(1L, Math.abs(werkstoff.getStats().getProtons() / (long)werkstoff.getContents().getValue().size())), Math.min(4, werkstoff.getContents().getValue().size()) * 30, 0);
                    GT_Recipe.GT_Recipe_Map.sMultiblockCentrifugeRecipes.add(tRecipe);
                }
                if (werkstoff.getGenerationFeatures().hasChemicalRecipes()) {
                    if (cells > 0) {
                        stOutputs.add(Materials.Empty.getCells(cells));
                    }
                    GT_Recipe.GT_Recipe_Map.sChemicalRecipes.add((GT_Recipe)new BWRecipes.DynamicGTRecipe(true, stOutputs.toArray(new ItemStack[0]), new ItemStack[]{input}, null, null, new FluidStack[]{flOutputs.size() > 0 ? (FluidStack)flOutputs.get(0) : null}, null, (int)Math.max(1L, Math.abs(werkstoff.getStats().getProtons() / (long)werkstoff.getContents().getValue().size())), Math.min(4, werkstoff.getContents().getValue().size()) * 30, 0));
                    GT_Recipe.GT_Recipe_Map.sMultiblockChemicalRecipes.addRecipe(true, stOutputs.toArray(new ItemStack[0]), new ItemStack[]{input}, null, null, new FluidStack[]{flOutputs.size() > 0 ? (FluidStack)flOutputs.get(0) : null}, null, (int)Math.max(1L, Math.abs(werkstoff.getStats().getProtons() / (long)werkstoff.getContents().getValue().size())), Math.min(4, werkstoff.getContents().getValue().size()) * 30, 0);
                }
                if (werkstoff.getGenerationFeatures().hasMixerRecipes()) {
                    short circuitID;
                    ItemStack circuit;
                    if (cells > 0) {
                        stOutputs.add(Materials.Empty.getCells(cells));
                    }
                    ItemStack itemStack = circuit = (circuitID = werkstoff.getMixCircuit()) == -1 ? null : GT_Utility.getIntegratedCircuit((int)circuitID);
                    if (circuit != null) {
                        stOutputs.add(circuit);
                    }
                    GT_Recipe.GT_Recipe_Map.sMixerRecipes.add((GT_Recipe)new BWRecipes.DynamicGTRecipe(true, stOutputs.toArray(new ItemStack[0]), new ItemStack[]{input}, null, null, new FluidStack[]{flOutputs.size() > 0 ? (FluidStack)flOutputs.get(0) : null}, null, (int)Math.max(1L, Math.abs(werkstoff.getStats().getMass() / (long)werkstoff.getContents().getValue().size())), Math.min(4, werkstoff.getContents().getValue().size()) * 5, 0));
                    GT_Recipe tRecipe = new GT_Recipe(false, stOutputs.toArray(new ItemStack[0]), new ItemStack[]{input}, null, null, new FluidStack[]{flOutputs.size() > 0 ? (FluidStack)flOutputs.get(0) : null}, null, (int)Math.max(1L, Math.abs(werkstoff.getStats().getProtons() / (long)werkstoff.getContents().getValue().size())), Math.min(4, werkstoff.getContents().getValue().size()) * 30, 0);
                    GT_Recipe.GT_Recipe_Map.sMultiblockMixerRecipes.add(tRecipe);
                }
            }
            GT_ModHandler.addCraftingRecipe((ItemStack)werkstoff.get(OrePrefixes.dust), (Object[])new Object[]{"TTT", "TTT", "TTT", Character.valueOf('T'), werkstoff.get(OrePrefixes.dustTiny)});
            GT_ModHandler.addCraftingRecipe((ItemStack)werkstoff.get(OrePrefixes.dust), (Object[])new Object[]{"TT ", "TT ", Character.valueOf('T'), WerkstoffLoader.getCorrespondingItemStack(OrePrefixes.dustSmall, werkstoff)});
            GT_ModHandler.addCraftingRecipe((ItemStack)WerkstoffLoader.getCorrespondingItemStack(OrePrefixes.dustSmall, werkstoff, 4), (Object[])new Object[]{" T ", Character.valueOf('T'), werkstoff.get(OrePrefixes.dust)});
            GT_ModHandler.addCraftingRecipe((ItemStack)WerkstoffLoader.getCorrespondingItemStack(OrePrefixes.dustTiny, werkstoff, 9), (Object[])new Object[]{"T  ", Character.valueOf('T'), werkstoff.get(OrePrefixes.dust)});
            GT_Values.RA.addBoxingRecipe(werkstoff.get(OrePrefixes.dustTiny, 9), ItemList.Schematic_Dust.get(0L, new Object[0]), werkstoff.get(OrePrefixes.dust), 100, 4);
            GT_Values.RA.addBoxingRecipe(werkstoff.get(OrePrefixes.dustSmall, 4), ItemList.Schematic_Dust.get(0L, new Object[0]), werkstoff.get(OrePrefixes.dust), 100, 4);
            GT_Values.RA.addBoxingRecipe(werkstoff.get(OrePrefixes.dustTiny, 9), ItemList.Schematic_3by3.get(0L, new Object[0]), werkstoff.get(OrePrefixes.dust), 100, 4);
            GT_Values.RA.addBoxingRecipe(werkstoff.get(OrePrefixes.dustSmall, 4), ItemList.Schematic_2by2.get(0L, new Object[0]), werkstoff.get(OrePrefixes.dust), 100, 4);
            if (werkstoff.hasItemType(OrePrefixes.ingot) && !werkstoff.getStats().isBlastFurnace()) {
                GT_ModHandler.addSmeltingRecipe((ItemStack)werkstoff.get(OrePrefixes.dust), (ItemStack)werkstoff.get(OrePrefixes.ingot));
                GT_ModHandler.addSmeltingRecipe((ItemStack)werkstoff.get(OrePrefixes.dustTiny), (ItemStack)werkstoff.get(OrePrefixes.nugget));
            } else if (werkstoff.hasItemType(OrePrefixes.ingot) && werkstoff.getStats().isBlastFurnace() && werkstoff.getStats().getMeltingPoint() != 0) {
                if (werkstoff.contains(WerkstoffLoader.ANAEROBE_SMELTING)) {
                    GT_Values.RA.addBlastRecipe(werkstoff.get(OrePrefixes.dust), GT_Utility.getIntegratedCircuit((int)11), Materials.Nitrogen.getGas(1000L), null, werkstoff.getStats().getMeltingPoint() < 1750 ? werkstoff.get(OrePrefixes.ingot) : werkstoff.get(OrePrefixes.ingotHot), null, (int)Math.max(werkstoff.getStats().getMass() / 40L, 1L) * werkstoff.getStats().getMeltingPoint(), werkstoff.getStats().getMeltingVoltage(), werkstoff.getStats().getMeltingPoint());
                } else if (werkstoff.contains(WerkstoffLoader.NOBLE_GAS_SMELTING)) {
                    GT_Values.RA.addBlastRecipe(werkstoff.get(OrePrefixes.dust), GT_Utility.getIntegratedCircuit((int)11), Materials.Argon.getGas(1000L), null, werkstoff.getStats().getMeltingPoint() < 1750 ? werkstoff.get(OrePrefixes.ingot) : werkstoff.get(OrePrefixes.ingotHot), null, (int)Math.max(werkstoff.getStats().getMass() / 40L, 1L) * werkstoff.getStats().getMeltingPoint(), werkstoff.getStats().getMeltingVoltage(), werkstoff.getStats().getMeltingPoint());
                } else {
                    GT_Values.RA.addBlastRecipe(werkstoff.get(OrePrefixes.dust), GT_Utility.getIntegratedCircuit((int)1), null, null, werkstoff.getStats().getMeltingPoint() < 1750 ? werkstoff.get(OrePrefixes.ingot) : werkstoff.get(OrePrefixes.ingotHot), null, (int)Math.max(werkstoff.getStats().getMass() / 40L, 1L) * werkstoff.getStats().getMeltingPoint(), werkstoff.getStats().getMeltingVoltage(), werkstoff.getStats().getMeltingPoint());
                    if (werkstoff.getStats().getMeltingPoint() <= 1000) {
                        GT_Values.RA.addPrimitiveBlastRecipe(werkstoff.get(OrePrefixes.dust), null, 9, werkstoff.get(OrePrefixes.ingot), null, (int)Math.max(werkstoff.getStats().getMass() / 40L, 1L) * werkstoff.getStats().getMeltingPoint());
                    }
                }
            }
            if (werkstoff.getStats().isBlastFurnace() && werkstoff.getStats().getMeltingPoint() > 1750) {
                GT_Values.RA.addVacuumFreezerRecipe(werkstoff.get(OrePrefixes.ingotHot), werkstoff.get(OrePrefixes.ingot), (int)Math.max(werkstoff.getStats().getMass() * 3L, 1L));
            }
            if (werkstoff.hasItemType(OrePrefixes.ingot)) {
                GT_ModHandler.addPulverisationRecipe((ItemStack)werkstoff.get(OrePrefixes.ingot), (ItemStack)werkstoff.get(OrePrefixes.dust));
                GT_ModHandler.addPulverisationRecipe((ItemStack)werkstoff.get(OrePrefixes.nugget), (ItemStack)werkstoff.get(OrePrefixes.dustTiny));
            }
            if (werkstoff.hasItemType(OrePrefixes.ingot) || werkstoff.hasItemType(OrePrefixes.gem)) {
                GT_ModHandler.addPulverisationRecipe((ItemStack)werkstoff.get(OrePrefixes.block), (ItemStack)werkstoff.get(OrePrefixes.dust, 9));
            }
        }
    }
}

