/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.crafting;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.RedstoneMode;
import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.definitions.ITileDefinition;
import appeng.api.implementations.IPowerChannelState;
import appeng.api.implementations.IUpgradeableHost;
import appeng.api.implementations.tiles.ICraftingMachine;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.ISimplifiedBundle;
import appeng.api.util.AECableType;
import appeng.api.util.DimensionalCoord;
import appeng.api.util.IConfigManager;
import appeng.container.ContainerNull;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketAssemblerAnimation;
import appeng.items.misc.ItemEncodedPattern;
import appeng.me.GridAccessException;
import appeng.parts.automation.DefinitionUpgradeInventory;
import appeng.parts.automation.UpgradeInventory;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import appeng.tile.grid.AENetworkInvTile;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.List;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;

public class TileMolecularAssembler
extends AENetworkInvTile
implements IUpgradeableHost,
IConfigManagerHost,
IGridTickable,
ICraftingMachine,
IPowerChannelState {
    private static final int[] SIDES = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
    private final InventoryCrafting craftingInv;
    private final AppEngInternalInventory inv = new AppEngInternalInventory(this, 11);
    private final IConfigManager settings;
    private final UpgradeInventory upgrades;
    private ISimplifiedBundle lightCache;
    private boolean isPowered = false;
    private ForgeDirection pushDirection = ForgeDirection.UNKNOWN;
    private ItemStack myPattern = null;
    private ICraftingPatternDetails myPlan = null;
    private double progress = 0.0;
    private boolean isAwake = false;
    private boolean forcePlan = false;
    private boolean reboot = true;

    public TileMolecularAssembler() {
        ITileDefinition assembler = AEApi.instance().definitions().blocks().molecularAssembler();
        this.settings = new ConfigManager(this);
        this.settings.registerSetting(Settings.REDSTONE_CONTROLLED, RedstoneMode.IGNORE);
        this.inv.setMaxStackSize(1);
        this.getProxy().setIdlePowerUsage(0.0);
        this.upgrades = new DefinitionUpgradeInventory(assembler, this, this.getUpgradeSlots());
        this.craftingInv = new InventoryCrafting((Container)new ContainerNull(), 3, 3);
    }

    private int getUpgradeSlots() {
        return 5;
    }

    @Override
    public boolean pushPattern(ICraftingPatternDetails patternDetails, InventoryCrafting table, ForgeDirection where) {
        if (this.myPattern == null) {
            int x;
            boolean isEmpty = true;
            for (x = 0; x < this.inv.func_70302_i_(); ++x) {
                isEmpty = this.inv.func_70301_a(x) == null && isEmpty;
            }
            if (isEmpty && patternDetails.isCraftable()) {
                this.forcePlan = true;
                this.myPlan = patternDetails;
                this.pushDirection = where;
                for (x = 0; x < table.func_70302_i_(); ++x) {
                    this.inv.func_70299_a(x, table.func_70301_a(x));
                }
                this.updateSleepiness();
                this.func_70296_d();
                return true;
            }
        }
        return false;
    }

    private void updateSleepiness() {
        boolean wasEnabled = this.isAwake;
        boolean bl = this.isAwake = this.myPlan != null && this.hasMats() || this.canPush();
        if (wasEnabled != this.isAwake) {
            try {
                if (this.isAwake) {
                    this.getProxy().getTick().wakeDevice(this.getProxy().getNode());
                } else {
                    this.getProxy().getTick().sleepDevice(this.getProxy().getNode());
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
    }

    private boolean canPush() {
        return this.inv.func_70301_a(9) != null;
    }

    private boolean hasMats() {
        if (this.myPlan == null) {
            return false;
        }
        for (int x = 0; x < this.craftingInv.func_70302_i_(); ++x) {
            this.craftingInv.func_70299_a(x, this.inv.func_70301_a(x));
        }
        return this.myPlan.getOutput(this.craftingInv, this.func_145831_w()) != null;
    }

    @Override
    public boolean acceptsPlans() {
        return this.inv.func_70301_a(10) == null;
    }

    @Override
    public int getInstalledUpgrades(Upgrades u) {
        return this.upgrades.getInstalledUpgrades(u);
    }

    @TileEvent(value=TileEventType.NETWORK_READ)
    public boolean readFromStream_TileMolecularAssembler(ByteBuf data) {
        boolean oldPower = this.isPowered;
        this.isPowered = data.readBoolean();
        return this.isPowered != oldPower;
    }

    @TileEvent(value=TileEventType.NETWORK_WRITE)
    public void writeToStream_TileMolecularAssembler(ByteBuf data) {
        data.writeBoolean(this.isPowered);
    }

    @TileEvent(value=TileEventType.WORLD_NBT_WRITE)
    public void writeToNBT_TileMolecularAssembler(NBTTagCompound data) {
        ItemStack pattern;
        if (this.forcePlan && this.myPlan != null && (pattern = this.myPlan.getPattern()) != null) {
            NBTTagCompound compound = new NBTTagCompound();
            pattern.func_77955_b(compound);
            data.func_74782_a("myPlan", (NBTBase)compound);
            data.func_74768_a("pushDirection", this.pushDirection.ordinal());
        }
        this.upgrades.writeToNBT(data, "upgrades");
        this.inv.writeToNBT(data, "inv");
        this.settings.writeToNBT(data);
    }

    @TileEvent(value=TileEventType.WORLD_NBT_READ)
    public void readFromNBT_TileMolecularAssembler(NBTTagCompound data) {
        World w;
        ItemEncodedPattern iep;
        ICraftingPatternDetails ph;
        Item item;
        ItemStack myPat;
        if (data.func_74764_b("myPlan") && (myPat = ItemStack.func_77949_a((NBTTagCompound)data.func_74775_l("myPlan"))) != null && (item = myPat.func_77973_b()) instanceof ItemEncodedPattern && (ph = (iep = (ItemEncodedPattern)item).getPatternForItem(myPat, w = this.func_145831_w())) != null && ph.isCraftable()) {
            this.forcePlan = true;
            this.myPlan = ph;
            this.pushDirection = ForgeDirection.getOrientation((int)data.func_74762_e("pushDirection"));
        }
        this.upgrades.readFromNBT(data, "upgrades");
        this.inv.readFromNBT(data, "inv");
        this.settings.readFromNBT(data);
        this.recalculatePlan();
    }

    private void recalculatePlan() {
        this.reboot = true;
        if (this.forcePlan) {
            return;
        }
        ItemStack is = this.inv.func_70301_a(10);
        if (is != null && is.func_77973_b() instanceof ItemEncodedPattern) {
            if (!Platform.isSameItem(is, this.myPattern)) {
                World w = this.func_145831_w();
                ItemEncodedPattern iep = (ItemEncodedPattern)is.func_77973_b();
                ICraftingPatternDetails ph = iep.getPatternForItem(is, w);
                if (ph != null && ph.isCraftable()) {
                    this.progress = 0.0;
                    this.myPattern = is;
                    this.myPlan = ph;
                }
            }
        } else {
            this.progress = 0.0;
            this.forcePlan = false;
            this.myPlan = null;
            this.myPattern = null;
            this.pushDirection = ForgeDirection.UNKNOWN;
        }
        this.updateSleepiness();
    }

    @Override
    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.COVERED;
    }

    @Override
    public DimensionalCoord getLocation() {
        return new DimensionalCoord(this);
    }

    @Override
    public IConfigManager getConfigManager() {
        return this.settings;
    }

    @Override
    public IInventory getInventoryByName(String name) {
        if (name.equals("upgrades")) {
            return this.upgrades;
        }
        if (name.equals("mac")) {
            return this.inv;
        }
        return null;
    }

    @Override
    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
    }

    @Override
    public IInventory getInternalInventory() {
        return this.inv;
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemstack) {
        if (i >= 9) {
            return false;
        }
        if (this.hasPattern()) {
            return this.myPlan.isValidItemForSlot(i, itemstack, this.func_145831_w());
        }
        return false;
    }

    private boolean hasPattern() {
        return this.myPlan != null && this.inv.func_70301_a(10) != null;
    }

    @Override
    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
        if (inv == this.inv) {
            this.recalculatePlan();
        }
    }

    @Override
    public boolean func_102008_b(int slotIndex, ItemStack extractedItem, int side) {
        return slotIndex == 9;
    }

    @Override
    public int[] getAccessibleSlotsBySide(ForgeDirection whichSide) {
        return SIDES;
    }

    public int getCraftingProgress() {
        return (int)this.progress;
    }

    @Override
    public void getDrops(World w, int x, int y, int z, List<ItemStack> drops) {
        super.getDrops(w, x, y, z, drops);
        for (int h = 0; h < this.upgrades.func_70302_i_(); ++h) {
            ItemStack is = this.upgrades.func_70301_a(h);
            if (is == null) continue;
            drops.add(is);
        }
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        this.recalculatePlan();
        this.updateSleepiness();
        return new TickingRequest(1, 1, !this.isAwake, false);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (this.inv.func_70301_a(9) != null) {
            this.pushOut(this.inv.func_70301_a(9));
            if (this.inv.func_70301_a(9) == null) {
                this.func_70296_d();
            }
            this.ejectHeldItems();
            this.updateSleepiness();
            this.progress = 0.0;
            return this.isAwake ? TickRateModulation.IDLE : TickRateModulation.SLEEP;
        }
        if (this.myPlan == null) {
            this.updateSleepiness();
            return TickRateModulation.SLEEP;
        }
        if (this.reboot) {
            ticksSinceLastCall = 1;
        }
        if (!this.isAwake) {
            return TickRateModulation.SLEEP;
        }
        this.reboot = false;
        int speed = 10;
        switch (this.upgrades.getInstalledUpgrades(Upgrades.SPEED)) {
            case 0: {
                speed = 10;
                this.progress += (double)this.userPower(ticksSinceLastCall, 10, 1.0);
                break;
            }
            case 1: {
                speed = 13;
                this.progress += (double)this.userPower(ticksSinceLastCall, 13, 1.3);
                break;
            }
            case 2: {
                speed = 17;
                this.progress += (double)this.userPower(ticksSinceLastCall, 17, 1.7);
                break;
            }
            case 3: {
                speed = 20;
                this.progress += (double)this.userPower(ticksSinceLastCall, 20, 2.0);
                break;
            }
            case 4: {
                speed = 25;
                this.progress += (double)this.userPower(ticksSinceLastCall, 25, 2.5);
                break;
            }
            case 5: {
                speed = 50;
                this.progress += (double)this.userPower(ticksSinceLastCall, 50, 5.0);
            }
        }
        if (this.progress >= 100.0) {
            for (int x = 0; x < this.craftingInv.func_70302_i_(); ++x) {
                this.craftingInv.func_70299_a(x, this.inv.func_70301_a(x));
            }
            this.progress = 0.0;
            ItemStack output = this.myPlan.getOutput(this.craftingInv, this.func_145831_w());
            if (output != null) {
                FMLCommonHandler.instance().firePlayerCraftingEvent(Platform.getPlayer((WorldServer)this.func_145831_w()), output, (IInventory)this.craftingInv);
                this.pushOut(output.func_77946_l());
                for (int x = 0; x < this.craftingInv.func_70302_i_(); ++x) {
                    this.inv.func_70299_a(x, Platform.getContainerItem(this.craftingInv.func_70301_a(x)));
                }
                if (this.inv.func_70301_a(10) == null) {
                    this.forcePlan = false;
                    this.myPlan = null;
                    this.pushDirection = ForgeDirection.UNKNOWN;
                }
                this.ejectHeldItems();
                try {
                    NetworkRegistry.TargetPoint where = new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 32.0);
                    AEItemStack item = AEItemStack.create(output);
                    NetworkHandler.instance.sendToAllAround(new PacketAssemblerAnimation(this.field_145851_c, this.field_145848_d, this.field_145849_e, (byte)speed, item), where);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.func_70296_d();
                this.updateSleepiness();
                return this.isAwake ? TickRateModulation.IDLE : TickRateModulation.SLEEP;
            }
        }
        return TickRateModulation.FASTER;
    }

    private void ejectHeldItems() {
        if (this.inv.func_70301_a(9) == null) {
            for (int x = 0; x < 9; ++x) {
                ItemStack is = this.inv.func_70301_a(x);
                if (is == null || this.myPlan != null && this.myPlan.isValidItemForSlot(x, is, this.field_145850_b)) continue;
                this.inv.func_70299_a(9, is);
                this.inv.func_70299_a(x, null);
                this.func_70296_d();
                return;
            }
        }
    }

    private int userPower(int ticksPassed, int bonusValue, double acceleratorTax) {
        try {
            return (int)(this.getProxy().getEnergy().extractAEPower((double)(ticksPassed * bonusValue) * acceleratorTax, Actionable.MODULATE, PowerMultiplier.CONFIG) / acceleratorTax);
        }
        catch (GridAccessException e) {
            return 0;
        }
    }

    private void pushOut(ItemStack output) {
        if (this.pushDirection == ForgeDirection.UNKNOWN) {
            for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
                output = this.pushTo(output, d);
            }
        } else {
            output = this.pushTo(output, this.pushDirection);
        }
        if (output == null && this.forcePlan) {
            this.forcePlan = false;
            this.recalculatePlan();
        }
        this.inv.func_70299_a(9, output);
    }

    private ItemStack pushTo(ItemStack output, ForgeDirection d) {
        int newSize;
        if (output == null) {
            return output;
        }
        TileEntity te = this.func_145831_w().func_147438_o(this.field_145851_c + d.offsetX, this.field_145848_d + d.offsetY, this.field_145849_e + d.offsetZ);
        if (te == null) {
            return output;
        }
        InventoryAdaptor adaptor = InventoryAdaptor.getAdaptor(te, d.getOpposite());
        if (adaptor == null) {
            return output;
        }
        int size = output.field_77994_a;
        int n = newSize = (output = adaptor.addItems(output)) == null ? 0 : output.field_77994_a;
        if (size != newSize) {
            this.func_70296_d();
        }
        return output;
    }

    @MENetworkEventSubscribe
    public void onPowerEvent(MENetworkPowerStatusChange p) {
        this.updatePowerState();
    }

    private void updatePowerState() {
        boolean newState = false;
        try {
            newState = this.getProxy().isActive() && this.getProxy().getEnergy().extractAEPower(1.0, Actionable.SIMULATE, PowerMultiplier.CONFIG) > 1.0E-4;
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        if (newState != this.isPowered) {
            this.isPowered = newState;
            this.markForUpdate();
        }
    }

    @Override
    public boolean isPowered() {
        return this.isPowered;
    }

    @Override
    public boolean isActive() {
        return this.isPowered;
    }

    public ISimplifiedBundle getLightCache() {
        return this.lightCache;
    }

    public void setLightCache(ISimplifiedBundle lightCache) {
        this.lightCache = lightCache;
    }
}

