/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.client.ClientHelper;
import appeng.client.render.effects.LightningFX;
import appeng.core.AEConfig;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.INetworkInfo;
import appeng.util.Platform;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.player.EntityPlayer;

public class PacketLightning
extends AppEngPacket {
    private final double x;
    private final double y;
    private final double z;

    public PacketLightning(ByteBuf stream) {
        this.x = stream.readFloat();
        this.y = stream.readFloat();
        this.z = stream.readFloat();
    }

    public PacketLightning(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        ByteBuf data = Unpooled.buffer();
        data.writeInt(this.getPacketID());
        data.writeFloat((float)x);
        data.writeFloat((float)y);
        data.writeFloat((float)z);
        this.configureWrite(data);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void clientPacketData(INetworkInfo network, AppEngPacket packet, EntityPlayer player) {
        try {
            if (Platform.isClient() && AEConfig.instance.enableEffects) {
                LightningFX fx = new LightningFX(ClientHelper.proxy.getWorld(), this.x, this.y, this.z, 0.0, 0.0, 0.0);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

