/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.AEApi;
import appeng.api.config.CopyMode;
import appeng.api.config.FuzzyMode;
import appeng.api.config.Settings;
import appeng.api.storage.ICellWorkbenchItem;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.container.guisync.GuiSync;
import appeng.container.implementations.ContainerUpgradeable;
import appeng.container.slot.OptionalSlotRestrictedInput;
import appeng.container.slot.SlotFakeTypeOnly;
import appeng.container.slot.SlotRestrictedInput;
import appeng.tile.inventory.AppEngNullInventory;
import appeng.tile.misc.TileCellWorkbench;
import appeng.util.Platform;
import appeng.util.iterators.NullIterator;
import java.util.Iterator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class ContainerCellWorkbench
extends ContainerUpgradeable {
    private final TileCellWorkbench workBench;
    private final AppEngNullInventory nullInventory = new AppEngNullInventory();
    @GuiSync(value=2)
    public CopyMode copyMode = CopyMode.CLEAR_ON_REMOVE;
    private ItemStack prevStack = null;
    private int lastUpgrades = 0;

    public ContainerCellWorkbench(InventoryPlayer ip, TileCellWorkbench te) {
        super(ip, te);
        this.workBench = te;
    }

    public void setFuzzy(FuzzyMode valueOf) {
        ICellWorkbenchItem cwi = this.workBench.getCell();
        if (cwi != null) {
            cwi.setFuzzyMode(this.workBench.getInventoryByName("cell").func_70301_a(0), valueOf);
        }
    }

    public void nextWorkBenchCopyMode() {
        this.workBench.getConfigManager().putSetting(Settings.COPY_MODE, Platform.nextEnum(this.getWorkBenchCopyMode()));
    }

    private CopyMode getWorkBenchCopyMode() {
        return (CopyMode)this.workBench.getConfigManager().getSetting(Settings.COPY_MODE);
    }

    @Override
    protected int getHeight() {
        return 251;
    }

    @Override
    protected void setupConfig() {
        int z;
        IInventory cell = this.getUpgradeable().getInventoryByName("cell");
        this.func_75146_a(new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.WORKBENCH_CELL, cell, 0, 152, 8, this.getInventoryPlayer()));
        IInventory inv = this.getUpgradeable().getInventoryByName("config");
        Upgrades upgradeInventory = new Upgrades();
        int offset = 0;
        int x = 8;
        int y = 29;
        for (int w = 0; w < 7; ++w) {
            for (z = 0; z < 9; ++z) {
                this.func_75146_a(new SlotFakeTypeOnly(inv, offset, 8 + z * 18, 29 + w * 18));
                ++offset;
            }
        }
        for (int zz = 0; zz < 3; ++zz) {
            for (z = 0; z < 8; ++z) {
                int iSLot = zz * 8 + z;
                this.func_75146_a(new OptionalSlotRestrictedInput(SlotRestrictedInput.PlacableItemType.UPGRADES, upgradeInventory, this, iSLot, 187 + zz * 18, 8 + 18 * z, iSLot, this.getInventoryPlayer()));
            }
        }
    }

    @Override
    public int availableUpgrades() {
        ItemStack is = this.workBench.getInventoryByName("cell").func_70301_a(0);
        if (this.prevStack != is) {
            this.prevStack = is;
            this.lastUpgrades = this.getCellUpgradeInventory().func_70302_i_();
        }
        return this.lastUpgrades;
    }

    @Override
    public void func_75142_b() {
        ItemStack is = this.workBench.getInventoryByName("cell").func_70301_a(0);
        if (Platform.isServer()) {
            if (this.workBench.func_145831_w().func_147438_o(this.workBench.field_145851_c, this.workBench.field_145848_d, this.workBench.field_145849_e) != this.workBench) {
                this.setValidContainer(false);
            }
            for (Object crafter : this.field_75149_d) {
                ICrafting icrafting = (ICrafting)crafter;
                if (this.prevStack == is) continue;
                for (Object s : this.field_75151_b) {
                    if (!(s instanceof OptionalSlotRestrictedInput)) continue;
                    OptionalSlotRestrictedInput sri = (OptionalSlotRestrictedInput)((Object)s);
                    icrafting.func_71111_a((Container)this, sri.field_75222_d, sri.func_75211_c());
                }
                ((EntityPlayerMP)icrafting).field_71137_h = false;
            }
            this.setCopyMode(this.getWorkBenchCopyMode());
            this.setFuzzyMode(this.getWorkBenchFuzzyMode());
        }
        this.prevStack = is;
        this.standardDetectAndSendChanges();
    }

    @Override
    public boolean isSlotEnabled(int idx) {
        return idx < this.availableUpgrades();
    }

    public IInventory getCellUpgradeInventory() {
        IInventory upgradeInventory = this.workBench.getCellUpgradeInventory();
        return upgradeInventory == null ? this.nullInventory : upgradeInventory;
    }

    @Override
    public void onUpdate(String field, Object oldValue, Object newValue) {
        if (field.equals("copyMode")) {
            this.workBench.getConfigManager().putSetting(Settings.COPY_MODE, this.getCopyMode());
        }
        super.onUpdate(field, oldValue, newValue);
    }

    public void clear() {
        IInventory inv = this.getUpgradeable().getInventoryByName("config");
        for (int x = 0; x < inv.func_70302_i_(); ++x) {
            inv.func_70299_a(x, null);
        }
        this.func_75142_b();
    }

    private FuzzyMode getWorkBenchFuzzyMode() {
        ICellWorkbenchItem cwi = this.workBench.getCell();
        if (cwi != null) {
            return cwi.getFuzzyMode(this.workBench.getInventoryByName("cell").func_70301_a(0));
        }
        return FuzzyMode.IGNORE_ALL;
    }

    public void partition() {
        IInventory inv = this.getUpgradeable().getInventoryByName("config");
        IMEInventoryHandler cellInv = AEApi.instance().registries().cell().getCellInventory(this.getUpgradeable().getInventoryByName("cell").func_70301_a(0), null, StorageChannel.ITEMS);
        Iterator<Object> i = new NullIterator();
        if (cellInv != null) {
            IItemList<IAEItemStack> list = cellInv.getAvailableItems(AEApi.instance().storage().createItemList());
            i = list.iterator();
        }
        for (int x = 0; x < inv.func_70302_i_(); ++x) {
            if (i.hasNext()) {
                ItemStack g = ((IAEItemStack)i.next()).getItemStack();
                g.field_77994_a = 1;
                inv.func_70299_a(x, g);
                continue;
            }
            inv.func_70299_a(x, null);
        }
        this.func_75142_b();
    }

    public CopyMode getCopyMode() {
        return this.copyMode;
    }

    private void setCopyMode(CopyMode copyMode) {
        this.copyMode = copyMode;
    }

    private class Upgrades
    implements IInventory {
        private Upgrades() {
        }

        public int func_70302_i_() {
            return ContainerCellWorkbench.this.getCellUpgradeInventory().func_70302_i_();
        }

        public ItemStack func_70301_a(int i) {
            return ContainerCellWorkbench.this.getCellUpgradeInventory().func_70301_a(i);
        }

        public ItemStack func_70298_a(int i, int j) {
            IInventory inv = ContainerCellWorkbench.this.getCellUpgradeInventory();
            ItemStack is = inv.func_70298_a(i, j);
            inv.func_70296_d();
            return is;
        }

        public ItemStack func_70304_b(int i) {
            IInventory inv = ContainerCellWorkbench.this.getCellUpgradeInventory();
            ItemStack is = inv.func_70304_b(i);
            inv.func_70296_d();
            return is;
        }

        public void func_70299_a(int i, ItemStack itemstack) {
            IInventory inv = ContainerCellWorkbench.this.getCellUpgradeInventory();
            inv.func_70299_a(i, itemstack);
            inv.func_70296_d();
        }

        public String func_145825_b() {
            return "Upgrades";
        }

        public boolean func_145818_k_() {
            return false;
        }

        public int func_70297_j_() {
            return 1;
        }

        public void func_70296_d() {
        }

        public boolean func_70300_a(EntityPlayer entityplayer) {
            return false;
        }

        public void func_70295_k_() {
        }

        public void func_70305_f() {
        }

        public boolean func_94041_b(int i, ItemStack itemstack) {
            return ContainerCellWorkbench.this.getCellUpgradeInventory().func_94041_b(i, itemstack);
        }
    }
}

