/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.nei.recipes.extractor;

import codechicken.nei.PositionedStack;
import com.glodblock.github.nei.object.IRecipeExtractor;
import com.glodblock.github.nei.object.OrderStack;
import com.glodblock.github.nei.recipes.extractor.ExtractorUtil;
import gregapi.item.ItemFluidDisplay;
import gregapi.recipes.Recipe;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class GregTech6RecipeExtractor
implements IRecipeExtractor {
    private final Recipe.RecipeMap Recipes;

    public GregTech6RecipeExtractor(Recipe.RecipeMap aMap) {
        this.Recipes = aMap;
    }

    @Override
    public List<OrderStack<?>> getInputIngredients(List<PositionedStack> rawInputs) {
        this.removeMachine(rawInputs);
        return ExtractorUtil.packItemStack(rawInputs, GregTech6RecipeExtractor::getFluidFromDisplay);
    }

    @Override
    public List<OrderStack<?>> getOutputIngredients(List<PositionedStack> rawOutputs) {
        return ExtractorUtil.packItemStack(rawOutputs, GregTech6RecipeExtractor::getFluidFromDisplay);
    }

    private void removeMachine(List<PositionedStack> list) {
        block0: for (int i = list.size() - 1; i >= 0; --i) {
            PositionedStack positionedStack = list.get(i);
            if (positionedStack == null) continue;
            for (ItemStack machine : this.Recipes.mRecipeMachineList) {
                if (!positionedStack.items[0].func_77969_a(machine)) continue;
                list.remove(i);
                continue block0;
            }
        }
    }

    public static Object getFluidFromDisplay(PositionedStack stack) {
        if (stack != null) {
            ItemStack item = stack.items[0].func_77946_l();
            if (item.func_77973_b() instanceof ItemFluidDisplay) {
                if (item.func_77978_p() != null) {
                    FluidStack fluid = ((ItemFluidDisplay)item.func_77973_b()).getFluid(item);
                    return fluid != null && fluid.amount > 0 ? fluid : null;
                }
            } else {
                return item;
            }
        }
        return null;
    }
}

