/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.client.render.tank;

import com.glodblock.github.client.render.tank.RenderEntityBlock;
import com.glodblock.github.util.RenderUtil;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.init.Blocks;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class FluidTankRenderer {
    public static final int DISPLAY_STAGES = 100;
    private static final Map<Fluid, int[]> flowingRenderCache = new HashMap<Fluid, int[]>();
    private static final Map<Fluid, int[]> stillRenderCache = new HashMap<Fluid, int[]>();
    private static final RenderEntityBlock.RenderInfo liquidBlock = new RenderEntityBlock.RenderInfo();

    public static void onTextureReload() {
        for (int[] ia : flowingRenderCache.values()) {
            for (int i : ia) {
                GL11.glDeleteLists((int)i, (int)1);
            }
        }
        flowingRenderCache.clear();
        for (int[] ia : stillRenderCache.values()) {
            for (int i : ia) {
                GL11.glDeleteLists((int)i, (int)1);
            }
        }
        stillRenderCache.clear();
    }

    public static IIcon getFluidTexture(FluidStack fluidStack, boolean flowing) {
        if (fluidStack == null) {
            return null;
        }
        return FluidTankRenderer.getFluidTexture(fluidStack.getFluid(), flowing);
    }

    public static IIcon getFluidTexture(Fluid fluid, boolean flowing) {
        IIcon icon;
        if (fluid == null) {
            return null;
        }
        IIcon iIcon = icon = flowing ? fluid.getFlowingIcon() : fluid.getStillIcon();
        if (icon == null) {
            icon = ((TextureMap)Minecraft.func_71410_x().func_110434_K().func_110581_b(TextureMap.field_110575_b)).func_110572_b("missingno");
        }
        return icon;
    }

    public static void setColorForFluidStack(FluidStack fluidstack) {
        if (fluidstack == null) {
            return;
        }
        int color = fluidstack.getFluid().getColor(fluidstack);
        RenderUtil.setGLColorFromInt(color);
    }

    public static int[] getFluidDisplayLists(FluidStack fluidStack, World world, boolean flowing) {
        if (fluidStack == null) {
            return null;
        }
        Fluid fluid = fluidStack.getFluid();
        if (fluid == null) {
            return null;
        }
        Map<Fluid, int[]> cache = flowing ? flowingRenderCache : stillRenderCache;
        int[] diplayLists = FluidTankRenderer.getCachedData(fluid, cache);
        if (diplayLists != null) {
            return diplayLists;
        }
        diplayLists = new int[100];
        FluidTankRenderer.liquidBlock.baseBlock = fluid.getBlock() != null ? fluid.getBlock() : Blocks.field_150355_j;
        FluidTankRenderer.liquidBlock.texture = FluidTankRenderer.getFluidTexture(fluidStack, flowing);
        cache.put(fluid, diplayLists);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2884);
        for (int s = 0; s < 100; ++s) {
            diplayLists[s] = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)diplayLists[s], (int)4864);
            FluidTankRenderer.liquidBlock.minX = 0.01f;
            FluidTankRenderer.liquidBlock.minY = 0.0;
            FluidTankRenderer.liquidBlock.minZ = 0.01f;
            FluidTankRenderer.liquidBlock.maxX = 0.99f;
            FluidTankRenderer.liquidBlock.maxY = (float)Math.max(s, 1) / 100.0f;
            FluidTankRenderer.liquidBlock.maxZ = 0.99f;
            RenderEntityBlock.INSTANCE.renderBlock(liquidBlock);
            GL11.glEndList();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)2884);
        GL11.glEnable((int)3042);
        GL11.glEnable((int)2896);
        return diplayLists;
    }

    private static int[] getCachedData(@Nonnull Fluid fluid, Map<Fluid, int[]> cache) {
        TextureAtlasSprite sprite;
        IIcon icon = fluid.getIcon();
        if (icon instanceof TextureAtlasSprite && (sprite = (TextureAtlasSprite)icon).func_130098_m()) {
            return null;
        }
        return cache.get(fluid);
    }
}

