/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack.reference;

import com.darkona.adventurebackpack.util.BackpackUtils;
import com.google.common.collect.EnumHashBiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.text.WordUtils;

public enum BackpackTypes {
    STANDARD(0, new Props[0]),
    BAT(2, Props.SPECIAL, Props.REMOVAL, Props.NIGHT_VISION),
    BLACK(3, new Props[0]),
    BLAZE(4, new Props[0]),
    BLUE(14, new Props[0]),
    BOOKSHELF(15, new Props[0]),
    BROWN(16, new Props[0]),
    BROWN_MUSHROOM(43, new Props[0]),
    CACTUS(17, Props.SPECIAL, Props.TILE),
    CAKE(18, new Props[0]),
    CARROT(5, new Props[0]),
    CHEST(19, new Props[0]),
    CHICKEN(28, Props.SPECIAL),
    COAL(6, new Props[0]),
    COOKIE(20, new Props[0]),
    COW(1, Props.SPECIAL),
    CREEPER(64, Props.SPECIAL),
    CYAN(21, new Props[0]),
    DELUXE(25, new Props[0]),
    DIAMOND(7, new Props[0]),
    DRAGON(22, Props.SPECIAL, Props.REMOVAL, Props.NIGHT_VISION),
    EGG(23, new Props[0]),
    ELECTRIC(24, new Props[0]),
    EMERALD(8, new Props[0]),
    END(27, new Props[0]),
    ENDERMAN(26, new Props[0]),
    GHAST(30, new Props[0]),
    GLOWSTONE(37, new Props[0]),
    GOLD(9, new Props[0]),
    GRAY(31, new Props[0]),
    GREEN(32, new Props[0]),
    HAYBALE(33, new Props[0]),
    HORSE(34, new Props[0]),
    IRON(10, new Props[0]),
    IRON_GOLEM(11, new Props[0]),
    LAPIS(12, new Props[0]),
    LEATHER(35, new Props[0]),
    LIGHT_BLUE(36, new Props[0]),
    LIGHT_GRAY(38, new Props[0]),
    LIME(39, new Props[0]),
    MAGENTA(40, new Props[0]),
    MAGMA_CUBE(41, new Props[0]),
    MELON(42, Props.SPECIAL, Props.TILE),
    MODDED_NETWORK(76, new Props[0]),
    MOOSHROOM(45, Props.SPECIAL),
    NETHER(46, new Props[0]),
    OBSIDIAN(48, new Props[0]),
    OCELOT(29, Props.SPECIAL),
    ORANGE(49, new Props[0]),
    OVERWORLD(50, new Props[0]),
    PIG(53, Props.SPECIAL),
    PIGMAN(51, Props.SPECIAL, Props.REMOVAL),
    PINK(52, new Props[0]),
    PUMPKIN(54, new Props[0]),
    PURPLE(55, new Props[0]),
    QUARTZ(56, new Props[0]),
    RAINBOW(57, Props.SPECIAL, Props.REMOVAL),
    RED(58, new Props[0]),
    RED_MUSHROOM(44, new Props[0]),
    REDSTONE(13, new Props[0]),
    SANDSTONE(59, new Props[0]),
    SHEEP(60, new Props[0]),
    SILVERFISH(61, new Props[0]),
    SKELETON(65, new Props[0]),
    SLIME(67, Props.SPECIAL),
    SNOW(68, new Props[0]),
    SPIDER(69, new Props[0]),
    SPONGE(70, new Props[0]),
    SQUID(62, Props.SPECIAL, Props.REMOVAL, Props.NIGHT_VISION),
    SUNFLOWER(63, Props.SPECIAL),
    VILLAGER(71, new Props[0]),
    WHITE(72, new Props[0]),
    WITHER(47, new Props[0]),
    WITHER_SKELETON(66, new Props[0]),
    WOLF(73, Props.SPECIAL),
    YELLOW(74, new Props[0]),
    ZOMBIE(75, new Props[0]),
    UNKNOWN(127, "UNKNOWN", new Props[0]);

    public static final ImmutableBiMap<Byte, BackpackTypes> BY_META;
    private final byte meta;
    private final String skinName;
    private final ImmutableSet<Props> props;

    private BackpackTypes(int meta, String skin, Props ... props) {
        Validate.inclusiveBetween((Object)0, (Object)127, (Comparable)Integer.valueOf(meta), (String)"wrong meta value: %s (%s)", (Object[])new Object[]{meta, this});
        this.meta = (byte)meta;
        this.skinName = skin.isEmpty() ? this.generateSkinName() : skin;
        this.props = Sets.immutableEnumSet(Arrays.asList(props));
    }

    private BackpackTypes(int meta, Props ... props) {
        this(meta, "", props);
    }

    private String generateSkinName() {
        return WordUtils.capitalize((String)this.name().toLowerCase(), (char[])new char[]{'_'}).replaceAll("_", "");
    }

    public static String getSkinName(BackpackTypes type) {
        return type.skinName;
    }

    public static String getSkinName(int meta) {
        return BackpackTypes.getType((int)meta).skinName;
    }

    public static String getSkinName(ItemStack backpack) {
        return BackpackTypes.getSkinName(BackpackTypes.getType(backpack));
    }

    public static String getLocalizedName(BackpackTypes type) {
        return StatCollector.func_74838_a((String)("adventurebackpack:skin.name." + type.name().toLowerCase()));
    }

    public static byte getMeta(BackpackTypes type) {
        return type.meta;
    }

    public static BackpackTypes getType(int meta) {
        Validate.inclusiveBetween((Object)0, (Object)127, (Comparable)Integer.valueOf(meta), (String)"wrong meta value: %s", (Object[])new Object[]{meta});
        BackpackTypes type = (BackpackTypes)((Object)BY_META.get((Object)((byte)meta)));
        return type != null ? type : UNKNOWN;
    }

    public static BackpackTypes getType(byte meta) {
        Validate.inclusiveBetween((Object)0, (Object)127, (Comparable)Byte.valueOf(meta), (String)"wrong meta value: %s", (Object[])new Object[]{meta});
        BackpackTypes type = (BackpackTypes)((Object)BY_META.get((Object)meta));
        return type != null ? type : UNKNOWN;
    }

    public static BackpackTypes getType(String skinName) {
        for (BackpackTypes type : BackpackTypes.values()) {
            if (!type.skinName.equals(skinName)) continue;
            return type;
        }
        return UNKNOWN;
    }

    public static BackpackTypes getType(ItemStack backpack) {
        if (backpack == null) {
            return null;
        }
        NBTTagCompound backpackTag = BackpackUtils.getWearableCompound(backpack);
        if (backpackTag.func_74771_c("type") == BackpackTypes.UNKNOWN.meta) {
            backpackTag.func_74774_a("type", BackpackTypes.STANDARD.meta);
        }
        return BackpackTypes.getType(backpackTag.func_74771_c("type"));
    }

    public static int getLowestUnusedMeta() {
        for (byte b = 0; b < 127; b = (byte)(b + 1)) {
            if (BY_META.get((Object)b) != null) continue;
            return b;
        }
        return -1;
    }

    public static boolean isNightVision(BackpackTypes type) {
        return BackpackTypes.hasProperty(type, Props.NIGHT_VISION);
    }

    public static boolean isSpecial(BackpackTypes type) {
        return BackpackTypes.hasProperty(type, Props.SPECIAL);
    }

    public static boolean hasProperty(BackpackTypes type, Props prop) {
        return type.props.contains((Object)prop);
    }

    public static boolean hasProperties(BackpackTypes type, ImmutableSet<Props> props) {
        return type.props.containsAll(props);
    }

    static {
        EnumHashBiMap byMeta = EnumHashBiMap.create(BackpackTypes.class);
        for (BackpackTypes type : BackpackTypes.values()) {
            if (byMeta.put((Object)type, (Object)type.meta) == null) continue;
            throw new IllegalArgumentException("duplicate meta: " + type.meta);
        }
        BY_META = ImmutableBiMap.copyOf((Map)byMeta.inverse());
    }

    public static enum Props {
        SPECIAL,
        REMOVAL,
        TILE,
        NIGHT_VISION;

        public static final ImmutableSet<Props> POTION_EFFECT;

        static {
            POTION_EFFECT = Sets.immutableEnumSet((Enum)SPECIAL, (Enum[])new Props[]{REMOVAL});
        }
    }
}

