/*
 * Decompiled with CFR 0.152.
 */
package shukaro.warptheory.handlers.warpevents;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import shukaro.warptheory.entity.EntityRainParticleFX;
import shukaro.warptheory.handlers.IMultiWarpEvent;
import shukaro.warptheory.net.PacketDispatcher;
import shukaro.warptheory.util.BlockCoord;
import shukaro.warptheory.util.RandomBlockHelper;

public class WarpFakeRain
extends IMultiWarpEvent {
    public static int rainLevel = -1;

    public WarpFakeRain(int minWarp) {
        super("fakerain", minWarp, 2, world -> 30 + world.field_73012_v.nextInt(30));
    }

    @Override
    public void sendChatMessage(EntityPlayer player) {
    }

    @Override
    public int triggerEvent(int eventLevel, int eventAmount, World world, EntityPlayer player) {
        if (eventAmount > 1) {
            PacketDispatcher.sendFakeRainEvent(player, eventLevel);
        } else {
            PacketDispatcher.sendFakeRainEvent(player, -1);
        }
        world.func_72956_a((Entity)player, "ambient.weather.rain", 0.5f, 1.0f);
        return 1;
    }

    private static boolean isValid(World world, BlockCoord block) {
        for (int i = 0; i <= 8; ++i) {
            if (world.func_147437_c(block.x, block.y + i, block.z)) continue;
            return false;
        }
        return true;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onClientTick(TickEvent.ClientTickEvent e) {
        if (e.phase != TickEvent.Phase.END) {
            return;
        }
        if (rainLevel >= 0) {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
            if (world != null && world.func_82737_E() % 5L == 0L && player != null) {
                int y = (int)player.field_70163_u + 8;
                for (int i = 0; i < 32; ++i) {
                    EntityRainParticleFX fx;
                    BlockCoord target = RandomBlockHelper.randomBlock((World)world, (EntityPlayer)player, 16, block -> true);
                    if (target == null) continue;
                    switch (rainLevel) {
                        case 1: {
                            fx = new EntityRainParticleFX((World)world, target.x, y, target.z, world.field_73012_v.nextFloat() + 0.2f, 0.0f, 0.0f);
                            break;
                        }
                        default: {
                            fx = new EntityRainParticleFX((World)world, target.x, y, target.z, 0.0f, 0.0f, 1.0f);
                        }
                    }
                    FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)fx);
                }
            }
        }
    }

    @Override
    @SubscribeEvent
    public void onTick(TickEvent.WorldTickEvent e) {
        if (e.world.func_82737_E() % 20L != 0L) {
            return;
        }
        super.onTick(e);
    }
}

