/*
 * Decompiled with CFR 0.152.
 */
package codechicken.translocator;

import codechicken.lib.inventory.InventoryUtils;
import codechicken.lib.math.MathHelper;
import codechicken.lib.packet.ICustomPacketTile;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Vector3;
import codechicken.translocator.TranslocatorSPH;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public abstract class TileTranslocator
extends TileEntity
implements ICustomPacketTile {
    public Attachment[] attachments = new Attachment[6];

    public void func_145845_h() {
        for (Attachment a : this.attachments) {
            if (a == null) continue;
            a.update(this.field_145850_b.field_72995_K);
        }
    }

    public Packet func_145844_m() {
        PacketCustom packet = new PacketCustom(TranslocatorSPH.channel, 1);
        packet.writeCoord(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        int attachmask = 0;
        for (int i = 0; i < 6; ++i) {
            if (this.attachments[i] == null) continue;
            attachmask |= 1 << i;
        }
        packet.writeByte(attachmask);
        for (Attachment a : this.attachments) {
            if (a == null) continue;
            a.write(packet);
        }
        return packet.toPacket();
    }

    public void handleDescriptionPacket(PacketCustom packet) {
        if (packet.getType() == 1) {
            short attachmask = packet.readUByte();
            for (int i = 0; i < 6; ++i) {
                if ((attachmask & 1 << i) != 0) {
                    boolean described;
                    boolean bl = described = this.attachments[i] != null;
                    if (!described) {
                        this.createAttachment(i);
                    }
                    this.attachments[i].read(packet, described);
                    continue;
                }
                this.attachments[i] = null;
            }
            this.field_145850_b.func_147479_m(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public void createAttachment(int side) {
        this.attachments[side] = new Attachment(side);
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        for (int i = 0; i < 6; ++i) {
            if (this.attachments[i] == null) continue;
            tag.func_74782_a("atmt" + i, (NBTBase)this.attachments[i].write(new NBTTagCompound()));
        }
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        for (int i = 0; i < 6; ++i) {
            if (!tag.func_74764_b("atmt" + i)) continue;
            this.createAttachment(i);
            this.attachments[i].read(tag.func_74775_l("atmt" + i));
        }
    }

    public void addTraceableCuboids(List<IndexedCuboid6> cuboids) {
        Vector3 pos = Vector3.fromTileEntity((TileEntity)this);
        Cuboid6 base = new Cuboid6(0.1875, 0.0, 0.1875, 0.8125, 0.125, 0.8125);
        for (int i = 0; i < 6; ++i) {
            Attachment a = this.attachments[i];
            if (a == null) continue;
            cuboids.add(new IndexedCuboid6((Object)i, this.transformPart(base, pos, i)));
            cuboids.add(new IndexedCuboid6((Object)(i + 6), this.transformPart(new Cuboid6(0.375, 0.0, 0.375, 0.625, a.a_insertpos * 2.0 / 16.0 + 0.0625, 0.625), pos, i)));
        }
    }

    private Cuboid6 transformPart(Cuboid6 box, Vector3 pos, int i) {
        return box.copy().apply(Rotation.sideRotations[i].at(Vector3.center)).add(pos);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1));
    }

    public boolean harvestPart(int i, boolean drop) {
        Attachment a = this.attachments[i];
        if (!this.field_145850_b.field_72995_K && drop) {
            for (ItemStack stack : a.getDrops()) {
                this.dropItem(stack);
            }
        }
        this.attachments[i] = null;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        for (Attachment a1 : this.attachments) {
            if (a1 == null) continue;
            return false;
        }
        this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return true;
    }

    public void dropItem(ItemStack stack) {
        InventoryUtils.dropItem((ItemStack)stack, (World)this.field_145850_b, (Vector3)Vector3.fromTileEntityCenter((TileEntity)this));
    }

    public boolean gettingPowered() {
        return this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public boolean connectRedstone() {
        for (Attachment a : this.attachments) {
            if (a == null || !a.redstone) continue;
            return true;
        }
        return false;
    }

    public int strongPowerLevel(int side) {
        return 0;
    }

    public class Attachment {
        public final int side;
        public boolean a_eject;
        public boolean b_eject;
        public boolean redstone;
        public boolean invert_redstone;
        public boolean fast;
        public double a_insertpos;
        public double b_insertpos;

        public Attachment(int side) {
            this.side = side;
            this.invert_redstone = true;
            this.b_eject = true;
            this.a_eject = true;
            this.b_insertpos = 1.0;
            this.a_insertpos = 1.0;
        }

        public void read(NBTTagCompound tag) {
            this.invert_redstone = tag.func_74767_n("invert_redstone");
            this.redstone = tag.func_74767_n("redstone");
            this.fast = tag.func_74767_n("fast");
        }

        public void update(boolean client) {
            this.b_insertpos = this.a_insertpos;
            this.a_insertpos = MathHelper.approachExp((double)this.a_insertpos, (double)this.approachInsertPos(), (double)0.5, (double)0.1);
            if (!client) {
                this.b_eject = this.a_eject;
                boolean bl = this.a_eject = (this.redstone && TileTranslocator.this.gettingPowered()) != this.invert_redstone;
                if (this.a_eject != this.b_eject) {
                    this.markUpdate();
                }
            }
        }

        public double approachInsertPos() {
            return this.a_eject ? 1.0 : 0.0;
        }

        public void write(PacketCustom packet) {
            packet.writeBoolean(this.a_eject);
            packet.writeBoolean(this.redstone);
            packet.writeBoolean(this.fast);
        }

        public void read(PacketCustom packet, boolean described) {
            this.a_eject = packet.readBoolean();
            this.redstone = packet.readBoolean();
            this.fast = packet.readBoolean();
            if (!described) {
                this.a_insertpos = this.b_insertpos = this.approachInsertPos();
            }
        }

        public NBTTagCompound write(NBTTagCompound tag) {
            tag.func_74757_a("invert_redstone", this.invert_redstone);
            tag.func_74757_a("redstone", this.redstone);
            tag.func_74757_a("fast", this.fast);
            return tag;
        }

        public boolean activate(EntityPlayer player, int subPart) {
            ItemStack held = player.field_71071_by.func_70448_g();
            if (held == null && player.func_70093_af()) {
                this.stripModifiers();
                this.markUpdate();
            } else if (held == null) {
                if (subPart == 1) {
                    this.invert_redstone = !this.invert_redstone;
                } else {
                    this.openGui(player);
                }
            } else if (held.func_77973_b() == Items.field_151137_ax && !this.redstone) {
                this.redstone = true;
                if (!player.field_71075_bZ.field_75098_d) {
                    --held.field_77994_a;
                }
                if (TileTranslocator.this.gettingPowered() != this.invert_redstone != this.a_eject) {
                    this.invert_redstone = !this.invert_redstone;
                }
                this.markUpdate();
            } else if (held.func_77973_b() == Items.field_151114_aO && !this.fast) {
                this.fast = true;
                if (!player.field_71075_bZ.field_75098_d) {
                    --held.field_77994_a;
                }
                this.markUpdate();
            } else {
                this.openGui(player);
            }
            return true;
        }

        public void stripModifiers() {
            if (this.redstone) {
                this.redstone = false;
                TileTranslocator.this.dropItem(new ItemStack(Items.field_151137_ax));
                if (this.invert_redstone != this.a_eject) {
                    boolean bl = this.invert_redstone = !this.invert_redstone;
                }
            }
            if (this.fast) {
                this.fast = false;
                TileTranslocator.this.dropItem(new ItemStack(Items.field_151114_aO));
            }
        }

        public void openGui(EntityPlayer player) {
        }

        public void markUpdate() {
            TileTranslocator.this.field_145850_b.func_147471_g(TileTranslocator.this.field_145851_c, TileTranslocator.this.field_145848_d, TileTranslocator.this.field_145849_e);
            TileTranslocator.this.func_70296_d();
        }

        public Collection<ItemStack> getDrops() {
            LinkedList<ItemStack> items = new LinkedList<ItemStack>();
            items.add(new ItemStack(TileTranslocator.this.func_145838_q(), 1, TileTranslocator.this.func_145832_p()));
            if (this.redstone) {
                items.add(new ItemStack(Items.field_151137_ax));
            }
            if (this.fast) {
                items.add(new ItemStack(Items.field_151114_aO));
            }
            return items;
        }

        public int getIconIndex() {
            int i = 0;
            if (this.redstone) {
                i |= TileTranslocator.this.gettingPowered() ? 2 : 1;
            }
            if (this.fast) {
                i |= 4;
            }
            return i;
        }
    }
}

