/*
 * Decompiled with CFR 0.152.
 */
package net.glease.tc4tweak.modules.generateItemHash;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.glease.tc4tweak.modules.generateItemHash.CustomItemStacks;
import net.glease.tc4tweak.modules.generateItemHash.RangedObjectTags;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import thaumcraft.api.ThaumcraftApi;

public class GenerateItemHash {
    private static final String DEFAULT_NAMESPACE = "oops:";
    private static final int DEFAULT_NAMESPACE_HASH_BASE;
    private static final ConcurrentHashMap<List<?>, int[]> groupedObjectTags;
    private static final CustomItemStacks customItemStacksCache;
    private static final RangedObjectTags rangedObjectTags;
    private static final ThreadLocal<StringBuilder> buffer;

    private static int updateHashColon(int hash) {
        return hash * 31 + 58;
    }

    private static int updateHash(int hash, int number) {
        StringBuilder buffer = GenerateItemHash.buffer.get();
        buffer.delete(0, buffer.length());
        buffer.append(number);
        return GenerateItemHash.updateHash(hash, buffer);
    }

    private static int updateHash(int hash, CharSequence later) {
        int length = later.length();
        for (int i = 0; i < length; ++i) {
            hash = hash * 31 + later.charAt(i);
        }
        return hash;
    }

    public static int generateItemHash(Item item, int meta) {
        ItemStack t = new ItemStack(item, 1, meta);
        try {
            if (t.func_77984_f() || !t.func_77981_g()) {
                meta = -1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        List<Object> key = Arrays.asList(item, meta);
        int[] value = groupedObjectTags.get(key);
        if (value != null) {
            meta = value[0];
        }
        key.set(1, meta);
        if (ThaumcraftApi.objectTags.containsKey(key)) {
            return GenerateItemHash.hash(item, meta, t);
        }
        if (rangedObjectTags.isEnabled()) {
            List ints = (List)((ConcurrentMap)rangedObjectTags.getCache()).get(item);
            if (ints != null) {
                Iterator iterator = ints.iterator();
                while (iterator.hasNext()) {
                    int[] range = (int[])iterator.next();
                    Arrays.sort(range);
                    if (Arrays.binarySearch(range, meta) < 0) continue;
                    return GenerateItemHash.hash(item, t, range);
                }
            }
        } else {
            for (List l : ThaumcraftApi.objectTags.keySet()) {
                String name = ((Item)l.get(0)).func_77658_a();
                if (!(l.get(1) instanceof int[]) || Item.field_150901_e.func_82594_a(name) != item && Block.field_149771_c.func_82594_a(name) != Block.func_149634_a((Item)item)) continue;
                int[] range = (int[])l.get(1);
                Arrays.sort(range);
                if (Arrays.binarySearch(range, meta) < 0) continue;
                return GenerateItemHash.hash(item, t, range);
            }
        }
        if (meta == -1) {
            for (int i = 0; i < 16; ++i) {
                key.set(1, i);
                if (!ThaumcraftApi.objectTags.containsKey(key)) continue;
                return GenerateItemHash.hash(item, i, t);
            }
        }
        return GenerateItemHash.hash(item, meta, t);
    }

    private static int hash(Item item, ItemStack t, int[] range) {
        int hash = GenerateItemHash.getUniqueIdentifierHash(item, t);
        for (int r : range) {
            hash = GenerateItemHash.updateHash(GenerateItemHash.updateHashColon(hash), r);
        }
        return hash;
    }

    private static int hash(Item item, int meta, ItemStack t) {
        return GenerateItemHash.updateHash(GenerateItemHash.updateHashColon(GenerateItemHash.getUniqueIdentifierHash(item, t)), meta);
    }

    private static int getUniqueIdentifierHash(Item item, ItemStack t) {
        if (customItemStacksCache.isEnabled()) {
            String name = Item.field_150901_e.func_148750_c((Object)item);
            if (name == null) {
                return DEFAULT_NAMESPACE_HASH_BASE;
            }
            if (((Set)customItemStacksCache.getCache()).contains(name)) {
                return t.func_77977_a().hashCode();
            }
            return name.hashCode();
        }
        try {
            GameRegistry.UniqueIdentifier ui = GameRegistry.findUniqueIdentifierFor((Item)item);
            if (ui == null) {
                return t.func_77977_a().hashCode();
            }
            return GenerateItemHash.updateHash(GenerateItemHash.updateHashColon(ui.modId.hashCode()), ui.name);
        }
        catch (Exception e) {
            return DEFAULT_NAMESPACE_HASH_BASE;
        }
    }

    public static void onNewObjectTag(List<?> key) {
        if (key.get(1) instanceof int[] && rangedObjectTags.isEnabled()) {
            ((ConcurrentMap)rangedObjectTags.getCache()).merge((Item)key.get(0), Collections.singletonList((int[])key.get(1)), (a, b) -> Stream.concat(a.stream(), b.stream()).collect(Collectors.toList()));
        }
    }

    public static void onRemoveObjectTag(List<?> key) {
        if (key.get(1) instanceof int[] && rangedObjectTags.isEnabled()) {
            ((ConcurrentMap)rangedObjectTags.getCache()).computeIfPresent((Item)key.get(0), (k, a) -> (List)GenerateItemHash.toNullIfEmpty((Collection)a.stream().filter(arr -> !Arrays.equals(arr, (int[])key.get(1))).collect(Collectors.toList())));
        }
    }

    private static <C extends Collection<?>> C toNullIfEmpty(C c) {
        if (c == null || c.isEmpty()) {
            return null;
        }
        return c;
    }

    static {
        ConcurrentHashMap tmp;
        DEFAULT_NAMESPACE_HASH_BASE = DEFAULT_NAMESPACE.hashCode() * 31;
        customItemStacksCache = new CustomItemStacks();
        rangedObjectTags = new RangedObjectTags();
        buffer = ThreadLocal.withInitial(StringBuilder::new);
        try {
            tmp = (ConcurrentHashMap)ReflectionHelper.getPrivateValue(ThaumcraftApi.class, null, (String[])new String[]{"groupedObjectTags"});
        }
        catch (Exception e) {
            tmp = new ConcurrentHashMap();
        }
        groupedObjectTags = tmp;
    }
}

