/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.mechanics.elementalMatter.definitions.complex;

import com.github.technus.tectech.TecTech;
import com.github.technus.tectech.loader.TecTechConfig;
import com.github.technus.tectech.mechanics.elementalMatter.core.EMException;
import com.github.technus.tectech.mechanics.elementalMatter.core.decay.EMDecay;
import com.github.technus.tectech.mechanics.elementalMatter.core.definitions.EMComplexTemplate;
import com.github.technus.tectech.mechanics.elementalMatter.core.definitions.IEMDefinition;
import com.github.technus.tectech.mechanics.elementalMatter.core.definitions.registry.EMDefinitionsRegistry;
import com.github.technus.tectech.mechanics.elementalMatter.core.definitions.registry.EMIndirectType;
import com.github.technus.tectech.mechanics.elementalMatter.core.maps.EMConstantStackMap;
import com.github.technus.tectech.mechanics.elementalMatter.core.maps.EMDefinitionStackMap;
import com.github.technus.tectech.mechanics.elementalMatter.core.stacks.EMDefinitionStack;
import com.github.technus.tectech.mechanics.elementalMatter.core.stacks.IEMStack;
import com.github.technus.tectech.mechanics.elementalMatter.core.transformations.EMTransformationRegistry;
import com.github.technus.tectech.mechanics.elementalMatter.definitions.complex.EMHadronDefinition;
import com.github.technus.tectech.mechanics.elementalMatter.definitions.complex.EMNuclideIAEA;
import com.github.technus.tectech.mechanics.elementalMatter.definitions.primitive.EMGaugeBosonDefinition;
import com.github.technus.tectech.mechanics.elementalMatter.definitions.primitive.EMLeptonDefinition;
import com.github.technus.tectech.mechanics.elementalMatter.definitions.primitive.EMNeutrinoDefinition;
import com.github.technus.tectech.util.TT_Utility;
import com.github.technus.tectech.util.XSTR;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.TreeSet;
import net.minecraft.util.StatCollector;

public class EMAtomDefinition
extends EMComplexTemplate {
    private static final String[] SYMBOL = new String[]{"Nt", "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", "Nh", "Fl", "Mc", "Lv", "Ts", "Og"};
    private static final String[] NAME = new String[]{"Neutronium", "Hydrogen", "Helium", "Lithium", "Beryllium", "Boron", "Carbon", "Nitrogen", "Oxygen", "Fluorine", "Neon", "Sodium", "Magnesium", "Aluminium", "Silicon", "Phosphorus", "Sulfur", "Chlorine", "Argon", "Potassium", "Calcium", "Scandium", "Titanium", "Vanadium", "Chromium", "Manganese", "Iron", "Cobalt", "Nickel", "Copper", "Zinc", "Gallium", "Germanium", "Arsenic", "Selenium", "Bromine", "Krypton", "Rubidium", "Strontium", "Yttrium", "Zirconium", "Niobium", "Molybdenum", "Technetium", "Ruthenium", "Rhodium", "Palladium", "Silver", "Cadmium", "Indium", "Tin", "Antimony", "Tellurium", "Iodine", "Xenon", "Caesium", "Barium", "Lanthanum", "Cerium", "Praseodymium", "Neodymium", "Promethium", "Samarium", "Europium", "Gadolinium", "Terbium", "Dysprosium", "Holmium", "Erbium", "Thulium", "Ytterbium", "Lutetium", "Hafnium", "Tantalum", "Tungsten", "Rhenium", "Osmium", "Iridium", "Platinum", "Gold", "Mercury", "Thallium", "Lead", "Bismuth", "Polonium", "Astatine", "Radon", "Francium", "Radium", "Actinium", "Thorium", "Protactinium", "Uranium", "Neptunium", "Plutonium", "Americium", "Curium", "Berkelium", "Californium", "Einsteinium", "Fermium", "Mendelevium", "Nobelium", "Lawrencium", "Rutherfordium", "Dubnium", "Seaborgium", "Bohrium", "Hassium", "Meitnerium", "Darmstadtium", "Roentgenium", "Copernicium", "Nihonium", "Flerovium", "Moscovium", "Livermorium", "Tennessine", "Oganesson"};
    private static final String[] SYMBOL_IUPAC = new String[]{"n", "u", "b", "t", "q", "p", "h", "s", "o", "e", "N", "U", "B", "T", "Q", "P", "H", "S", "O", "E"};
    public static final long ATOM_COMPLEXITY_LIMIT = 65536L;
    private static final byte BYTE_OFFSET = 32;
    private final int hash;
    public static double refMass;
    public static double refUnstableMass;
    private static final String nbtType = "a";
    private static final Random xstr;
    private static Map<Integer, TreeSet<Integer>> stableIsotopes;
    private static final Map<Integer, EMAtomDefinition> stableAtoms;
    private static Map<Integer, TreeMap<Double, Integer>> mostStableUnstableIsotopes;
    private static final Map<Integer, EMAtomDefinition> unstableAtoms;
    private static EMDefinitionStack alpha;
    private static EMDefinitionStack deuterium;
    private static EMDefinitionStack tritium;
    private static EMDefinitionStack helium_3;
    private static EMDefinitionStack beryllium_8;
    private static EMDefinitionStack carbon_14;
    private static EMDefinitionStack neon_24;
    private static EMDefinitionStack silicon_34;
    private static EMDefinitionStack uranium_238;
    private static EMDefinitionStack uranium_235;
    private static EMDefinitionStack plutonium_239;
    private static EMDefinitionStack plutonium_241;
    private static final HashMap<EMAtomDefinition, Double> lifetimeOverrides;
    private final EMNuclideIAEA iaea;
    private static EMAtomDefinition somethingHeavy;
    private static final ArrayList<Runnable> overrides;
    private final double mass;
    private final int charge;
    private final int chargeLeptons;
    private final double rawLifeTime;
    private final byte type;
    private final byte decayMode;
    private final int neutralCount;
    private final int element;
    private final boolean iaeaDefinitionExistsAndHasEnergyLevels;
    private final EMConstantStackMap elementalStacks;

    public static EMAtomDefinition getSomethingHeavy() {
        return somethingHeavy;
    }

    public static void addOverride(EMAtomDefinition atom, double rawLifeTime) {
        lifetimeOverrides.put(atom, rawLifeTime);
    }

    public EMAtomDefinition(EMDefinitionStack ... things) throws EMException {
        this(true, new EMConstantStackMap(things));
    }

    public EMAtomDefinition(EMConstantStackMap things) throws EMException {
        this(true, things);
    }

    private EMAtomDefinition(boolean check, EMConstantStackMap things) throws EMException {
        Double overriddenLifeTime;
        if (check && !EMAtomDefinition.canTheyBeTogether(things)) {
            throw new EMException("Atom Definition error");
        }
        this.elementalStacks = things;
        double mass = 0.0;
        int cLeptons = 0;
        int cNucleus = 0;
        int neutralCount = 0;
        int element = 0;
        int type = 0;
        boolean containsAnti = false;
        for (EMDefinitionStack stack : (EMDefinitionStack[])this.elementalStacks.valuesToArray()) {
            IEMDefinition def = stack.getDefinition();
            int amount = (int)stack.getAmount();
            if ((double)((int)stack.getAmount()) != stack.getAmount()) {
                throw new ArithmeticException("Amount cannot be safely converted to int!");
            }
            mass += stack.getMass();
            if (def.getGeneration() < 0) {
                containsAnti = true;
            }
            type = Math.max(type, Math.abs(def.getGeneration()));
            if (def instanceof EMLeptonDefinition) {
                cLeptons = (int)((double)cLeptons + stack.getCharge());
                continue;
            }
            cNucleus = (int)((double)cNucleus + stack.getCharge());
            if (def.getCharge() == 3) {
                element += amount;
                continue;
            }
            if (def.getCharge() == -3) {
                element -= amount;
                continue;
            }
            if (def.getCharge() != 0) continue;
            neutralCount += amount;
        }
        this.type = containsAnti ? (byte)(-type) : (byte)type;
        this.chargeLeptons = cLeptons;
        this.charge = cNucleus + cLeptons;
        this.neutralCount = neutralCount;
        this.element = element;
        element = Math.abs(element);
        int StableIsotope = EMAtomDefinition.stableIzoCurve(element);
        int izoDiff = neutralCount - StableIsotope;
        int izoDiffAbs = Math.abs(izoDiff);
        xstr.setSeed(((long)element + 1L) * ((long)neutralCount + 100L));
        this.iaea = EMNuclideIAEA.get(element, neutralCount);
        if (this.getIaea() != null) {
            this.mass = Double.isNaN(this.getIaea().getMass()) ? mass : this.getIaea().getMass();
            if (Double.isNaN(this.getIaea().getHalfTime())) {
                overriddenLifeTime = lifetimeOverrides.get(this);
                double rawLifeTimeTemp = overriddenLifeTime != null ? overriddenLifeTime : EMAtomDefinition.calculateLifeTime(izoDiff, izoDiffAbs, element, neutralCount, containsAnti);
                this.rawLifeTime = Math.min(rawLifeTimeTemp, 1.5E36);
            } else {
                this.rawLifeTime = containsAnti ? this.getIaea().getHalfTime() * 1.5514433E-21 * (1.0 + xstr.nextDouble() * 9.0) : this.getIaea().getHalfTime();
            }
            this.iaeaDefinitionExistsAndHasEnergyLevels = this.getIaea().getEnergeticStatesArray().length > 1;
        } else {
            this.mass = mass;
            overriddenLifeTime = lifetimeOverrides.get(this);
            double rawLifeTimeTemp = overriddenLifeTime != null ? overriddenLifeTime : EMAtomDefinition.calculateLifeTime(izoDiff, izoDiffAbs, element, neutralCount, containsAnti);
            this.rawLifeTime = Math.min(rawLifeTimeTemp, 1.5E36);
            this.iaeaDefinitionExistsAndHasEnergyLevels = false;
        }
        this.decayMode = this.getIaea() == null || this.getIaea().getEnergeticStatesArray()[0].energy != 0.0 ? (izoDiff == 0 ? (byte)0 : (izoDiff > 0 ? (byte)Math.min(2, 1 + izoDiffAbs / 4) : (byte)(-Math.min(2, 1 + izoDiffAbs / 4)))) : (izoDiff > 0 ? (byte)(Math.min(2, 1 + izoDiffAbs / 4) + 32) : (byte)(-Math.min(2, 1 + izoDiffAbs / 4) + 32));
        this.hash = super.hashCode();
    }

    private static int stableIzoCurve(int element) {
        return (int)Math.round(-1.19561E-6 * Math.pow(element, 4.0) + 1.60885E-4 * Math.pow(element, 3.0) + 3.76604E-4 * Math.pow(element, 2.0) + 1.08418 * (double)element);
    }

    private static double calculateLifeTime(int izoDiff, int izoDiffAbs, int element, int isotope, boolean containsAnti) {
        double rawLifeTime;
        if (element <= 83 && isotope < 127 && (izoDiffAbs == 0 || element == 1 && isotope == 0 || element == 2 && isotope == 1 || izoDiffAbs == 1 && element > 2 && element % 2 == 1 || izoDiffAbs == 3 && element > 30 && element % 2 == 0 || izoDiffAbs == 5 && element > 30 && element % 2 == 0 || izoDiffAbs == 2 && element > 20 && element % 2 == 1)) {
            rawLifeTime = (1.0 + xstr.nextDouble() * 9.0) * (containsAnti ? 23810.0 : 1.5347E25);
        } else {
            double unstabilityEXP;
            if (element == 0) {
                return 1.0E-35;
            }
            if (element == 1) {
                unstabilityEXP = 1.743 - (double)Math.abs(izoDiff - 1) * 9.743;
            } else if (element == 2) {
                switch (isotope) {
                    case 4: {
                        unstabilityEXP = 1.61;
                        break;
                    }
                    case 5: {
                        unstabilityEXP = -7.523;
                        break;
                    }
                    case 6: {
                        unstabilityEXP = -1.51;
                        break;
                    }
                    default: {
                        unstabilityEXP = -((double)izoDiffAbs * 6.165);
                        break;
                    }
                }
            } else if (element <= 83 || isotope <= 127 && element <= 120) {
                double elementPow4 = Math.pow(element, 4.0);
                unstabilityEXP = Math.min((double)element / 2.4, 6.0 + (double)((element + 1) % 2) * 3000000.0 / elementPow4) + (double)(-izoDiff) * elementPow4 / 1.0E8 - Math.abs((double)(izoDiff - 1) + (double)element / 60.0) * (3.0 - (double)element / 12.5 + (double)(element * element) / 1500.0);
            } else if (element < 180) {
                unstabilityEXP = Math.min((double)((element - 85) * 2), 16.0 + (double)((isotope + 1) % 2) * 2.5 - (double)(element - 85) / 3.0) - (double)Math.abs(izoDiff) * (3.0 - (double)element / 13.0 + (double)(element * element) / 1600.0);
            } else {
                return -1.0;
            }
            if ((isotope == 127 || isotope == 128) && element < 120 && element > 83) {
                unstabilityEXP -= 1.8;
            }
            if (element > 83 && element < 93 && isotope % 2 == 0 && izoDiff == 3) {
                unstabilityEXP += 6.0;
            }
            if (element > 93 && element < 103 && isotope % 2 == 0 && izoDiff == 4) {
                unstabilityEXP += 6.0;
            }
            rawLifeTime = (containsAnti ? 1.0E-8 : 1.0) * Math.pow(10.0, unstabilityEXP) * (1.0 + xstr.nextDouble() * 9.0);
        }
        if (rawLifeTime < 8.0E-15) {
            return 1.0E-35;
        }
        if (rawLifeTime > 8.0E28) {
            return 8.0E30;
        }
        return rawLifeTime;
    }

    private static boolean canTheyBeTogether(EMConstantStackMap stacks) {
        boolean nuclei = false;
        long qty = 0L;
        for (EMDefinitionStack stack : (EMDefinitionStack[])stacks.valuesToArray()) {
            if (stack.getDefinition() instanceof EMHadronDefinition) {
                if (((EMHadronDefinition)stack.getDefinition()).getAmount() != 3) {
                    return false;
                }
                nuclei = true;
            } else if (!(stack.getDefinition() instanceof EMLeptonDefinition)) {
                return false;
            }
            if ((double)((int)stack.getAmount()) != stack.getAmount()) {
                throw new ArithmeticException("Amount cannot be safely converted to int!");
            }
            qty = (long)((double)qty + stack.getAmount());
        }
        return nuclei && qty < 65536L;
    }

    @Override
    public int getCharge() {
        return this.charge;
    }

    public int getChargeLeptons() {
        return this.chargeLeptons;
    }

    public int getChargeHadrons() {
        return this.getCharge() - this.getChargeLeptons();
    }

    public int getIonizationElementWise() {
        return this.getElement() * 3 + this.getChargeLeptons();
    }

    @Override
    public double getMass() {
        return this.mass;
    }

    @Override
    public int getGeneration() {
        return this.type;
    }

    @Override
    public double getRawTimeSpan(long currentEnergy) {
        if (currentEnergy <= 0L) {
            return this.rawLifeTime;
        }
        if (this.iaeaDefinitionExistsAndHasEnergyLevels) {
            if (currentEnergy >= (long)this.getIaea().getEnergeticStatesArray().length) {
                return this.getIaea().getEnergeticStatesArray()[this.getIaea().getEnergeticStatesArray().length - 1].Thalf / (double)(currentEnergy - (long)this.getIaea().getEnergeticStatesArray().length + 1L);
            }
            return this.getIaea().getEnergeticStatesArray()[(int)currentEnergy].Thalf;
        }
        return this.rawLifeTime / (double)(currentEnergy + 1L);
    }

    @Override
    public boolean isTimeSpanHalfLife() {
        return true;
    }

    @Override
    public int getMaxColors() {
        return -10;
    }

    @Override
    public String getLocalizedTypeName() {
        return StatCollector.func_74838_a((String)"tt.keyword.Element");
    }

    @Override
    public String getShortLocalizedName() {
        int element;
        boolean weird;
        boolean anti = this.getElement() < 0;
        boolean bl = weird = Math.abs(this.getGeneration()) != 1;
        if (element >= NAME.length) {
            StringBuilder s = new StringBuilder();
            if (anti) {
                s.append(StatCollector.func_74838_a((String)"tt.IUPAC.Anti"));
                do {
                    s.append(StatCollector.func_74838_a((String)("tt.IUPAC." + SYMBOL_IUPAC[element % 10])));
                } while ((element /= 10) > 0);
            } else {
                for (element = Math.abs(this.getElement()); element >= 10; element /= 10) {
                    s.append(StatCollector.func_74838_a((String)("tt.IUPAC." + SYMBOL_IUPAC[element % 10])));
                }
                s.append(StatCollector.func_74838_a((String)("tt.IUPAC." + SYMBOL_IUPAC[element + 10])));
            }
            if (weird) {
                s.append(StatCollector.func_74838_a((String)"tt.keyword.Weird"));
            }
            return s.toString();
        }
        return StatCollector.func_74838_a((String)("tt.element." + (anti ? "Anti" : "") + NAME[element])) + (weird ? StatCollector.func_74838_a((String)"tt.keyword.Weird") : "");
    }

    @Override
    public String getSymbol() {
        String ionName = "";
        int ionization = this.getCharge() / 3;
        if (ionization > 0) {
            ionName = ionization == 1 ? TT_Utility.toSuperscript("+") : TT_Utility.toSuperscript(ionization + "+");
        } else if (ionization < 0) {
            ionName = ionization == -1 ? TT_Utility.toSuperscript("-") : TT_Utility.toSuperscript(-ionization + "-");
        }
        return TT_Utility.toSuperscript(Long.toString((long)this.getNeutralCount() + (long)this.getElement())) + this.getShortSymbol() + ionName;
    }

    @Override
    public String getShortSymbol() {
        int element;
        boolean weird;
        boolean anti = this.getElement() < 0;
        boolean bl = weird = Math.abs(this.getGeneration()) != 1;
        if (element >= SYMBOL.length) {
            StringBuilder s = new StringBuilder(anti ? "~" : "");
            for (element = Math.abs(this.getElement()); element >= 10; element /= 10) {
                s.append(SYMBOL_IUPAC[element % 10]);
            }
            s.append(SYMBOL_IUPAC[element + 10]);
            if (weird) {
                s.append(StatCollector.func_74838_a((String)"tt.keyword.Weird"));
            }
            return s.toString();
        }
        return (anti ? "~" : "") + SYMBOL[element] + (weird ? StatCollector.func_74838_a((String)"tt.keyword.Weird") : "");
    }

    @Override
    public EMConstantStackMap getSubParticles() {
        return this.elementalStacks.clone();
    }

    @Override
    public EMDecay[] getDecayArray() {
        ArrayList<EMDecay> decaysList = new ArrayList<EMDecay>(4);
        return this.getDecayArray(decaysList, this.getDecayMode(), true);
    }

    private EMDecay[] getDecayArray(ArrayList<EMDecay> decaysList, int decayMode, boolean tryAnti) {
        EMAtomDefinition anti;
        if (this.getGeneration() == 1) {
            switch (decayMode) {
                case -2: {
                    if (TecTech.RANDOM.nextBoolean() && this.ElectronCapture(decaysList)) {
                        return decaysList.toArray(EMDecay.NO_PRODUCT);
                    }
                    if (!this.PbetaDecay(decaysList)) break;
                    return decaysList.toArray(EMDecay.NO_PRODUCT);
                }
                case -1: {
                    if (!this.Emmision(decaysList, EMHadronDefinition.hadron_p1)) break;
                    return decaysList.toArray(EMDecay.NO_PRODUCT);
                }
                case 0: {
                    if (!this.alphaDecay(decaysList)) break;
                    return decaysList.toArray(EMDecay.NO_PRODUCT);
                }
                case 1: {
                    if (!this.Emmision(decaysList, EMHadronDefinition.hadron_n1)) break;
                    return decaysList.toArray(EMDecay.NO_PRODUCT);
                }
                case 2: {
                    if (!this.MbetaDecay(decaysList)) break;
                    return decaysList.toArray(EMDecay.NO_PRODUCT);
                }
                default: {
                    if (decayMode <= 8) break;
                    if (this.iaeaDecay(decaysList, 0L)) {
                        return decaysList.toArray(EMDecay.NO_PRODUCT);
                    }
                    return this.getDecayArray(decaysList, decayMode - 32, false);
                }
            }
            return EMDecay.NO_DECAY;
        }
        if (this.getGeneration() == -1 && (anti = this.getAnti()) != null) {
            return anti.getDecayArray(decaysList, decayMode, false);
        }
        return this.getNaturalDecayInstant();
    }

    private boolean iaeaDecay(ArrayList<EMDecay> decaysList, long energy) {
        EMNuclideIAEA.energeticState state = energy > (long)this.getIaea().getEnergeticStatesArray().length ? this.getIaea().getEnergeticStatesArray()[this.getIaea().getEnergeticStatesArray().length - 1] : (energy <= 0L ? this.getIaea().getEnergeticStatesArray()[0] : this.getIaea().getEnergeticStatesArray()[(int)energy]);
        for (int i = 0; i < state.decaymodes.length; ++i) {
            if (this.getDecayFromIaea(decaysList, state.decaymodes[i], energy)) continue;
            decaysList.clear();
            return false;
        }
        return !decaysList.isEmpty();
    }

    private boolean getDecayFromIaea(ArrayList<EMDecay> decaysList, EMNuclideIAEA.iaeaDecay decay, long energy) {
        EMDefinitionStackMap withThis = this.elementalStacks.toMutable();
        EMDefinitionStackMap newStuff = new EMDefinitionStackMap();
        switch (decay.decayName) {
            case "D": {
                if (!withThis.removeAllAmountsExact(deuterium.getDefinition().getSubParticles())) break;
                withThis.putReplace(deuterium);
                decaysList.add(new EMDecay(decay.chance, withThis.toImmutable_optimized_unsafe_LeavesExposedElementalTree()));
                return true;
            }
            case "3H": {
                if (!withThis.removeAllAmountsExact(tritium.getDefinition().getSubParticles())) break;
                withThis.putReplace(tritium);
                decaysList.add(new EMDecay(decay.chance, withThis.toImmutable_optimized_unsafe_LeavesExposedElementalTree()));
                return true;
            }
            case "3HE": {
                if (!withThis.removeAllAmountsExact(helium_3.getDefinition().getSubParticles())) break;
                withThis.putReplace(helium_3);
                decaysList.add(new EMDecay(decay.chance, withThis.toImmutable_optimized_unsafe_LeavesExposedElementalTree()));
                return true;
            }
            case "8BE": {
                if (!withThis.removeAllAmountsExact(beryllium_8.getDefinition().getSubParticles())) break;
                withThis.putReplace(beryllium_8);
                decaysList.add(new EMDecay(decay.chance, withThis.toImmutable_optimized_unsafe_LeavesExposedElementalTree()));
                return true;
            }
            case "14C": {
                if (!withThis.removeAllAmountsExact(carbon_14.getDefinition().getSubParticles())) break;
                newStuff.putReplace(carbon_14);
                try {
                    newStuff.putReplace(new EMAtomDefinition(withThis.toImmutable_optimized_unsafe_LeavesExposedElementalTree()).getStackForm(1.0));
                    decaysList.add(new EMDecay(decay.chance, newStuff.toImmutable_optimized_unsafe_LeavesExposedElementalTree()));
                    return true;
                }
                catch (Exception e) {
                    if (!TecTechConfig.DEBUG_MODE) break;
                    e.printStackTrace();
                    break;
                }
            }
            case "24NE": {
                if (!withThis.removeAllAmountsExact(neon_24.getDefinition().getSubParticles())) break;
                newStuff.putReplace(neon_24);
                try {
                    newStuff.putReplace(new EMAtomDefinition(withThis.toImmutable_optimized_unsafe_LeavesExposedElementalTree()).getStackForm(1.0));
                    decaysList.add(new EMDecay(decay.chance, newStuff.toImmutable_optimized_unsafe_LeavesExposedElementalTree()));
                    return true;
                }
                catch (Exception e) {
                    if (!TecTechConfig.DEBUG_MODE) break;
                    e.printStackTrace();
                    break;
                }
            }
            case "34SI": {
                if (!withThis.removeAllAmountsExact(silicon_34.getDefinition().getSubParticles())) break;
                newStuff.putReplace(silicon_34);
                try {
                    newStuff.putReplace(new EMAtomDefinition(withThis.toImmutable_optimized_unsafe_LeavesExposedElementalTree()).getStackForm(1.0));
                    decaysList.add(new EMDecay(decay.chance, newStuff.toImmutable_optimized_unsafe_LeavesExposedElementalTree()));
                    return true;
                }
                catch (Exception e) {
                    if (!TecTechConfig.DEBUG_MODE) break;
                    e.printStackTrace();
                    break;
                }
            }
            case "A": 
            case "A?": {
                if (!withThis.removeAllAmountsExact(EMHadronDefinition.hadron_n2, EMHadronDefinition.hadron_p2)) break;
                newStuff.putReplace(alpha);
                try {
                    newStuff.putReplace(new EMAtomDefinition(withThis.toImmutable_optimized_unsafe_LeavesExposedElementalTree()).getStackForm(1.0));
                    decaysList.add(new EMDecay(decay.chance, newStuff.toImmutable_optimized_unsafe_LeavesExposedElementalTree()));
                    return true;
                }
                catch (Exception e) {
                    if (!TecTechConfig.DEBUG_MODE) break;
                    e.printStackTrace();
                    break;
                }
            }
            case "B+": {
                if (!withThis.removeAllAmountsExact(EMHadronDefinition.hadron_p1)) break;
                withThis.putUnifyExact(EMHadronDefinition.hadron_n1);
                newStuff.putReplace(EMLeptonDefinition.lepton_e_1);
                newStuff.putReplace(EMNeutrinoDefinition.lepton_Ve1);
                try {
                    newStuff.putReplace(new EMAtomDefinition(withThis.toImmutable_optimized_unsafe_LeavesExposedElementalTree()).getStackForm(1.0));
                    decaysList.add(new EMDecay(decay.chance, newStuff.toImmutable_optimized_unsafe_LeavesExposedElementalTree()));
                    return true;
                }
                catch (Exception e) {
                    if (!TecTechConfig.DEBUG_MODE) break;
                    e.printStackTrace();
                    break;
                }
            }
            case "2B+": {
                if (!withThis.removeAllAmountsExact(EMHadronDefinition.hadron_p2)) break;
                withThis.putUnifyExact(EMHadronDefinition.hadron_n2);
                newStuff.putReplace(EMLeptonDefinition.lepton_e_2);
                newStuff.putReplace(EMNeutrinoDefinition.lepton_Ve2);
                try {
                    newStuff.putReplace(new EMAtomDefinition(withThis.toImmutable_optimized_unsafe_LeavesExposedElementalTree()).getStackForm(1.0));
                    decaysList.add(new EMDecay(decay.chance, newStuff.toImmutable_optimized_unsafe_LeavesExposedElementalTree()));
                    return true;
                }
                catch (Exception e) {
                    if (!TecTechConfig.DEBUG_MODE) break;
                    e.printStackTrace();
                    break;
                }
            }
            case "B-": {
                if (!withThis.removeAllAmountsExact(EMHadronDefinition.hadron_n1)) break;
                withThis.putUnifyExact(EMHadronDefinition.hadron_p1);
                newStuff.putReplace(EMLeptonDefinition.lepton_e1);
                newStuff.putReplace(EMNeutrinoDefinition.lepton_Ve_1);
                try {
                    newStuff.putReplace(new EMAtomDefinition(withThis.toImmutable_optimized_unsafe_LeavesExposedElementalTree()).getStackForm(1.0));
                    decaysList.add(new EMDecay(decay.chance, newStuff.toImmutable_optimized_unsafe_LeavesExposedElementalTree()));
                    return true;
                }
                catch (Exception e) {
                    if (!TecTechConfig.DEBUG_MODE) break;
                    e.printStackTrace();
                    break;
                }
            }
            case "2B-": {
                if (!withThis.removeAllAmountsExact(EMHadronDefinition.hadron_n2)) break;
                withThis.putUnifyExact(EMHadronDefinition.hadron_p2);
                newStuff.putReplace(EMLeptonDefinition.lepton_e2);
                newStuff.putReplace(EMNeutrinoDefinition.lepton_Ve_2);
                try {
                    newStuff.putReplace(new EMAtomDefinition(withThis.toImmutable_optimized_unsafe_LeavesExposedElementalTree()).getStackForm(1.0));
                    decaysList.add(new EMDecay(decay.chance, newStuff.toImmutable_optimized_unsafe_LeavesExposedElementalTree()));
                    return true;
                }
                catch (Exception e) {
                    if (!TecTechConfig.DEBUG_MODE) break;
                    e.printStackTrace();
                    break;
                }
            }
            case "EC": {
                if (!withThis.removeAllAmountsExact(EMHadronDefinition.hadron_p1, EMLeptonDefinition.lepton_e1)) break;
                withThis.putUnifyExact(EMHadronDefinition.hadron_n1);
                newStuff.putReplace(EMNeutrinoDefinition.lepton_Ve1);
                try {
                    newStuff.putReplace(new EMAtomDefinition(withThis.toImmutable_optimized_unsafe_LeavesExposedElementalTree()).getStackForm(1.0));
                    decaysList.add(new EMDecay(decay.chance, newStuff.toImmutable_optimized_unsafe_LeavesExposedElementalTree()));
                    return true;
                }
                catch (Exception e) {
                    if (!TecTechConfig.DEBUG_MODE) break;
                    e.printStackTrace();
                    break;
                }
            }
            case "2EC": {
                if (!withThis.removeAllAmountsExact(EMHadronDefinition.hadron_p2, EMLeptonDefinition.lepton_e2)) break;
                withThis.putUnifyExact(EMHadronDefinition.hadron_n2);
                newStuff.putReplace(EMNeutrinoDefinition.lepton_Ve2);
                try {
                    newStuff.putReplace(new EMAtomDefinition(withThis.toImmutable_optimized_unsafe_LeavesExposedElementalTree()).getStackForm(1.0));
                    decaysList.add(new EMDecay(decay.chance, newStuff.toImmutable_optimized_unsafe_LeavesExposedElementalTree()));
                    return true;
                }
                catch (Exception e) {
                    if (!TecTechConfig.DEBUG_MODE) break;
                    e.printStackTrace();
                    break;
                }
            }
            case "B++EC": 
            case "EC+B+": {
                if (!withThis.removeAllAmountsExact(EMHadronDefinition.hadron_p2, EMLeptonDefinition.lepton_e1)) break;
                withThis.putUnifyExact(EMHadronDefinition.hadron_n2);
                newStuff.putReplace(EMLeptonDefinition.lepton_e_1);
                newStuff.putReplace(EMNeutrinoDefinition.lepton_Ve2);
                try {
                    newStuff.putReplace(new EMAtomDefinition(withThis.toImmutable_optimized_unsafe_LeavesExposedElementalTree()).getStackForm(1.0));
                    decaysList.add(new EMDecay(decay.chance, newStuff.toImmutable_optimized_unsafe_LeavesExposedElementalTree()));
                    return true;
                }
                catch (Exception e) {
                    if (!TecTechConfig.DEBUG_MODE) break;
                    e.printStackTrace();
                    break;
                }
            }
            case "B+A": {
                if (!withThis.removeAllAmountsExact(EMHadronDefinition.hadron_p3, EMHadronDefinition.hadron_n1)) break;
                newStuff.putReplace(EMLeptonDefinition.lepton_e_1);
                newStuff.putReplace(EMNeutrinoDefinition.lepton_Ve1);
                newStuff.putReplace(alpha);
                try {
                    newStuff.putReplace(new EMAtomDefinition(withThis.toImmutable_optimized_unsafe_LeavesExposedElementalTree()).getStackForm(1.0));
                    decaysList.add(new EMDecay(decay.chance, newStuff.toImmutable_optimized_unsafe_LeavesExposedElementalTree()));
                    return true;
                }
                catch (Exception e) {
                    if (!TecTechConfig.DEBUG_MODE) break;
                    e.printStackTrace();
                    break;
                }
            }
            case "B+P": {
                if (!withThis.removeAllAmountsExact(EMHadronDefinition.hadron_p2)) break;
                withThis.putUnifyExact(EMHadronDefinition.hadron_n1);
                newStuff.putReplace(EMLeptonDefinition.lepton_e_1);
                newStuff.putReplace(EMNeutrinoDefinition.lepton_Ve1);
                newStuff.putReplace(EMHadronDefinition.hadron_p1);
                try {
                    newStuff.putReplace(new EMAtomDefinition(withThis.toImmutable_optimized_unsafe_LeavesExposedElementalTree()).getStackForm(1.0));
                    decaysList.add(new EMDecay(decay.chance, newStuff.toImmutable_optimized_unsafe_LeavesExposedElementalTree()));
                    return true;
                }
                catch (Exception e) {
                    if (!TecTechConfig.DEBUG_MODE) break;
                    e.printStackTrace();
                    break;
                }
            }
            case "B+2P": {
                if (!withThis.removeAllAmountsExact(EMHadronDefinition.hadron_p3)) break;
                withThis.putUnifyExact(EMHadronDefinition.hadron_n1);
                newStuff.putReplace(EMLeptonDefinition.lepton_e_1);
                newStuff.putReplace(EMNeutrinoDefinition.lepton_Ve1);
                newStuff.putReplace(EMHadronDefinition.hadron_p2);
                try {
                    newStuff.putReplace(new EMAtomDefinition(withThis.toImmutable_optimized_unsafe_LeavesExposedElementalTree()).getStackForm(1.0));
                    decaysList.add(new EMDecay(decay.chance, newStuff.toImmutable_optimized_unsafe_LeavesExposedElementalTree()));
                    return true;
                }
                catch (Exception e) {
                    if (!TecTechConfig.DEBUG_MODE) break;
                    e.printStackTrace();
                    break;
                }
            }
            case "B-A": {
                if (!withThis.removeAllAmountsExact(EMHadronDefinition.hadron_n3, EMHadronDefinition.hadron_p1)) break;
                newStuff.putReplace(EMLeptonDefinition.lepton_e1);
                newStuff.putReplace(EMNeutrinoDefinition.lepton_Ve_1);
                newStuff.putReplace(alpha);
                try {
                    newStuff.putReplace(new EMAtomDefinition(withThis.toImmutable_optimized_unsafe_LeavesExposedElementalTree()).getStackForm(1.0));
                    decaysList.add(new EMDecay(decay.chance, newStuff.toImmutable_optimized_unsafe_LeavesExposedElementalTree()));
                    return true;
                }
                catch (Exception e) {
                    if (!TecTechConfig.DEBUG_MODE) break;
                    e.printStackTrace();
                    break;
                }
            }
            case "B-N": {
                if (!withThis.removeAllAmountsExact(EMHadronDefinition.hadron_n2)) break;
                withThis.putUnifyExact(EMHadronDefinition.hadron_p1);
                newStuff.putReplace(EMLeptonDefinition.lepton_e1);
                newStuff.putReplace(EMNeutrinoDefinition.lepton_Ve_1);
                newStuff.putReplace(EMHadronDefinition.hadron_n1);
                try {
                    newStuff.putReplace(new EMAtomDefinition(withThis.toImmutable_optimized_unsafe_LeavesExposedElementalTree()).getStackForm(1.0));
                    decaysList.add(new EMDecay(decay.chance, newStuff.toImmutable_optimized_unsafe_LeavesExposedElementalTree()));
                    return true;
                }
                catch (Exception e) {
                    if (!TecTechConfig.DEBUG_MODE) break;
                    e.printStackTrace();
                    break;
                }
            }
            case "B-2N": {
                if (!withThis.removeAllAmountsExact(EMHadronDefinition.hadron_n3)) break;
                withThis.putUnifyExact(EMHadronDefinition.hadron_p1);
                newStuff.putReplace(EMLeptonDefinition.lepton_e1);
                newStuff.putReplace(EMNeutrinoDefinition.lepton_Ve_1);
                newStuff.putReplace(EMHadronDefinition.hadron_n2);
                try {
                    newStuff.putReplace(new EMAtomDefinition(withThis.toImmutable_optimized_unsafe_LeavesExposedElementalTree()).getStackForm(1.0));
                    decaysList.add(new EMDecay(decay.chance, newStuff.toImmutable_optimized_unsafe_LeavesExposedElementalTree()));
                    return true;
                }
                catch (Exception e) {
                    if (!TecTechConfig.DEBUG_MODE) break;
                    e.printStackTrace();
                    break;
                }
            }
            case "B-P": {
                if (!withThis.removeAllAmountsExact(EMHadronDefinition.hadron_n1)) break;
                newStuff.putReplace(EMLeptonDefinition.lepton_e1);
                newStuff.putReplace(EMNeutrinoDefinition.lepton_Ve_1);
                newStuff.putReplace(EMHadronDefinition.hadron_p1);
                try {
                    newStuff.putReplace(new EMAtomDefinition(withThis.toImmutable_optimized_unsafe_LeavesExposedElementalTree()).getStackForm(1.0));
                    decaysList.add(new EMDecay(decay.chance, newStuff.toImmutable_optimized_unsafe_LeavesExposedElementalTree()));
                    return true;
                }
                catch (Exception e) {
                    if (!TecTechConfig.DEBUG_MODE) break;
                    e.printStackTrace();
                    break;
                }
            }
            case "ECA": {
                if (!withThis.removeAllAmountsExact(EMHadronDefinition.hadron_n1, EMLeptonDefinition.lepton_e1, EMHadronDefinition.hadron_p3)) break;
                newStuff.putReplace(EMNeutrinoDefinition.lepton_Ve1);
                newStuff.putReplace(alpha);
                try {
                    newStuff.putReplace(new EMAtomDefinition(withThis.toImmutable_optimized_unsafe_LeavesExposedElementalTree()).getStackForm(1.0));
                    decaysList.add(new EMDecay(decay.chance, newStuff.toImmutable_optimized_unsafe_LeavesExposedElementalTree()));
                    return true;
                }
                catch (Exception e) {
                    if (!TecTechConfig.DEBUG_MODE) break;
                    e.printStackTrace();
                    break;
                }
            }
            case "ECP": {
                if (!withThis.removeAllAmountsExact(EMLeptonDefinition.lepton_e1, EMHadronDefinition.hadron_p2)) break;
                withThis.putUnifyExact(EMHadronDefinition.hadron_n1);
                newStuff.putReplace(EMNeutrinoDefinition.lepton_Ve1);
                newStuff.putReplace(EMHadronDefinition.hadron_p1);
                try {
                    newStuff.putReplace(new EMAtomDefinition(withThis.toImmutable_optimized_unsafe_LeavesExposedElementalTree()).getStackForm(1.0));
                    decaysList.add(new EMDecay(decay.chance, newStuff.toImmutable_optimized_unsafe_LeavesExposedElementalTree()));
                    return true;
                }
                catch (Exception e) {
                    if (!TecTechConfig.DEBUG_MODE) break;
                    e.printStackTrace();
                    break;
                }
            }
            case "EC2P": {
                if (!withThis.removeAllAmountsExact(EMLeptonDefinition.lepton_e1, EMHadronDefinition.hadron_p3)) break;
                withThis.putUnifyExact(EMHadronDefinition.hadron_n1);
                newStuff.putReplace(EMNeutrinoDefinition.lepton_Ve1);
                newStuff.putReplace(EMHadronDefinition.hadron_p2);
                try {
                    newStuff.putReplace(new EMAtomDefinition(withThis.toImmutable_optimized_unsafe_LeavesExposedElementalTree()).getStackForm(1.0));
                    decaysList.add(new EMDecay(decay.chance, newStuff.toImmutable_optimized_unsafe_LeavesExposedElementalTree()));
                    return true;
                }
                catch (Exception e) {
                    if (!TecTechConfig.DEBUG_MODE) break;
                    e.printStackTrace();
                    break;
                }
            }
            case "ECP+EC2P": {
                if (!withThis.removeAllAmountsExact(EMLeptonDefinition.lepton_e2, EMHadronDefinition.hadron_p5)) break;
                withThis.putUnifyExact(EMHadronDefinition.hadron_n1);
                newStuff.putReplace(EMNeutrinoDefinition.lepton_Ve2);
                newStuff.putReplace(EMHadronDefinition.hadron_p3);
                try {
                    newStuff.putReplace(new EMAtomDefinition(withThis.toImmutable_optimized_unsafe_LeavesExposedElementalTree()).getStackForm(1.0));
                    decaysList.add(new EMDecay(decay.chance, newStuff.toImmutable_optimized_unsafe_LeavesExposedElementalTree()));
                    return true;
                }
                catch (Exception e) {
                    if (!TecTechConfig.DEBUG_MODE) break;
                    e.printStackTrace();
                    break;
                }
            }
            case "N": {
                if (!withThis.removeAllAmountsExact(EMHadronDefinition.hadron_n1)) break;
                newStuff.putReplace(EMHadronDefinition.hadron_n1);
                try {
                    newStuff.putReplace(new EMAtomDefinition(withThis.toImmutable_optimized_unsafe_LeavesExposedElementalTree()).getStackForm(1.0));
                    decaysList.add(new EMDecay(decay.chance, newStuff.toImmutable_optimized_unsafe_LeavesExposedElementalTree()));
                    return true;
                }
                catch (Exception e) {
                    if (!TecTechConfig.DEBUG_MODE) break;
                    e.printStackTrace();
                    break;
                }
            }
            case "2N": {
                if (!withThis.removeAllAmountsExact(EMHadronDefinition.hadron_n2)) break;
                newStuff.putReplace(EMHadronDefinition.hadron_n2);
                try {
                    newStuff.putReplace(new EMAtomDefinition(withThis.toImmutable_optimized_unsafe_LeavesExposedElementalTree()).getStackForm(1.0));
                    decaysList.add(new EMDecay(decay.chance, newStuff.toImmutable_optimized_unsafe_LeavesExposedElementalTree()));
                    return true;
                }
                catch (Exception e) {
                    if (!TecTechConfig.DEBUG_MODE) break;
                    e.printStackTrace();
                    break;
                }
            }
            case "P": {
                if (!withThis.removeAllAmountsExact(EMHadronDefinition.hadron_p1)) break;
                newStuff.putReplace(EMHadronDefinition.hadron_p1);
                try {
                    newStuff.putReplace(new EMAtomDefinition(withThis.toImmutable_optimized_unsafe_LeavesExposedElementalTree()).getStackForm(1.0));
                    decaysList.add(new EMDecay(decay.chance, newStuff.toImmutable_optimized_unsafe_LeavesExposedElementalTree()));
                    return true;
                }
                catch (Exception e) {
                    if (!TecTechConfig.DEBUG_MODE) break;
                    e.printStackTrace();
                    break;
                }
            }
            case "2P": {
                if (!withThis.removeAllAmountsExact(EMHadronDefinition.hadron_p2)) break;
                newStuff.putReplace(EMHadronDefinition.hadron_p2);
                try {
                    newStuff.putReplace(new EMAtomDefinition(withThis.toImmutable_optimized_unsafe_LeavesExposedElementalTree()).getStackForm(1.0));
                    decaysList.add(new EMDecay(decay.chance, newStuff.toImmutable_optimized_unsafe_LeavesExposedElementalTree()));
                    return true;
                }
                catch (Exception e) {
                    if (!TecTechConfig.DEBUG_MODE) break;
                    e.printStackTrace();
                    break;
                }
            }
            case "SF": {
                if (!this.Fission(decaysList, withThis, newStuff, decay.chance, false)) break;
                return true;
            }
            case "B-F": {
                if (!withThis.removeAllAmountsExact(EMHadronDefinition.hadron_n1)) break;
                withThis.putUnifyExact(EMHadronDefinition.hadron_p1);
                newStuff.putReplace(EMLeptonDefinition.lepton_e1);
                newStuff.putReplace(EMNeutrinoDefinition.lepton_Ve_1);
                try {
                    if (this.Fission(decaysList, withThis, newStuff, decay.chance, false)) {
                        return true;
                    }
                }
                catch (Exception e) {
                    if (!TecTechConfig.DEBUG_MODE) break;
                    e.printStackTrace();
                }
                break;
            }
            case "ECF": 
            case "ECSF": 
            case "EC(+SF)": {
                if (!withThis.removeAllAmountsExact(EMHadronDefinition.hadron_p1, EMLeptonDefinition.lepton_e1)) break;
                withThis.putUnifyExact(EMHadronDefinition.hadron_n1);
                newStuff.putReplace(EMNeutrinoDefinition.lepton_Ve1);
                try {
                    if (this.Fission(decaysList, withThis, newStuff, decay.chance, false)) {
                        return true;
                    }
                }
                catch (Exception e) {
                    if (!TecTechConfig.DEBUG_MODE) break;
                    e.printStackTrace();
                }
                break;
            }
            case "SF(+EC+B+)": 
            case "SF+EC+B+": {
                if (!withThis.removeAllAmountsExact(EMHadronDefinition.hadron_p2, EMLeptonDefinition.lepton_e1)) break;
                withThis.putUnifyExact(EMHadronDefinition.hadron_n2);
                newStuff.putReplace(EMLeptonDefinition.lepton_e_1);
                newStuff.putReplace(EMNeutrinoDefinition.lepton_Ve2);
                try {
                    if (this.Fission(decaysList, withThis, newStuff, decay.chance, false)) {
                        return true;
                    }
                }
                catch (Exception e) {
                    if (!TecTechConfig.DEBUG_MODE) break;
                    e.printStackTrace();
                }
                break;
            }
            case "SF+EC+B-": {
                if (!withThis.removeAllAmountsExact(EMLeptonDefinition.lepton_e1)) break;
                newStuff.putReplace(EMLeptonDefinition.lepton_e1);
                newStuff.putReplace(EMNeutrinoDefinition.lepton_Ve1);
                newStuff.putReplace(EMNeutrinoDefinition.lepton_Ve_1);
                try {
                    if (this.Fission(decaysList, withThis, newStuff, decay.chance, false)) {
                        return true;
                    }
                }
                catch (Exception e) {
                    if (!TecTechConfig.DEBUG_MODE) break;
                    e.printStackTrace();
                }
                break;
            }
            case "IT": 
            case "IT?": 
            case "G": {
                if (energy > 0L) {
                    decaysList.add(new EMDecay(decay.chance, this, EMGaugeBosonDefinition.boson_Y__));
                } else {
                    if (TecTechConfig.DEBUG_MODE) {
                        TecTech.LOGGER.info((Object)"Tried to emit Gamma from ground state");
                    }
                    decaysList.add(new EMDecay(decay.chance, this));
                }
                return true;
            }
            case "IT+EC+B+": {
                if (!withThis.removeAllAmountsExact(EMHadronDefinition.hadron_p2, EMLeptonDefinition.lepton_e1)) break;
                withThis.putUnifyExact(EMHadronDefinition.hadron_n2);
                newStuff.putReplace(EMLeptonDefinition.lepton_e_1);
                newStuff.putReplace(EMNeutrinoDefinition.lepton_Ve2);
                newStuff.putReplace(EMGaugeBosonDefinition.boson_Y__1);
                try {
                    newStuff.putReplace(new EMAtomDefinition(withThis.toImmutable_optimized_unsafe_LeavesExposedElementalTree()).getStackForm(1.0));
                    decaysList.add(new EMDecay(decay.chance, newStuff.toImmutable_optimized_unsafe_LeavesExposedElementalTree()));
                    return true;
                }
                catch (Exception e) {
                    if (!TecTechConfig.DEBUG_MODE) break;
                    e.printStackTrace();
                    break;
                }
            }
            case "DEAD_END": {
                decaysList.add(EMGaugeBosonDefinition.deadEnd);
                return true;
            }
            default: {
                throw new Error("Unsupported decay mode: " + decay.decayName + ' ' + this.getNeutralCount() + ' ' + this.getElement());
            }
        }
        if (TecTechConfig.DEBUG_MODE) {
            TecTech.LOGGER.info((Object)("Failed to decay " + this.getElement() + ' ' + this.getNeutralCount() + ' ' + decay.decayName));
        }
        return false;
    }

    private boolean Emmision(ArrayList<EMDecay> decaysList, EMDefinitionStack emit) {
        block3: {
            EMDefinitionStackMap tree = this.elementalStacks.toMutable();
            if (tree.removeAmountExact(emit)) {
                try {
                    decaysList.add(new EMDecay(1.0, new EMDefinitionStack(new EMAtomDefinition(tree.toImmutable_optimized_unsafe_LeavesExposedElementalTree()), 1.0), emit));
                    return true;
                }
                catch (Exception e) {
                    if (!TecTechConfig.DEBUG_MODE) break block3;
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    private boolean alphaDecay(ArrayList<EMDecay> decaysList) {
        block3: {
            EMDefinitionStackMap tree = this.elementalStacks.toMutable();
            if (tree.removeAllAmountsExact(alpha.getDefinition().getSubParticles())) {
                try {
                    decaysList.add(new EMDecay(1.0, new EMDefinitionStack(new EMAtomDefinition(tree.toImmutable_optimized_unsafe_LeavesExposedElementalTree()), 1.0), alpha));
                    return true;
                }
                catch (Exception e) {
                    if (!TecTechConfig.DEBUG_MODE) break block3;
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    private boolean MbetaDecay(ArrayList<EMDecay> decaysList) {
        block3: {
            EMDefinitionStackMap tree = this.elementalStacks.toMutable();
            if (tree.removeAmountExact(EMHadronDefinition.hadron_n1)) {
                try {
                    tree.putUnifyExact(EMHadronDefinition.hadron_p1);
                    decaysList.add(new EMDecay(1.0, new EMDefinitionStack(new EMAtomDefinition(tree.toImmutable_optimized_unsafe_LeavesExposedElementalTree()), 1.0), EMLeptonDefinition.lepton_e1, EMNeutrinoDefinition.lepton_Ve_1));
                    return true;
                }
                catch (Exception e) {
                    if (!TecTechConfig.DEBUG_MODE) break block3;
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    private boolean PbetaDecay(ArrayList<EMDecay> decaysList) {
        block3: {
            EMDefinitionStackMap tree = this.elementalStacks.toMutable();
            if (tree.removeAmountExact(EMHadronDefinition.hadron_p1)) {
                try {
                    tree.putUnifyExact(EMHadronDefinition.hadron_n1);
                    decaysList.add(new EMDecay(1.0, new EMDefinitionStack(new EMAtomDefinition(tree.toImmutable_optimized_unsafe_LeavesExposedElementalTree()), 1.0), EMLeptonDefinition.lepton_e_1, EMNeutrinoDefinition.lepton_Ve1));
                    return true;
                }
                catch (Exception e) {
                    if (!TecTechConfig.DEBUG_MODE) break block3;
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    private boolean ElectronCapture(ArrayList<EMDecay> decaysList) {
        block3: {
            EMDefinitionStackMap tree = this.elementalStacks.toMutable();
            if (tree.removeAllAmountsExact(EMHadronDefinition.hadron_p1, EMLeptonDefinition.lepton_e1)) {
                try {
                    tree.putUnifyExact(EMHadronDefinition.hadron_n1);
                    decaysList.add(new EMDecay(1.0, new EMDefinitionStack(new EMAtomDefinition(tree.toImmutable_optimized_unsafe_LeavesExposedElementalTree()), 1.0), EMNeutrinoDefinition.lepton_Ve1));
                    return true;
                }
                catch (Exception e) {
                    if (!TecTechConfig.DEBUG_MODE) break block3;
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    private boolean Fission(ArrayList<EMDecay> decaysList, EMDefinitionStackMap fissile, EMDefinitionStackMap particles, double probability, boolean spontaneousCheck) {
        EMDefinitionStackMap heavy = new EMDefinitionStackMap();
        double[] liquidDrop = EMAtomDefinition.liquidDropFunction(Math.abs(this.getElement()) <= 97);
        for (EMDefinitionStack stack : (EMDefinitionStack[])fissile.valuesToArray()) {
            if (spontaneousCheck && stack.getDefinition() instanceof EMHadronDefinition && (stack.getAmount() <= 80.0 || stack.getAmount() < 90.0 && (double)XSTR.XSTR_INSTANCE.nextInt(10) < stack.getAmount() - 80.0)) {
                return false;
            }
            if (stack.getDefinition().getCharge() == 0) {
                int neutrals_cnt;
                double neutrals;
                particles.putUnifyExact(new EMDefinitionStack(stack.getDefinition(), neutrals_cnt += (neutrals = stack.getAmount() * liquidDrop[2]) - (double)(neutrals_cnt = (int)Math.floor(neutrals)) > XSTR.XSTR_INSTANCE.nextDouble() ? 1 : 0));
                int heavy_cnt = (int)Math.ceil(stack.getAmount() * liquidDrop[1]);
                while ((double)(heavy_cnt + neutrals_cnt) > stack.getAmount()) {
                    --heavy_cnt;
                }
                fissile.removeAmountExact(new EMDefinitionStack(stack.getDefinition(), heavy_cnt + neutrals_cnt));
                heavy.putReplace(new EMDefinitionStack(stack.getDefinition(), heavy_cnt));
                continue;
            }
            int heavy_cnt = (int)Math.ceil(stack.getAmount() * liquidDrop[0]);
            if (heavy_cnt % 2 == 1 && XSTR.XSTR_INSTANCE.nextDouble() > 0.05) {
                --heavy_cnt;
            }
            EMDefinitionStack new_stack = new EMDefinitionStack(stack.getDefinition(), heavy_cnt);
            fissile.removeAmountExact(new_stack);
            heavy.putReplace(new_stack);
        }
        try {
            particles.putReplace(new EMDefinitionStack(new EMAtomDefinition(fissile.toImmutable_optimized_unsafe_LeavesExposedElementalTree()), 1.0));
            particles.putReplace(new EMDefinitionStack(new EMAtomDefinition(heavy.toImmutable_optimized_unsafe_LeavesExposedElementalTree()), 1.0));
            decaysList.add(new EMDecay(probability, particles.toImmutable_optimized_unsafe_LeavesExposedElementalTree()));
            return true;
        }
        catch (Exception e) {
            if (TecTechConfig.DEBUG_MODE) {
                e.printStackTrace();
            }
            return false;
        }
    }

    private static double[] liquidDropFunction(boolean asymmetric) {
        double[] out = new double[3];
        out[0] = XSTR.XSTR_INSTANCE.nextGaussian();
        if (out[0] < 1.0 && out[0] >= -1.0 && XSTR.XSTR_INSTANCE.nextBoolean()) {
            out[0] = XSTR.XSTR_INSTANCE.nextDouble() * 2.0 - 1.0;
        }
        if (asymmetric && out[0] > XSTR.XSTR_INSTANCE.nextDouble() && XSTR.XSTR_INSTANCE.nextInt(4) == 0) {
            out[0] = -out[0];
        }
        out[0] = out[0] * 0.05 + 0.6;
        if (out[0] < 0.0 || out[0] > 1.0) {
            return EMAtomDefinition.liquidDropFunction(asymmetric);
        }
        if (out[0] < 0.5) {
            out[0] = 1.0 - out[0];
        }
        out[2] = 0.012 + XSTR.XSTR_INSTANCE.nextDouble() * 0.01;
        out[1] = asymmetric ? out[0] : out[0] - out[2] * 0.5;
        return out;
    }

    @Override
    public EMDecay[] getEnergyInducedDecay(long energyLevel) {
        ArrayList<EMDecay> decays;
        if (this.iaeaDefinitionExistsAndHasEnergyLevels && this.iaeaDecay(decays = new ArrayList<EMDecay>(4), energyLevel)) {
            return decays.toArray(EMDecay.NO_PRODUCT);
        }
        if (energyLevel < (long)(Math.abs(this.getCharge()) / 3 + this.getNeutralCount())) {
            return new EMDecay[]{new EMDecay(1.0, this, EMGaugeBosonDefinition.boson_Y__)};
        }
        return this.getNaturalDecayInstant();
    }

    @Override
    public double getEnergyDiffBetweenStates(long currentEnergyLevel, long newEnergyLevel) {
        if (this.iaeaDefinitionExistsAndHasEnergyLevels) {
            boolean backwards;
            double result = 0.0;
            boolean bl = backwards = newEnergyLevel < currentEnergyLevel;
            if (backwards) {
                long temp = currentEnergyLevel;
                currentEnergyLevel = newEnergyLevel;
                newEnergyLevel = temp;
            }
            if (currentEnergyLevel <= 0L) {
                if (newEnergyLevel <= 0L) {
                    return 25000.0 * (double)(newEnergyLevel - currentEnergyLevel);
                }
                result += 25000.0 * (double)(-currentEnergyLevel);
            } else {
                result -= this.getIaea().getEnergeticStatesArray()[(int)Math.min((long)((long)(this.getIaea().getEnergeticStatesArray().length - 1)), (long)currentEnergyLevel)].energy;
            }
            if (newEnergyLevel >= (long)this.getIaea().getEnergeticStatesArray().length) {
                if (currentEnergyLevel >= (long)this.getIaea().getEnergeticStatesArray().length) {
                    return 25000.0 * (double)(newEnergyLevel - currentEnergyLevel);
                }
                result += 25000.0 * (double)(newEnergyLevel - (long)this.getIaea().getEnergeticStatesArray().length + 1L);
                result += this.getIaea().getEnergeticStatesArray()[this.getIaea().getEnergeticStatesArray().length - 1].energy;
            } else {
                result += this.getIaea().getEnergeticStatesArray()[(int)newEnergyLevel].energy;
            }
            return backwards ? -result : result;
        }
        return 25000.0 * (double)(newEnergyLevel - currentEnergyLevel);
    }

    @Override
    public boolean usesSpecialEnergeticDecayHandling() {
        return this.iaeaDefinitionExistsAndHasEnergyLevels;
    }

    @Override
    public boolean usesMultipleDecayCalls(long energyLevel) {
        if (!this.iaeaDefinitionExistsAndHasEnergyLevels) {
            return false;
        }
        EMNuclideIAEA.energeticState state = energyLevel > (long)this.getIaea().getEnergeticStatesArray().length ? this.getIaea().getEnergeticStatesArray()[this.getIaea().getEnergeticStatesArray().length - 1] : (energyLevel <= 0L ? this.getIaea().getEnergeticStatesArray()[0] : this.getIaea().getEnergeticStatesArray()[(int)energyLevel]);
        for (EMNuclideIAEA.iaeaDecay decay : state.decaymodes) {
            if (!decay.decayName.contains("F")) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean decayMakesEnergy(long energyLevel) {
        return this.iaeaDefinitionExistsAndHasEnergyLevels;
    }

    @Override
    public boolean fusionMakesEnergy(long energyLevel) {
        return this.getIaea() != null || this.iaeaDefinitionExistsAndHasEnergyLevels;
    }

    @Override
    public EMDecay[] getNaturalDecayInstant() {
        ArrayList<EMDefinitionStack> decaysInto = new ArrayList<EMDefinitionStack>();
        for (EMDefinitionStack elementalStack : (EMDefinitionStack[])this.elementalStacks.valuesToArray()) {
            if (elementalStack.getDefinition().getGeneration() == 1 || elementalStack.getDefinition().getGeneration() == -1) {
                decaysInto.add(elementalStack);
                continue;
            }
            decaysInto.add(new EMDefinitionStack(EMGaugeBosonDefinition.boson_Y__, 2.0));
        }
        return new EMDecay[]{new EMDecay(0.75, decaysInto.toArray(new EMDefinitionStack[0])), EMGaugeBosonDefinition.deadEnd};
    }

    @Override
    public EMAtomDefinition getAnti() {
        EMDefinitionStackMap anti = new EMDefinitionStackMap();
        for (EMDefinitionStack stack : (EMDefinitionStack[])this.elementalStacks.valuesToArray()) {
            anti.putReplace(new EMDefinitionStack(stack.getDefinition().getAnti(), stack.getAmount()));
        }
        try {
            return new EMAtomDefinition(anti.toImmutable_optimized_unsafe_LeavesExposedElementalTree());
        }
        catch (EMException e) {
            if (TecTechConfig.DEBUG_MODE) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public EMNuclideIAEA getIaea() {
        return this.iaea;
    }

    public byte getDecayMode() {
        return this.decayMode;
    }

    public int getNeutralCount() {
        return this.neutralCount;
    }

    public int getElement() {
        return this.element;
    }

    @Override
    protected String getTagValue() {
        return nbtType;
    }

    /*
     * WARNING - void declaration
     */
    public static void run(EMDefinitionsRegistry registry) {
        block14: {
            double rawLifeTime;
            int izoDiffAbs;
            int izoDiff;
            int element;
            registry.registerDefinitionClass(nbtType, new EMIndirectType((definitionsRegistry, nbt) -> new EMAtomDefinition(EMConstantStackMap.fromNBT(definitionsRegistry, nbt)), EMAtomDefinition.class, "tt.keyword.Element"));
            EMNuclideIAEA.run();
            for (Runnable runnable : overrides) {
                runnable.run();
            }
            for (Map.Entry entry : lifetimeOverrides.entrySet()) {
                try {
                    lifetimeOverrides.put(new EMAtomDefinition(((EMAtomDefinition)entry.getKey()).elementalStacks), (Double)entry.getValue());
                }
                catch (EMException e) {
                    e.printStackTrace();
                }
            }
            for (element = 1; element < 83; ++element) {
                for (int i = 0; i < 130; ++i) {
                    xstr.setSeed((long)(element + 1) * (long)(i + 100));
                    int StableIsotope = EMAtomDefinition.stableIzoCurve(element);
                    izoDiff = i - StableIsotope;
                    izoDiffAbs = Math.abs(izoDiff);
                    rawLifeTime = EMAtomDefinition.calculateLifeTime(izoDiff, izoDiffAbs, element, i, false);
                    EMNuclideIAEA nuclide = EMNuclideIAEA.get(element, i);
                    if (!(rawLifeTime >= 1.5E36) && (nuclide == null || !(nuclide.getHalfTime() >= 1.5E36))) continue;
                    TreeSet isotopes = stableIsotopes.computeIfAbsent(element, k -> new TreeSet());
                    isotopes.add(i);
                }
            }
            for (element = 1; element < 150; ++element) {
                for (int i = 100; i < 180; ++i) {
                    xstr.setSeed((long)(element + 1) * (long)(i + 100));
                    int Isotope = EMAtomDefinition.stableIzoCurve(element);
                    izoDiff = i - Isotope;
                    izoDiffAbs = Math.abs(izoDiff);
                    rawLifeTime = EMAtomDefinition.calculateLifeTime(izoDiff, izoDiffAbs, element, i, false);
                    TreeMap isotopes = mostStableUnstableIsotopes.computeIfAbsent(element, k -> new TreeMap());
                    isotopes.put(rawLifeTime, i);
                }
            }
            try {
                for (Map.Entry<Integer, TreeSet<Integer>> entry : stableIsotopes.entrySet()) {
                    stableAtoms.put(entry.getKey(), new EMAtomDefinition(new EMDefinitionStack(EMHadronDefinition.hadron_p, entry.getKey().intValue()), new EMDefinitionStack(EMHadronDefinition.hadron_n, entry.getValue().first().intValue()), new EMDefinitionStack(EMLeptonDefinition.lepton_e, entry.getKey().intValue())));
                    if (!TecTechConfig.DEBUG_MODE) continue;
                    TecTech.LOGGER.info((Object)("Added Stable Atom:" + entry.getKey() + ' ' + entry.getValue().first() + ' ' + stableAtoms.get(entry.getKey()).getMass()));
                }
                for (Map.Entry<Integer, Cloneable> entry : mostStableUnstableIsotopes.entrySet()) {
                    unstableAtoms.put(entry.getKey(), new EMAtomDefinition(new EMDefinitionStack(EMHadronDefinition.hadron_p, entry.getKey().intValue()), new EMDefinitionStack(EMHadronDefinition.hadron_n, ((Integer)((TreeMap)entry.getValue()).lastEntry().getValue()).intValue()), new EMDefinitionStack(EMLeptonDefinition.lepton_e, entry.getKey().intValue())));
                    if (!TecTechConfig.DEBUG_MODE) continue;
                    TecTech.LOGGER.info((Object)("Added Unstable Atom:" + entry.getKey() + ' ' + ((TreeMap)entry.getValue()).lastEntry().getValue() + ' ' + unstableAtoms.get(entry.getKey()).getMass()));
                }
                deuterium = new EMAtomDefinition(EMHadronDefinition.hadron_p1, EMHadronDefinition.hadron_n1, EMLeptonDefinition.lepton_e1).getStackForm(1.0);
                registry.registerForDisplay(deuterium.getDefinition());
                tritium = new EMAtomDefinition(EMHadronDefinition.hadron_p1, EMHadronDefinition.hadron_n2, EMLeptonDefinition.lepton_e1).getStackForm(1.0);
                registry.registerForDisplay(tritium.getDefinition());
                helium_3 = new EMAtomDefinition(EMHadronDefinition.hadron_p2, EMHadronDefinition.hadron_n1, EMLeptonDefinition.lepton_e2).getStackForm(1.0);
                registry.registerForDisplay(helium_3.getDefinition());
                alpha = new EMAtomDefinition(EMHadronDefinition.hadron_p2, EMHadronDefinition.hadron_n2).getStackForm(1.0);
                registry.registerForDisplay(alpha.getDefinition());
                beryllium_8 = new EMAtomDefinition(new EMDefinitionStack(EMHadronDefinition.hadron_p, 4.0), new EMDefinitionStack(EMHadronDefinition.hadron_n, 4.0), new EMDefinitionStack(EMLeptonDefinition.lepton_e, 4.0)).getStackForm(1.0);
                registry.registerForDisplay(beryllium_8.getDefinition());
                carbon_14 = new EMAtomDefinition(new EMDefinitionStack(EMHadronDefinition.hadron_p, 6.0), new EMDefinitionStack(EMHadronDefinition.hadron_n, 8.0), new EMDefinitionStack(EMLeptonDefinition.lepton_e, 6.0)).getStackForm(1.0);
                registry.registerForDisplay(carbon_14.getDefinition());
                neon_24 = new EMAtomDefinition(new EMDefinitionStack(EMHadronDefinition.hadron_p, 10.0), new EMDefinitionStack(EMHadronDefinition.hadron_n, 14.0), new EMDefinitionStack(EMLeptonDefinition.lepton_e, 10.0)).getStackForm(1.0);
                registry.registerForDisplay(neon_24.getDefinition());
                silicon_34 = new EMAtomDefinition(new EMDefinitionStack(EMHadronDefinition.hadron_p, 14.0), new EMDefinitionStack(EMHadronDefinition.hadron_n, 20.0), new EMDefinitionStack(EMLeptonDefinition.lepton_e, 14.0)).getStackForm(1.0);
                registry.registerForDisplay(silicon_34.getDefinition());
                uranium_238 = new EMAtomDefinition(new EMDefinitionStack(EMLeptonDefinition.lepton_e, 92.0), new EMDefinitionStack(EMHadronDefinition.hadron_p, 92.0), new EMDefinitionStack(EMHadronDefinition.hadron_n, 146.0)).getStackForm(1.0);
                registry.registerForDisplay(uranium_238.getDefinition());
                uranium_235 = new EMAtomDefinition(new EMDefinitionStack(EMLeptonDefinition.lepton_e, 92.0), new EMDefinitionStack(EMHadronDefinition.hadron_p, 92.0), new EMDefinitionStack(EMHadronDefinition.hadron_n, 143.0)).getStackForm(1.0);
                registry.registerForDisplay(uranium_235.getDefinition());
                TecTech.LOGGER.info((Object)("Diff Mass U : " + (uranium_238.getDefinition().getMass() - uranium_235.getDefinition().getMass())));
                plutonium_239 = new EMAtomDefinition(new EMDefinitionStack(EMLeptonDefinition.lepton_e, 94.0), new EMDefinitionStack(EMHadronDefinition.hadron_p, 94.0), new EMDefinitionStack(EMHadronDefinition.hadron_n, 145.0)).getStackForm(1.0);
                registry.registerForDisplay(plutonium_239.getDefinition());
                plutonium_241 = new EMAtomDefinition(new EMDefinitionStack(EMLeptonDefinition.lepton_e, 94.0), new EMDefinitionStack(EMHadronDefinition.hadron_p, 94.0), new EMDefinitionStack(EMHadronDefinition.hadron_n, 147.0)).getStackForm(1.0);
                registry.registerForDisplay(plutonium_241.getDefinition());
                TecTech.LOGGER.info((Object)("Diff Mass Pu: " + (plutonium_241.getDefinition().getMass() - plutonium_239.getDefinition().getMass())));
                somethingHeavy = (EMAtomDefinition)plutonium_241.getDefinition();
            }
            catch (Exception e) {
                if (!TecTechConfig.DEBUG_MODE) break block14;
                e.printStackTrace();
            }
        }
        if (TecTechConfig.DEBUG_MODE) {
            TecTech.LOGGER.info((Object)("Registered Elemental Matter Class: Atom a " + EMAtomDefinition.getClassTypeStatic()));
        }
        for (int i = 1; i <= 118; ++i) {
            void var2_15;
            EMAtomDefinition eMAtomDefinition;
            EMAtomDefinition eMAtomDefinition2 = EMAtomDefinition.getFirstStableIsotope(i);
            if (eMAtomDefinition2 == null && (eMAtomDefinition = EMAtomDefinition.getBestUnstableIsotope(i)) == null) continue;
            registry.registerForDisplay((IEMDefinition)var2_15);
        }
    }

    public static void setTransformations(EMTransformationRegistry transformationInfo) {
        refMass = EMAtomDefinition.getFirstStableIsotope(1).getMass() * EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED;
        transformationInfo.addFluid(new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(1), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), Materials.Hydrogen.mGas, 144);
        transformationInfo.addFluid(new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(2), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), Materials.Helium.mGas, 144);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(3), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, Materials.Lithium, 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(4), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, Materials.Beryllium, 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(5), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, Materials.Boron, 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(6), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, Materials.Carbon, 1);
        transformationInfo.addFluid(new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(7), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), Materials.Nitrogen.mGas, 144);
        transformationInfo.addFluid(new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(8), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), Materials.Oxygen.mGas, 144);
        transformationInfo.addFluid(new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(9), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), Materials.Fluorine.mGas, 144);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(11), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, Materials.Sodium, 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(12), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, Materials.Magnesium, 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(13), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, Materials.Aluminium, 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(14), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, Materials.Silicon, 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(15), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, Materials.Phosphorus, 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(16), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, Materials.Sulfur, 1);
        transformationInfo.addFluid(new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(17), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), Materials.Argon.mGas, 144);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(19), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, Materials.Potassium, 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(20), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, Materials.Calcium, 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(21), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, Materials.Scandium, 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(22), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, Materials.Titanium, 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(23), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, Materials.Vanadium, 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(24), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, Materials.Chrome, 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(25), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, Materials.Manganese, 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(26), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, Materials.Iron, 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(27), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, Materials.Cobalt, 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(28), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, Materials.Nickel, 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(29), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, Materials.Copper, 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(30), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, Materials.Zinc, 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(31), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, Materials.Gallium, 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(33), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, Materials.Arsenic, 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(37), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, Materials.Rubidium, 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(38), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, Materials.Strontium, 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(39), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, Materials.Yttrium, 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(41), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, Materials.Niobium, 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(42), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, Materials.Molybdenum, 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(46), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, Materials.Palladium, 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(47), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, Materials.Silver, 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(48), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, Materials.Cadmium, 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(49), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, Materials.Indium, 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(50), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, Materials.Tin, 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(51), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, Materials.Antimony, 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(52), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, Materials.Tellurium, 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(55), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, Materials.Caesium, 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(56), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, Materials.Barium, 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(57), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, Materials.Lanthanum, 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(58), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, Materials.Cerium, 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(59), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, Materials.Praseodymium, 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(60), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, Materials.Neodymium, 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(62), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, Materials.Samarium, 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(63), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, Materials.Europium, 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(64), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, Materials.Gadolinium, 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(65), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, Materials.Terbium, 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(66), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, Materials.Dysprosium, 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(67), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, Materials.Holmium, 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(68), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, Materials.Erbium, 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(69), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, Materials.Thulium, 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(70), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, Materials.Ytterbium, 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(71), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, Materials.Lutetium, 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(73), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, Materials.Tantalum, 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(74), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, Materials.Tungsten, 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(76), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, Materials.Osmium, 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(77), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, Materials.Iridium, 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(78), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, Materials.Platinum, 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(79), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, Materials.Gold, 1);
        transformationInfo.addFluid(new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(80), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), Materials.Mercury.mFluid, 144);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getFirstStableIsotope(82), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, Materials.Lead, 1);
        refUnstableMass = EMAtomDefinition.getFirstStableIsotope(82).getMass() * EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED;
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getBestUnstableIsotope(61), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, Materials.Promethium, 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getBestUnstableIsotope(83), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, Materials.Bismuth, 1);
        transformationInfo.addFluid(new EMDefinitionStack(EMAtomDefinition.getBestUnstableIsotope(86), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), Materials.Radon.mGas, 144);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getBestUnstableIsotope(90), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, Materials.Thorium, 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(EMAtomDefinition.getBestUnstableIsotope(95), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, Materials.Americium, 1);
        transformationInfo.addFluid(new EMDefinitionStack(deuterium.getDefinition(), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), Materials.Deuterium.mGas, 144);
        transformationInfo.addFluid(new EMDefinitionStack(tritium.getDefinition(), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), Materials.Tritium.mGas, 144);
        transformationInfo.addFluid(new EMDefinitionStack(helium_3.getDefinition(), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), Materials.Helium_3.mGas, 144);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(uranium_238.getDefinition(), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, Materials.Uranium, 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(uranium_235.getDefinition(), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, Materials.Uranium235, 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(plutonium_239.getDefinition(), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, Materials.Plutonium, 1);
        transformationInfo.addOredict((IEMStack)new EMDefinitionStack(plutonium_241.getDefinition(), EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED), OrePrefixes.dust, Materials.Plutonium241, 1);
    }

    public static EMAtomDefinition getFirstStableIsotope(int element) {
        return stableAtoms.get(element);
    }

    public static EMAtomDefinition getBestUnstableIsotope(int element) {
        return unstableAtoms.get(element);
    }

    @Override
    public int getMatterMassType() {
        return EMAtomDefinition.getClassTypeStatic();
    }

    public static int getClassTypeStatic() {
        return 64;
    }

    @Override
    public int hashCode() {
        return this.hash;
    }

    static {
        xstr = new XSTR();
        stableIsotopes = new HashMap<Integer, TreeSet<Integer>>();
        stableAtoms = new HashMap<Integer, EMAtomDefinition>();
        mostStableUnstableIsotopes = new HashMap<Integer, TreeMap<Double, Integer>>();
        unstableAtoms = new HashMap<Integer, EMAtomDefinition>();
        lifetimeOverrides = new HashMap();
        overrides = new ArrayList();
    }
}

