/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.tools.inventory;

import java.lang.ref.WeakReference;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.world.World;
import tconstruct.library.crafting.ModifyBuilder;
import tconstruct.library.modifier.IModifyable;
import tconstruct.tools.TinkerTools;
import tconstruct.tools.gui.ChestSlot;
import tconstruct.tools.inventory.InventoryCraftingStation;
import tconstruct.tools.inventory.InventoryCraftingStationResult;
import tconstruct.tools.inventory.SlotCraftingStation;
import tconstruct.tools.logic.CraftingStationLogic;

public class CraftingStationContainer
extends Container {
    private final World worldObj;
    private final int posX;
    private final int posY;
    private final int posZ;
    private final WeakReference[] inventories;
    public InventoryCrafting craftMatrix;
    public IInventory craftResult;
    public CraftingStationLogic logic;
    EntityPlayer player;

    public CraftingStationContainer(InventoryPlayer inventoryplayer, CraftingStationLogic logic, int x, int y, int z) {
        int col;
        int row;
        this.worldObj = logic.func_145831_w();
        this.player = inventoryplayer.field_70458_d;
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.logic = logic;
        this.craftMatrix = new InventoryCraftingStation(this, 3, 3, logic);
        this.craftResult = new InventoryCraftingStationResult(logic);
        this.inventories = logic.getInventories();
        int bothOffset = 0;
        if (logic.chest != null) {
            if (logic.slotCount > 54) {
                bothOffset += 12;
            }
            bothOffset += 122;
        }
        int craftingOffsetX = 30 + bothOffset;
        int inventoryOffsetX = 8 + bothOffset;
        this.func_75146_a((Slot)new SlotCraftingStation(inventoryplayer.field_70458_d, (IInventory)this.craftMatrix, this.craftResult, 0, craftingOffsetX + 94, 35));
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 3; ++col) {
                this.func_75146_a(new Slot((IInventory)this.craftMatrix, col + row * 3, craftingOffsetX + col * 18, 17 + row * 18));
            }
        }
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.func_75146_a(new Slot((IInventory)inventoryplayer, col + row * 9 + 9, inventoryOffsetX + col * 18, 84 + row * 18));
            }
        }
        for (col = 0; col < 9; ++col) {
            this.func_75146_a(new Slot((IInventory)inventoryplayer, col, inventoryOffsetX + col * 18, 142));
        }
        if (logic.chest != null) {
            IInventory inv = logic.getFirstInventory();
            IInventory secondInv = logic.getSecondInventory();
            int accessSide = logic.chestDirection.getOpposite().ordinal();
            int[] accessibleSlots = inv instanceof ISidedInventory ? ((ISidedInventory)inv).func_94128_d(accessSide) : null;
            int index = 0;
            int invSize = inv.func_70302_i_() * (secondInv != null ? 2 : 1);
            block5: for (row = 0; row < logic.invRows; ++row) {
                for (col = 0; col < logic.invColumns && index < invSize; ++index, ++col) {
                    int curIndex;
                    IInventory curInv = secondInv != null && index >= 27 ? secondInv : inv;
                    int n = curIndex = secondInv != null && index >= 27 ? index - 27 : index;
                    if (accessibleSlots != null) {
                        if (curIndex >= accessibleSlots.length) continue block5;
                        curIndex = accessibleSlots[curIndex];
                    }
                    this.func_75146_a(new ChestSlot(curInv, curIndex, index, 8 + col * 18, 19 + row * 18, accessSide));
                }
            }
        }
        this.func_75130_a((IInventory)this.craftMatrix);
    }

    public ItemStack modifyItem() {
        Item item;
        ItemStack input = this.craftMatrix.func_70301_a(4);
        if (input != null && (item = input.func_77973_b()) instanceof IModifyable) {
            ItemStack[] slots = new ItemStack[8];
            for (int i = 0; i < 4; ++i) {
                slots[i] = this.craftMatrix.func_70301_a(i);
                slots[i + 4] = this.craftMatrix.func_70301_a(i + 5);
            }
            return ModifyBuilder.instance.modifyItem(input, slots);
        }
        return null;
    }

    public ItemStack func_82846_b(EntityPlayer entityPlayer, int index) {
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot == null || !slot.func_75216_d()) {
            return null;
        }
        ItemStack itemstack = slot.func_75211_c();
        ItemStack ret = itemstack.func_77946_l();
        boolean nothingDone = true;
        if (index == 0) {
            if (ret.func_77973_b() instanceof IModifyable) {
                nothingDone &= !this.mergeCraftedStack(itemstack, this.logic.func_70302_i_(), this.field_75151_b.size(), true, entityPlayer);
            } else {
                nothingDone &= this.refillChest(itemstack);
                nothingDone &= this.moveToPlayerInventory(itemstack);
            }
            slot.func_75220_a(itemstack, ret);
        } else if (index >= 1 && index < 10) {
            nothingDone &= this.refillChest(itemstack);
            nothingDone &= this.moveToPlayerInventory(itemstack);
        } else if (index >= 10 && index < 46) {
            nothingDone &= this.moveToCraftingGrid(itemstack);
            nothingDone &= this.moveToChest(itemstack);
        } else {
            nothingDone &= this.moveToCraftingGrid(itemstack);
            nothingDone &= this.moveToPlayerInventory(itemstack);
        }
        if (nothingDone) {
            return null;
        }
        if (itemstack.field_77994_a == 0) {
            slot.func_75215_d(null);
        } else {
            slot.func_75218_e();
        }
        if (itemstack.field_77994_a == ret.field_77994_a) {
            return null;
        }
        slot.func_82870_a(entityPlayer, itemstack);
        return ret;
    }

    protected boolean refillChest(ItemStack itemstack) {
        if (itemstack == null || itemstack.field_77994_a <= 0 || this.logic.slotCount == 0) {
            return false;
        }
        return !this.mergeItemStackRefill(itemstack, 46, 46 + this.logic.slotCount, false);
    }

    protected boolean moveToChest(ItemStack itemstack) {
        if (itemstack == null || itemstack.field_77994_a <= 0 || this.logic.slotCount == 0) {
            return false;
        }
        return !this.func_75135_a(itemstack, 46, 46 + this.logic.slotCount, false);
    }

    protected boolean moveToPlayerInventory(ItemStack itemstack) {
        if (itemstack == null || itemstack.field_77994_a <= 0) {
            return false;
        }
        return !this.func_75135_a(itemstack, 10, 46, false);
    }

    protected boolean moveToCraftingGrid(ItemStack itemstack) {
        if (itemstack == null || itemstack.field_77994_a <= 0) {
            return false;
        }
        return !this.func_75135_a(itemstack, 1, 10, true);
    }

    public boolean func_94530_a(ItemStack par1ItemStack, Slot par2Slot) {
        return par2Slot.field_75224_c != this.craftResult && super.func_94530_a(par1ItemStack, par2Slot);
    }

    public void func_75134_a(EntityPlayer par1EntityPlayer) {
        super.func_75134_a(par1EntityPlayer);
        if (!this.worldObj.field_72995_K) {
            for (int i = 0; i < 9; ++i) {
                ItemStack itemstack = this.craftMatrix.func_70304_b(i);
                if (itemstack == null) continue;
                par1EntityPlayer.func_71019_a(itemstack, false);
            }
        }
    }

    public void func_75130_a(IInventory par1IInventory) {
        ItemStack tool = this.modifyItem();
        if (tool != null) {
            this.craftResult.func_70299_a(0, tool);
        } else {
            this.craftResult.func_70299_a(0, CraftingManager.func_77594_a().func_82787_a(this.craftMatrix, this.worldObj));
        }
    }

    public boolean func_75145_c(EntityPlayer player) {
        Block block = this.worldObj.func_147439_a(this.posX, this.posY, this.posZ);
        if (block != TinkerTools.craftingStationWood && block != TinkerTools.craftingSlabWood) {
            return false;
        }
        if (!this.logic.func_70300_a(player) || !CraftingStationLogic.isUseableByPlayer(player, this.inventories)) {
            return false;
        }
        return player.func_70092_e((double)this.posX + 0.5, (double)this.posY + 0.5, (double)this.posZ + 0.5) <= 64.0;
    }

    protected boolean mergeCraftedStack(ItemStack stack, int slotsStart, int slotsTotal, boolean playerInventory, EntityPlayer player) {
        boolean failedToMerge = false;
        int slotIndex = slotsStart;
        if (playerInventory) {
            slotIndex = slotsTotal - 1;
        }
        if (stack.field_77994_a > 0) {
            while (!playerInventory && slotIndex < slotsTotal || playerInventory && slotIndex >= slotsStart) {
                Slot otherInventorySlot = (Slot)this.field_75151_b.get(slotIndex);
                ItemStack copyStack = otherInventorySlot.func_75211_c();
                if (copyStack == null && otherInventorySlot.func_75214_a(stack)) {
                    otherInventorySlot.func_75215_d(stack.func_77946_l());
                    otherInventorySlot.func_75218_e();
                    stack.field_77994_a = 0;
                    failedToMerge = true;
                    break;
                }
                if (playerInventory) {
                    --slotIndex;
                    continue;
                }
                ++slotIndex;
            }
        }
        return failedToMerge;
    }

    protected boolean func_75135_a(@Nonnull ItemStack stack, int startIndex, int endIndex, boolean useEndIndex) {
        boolean ret = this.mergeItemStackRefill(stack, startIndex, endIndex, useEndIndex);
        if (stack.field_77994_a > 0) {
            ret |= this.mergeItemStackMove(stack, startIndex, endIndex, useEndIndex);
        }
        return ret;
    }

    protected boolean mergeItemStackRefill(@Nonnull ItemStack stack, int startIndex, int endIndex, boolean useEndIndex) {
        int k;
        if (stack.field_77994_a <= 0) {
            return false;
        }
        boolean didSomething = false;
        int n = k = useEndIndex ? endIndex - 1 : startIndex;
        if (stack.func_77985_e()) {
            while (stack.field_77994_a > 0 && (!useEndIndex && k < endIndex || useEndIndex && k >= startIndex)) {
                Slot slot = (Slot)this.field_75151_b.get(k);
                ItemStack itemstack1 = slot.func_75211_c();
                if (itemstack1 != null && itemstack1.func_77973_b() == stack.func_77973_b() && (!stack.func_77981_g() || stack.func_77960_j() == itemstack1.func_77960_j()) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack1) && this.func_94530_a(stack, slot)) {
                    int l = itemstack1.field_77994_a + stack.field_77994_a;
                    int limit = Math.min(stack.func_77976_d(), slot.func_75219_a());
                    if (l <= limit) {
                        stack.field_77994_a = 0;
                        itemstack1.field_77994_a = l;
                        slot.func_75218_e();
                        didSomething = true;
                    } else if (itemstack1.field_77994_a < limit) {
                        stack.field_77994_a -= limit - itemstack1.field_77994_a;
                        itemstack1.field_77994_a = limit;
                        slot.func_75218_e();
                        didSomething = true;
                    }
                }
                if (useEndIndex) {
                    --k;
                    continue;
                }
                ++k;
            }
        }
        return didSomething;
    }

    protected boolean mergeItemStackMove(@Nonnull ItemStack stack, int startIndex, int endIndex, boolean useEndIndex) {
        int k;
        if (stack.field_77994_a <= 0) {
            return false;
        }
        boolean didSomething = false;
        int n = k = useEndIndex ? endIndex - 1 : startIndex;
        while (!useEndIndex && k < endIndex || useEndIndex && k >= startIndex) {
            Slot slot = (Slot)this.field_75151_b.get(k);
            ItemStack itemstack1 = slot.func_75211_c();
            if ((itemstack1 == null || itemstack1.field_77994_a == 0) && slot.func_75214_a(stack) && this.func_94530_a(stack, slot)) {
                int limit = slot.func_75219_a();
                ItemStack stack2 = stack.func_77946_l();
                if (stack2.field_77994_a > limit) {
                    stack2.field_77994_a = limit;
                    stack.field_77994_a -= limit;
                } else {
                    stack.field_77994_a = 0;
                }
                slot.func_75215_d(stack2);
                slot.func_75218_e();
                didSomething = true;
                if (stack.field_77994_a <= 0) break;
            }
            if (useEndIndex) {
                --k;
                continue;
            }
            ++k;
        }
        return didSomething;
    }
}

