/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.blocks.slime;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import tconstruct.library.TConstructRegistry;
import tconstruct.tools.TinkerTools;
import tconstruct.world.TinkerWorld;
import tconstruct.world.gen.SlimeTreeGen;

public class SlimeSapling
extends BlockSapling {
    public IIcon[] icons;
    public String[] textureNames = new String[]{"blue"};

    public SlimeSapling() {
        float f = 0.4f;
        this.func_149676_a(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, f * 2.0f, 0.5f + f);
        this.func_149711_c(0.0f);
        this.func_149672_a(Block.field_149779_h);
        this.func_149647_a(TConstructRegistry.blockTab);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.icons = new IIcon[this.textureNames.length];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = iconRegister.func_94245_a("tinker:slimesapling_" + this.textureNames[i]);
        }
    }

    public boolean func_149854_a(Block id) {
        return id == Blocks.field_150349_c || id == Blocks.field_150346_d || id == TinkerWorld.slimeGrass || id == TinkerTools.craftedSoil;
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        if (world.field_72995_K) {
            return;
        }
        super.func_149674_a(world, x, y, z, random);
        int md = world.func_72805_g(x, y, z);
        if (random.nextInt(10) == 0 && world.func_72957_l(x, y + 1, z) >= 9) {
            if ((md & 8) == 0) {
                world.func_72921_c(x, y, z, md | 8, 4);
            } else {
                this.growTree(world, x, y, z, random);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.icons[meta % this.icons.length];
    }

    public void func_149879_c(World world, int x, int y, int z, Random random) {
        this.boneFertilize(world, x, y, z, random, null);
    }

    public boolean boneFertilize(World world, int x, int y, int z, Random random, EntityPlayer player) {
        int meta = world.func_72805_g(x, y, z);
        if (!(meta % 8 != 0 || player != null && player.field_71075_bZ.field_75098_d)) {
            return false;
        }
        if ((meta & 8) == 0) {
            world.func_72921_c(x, y, z, meta | 8, 4);
        } else {
            this.growTree(world, x, y, z, random);
        }
        return true;
    }

    public void growTree(World world, int x, int y, int z, Random random) {
        int md = world.func_72805_g(x, y, z) % 8;
        world.func_147449_b(x, y, z, Blocks.field_150350_a);
        SlimeTreeGen obj = new SlimeTreeGen(true, 5, 4, 1, 0);
        if (!obj.func_76484_a(world, random, x, y, z)) {
            world.func_147465_d(x, y, z, (Block)this, md + 8, 3);
        }
    }

    public int func_149692_a(int i) {
        return i % 8;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int i = 0; i < 1; ++i) {
            par3List.add(new ItemStack(par1, 1, i));
        }
    }
}

