/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.Fancy;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.renderer.IImageBuffer;
import net.minecraft.client.renderer.ThreadDownloadImageData;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import vswe.stevescarts.Fancy.LOAD_TYPE;
import vswe.stevescarts.Fancy.ServerFancy;
import vswe.stevescarts.Fancy.UserFancy;
import vswe.stevescarts.Helpers.ResourceHelper;

@SideOnly(value=Side.CLIENT)
public abstract class FancyPancyHandler {
    private final String code;
    private static final int PROTOCOL_VERSION = 0;
    private HashMap<String, UserFancy> fancies;
    private HashMap<String, ServerFancy> serverFancies;
    private boolean ready = false;
    private String serverHash;
    private int serverReHash;

    public HashMap<String, ServerFancy> getServerFancies() {
        return this.serverFancies;
    }

    public HashMap<String, UserFancy> getFancies() {
        return this.fancies;
    }

    public final String getCode() {
        return this.code;
    }

    public FancyPancyHandler(String code) {
        this.code = code;
        FMLCommonHandler.instance().bus().register((Object)this);
        this.fancies = new HashMap();
        this.serverFancies = new HashMap();
    }

    public void setReady(boolean ready) {
        this.ready = ready;
    }

    private void generateServerHash() {
        ServerData data = (ServerData)ReflectionHelper.getPrivateValue(Minecraft.class, (Object)Minecraft.func_71410_x(), (int)7);
        String ip = data != null ? (data.field_78845_b.equals("127.0.0.1") ? "localhost" : data.field_78845_b) : (Minecraft.func_71410_x().func_71401_C() != null && Minecraft.func_71410_x().func_71401_C().func_71344_c() ? "localhost" : "single player");
        this.serverHash = this.md5(ip.toLowerCase());
        this.serverReHash = 100;
    }

    public String getServerHash() {
        if (this.serverReHash == 0) {
            this.generateServerHash();
        }
        return this.serverHash;
    }

    private String md5(String str) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(str.getBytes());
            byte[] bytes = md5.digest();
            String result = "";
            for (byte b : bytes) {
                result = result + Integer.toString((b & 0xFF) + 256, 16).substring(1);
            }
            return result;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    @SubscribeEvent
    public void tick(TickEvent.PlayerTickEvent event) {
        EntityPlayer player;
        if (!this.ready || event.phase != TickEvent.Phase.START) {
            return;
        }
        if (this.serverReHash > 0) {
            --this.serverReHash;
        }
        if ((player = event.player) instanceof AbstractClientPlayer) {
            this.loadNewFancy((AbstractClientPlayer)player);
        }
    }

    private void loadNewFancy(AbstractClientPlayer player) {
        if (player != null) {
            String username = StringUtils.func_76338_a((String)player.getDisplayName());
            UserFancy fancyObj = this.fancies.get(username);
            if (fancyObj == null && this.serverFancies.size() > 0 && this.serverFancies.containsKey(this.getServerHash())) {
                fancyObj = new UserFancy(this);
                this.fancies.put(username, fancyObj);
            }
            if (fancyObj != null) {
                ResourceLocation loc;
                fancyObj.update(player);
                String fancy = fancyObj.getImage(player);
                if (fancy != null && !(loc = ResourceHelper.getResourceFromPath(fancy)).equals((Object)this.getCurrentResource(player))) {
                    this.setCurrentResource(player, loc, fancy);
                }
            }
        }
    }

    public ThreadDownloadImageData tryToDownloadFancy(ResourceLocation fancy, String fancyUrl) {
        return this.tryToDownloadFancy(fancy, fancyUrl, null, null);
    }

    public ThreadDownloadImageData tryToDownloadFancy(ResourceLocation fancy, String fancyUrl, ResourceLocation fallbackResource, IImageBuffer optionalBuffer) {
        TextureManager texturemanager = Minecraft.func_71410_x().func_110434_K();
        ITextureObject object = texturemanager.func_110581_b(fancy);
        if (object == null) {
            object = new ThreadDownloadImageData(null, fancyUrl, fallbackResource, optionalBuffer);
            texturemanager.func_110579_a(fancy, object);
        }
        return (ThreadDownloadImageData)object;
    }

    public abstract String getDefaultUrl(AbstractClientPlayer var1);

    public abstract ResourceLocation getDefaultResource(AbstractClientPlayer var1);

    public abstract ThreadDownloadImageData getCurrentTexture(AbstractClientPlayer var1);

    public abstract ResourceLocation getCurrentResource(AbstractClientPlayer var1);

    public abstract void setCurrentResource(AbstractClientPlayer var1, ResourceLocation var2, String var3);

    public abstract LOAD_TYPE getDefaultLoadType();

    public abstract String getDefaultUrl();
}

