/*
 * Decompiled with CFR 0.152.
 */
package toast.specialMobs.entity.skeleton;

import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import toast.specialMobs.DataWatcherHelper;
import toast.specialMobs.EffectHelper;
import toast.specialMobs.EnchantmentSpecial;
import toast.specialMobs._SpecialMobs;
import toast.specialMobs.entity.EntityAINinja;
import toast.specialMobs.entity.INinja;
import toast.specialMobs.entity.skeleton.Entity_SpecialSkeleton;

public class EntityNinjaSkeleton
extends Entity_SpecialSkeleton
implements INinja {
    public static final byte DW_FROZEN = DataWatcherHelper.instance.SKELETON_NINJA.nextKey();
    public static final byte DW_HIDING_BLOCK = DataWatcherHelper.instance.SKELETON_NINJA.nextKey();
    public static final byte DW_HIDING_DATA = DataWatcherHelper.instance.SKELETON_NINJA.nextKey();
    public static final byte HU_REVEAL_FX = 11;
    public static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation(_SpecialMobs.TEXTURE_PATH + "skeleton/ninja.png"), new ResourceLocation(_SpecialMobs.TEXTURE_PATH + "skeleton/ninja_wither.png")};
    public boolean canHide = true;

    public EntityNinjaSkeleton(World world) {
        super(world);
        this.field_70714_bg.func_75776_a(-1, (EntityAIBase)new EntityAINinja((EntityLiving)this));
        this.getSpecialData().setTextures(TEXTURES);
        this.field_70728_aV += 2;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a((int)DW_FROZEN, (Object)0);
        this.field_70180_af.func_75682_a((int)DW_HIDING_BLOCK, (Object)0);
        this.field_70180_af.func_75682_a((int)DW_HIDING_DATA, (Object)0);
    }

    @Override
    public boolean getFrozen() {
        return this.field_70180_af.func_75683_a((int)DW_FROZEN) != 0;
    }

    @Override
    public void setFrozen(boolean frozen) {
        if (frozen != this.getFrozen()) {
            this.field_70180_af.func_75692_b((int)DW_FROZEN, (Object)((byte)(frozen ? 1 : 0)));
            if (frozen) {
                this.field_70165_t = Math.floor(this.field_70165_t) + 0.5;
                this.field_70163_u = Math.floor(this.field_70163_u);
                this.field_70161_v = Math.floor(this.field_70161_v) + 0.5;
            }
        }
    }

    @Override
    public Block getHidingBlock() {
        Block block;
        int id;
        if (this.func_70089_S() && (id = this.field_70180_af.func_75679_c((int)DW_HIDING_BLOCK)) > 0 && (block = Block.func_149729_e((int)id)) != Blocks.field_150350_a) {
            return block;
        }
        return null;
    }

    @Override
    public int getHidingData() {
        return this.field_70180_af.func_75683_a((int)DW_HIDING_DATA);
    }

    @Override
    public void setHidingBlock(Block block, int data) {
        int id = block == null ? 0 : Block.func_149682_b((Block)block);
        if (id != this.field_70180_af.func_75679_c((int)DW_HIDING_BLOCK)) {
            if (id == 0) {
                this.field_70170_p.func_72956_a((Entity)this, "mob.zombie.infect", 1.0f, 0.5f);
                this.field_70170_p.func_72960_a((Entity)this, (byte)11);
            }
            this.field_70180_af.func_75692_b((int)DW_HIDING_BLOCK, (Object)id);
        }
        if (data != this.getHidingData()) {
            this.field_70180_af.func_75692_b((int)DW_HIDING_DATA, (Object)((byte)data));
        }
        this.canHide = false;
    }

    @Override
    protected void initTypeAI() {
        this.setRangedAI(1.0, 20, 30, 9.0f);
        this.setMeleeAI(1.2);
    }

    @Override
    public void adjustTypeAttributes() {
        if (this.field_70146_Z.nextBoolean()) {
            ItemStack sword = new ItemStack(Items.field_151040_l);
            try {
                EffectHelper.enchantItem(this.field_70146_Z, sword, 30);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            EffectHelper.setItemName(sword, "Katana");
            this.func_70062_b(0, sword);
        }
        this.func_98053_h(true);
    }

    @Override
    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.canHide) {
                this.setHiding();
            } else if (this.field_70122_E && (this.func_70777_m() == null || this.func_70777_m() instanceof EntityPlayer && ((EntityPlayer)this.func_70777_m()).field_71075_bZ.field_75098_d) && this.getHidingBlock() == null) {
                this.canHide = true;
            }
        }
        super.func_70636_d();
    }

    @Override
    protected void onTypeAttack(Entity target) {
        this.setHidingBlock(null, 0);
        this.func_70784_b(target);
    }

    public boolean func_70097_a(DamageSource damageSource, float damage) {
        if (super.func_70097_a(damageSource, damage)) {
            this.setHidingBlock(null, 0);
            return true;
        }
        return false;
    }

    public boolean func_70085_c(EntityPlayer player) {
        if (!this.field_70170_p.field_72995_K && this.getHidingBlock() != null) {
            this.setHidingBlock(null, 0);
            this.func_70784_b((Entity)player);
        }
        return super.func_70085_c(player);
    }

    protected String func_70639_aQ() {
        return null;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public void func_70091_d(double x, double y, double z) {
        if (!this.getFrozen()) {
            super.func_70091_d(x, y, z);
        } else {
            this.field_70181_x = 0.0;
        }
    }

    public boolean func_70104_M() {
        return !this.getFrozen();
    }

    @Override
    protected void func_70628_a(boolean hit, int looting) {
        super.func_70628_a(hit, looting);
        int i = this.field_70146_Z.nextInt(3 + looting);
        while (i-- > 0) {
            this.func_145779_a(Items.field_151121_aF, 1);
        }
        i = this.field_70146_Z.nextInt(2 + looting);
        while (i-- > 0) {
            this.func_145779_a(Items.field_151100_aR, 1);
        }
    }

    protected void func_70600_l(int superRare) {
        ItemStack drop = new ItemStack(Items.field_151040_l);
        try {
            EffectHelper.enchantItem(this.field_70146_Z, drop, 30);
            if (EnchantmentSpecial.painSword != null) {
                EffectHelper.overrideEnchantment(drop, EnchantmentSpecial.painSword, 2);
            } else {
                EffectHelper.overrideEnchantment(drop, Enchantment.field_77338_j, 2);
            }
            EffectHelper.overrideEnchantment(drop, Enchantment.field_77347_r, 5);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        EffectHelper.setItemName(drop, "Kusanagi-no-Tsurugi", 13);
        this.func_70099_a(drop, 0.0f);
    }

    public void func_70103_a(byte b) {
        if (b == 11) {
            this.func_70656_aK();
        } else {
            super.func_70103_a(b);
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        Block hidingBlock = this.getHidingBlock();
        if (hidingBlock != null) {
            tag.func_74778_a("HidingBlock", Block.field_149771_c.func_148750_c((Object)hidingBlock));
            tag.func_74774_a("HidingData", (byte)(this.getHidingData() & 0xF));
        } else {
            tag.func_74778_a("HidingBlock", "\f");
            tag.func_74774_a("HidingData", (byte)0);
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        if (tag.func_74764_b("HidingBlock")) {
            String hidingBlock = tag.func_74779_i("HidingBlock");
            if (hidingBlock.equals("\f")) {
                this.setHidingBlock(null, 0);
            } else {
                this.setHidingBlock(Block.func_149684_b((String)hidingBlock), tag.func_74771_c("HidingData"));
            }
        }
    }

    public void setHiding() {
        switch (this.field_70146_Z.nextInt(100)) {
            case 0: {
                this.setHidingBlock((Block)Blocks.field_150486_ae, this.field_70146_Z.nextInt(4) + 2);
                return;
            }
            case 1: {
                this.setHidingBlock(Blocks.field_150364_r, 0);
                return;
            }
            case 2: {
                this.setHidingBlock(Blocks.field_150360_v, 0);
                return;
            }
            case 3: {
                this.setHidingBlock((Block)Blocks.field_150330_I, 0);
                return;
            }
            case 4: {
                this.setHidingBlock((Block)Blocks.field_150362_t, 0);
                return;
            }
        }
        int x = (int)Math.floor(this.field_70165_t);
        int y = (int)Math.floor(this.field_70163_u) - 1;
        int z = (int)Math.floor(this.field_70161_v);
        Block hidingBlock = this.field_70170_p.func_147439_a(x, y, z);
        if (hidingBlock != Blocks.field_150350_a) {
            if (hidingBlock == Blocks.field_150348_b) {
                switch (this.field_70146_Z.nextInt(32)) {
                    case 0: {
                        this.setHidingBlock(hidingBlock, 0);
                        return;
                    }
                    case 1: {
                        this.setHidingBlock(Blocks.field_150351_n, 0);
                        return;
                    }
                    case 2: {
                        this.setHidingBlock(Blocks.field_150365_q, 0);
                        return;
                    }
                    case 3: {
                        this.setHidingBlock(Blocks.field_150366_p, 0);
                        return;
                    }
                    case 4: {
                        this.setHidingBlock(Blocks.field_150369_x, 0);
                        return;
                    }
                    case 5: {
                        this.setHidingBlock(Blocks.field_150352_o, 0);
                        return;
                    }
                    case 6: {
                        this.setHidingBlock(Blocks.field_150450_ax, 0);
                        return;
                    }
                    case 7: {
                        this.setHidingBlock(Blocks.field_150482_ag, 0);
                        return;
                    }
                    case 8: {
                        this.setHidingBlock(Blocks.field_150412_bA, 0);
                        return;
                    }
                }
            } else if (hidingBlock == Blocks.field_150349_c) {
                switch (this.field_70146_Z.nextInt(10)) {
                    case 0: {
                        this.setHidingBlock(hidingBlock, 0);
                        return;
                    }
                    case 1: {
                        this.setHidingBlock(Blocks.field_150364_r, this.field_70146_Z.nextInt(4));
                        return;
                    }
                    case 2: {
                        this.setHidingBlock(Blocks.field_150423_aK, this.field_70146_Z.nextInt(4));
                        return;
                    }
                    case 3: {
                        this.setHidingBlock(Blocks.field_150440_ba, 0);
                        return;
                    }
                    case 4: {
                        this.setHidingBlock((Block)Blocks.field_150329_H, this.field_70146_Z.nextInt(2) + 1);
                        return;
                    }
                    case 5: {
                        this.setHidingBlock((Block)Blocks.field_150362_t, this.field_70146_Z.nextInt(4));
                        return;
                    }
                }
            } else if (hidingBlock == Blocks.field_150354_m) {
                switch (this.field_70146_Z.nextInt(6)) {
                    case 0: {
                        this.setHidingBlock(hidingBlock, 0);
                        return;
                    }
                    case 1: {
                        this.setHidingBlock(Blocks.field_150434_aF, 0);
                        return;
                    }
                    case 2: {
                        this.setHidingBlock((Block)Blocks.field_150330_I, 0);
                        return;
                    }
                }
            }
        }
        int i = 16;
        while (i-- > 0) {
            x = (int)Math.floor(this.field_70165_t) + this.field_70146_Z.nextInt(17) - 8;
            y = (int)Math.floor(this.field_70163_u) + this.field_70146_Z.nextInt(4) - 2;
            z = (int)Math.floor(this.field_70161_v) + this.field_70146_Z.nextInt(17) - 8;
            hidingBlock = this.field_70170_p.func_147439_a(x, y, z);
            int hidingData = this.field_70170_p.func_72805_g(x, y, z);
            if (hidingBlock == Blocks.field_150350_a || hidingBlock instanceof BlockLiquid) continue;
            this.setHidingBlock(hidingBlock, hidingData);
            return;
        }
        this.setHidingBlock(Blocks.field_150364_r, 0);
    }
}

