/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.worldgen;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import mods.railcraft.common.plugins.forge.OreDictPlugin;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fluids.IFluidBlock;

public class WorldGenQuarry
extends WorldGenerator {
    private static final int DISTANCE_OUTER_SQ = 64;
    private final Block blockStone;
    private final int meta;
    public final Set<Block> replaceable = new HashSet<Block>();

    public WorldGenQuarry(Block block, int meta) {
        this.blockStone = block;
        this.meta = meta;
        this.replaceable.add(Blocks.field_150365_q);
        this.replaceable.add(Blocks.field_150366_p);
        this.replaceable.add(Blocks.field_150352_o);
        this.replaceable.add(Blocks.field_150482_ag);
        this.replaceable.add(Blocks.field_150412_bA);
        this.replaceable.add(Blocks.field_150369_x);
        this.replaceable.add(Blocks.field_150449_bY);
        this.replaceable.add(Blocks.field_150450_ax);
        this.replaceable.add(Blocks.field_150439_ay);
        this.replaceable.add(Blocks.field_150346_d);
        this.replaceable.add(Blocks.field_150351_n);
        this.replaceable.add((Block)Blocks.field_150349_c);
        this.replaceable.add(Blocks.field_150435_aG);
        this.replaceable.addAll(OreDictPlugin.getOreBlocks());
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        int distSq;
        int j;
        int k;
        int i;
        boolean clearTop = true;
        for (i = -8; i < 8; ++i) {
            block1: for (k = -8; k < 8; ++k) {
                for (j = 1; j < 4 && j + y < world.func_72940_L() - 1; ++j) {
                    distSq = i * i + k * k;
                    if (distSq > 64 || !this.isLiquid(world, x + i, y + j, z + k)) continue;
                    clearTop = false;
                    continue block1;
                }
            }
        }
        if (clearTop) {
            for (i = -8; i < 8; ++i) {
                for (k = -8; k < 8; ++k) {
                    for (j = 1; j < 4 && j + y < world.func_72940_L() - 1 && ((distSq = i * i + k * k) > 64 || this.placeAir(world, rand, x + i, y + j, z + k)); ++j) {
                    }
                }
            }
        }
        for (i = -8; i < 8; ++i) {
            for (k = -8; k < 8; ++k) {
                for (j = -8; j < 1 && j + y < world.func_72940_L() - 1; ++j) {
                    distSq = i * i + k * k + j * j;
                    if (distSq > 64) continue;
                    this.placeStone(world, rand, x + i, y + j, z + k);
                }
            }
        }
        return true;
    }

    private boolean isLiquid(World world, int x, int y, int z) {
        Block block = WorldPlugin.getBlock((IBlockAccess)world, x, y, z);
        return block instanceof BlockLiquid || block instanceof IFluidBlock;
    }

    private boolean placeAir(World world, Random rand, int x, int y, int z) {
        if (WorldPlugin.getBlock((IBlockAccess)world, x, y + 1, z) != Blocks.field_150350_a) {
            return false;
        }
        if (this.isLiquid(world, x, y, z)) {
            return false;
        }
        if (WorldPlugin.getBlock((IBlockAccess)world, x + 1, y + 1, z) != Blocks.field_150350_a) {
            return false;
        }
        if (WorldPlugin.getBlock((IBlockAccess)world, x - 1, y + 1, z) != Blocks.field_150350_a) {
            return false;
        }
        if (WorldPlugin.getBlock((IBlockAccess)world, x, y + 1, z + 1) != Blocks.field_150350_a) {
            return false;
        }
        if (WorldPlugin.getBlock((IBlockAccess)world, x, y + 1, z - 1) != Blocks.field_150350_a) {
            return false;
        }
        world.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 2);
        return true;
    }

    private void placeStone(World world, Random rand, int x, int y, int z) {
        if (WorldPlugin.getBlock((IBlockAccess)world, x, y + 1, z) == Blocks.field_150329_H) {
            world.func_147465_d(x, y + 1, z, Blocks.field_150350_a, 0, 2);
        }
        if (this.isReplaceable(world, x, y, z)) {
            world.func_147465_d(x, y, z, this.blockStone, this.meta, 2);
        }
    }

    private boolean isReplaceable(World world, int x, int y, int z) {
        Block existing = WorldPlugin.getBlock((IBlockAccess)world, x, y, z);
        if (existing == null) {
            return false;
        }
        if (existing.isReplaceableOreGen(world, x, y, z, Blocks.field_150348_b)) {
            return true;
        }
        return this.replaceable.contains(existing);
    }
}

