/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.detector;

import java.util.List;
import mods.railcraft.common.blocks.detector.BlockDetector;
import mods.railcraft.common.blocks.detector.EnumDetector;
import mods.railcraft.common.blocks.detector.TileDetector;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.plugins.forge.LocalizationPlugin;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemDetector
extends ItemBlock {
    private final BlockDetector blockDetector;

    public ItemDetector(Block block) {
        super(block);
        this.blockDetector = (BlockDetector)block;
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.func_77655_b("railcraft.detector");
    }

    public IIcon func_77617_a(int meta) {
        return BlockDetector.getBlock().func_149691_a(2, meta);
    }

    public String func_77667_c(ItemStack stack) {
        return EnumDetector.fromOrdinal(stack.func_77960_j()).getTag();
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        if (!world.func_147465_d(x, y, z, (Block)this.blockDetector, metadata, 3)) {
            return false;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileDetector) {
            ((TileDetector)tile).setDetector(EnumDetector.fromOrdinal(stack.func_77960_j()));
        }
        if (world.func_147439_a(x, y, z) == this.blockDetector) {
            this.blockDetector.func_149689_a(world, x, y, z, (EntityLivingBase)player, stack);
            this.blockDetector.func_149714_e(world, x, y, z, metadata);
        }
        return true;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List info, boolean adv) {
        if (RailcraftConfig.cannotMobsSpawnOnMechanism) {
            info.add(LocalizationPlugin.translate("item.nomobspawnsonthisblock.tip"));
        }
    }
}

