/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui;

import mods.railcraft.api.signals.SignalAspect;
import mods.railcraft.client.gui.GuiContainerRailcraft;
import mods.railcraft.client.gui.GuiTools;
import mods.railcraft.client.gui.buttons.GuiMultiButton;
import mods.railcraft.client.gui.buttons.GuiToggleButton;
import mods.railcraft.common.blocks.signals.IAspectActionManager;
import mods.railcraft.common.gui.buttons.LockButtonState;
import mods.railcraft.common.gui.containers.ContainerAspectAction;
import mods.railcraft.common.gui.tooltips.ToolTip;
import mods.railcraft.common.plugins.forge.LocalizationPlugin;
import mods.railcraft.common.util.network.IGuiReturnHandler;
import mods.railcraft.common.util.network.PacketDispatcher;
import mods.railcraft.common.util.network.PacketGuiReturn;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;

public class GuiAspectAction
extends GuiContainerRailcraft {
    private final IAspectActionManager actionManager;
    private final String title;
    private final EntityPlayer player;
    private final boolean[] aspects = new boolean[SignalAspect.values().length];
    private GuiMultiButton lockButton;
    private boolean changed;
    private ToolTip lockedToolTips;
    private ToolTip unlockedToolTips;
    private ToolTip notownedToolTips;
    public String ownerName = "[Unknown]";

    public GuiAspectAction(EntityPlayer player, IAspectActionManager actionManager, String title) {
        this(player, actionManager, title, "railcraft:textures/gui/gui_basic.png");
        this.field_147000_g = 88;
    }

    protected GuiAspectAction(EntityPlayer player, IAspectActionManager actionManager, String title, String texture) {
        super(new ContainerAspectAction(player, actionManager), texture);
        this.player = player;
        this.actionManager = actionManager;
        this.title = title;
        for (SignalAspect aspect : SignalAspect.values()) {
            this.aspects[aspect.ordinal()] = actionManager.doesActionOnAspect(aspect);
        }
        this.lockedToolTips = ToolTip.buildToolTip("railcraft.gui.tip.button.lock.locked", "{owner}=" + this.ownerName);
        this.unlockedToolTips = ToolTip.buildToolTip("railcraft.gui.tip.button.lock.unlocked", "{owner}=" + this.ownerName);
        this.notownedToolTips = ToolTip.buildToolTip("railcraft.gui.tip.button.lock.notowner", "{owner}=" + this.ownerName);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.actionManager == null) {
            return;
        }
        this.field_146292_n.clear();
        int w = (this.field_146294_l - this.field_146999_f) / 2;
        int h = (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146292_n.add(new GuiToggleButton(0, w + 7, h + 30, 50, LocalizationPlugin.translate(SignalAspect.GREEN.getLocalizationTag()), this.aspects[SignalAspect.GREEN.ordinal()]));
        this.field_146292_n.add(new GuiToggleButton(1, w + 12, h + 55, 70, LocalizationPlugin.translate(SignalAspect.BLINK_YELLOW.getLocalizationTag()), this.aspects[SignalAspect.BLINK_YELLOW.ordinal()]));
        this.field_146292_n.add(new GuiToggleButton(2, w + 63, h + 30, 50, LocalizationPlugin.translate(SignalAspect.YELLOW.getLocalizationTag()), this.aspects[SignalAspect.YELLOW.ordinal()]));
        this.field_146292_n.add(new GuiToggleButton(3, w + 94, h + 55, 70, LocalizationPlugin.translate(SignalAspect.BLINK_RED.getLocalizationTag()), this.aspects[SignalAspect.BLINK_RED.ordinal()]));
        this.field_146292_n.add(new GuiToggleButton(4, w + 119, h + 30, 50, LocalizationPlugin.translate(SignalAspect.RED.getLocalizationTag()), this.aspects[SignalAspect.RED.ordinal()]));
        this.lockButton = new GuiMultiButton(5, w + 152, h + 8, 16, this.actionManager.getLockController());
        this.field_146292_n.add(this.lockButton);
        this.lockButton.field_146124_l = false;
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        GuiTools.drawCenteredString(this.field_146289_q, this.title, 15);
    }

    protected final void func_146284_a(GuiButton button) {
        if (this.actionManager == null) {
            return;
        }
        if (!button.field_146124_l) {
            return;
        }
        if (!this.canChange()) {
            return;
        }
        this.markChanged();
        this.onButtonPressed(button);
    }

    protected void onButtonPressed(GuiButton button) {
        if (button.field_146127_k <= 4) {
            SignalAspect aspect = SignalAspect.VALUES[button.field_146127_k];
            this.aspects[aspect.ordinal()] = !this.aspects[aspect.ordinal()];
            ((GuiToggleButton)button).active = this.aspects[aspect.ordinal()];
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.lockButton.field_146124_l = ((ContainerAspectAction)this.container).canLock;
        this.lockButton.setToolTip(this.actionManager.getLockController().getButtonState() == LockButtonState.LOCKED ? this.lockedToolTips : (this.lockButton.field_146124_l ? this.unlockedToolTips : this.notownedToolTips));
        String username = ((ContainerAspectAction)this.container).ownerName;
        if (username != null && !username.equals(this.ownerName)) {
            this.ownerName = username;
            this.lockedToolTips = ToolTip.buildToolTip("railcraft.gui.tip.button.lock.locked", "{owner}=" + username);
            this.unlockedToolTips = ToolTip.buildToolTip("railcraft.gui.tip.button.lock.unlocked", "{owner}=" + username);
            this.notownedToolTips = ToolTip.buildToolTip("railcraft.gui.tip.button.lock.notowner", "{owner}=" + username);
        }
    }

    public void func_146281_b() {
        if (this.changed && this.actionManager instanceof IGuiReturnHandler && this.canChange()) {
            this.prepareForPacket();
            PacketGuiReturn pkt = new PacketGuiReturn((IGuiReturnHandler)((Object)this.actionManager));
            PacketDispatcher.sendToServer(pkt);
        }
    }

    protected void prepareForPacket() {
        for (SignalAspect aspect : SignalAspect.VALUES) {
            this.actionManager.doActionOnAspect(aspect, this.aspects[aspect.ordinal()]);
        }
    }

    public void markChanged() {
        this.changed = true;
    }

    public boolean canChange() {
        return this.actionManager.getLockController().getButtonState() == LockButtonState.UNLOCKED || ((ContainerAspectAction)this.container).canLock;
    }
}

