/*
 * Decompiled with CFR 0.152.
 */
package io.nettyopis.handler.codec.base64;

import io.nettyopis.buffer.ByteBuf;
import io.nettyopis.channel.ChannelHandler;
import io.nettyopis.channel.ChannelHandlerContext;
import io.nettyopis.handler.codec.MessageToMessageDecoder;
import io.nettyopis.handler.codec.base64.Base64;
import io.nettyopis.handler.codec.base64.Base64Dialect;
import java.util.List;

@ChannelHandler.Sharable
public class Base64Decoder
extends MessageToMessageDecoder<ByteBuf> {
    private final Base64Dialect dialect;

    public Base64Decoder() {
        this(Base64Dialect.STANDARD);
    }

    public Base64Decoder(Base64Dialect dialect) {
        if (dialect == null) {
            throw new NullPointerException("dialect");
        }
        this.dialect = dialect;
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf msg, List<Object> out) throws Exception {
        out.add(Base64.decode(msg, msg.readerIndex(), msg.readableBytes(), this.dialect));
    }
}

