/*
 * Decompiled with CFR 0.152.
 */
package openmodularturrets.util;

import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityAmbientCreature;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import openmodularturrets.compatability.ModCompatibility;
import openmodularturrets.handler.ConfigHandler;
import openmodularturrets.items.addons.ConcealerAddonItem;
import openmodularturrets.items.addons.DamageAmpAddonItem;
import openmodularturrets.items.addons.PotentiaAddonItem;
import openmodularturrets.items.addons.RecyclerAddonItem;
import openmodularturrets.items.addons.RedstoneReactorAddonItem;
import openmodularturrets.items.addons.SerialPortAddonItem;
import openmodularturrets.items.addons.SolarPanelAddonItem;
import openmodularturrets.items.upgrades.AccuracyUpgradeItem;
import openmodularturrets.items.upgrades.EfficiencyUpgradeItem;
import openmodularturrets.items.upgrades.FireRateUpgradeItem;
import openmodularturrets.items.upgrades.RangeUpgradeItem;
import openmodularturrets.items.upgrades.ScattershotUpgradeItem;
import openmodularturrets.tileentity.expander.AbstractInvExpander;
import openmodularturrets.tileentity.expander.AbstractPowerExpander;
import openmodularturrets.tileentity.turretbase.TrustedPlayer;
import openmodularturrets.tileentity.turretbase.TurretBase;
import openmodularturrets.tileentity.turretbase.TurretBaseTierOneTileEntity;
import openmodularturrets.tileentity.turrets.TurretHead;
import openmodularturrets.util.PlayerUtil;

public class TurretHeadUtil {
    private static final HashSet<EntityPlayerMP> warnedPlayers = new HashSet();

    public static void warnPlayers(TurretBase base, World worldObj, int downLowAmount, int xCoord, int yCoord, int zCoord, int turretRange) {
        if (base.isAttacksPlayers()) {
            int warnDistance = ConfigHandler.getTurretWarningDistance();
            AxisAlignedBB axis = AxisAlignedBB.func_72330_a((double)(xCoord - turretRange - warnDistance), (double)(yCoord - downLowAmount - warnDistance), (double)(zCoord - turretRange - warnDistance), (double)(xCoord + turretRange + warnDistance), (double)(yCoord + turretRange + warnDistance), (double)(zCoord + turretRange + warnDistance));
            if (worldObj.func_72820_D() % 2000L == 0L) {
                warnedPlayers.clear();
            }
            List targets = worldObj.func_72872_a(EntityPlayerMP.class, axis);
            for (EntityPlayerMP target : targets) {
                if (target.func_110124_au().toString().equals(base.getOwner()) || TurretHeadUtil.isTrustedPlayer(target.func_110124_au(), base) || warnedPlayers.contains(target) || target.field_71075_bZ.field_75098_d) continue;
                TurretHeadUtil.dispatchWarnMessage(target, worldObj);
                warnedPlayers.add(target);
            }
        }
    }

    private static void dispatchWarnMessage(EntityPlayerMP player, World worldObj) {
        if (ConfigHandler.turretAlarmSound) {
            worldObj.func_72908_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, "openmodularturrets:warning", 1.0f, 1.0f);
        }
        if (ConfigHandler.turretWarnMessage) {
            player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.DARK_RED + StatCollector.func_74838_a((String)"status.warning")));
        }
    }

    public static Entity getTarget(TurretBase base, World worldObj, int downLowAmount, int xCoord, int yCoord, int zCoord, int turretRange, TurretHead turret) {
        EntityLivingBase target = null;
        if (!worldObj.field_72995_K && base != null && base.getOwner() != null) {
            AxisAlignedBB axis = AxisAlignedBB.func_72330_a((double)(xCoord - turretRange), (double)(yCoord - downLowAmount), (double)(zCoord - turretRange), (double)(xCoord + turretRange), (double)(yCoord + turretRange), (double)(zCoord + turretRange));
            List targets = worldObj.func_72872_a(EntityLivingBase.class, axis);
            for (EntityLivingBase target1 : targets) {
                EntityLivingBase targetELB;
                EntityPlayerMP entity;
                if (base.isAttacksNeutrals() && ConfigHandler.globalCanTargetNeutrals && target1 instanceof EntityAnimal && !target1.field_70128_L) {
                    target = target1;
                }
                if (base.isAttacksNeutrals() && ConfigHandler.globalCanTargetNeutrals && target1 instanceof EntityAmbientCreature && !target1.field_70128_L) {
                    target = target1;
                }
                if (base.isAttacksMobs() && ConfigHandler.globalCanTargetMobs && target1.isCreatureType(EnumCreatureType.monster, false) && !target1.field_70128_L) {
                    target = target1;
                }
                if (base.isAttacksPlayers() && ConfigHandler.globalCanTargetPlayers && target1 instanceof EntityPlayerMP && !target1.field_70128_L && !PlayerUtil.isPlayerOwner((EntityPlayer)(entity = (EntityPlayerMP)target1), base) && !TurretHeadUtil.isTrustedPlayer(entity.func_110124_au(), base) && !entity.field_71075_bZ.field_75098_d) {
                    target = target1;
                }
                if (target == null || turret == null || base.isMultiTargeting() && TurretHeadUtil.isTargetAlreadyTargeted(base, (Entity)target) || !TurretHeadUtil.canTurretSeeTarget(turret, targetELB = target) || !(targetELB.func_110143_aJ() > 0.0f)) continue;
                return target;
            }
        }
        return null;
    }

    public static Entity getTargetWithMinimumRange(TurretBase base, World worldObj, int downLowAmount, int xCoord, int yCoord, int zCoord, int turretRange, TurretHead turret) {
        EntityLivingBase target = null;
        if (!worldObj.field_72995_K && base != null && base.getOwner() != null) {
            AxisAlignedBB axis = AxisAlignedBB.func_72330_a((double)(xCoord - turretRange), (double)(yCoord - downLowAmount), (double)(zCoord - turretRange), (double)(xCoord + turretRange), (double)(yCoord + turretRange), (double)(zCoord + turretRange));
            List targets = worldObj.func_72872_a(EntityLivingBase.class, axis);
            for (EntityLivingBase target1 : targets) {
                EntityLivingBase targetELB;
                EntityPlayerMP entity;
                if (base.isAttacksNeutrals() && ConfigHandler.globalCanTargetNeutrals && target1 instanceof EntityAnimal && !target1.field_70128_L && target1.func_70011_f((double)xCoord, (double)yCoord, (double)zCoord) >= 3.0) {
                    target = target1;
                }
                if (base.isAttacksNeutrals() && ConfigHandler.globalCanTargetNeutrals && target1 instanceof EntityAmbientCreature && !target1.field_70128_L && target1.func_70011_f((double)xCoord, (double)yCoord, (double)zCoord) >= 3.0) {
                    target = target1;
                }
                if (base.isAttacksMobs() && ConfigHandler.globalCanTargetMobs && target1 instanceof IMob && !target1.field_70128_L && target1.func_70011_f((double)xCoord, (double)yCoord, (double)zCoord) >= 3.0) {
                    target = target1;
                }
                if (base.isAttacksPlayers() && ConfigHandler.globalCanTargetPlayers && target1 instanceof EntityPlayerMP && !target1.field_70128_L && target1.func_70011_f((double)xCoord, (double)yCoord, (double)zCoord) >= 3.0 && !(entity = (EntityPlayerMP)target1).func_110124_au().toString().equals(base.getOwner()) && !TurretHeadUtil.isTrustedPlayer(entity.func_110124_au(), base) && !entity.field_71075_bZ.field_75098_d) {
                    target = target1;
                }
                if (target == null || turret == null || base.isMultiTargeting() && TurretHeadUtil.isTargetAlreadyTargeted(base, target) || !TurretHeadUtil.canTurretSeeTarget(turret, targetELB = (EntityLivingBase)target) || !(targetELB.func_110143_aJ() > 0.0f)) continue;
                return target;
            }
        }
        return null;
    }

    public static Entity getTargetWithoutSlowEffect(TurretBase base, World worldObj, int downLowAmount, int xCoord, int yCoord, int zCoord, int turretRange, TurretHead turret) {
        EntityLivingBase target = null;
        if (!worldObj.field_72995_K && base != null && base.getOwner() != null) {
            AxisAlignedBB axis = AxisAlignedBB.func_72330_a((double)(xCoord - turretRange), (double)(yCoord - downLowAmount), (double)(zCoord - turretRange), (double)(xCoord + turretRange), (double)(yCoord + turretRange), (double)(zCoord + turretRange));
            List targets = worldObj.func_72872_a(EntityLivingBase.class, axis);
            for (EntityLivingBase target1 : targets) {
                EntityPlayerMP entity;
                if (base.isAttacksNeutrals() && ConfigHandler.globalCanTargetNeutrals && target1 instanceof EntityAnimal && !target1.field_70128_L && !target1.func_82165_m(Potion.field_76421_d.field_76415_H)) {
                    target = target1;
                }
                if (base.isAttacksNeutrals() && ConfigHandler.globalCanTargetNeutrals && target1 instanceof EntityAmbientCreature && !target1.field_70128_L && !target1.func_82165_m(Potion.field_76421_d.field_76415_H)) {
                    target = target1;
                }
                if (base.isAttacksMobs() && ConfigHandler.globalCanTargetMobs && target1 instanceof IMob && !target1.field_70128_L && !target1.func_82165_m(Potion.field_76421_d.field_76415_H)) {
                    target = target1;
                }
                if (base.isAttacksPlayers() && ConfigHandler.globalCanTargetPlayers && target1 instanceof EntityPlayerMP && !target1.field_70128_L && !target1.func_82165_m(Potion.field_76421_d.field_76415_H) && !(entity = (EntityPlayerMP)target1).func_110124_au().toString().equals(base.getOwner()) && !TurretHeadUtil.isTrustedPlayer(entity.func_110124_au(), base) && !entity.field_71075_bZ.field_75098_d) {
                    target = target1;
                }
                if (target == null || turret == null) continue;
                EntityLivingBase targetELB = target;
                if (base.isMultiTargeting() && TurretHeadUtil.isTargetAlreadyTargeted(base, (Entity)target) || !TurretHeadUtil.canTurretSeeTarget(turret, targetELB) || !(targetELB.func_110143_aJ() > 0.0f)) continue;
                return target;
            }
        }
        return null;
    }

    private static boolean isTargetAlreadyTargeted(TurretBase base, Entity entity) {
        TurretHead turret;
        if (base.func_145831_w().func_147438_o(base.field_145851_c + 1, base.field_145848_d, base.field_145849_e) instanceof TurretHead) {
            turret = (TurretHead)base.func_145831_w().func_147438_o(base.field_145851_c + 1, base.field_145848_d, base.field_145849_e);
            if (turret.target != null && entity.equals((Object)turret.target)) {
                return true;
            }
        }
        if (base.func_145831_w().func_147438_o(base.field_145851_c - 1, base.field_145848_d, base.field_145849_e) instanceof TurretHead) {
            turret = (TurretHead)base.func_145831_w().func_147438_o(base.field_145851_c - 1, base.field_145848_d, base.field_145849_e);
            if (turret.target != null && entity.equals((Object)turret.target)) {
                return true;
            }
        }
        if (base.func_145831_w().func_147438_o(base.field_145851_c, base.field_145848_d + 1, base.field_145849_e) instanceof TurretHead) {
            turret = (TurretHead)base.func_145831_w().func_147438_o(base.field_145851_c, base.field_145848_d + 1, base.field_145849_e);
            if (turret.target != null && entity.equals((Object)turret.target)) {
                return true;
            }
        }
        if (base.func_145831_w().func_147438_o(base.field_145851_c, base.field_145848_d - 1, base.field_145849_e) instanceof TurretHead) {
            turret = (TurretHead)base.func_145831_w().func_147438_o(base.field_145851_c, base.field_145848_d - 1, base.field_145849_e);
            if (turret.target != null && entity.equals((Object)turret.target)) {
                return true;
            }
        }
        if (base.func_145831_w().func_147438_o(base.field_145851_c, base.field_145848_d, base.field_145849_e + 1) instanceof TurretHead) {
            turret = (TurretHead)base.func_145831_w().func_147438_o(base.field_145851_c, base.field_145848_d, base.field_145849_e + 1);
            if (turret.target != null && entity.equals((Object)turret.target)) {
                return true;
            }
        }
        if (base.func_145831_w().func_147438_o(base.field_145851_c, base.field_145848_d, base.field_145849_e - 1) instanceof TurretHead) {
            turret = (TurretHead)base.func_145831_w().func_147438_o(base.field_145851_c, base.field_145848_d, base.field_145849_e - 1);
            if (turret.target != null && entity.equals((Object)turret.target)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isTrustedPlayer(UUID uuid, TurretBase base) {
        for (TrustedPlayer trusted_player : base.getTrustedPlayers()) {
            if (!trusted_player.uuid.equals(uuid)) continue;
            return true;
        }
        return false;
    }

    public static int getPowerExpanderTotalExtraCapacity(World world, int x, int y, int z) {
        int totalExtraCap = 0;
        if (world.func_147438_o(x + 1, y, z) instanceof AbstractPowerExpander) {
            totalExtraCap += TurretHeadUtil.getPowerExtenderCapacityValue((AbstractPowerExpander)world.func_147438_o(x + 1, y, z));
        }
        if (world.func_147438_o(x - 1, y, z) instanceof AbstractPowerExpander) {
            totalExtraCap += TurretHeadUtil.getPowerExtenderCapacityValue((AbstractPowerExpander)world.func_147438_o(x - 1, y, z));
        }
        if (world.func_147438_o(x, y + 1, z) instanceof AbstractPowerExpander) {
            totalExtraCap += TurretHeadUtil.getPowerExtenderCapacityValue((AbstractPowerExpander)world.func_147438_o(x, y + 1, z));
        }
        if (world.func_147438_o(x, y - 1, z) instanceof AbstractPowerExpander) {
            totalExtraCap += TurretHeadUtil.getPowerExtenderCapacityValue((AbstractPowerExpander)world.func_147438_o(x, y - 1, z));
        }
        if (world.func_147438_o(x, y, z + 1) instanceof AbstractPowerExpander) {
            totalExtraCap += TurretHeadUtil.getPowerExtenderCapacityValue((AbstractPowerExpander)world.func_147438_o(x, y, z + 1));
        }
        if (world.func_147438_o(x, y, z - 1) instanceof AbstractPowerExpander) {
            totalExtraCap += TurretHeadUtil.getPowerExtenderCapacityValue((AbstractPowerExpander)world.func_147438_o(x, y, z - 1));
        }
        return totalExtraCap;
    }

    private static ItemStack deductFromInvExpander(ItemStack itemStack, AbstractInvExpander exp, TurretBase base) {
        for (int i = 0; i < exp.func_70302_i_(); ++i) {
            ItemStack ammoCheck = exp.func_70301_a(i);
            if (ammoCheck == null || ammoCheck.func_77973_b() != itemStack.func_77973_b()) continue;
            if (TurretHeadUtil.hasRecyclerAddon(base)) {
                int chance = new Random().nextInt(99);
                if (chance >= 0 && chance < ConfigHandler.getRecyclerNegateChance()) {
                    return new ItemStack(ammoCheck.func_77973_b());
                }
                if (chance > ConfigHandler.getRecyclerNegateChance() && chance < ConfigHandler.getRecyclerNegateChance() + ConfigHandler.getRecyclerAddChance()) {
                    exp.func_70298_a(i, -1);
                    return new ItemStack(ammoCheck.func_77973_b());
                }
                exp.func_70298_a(i, 1);
                return new ItemStack(ammoCheck.func_77973_b());
            }
            exp.func_70298_a(i, 1);
            return new ItemStack(ammoCheck.func_77973_b());
        }
        return null;
    }

    public static ItemStack getSpecificItemFromInvExpanders(World world, ItemStack itemStack, TurretBase base) {
        AbstractInvExpander exp;
        ItemStack stack;
        int x = base.field_145851_c;
        int y = base.field_145848_d;
        int z = base.field_145849_e;
        if (world.func_147438_o(x + 1, y, z) instanceof AbstractInvExpander && (stack = TurretHeadUtil.deductFromInvExpander(itemStack, exp = (AbstractInvExpander)world.func_147438_o(x + 1, y, z), base)) != null) {
            return stack;
        }
        if (world.func_147438_o(x - 1, y, z) instanceof AbstractInvExpander && (stack = TurretHeadUtil.deductFromInvExpander(itemStack, exp = (AbstractInvExpander)world.func_147438_o(x - 1, y, z), base)) != null) {
            return stack;
        }
        if (world.func_147438_o(x, y + 1, z) instanceof AbstractInvExpander && (stack = TurretHeadUtil.deductFromInvExpander(itemStack, exp = (AbstractInvExpander)world.func_147438_o(x, y + 1, z), base)) != null) {
            return stack;
        }
        if (world.func_147438_o(x, y - 1, z) instanceof AbstractInvExpander && (stack = TurretHeadUtil.deductFromInvExpander(itemStack, exp = (AbstractInvExpander)world.func_147438_o(x, y - 1, z), base)) != null) {
            return stack;
        }
        if (world.func_147438_o(x, y, z + 1) instanceof AbstractInvExpander && (stack = TurretHeadUtil.deductFromInvExpander(itemStack, exp = (AbstractInvExpander)world.func_147438_o(x, y, z + 1), base)) != null) {
            return stack;
        }
        if (world.func_147438_o(x, y, z - 1) instanceof AbstractInvExpander && (stack = TurretHeadUtil.deductFromInvExpander(itemStack, exp = (AbstractInvExpander)world.func_147438_o(x, y, z - 1), base)) != null) {
            return stack;
        }
        return null;
    }

    public static ItemStack getAnyItemFromInvExpanders(World world, TurretBase base) {
        ItemStack itemCheck;
        int i;
        AbstractInvExpander exp;
        int x = base.field_145851_c;
        int y = base.field_145848_d;
        int z = base.field_145849_e;
        if (world.func_147438_o(x + 1, y, z) instanceof AbstractInvExpander) {
            exp = (AbstractInvExpander)world.func_147438_o(x + 1, y, z);
            for (i = 0; i < exp.func_70302_i_(); ++i) {
                itemCheck = exp.func_70301_a(i);
                if (itemCheck == null) continue;
                exp.func_70298_a(i, 1);
                return new ItemStack(itemCheck.func_77973_b());
            }
        }
        if (world.func_147438_o(x - 1, y, z) instanceof AbstractInvExpander) {
            exp = (AbstractInvExpander)world.func_147438_o(x - 1, y, z);
            for (i = 0; i < exp.func_70302_i_(); ++i) {
                itemCheck = exp.func_70301_a(i);
                if (itemCheck == null) continue;
                exp.func_70298_a(i, 1);
                return new ItemStack(itemCheck.func_77973_b());
            }
        }
        if (world.func_147438_o(x, y + 1, z) instanceof AbstractInvExpander) {
            exp = (AbstractInvExpander)world.func_147438_o(x, y + 1, z);
            for (i = 0; i < exp.func_70302_i_(); ++i) {
                itemCheck = exp.func_70301_a(i);
                if (itemCheck == null) continue;
                exp.func_70298_a(i, 1);
                return new ItemStack(itemCheck.func_77973_b());
            }
        }
        if (world.func_147438_o(x, y - 1, z) instanceof AbstractInvExpander) {
            exp = (AbstractInvExpander)world.func_147438_o(x, y - 1, z);
            for (i = 0; i < exp.func_70302_i_(); ++i) {
                itemCheck = exp.func_70301_a(i);
                if (itemCheck == null) continue;
                exp.func_70298_a(i, 1);
                return new ItemStack(itemCheck.func_77973_b());
            }
        }
        if (world.func_147438_o(x, y, z + 1) instanceof AbstractInvExpander) {
            exp = (AbstractInvExpander)world.func_147438_o(x, y, z + 1);
            for (i = 0; i < exp.func_70302_i_(); ++i) {
                itemCheck = exp.func_70301_a(i);
                if (itemCheck == null) continue;
                exp.func_70298_a(i, 1);
                return new ItemStack(itemCheck.func_77973_b());
            }
        }
        if (world.func_147438_o(x, y, z - 1) instanceof AbstractInvExpander) {
            exp = (AbstractInvExpander)world.func_147438_o(x, y, z - 1);
            for (i = 0; i < exp.func_70302_i_(); ++i) {
                itemCheck = exp.func_70301_a(i);
                if (itemCheck == null) continue;
                exp.func_70298_a(i, 1);
                return new ItemStack(itemCheck.func_77973_b());
            }
        }
        return null;
    }

    private static int getPowerExtenderCapacityValue(AbstractPowerExpander expander) {
        if (expander != null) {
            int tier = expander.getTier();
            switch (tier) {
                case 1: {
                    return ConfigHandler.getExpanderPowerTierOneCapacity();
                }
                case 2: {
                    return ConfigHandler.getExpanderPowerTierTwoCapacity();
                }
                case 3: {
                    return ConfigHandler.getExpanderPowerTierThreeCapacity();
                }
                case 4: {
                    return ConfigHandler.getExpanderPowerTierFourCapacity();
                }
                case 5: {
                    return ConfigHandler.getExpanderPowerTierFiveCapacity();
                }
            }
            return 0;
        }
        return 0;
    }

    public static TurretBase getTurretBase(World world, int x, int y, int z) {
        if (world == null) {
            return null;
        }
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            int offsetX = x + direction.offsetX;
            int offsetY = y + direction.offsetY;
            int offsetZ = z + direction.offsetZ;
            if (!(world.func_147438_o(offsetX, offsetY, offsetZ) instanceof TurretBase)) continue;
            return (TurretBase)world.func_147438_o(offsetX, offsetY, offsetZ);
        }
        return null;
    }

    public static float getAimYaw(Entity target, int xCoord, int zCoord) {
        double dX = target.field_70165_t - (double)xCoord;
        double dZ = target.field_70161_v - (double)zCoord;
        float yaw = (float)Math.atan2(dZ, dX);
        yaw = yaw - 1.570796f + 3.1f;
        return yaw;
    }

    public static float getAimPitch(Entity target, int xCoord, int yCoord, int zCoord) {
        double dX = target.field_70165_t - (double)0.2f - (double)((float)xCoord + 0.6f);
        double dY = target.field_70163_u + (double)0.6f - (double)((float)yCoord - 0.6f);
        double dZ = target.field_70161_v - (double)0.2f - (double)((float)zCoord + 0.6f);
        float pitch = (float)(Math.atan2(Math.sqrt(dZ * dZ + dX * dX), dY) + Math.PI);
        return pitch += 1.65f;
    }

    public static ItemStack useAnyItemStackFromBase(TurretBase base) {
        for (int i = 0; i <= 8; ++i) {
            ItemStack ammoCheck = base.func_70301_a(i);
            if (ammoCheck == null || ammoCheck.field_77994_a <= 0 || ammoCheck.func_77973_b() == null) continue;
            base.func_70298_a(i, 1);
            return new ItemStack(ammoCheck.func_77973_b());
        }
        return null;
    }

    public static ItemStack useSpecificItemStackBlockFromBase(TurretBase base, ItemStack stack) {
        for (int i = 0; i <= 8; ++i) {
            ItemStack ammo_stack = base.func_70301_a(i);
            if (ammo_stack == null || ammo_stack.field_77994_a <= 0 || ammo_stack.func_77973_b() != stack.func_77973_b()) continue;
            base.func_70298_a(i, 1);
            return new ItemStack(ammo_stack.func_77973_b());
        }
        return null;
    }

    public static ItemStack useSpecificItemStackItemFromBase(TurretBase base, Item item) {
        for (int i = 0; i <= 8; ++i) {
            ItemStack ammo_stack = base.func_70301_a(i);
            if (ammo_stack == null || ammo_stack.field_77994_a <= 0 || ammo_stack.func_77973_b() != item) continue;
            if (TurretHeadUtil.hasRecyclerAddon(base)) {
                int chance = new Random().nextInt(99);
                if (chance > 0 && chance < ConfigHandler.getRecyclerNegateChance()) {
                    return new ItemStack(ammo_stack.func_77973_b());
                }
                if (chance > ConfigHandler.getRecyclerNegateChance() && chance < ConfigHandler.getRecyclerNegateChance() + ConfigHandler.getRecyclerAddChance()) {
                    base.func_70298_a(i, -1);
                    return new ItemStack(ammo_stack.func_77973_b());
                }
                base.func_70298_a(i, 1);
                return new ItemStack(ammo_stack.func_77973_b());
            }
            base.func_70298_a(i, 1);
            return new ItemStack(ammo_stack.func_77973_b());
        }
        return null;
    }

    public static int getRangeUpgrades(TurretBase base) {
        int value = 0;
        int tier = base.getBaseTier();
        if (tier == 1) {
            return value;
        }
        if (tier == 5 && base.func_70301_a(12) != null && base.func_70301_a(12).func_77973_b() instanceof RangeUpgradeItem) {
            value += ConfigHandler.getRangeUpgradeBoost() * base.func_70301_a((int)12).field_77994_a;
        }
        if (base.func_70301_a(11) != null && base.func_70301_a(11).func_77973_b() instanceof RangeUpgradeItem) {
            value += ConfigHandler.getRangeUpgradeBoost() * base.func_70301_a((int)11).field_77994_a;
        }
        return value;
    }

    public static int getScattershotUpgrades(TurretBase base) {
        int value = 0;
        int tier = base.getBaseTier();
        if (tier == 1) {
            return value;
        }
        if (tier == 5 && base.func_70301_a(12) != null && base.func_70301_a(12).func_77973_b() instanceof ScattershotUpgradeItem) {
            value += ConfigHandler.getRangeUpgradeBoost() * base.func_70301_a((int)12).field_77994_a;
        }
        if (base.func_70301_a(11) != null && base.func_70301_a(11).func_77973_b() instanceof ScattershotUpgradeItem) {
            value += ConfigHandler.getRangeUpgradeBoost() * base.func_70301_a((int)11).field_77994_a;
        }
        return value;
    }

    public static float getAccuraccyUpgrades(TurretBase base) {
        float accuracy = 0.0f;
        int tier = base.getBaseTier();
        if (tier == 1) {
            return accuracy;
        }
        if (tier == 5 && base.func_70301_a(12) != null && base.func_70301_a(12).func_77973_b() instanceof AccuracyUpgradeItem) {
            accuracy = (float)((double)accuracy + ConfigHandler.getAccuracyUpgradeBoost() * (double)base.func_70301_a((int)12).field_77994_a);
        }
        if (base.func_70301_a(11) != null && base.func_70301_a(11).func_77973_b() instanceof AccuracyUpgradeItem) {
            accuracy = (float)((double)accuracy + ConfigHandler.getAccuracyUpgradeBoost() * (double)base.func_70301_a((int)11).field_77994_a);
        }
        return accuracy;
    }

    public static float getEfficiencyUpgrades(TurretBase base) {
        float efficiency = 0.0f;
        int tier = base.getBaseTier();
        if (tier == 1) {
            return efficiency;
        }
        if (tier == 5 && base.func_70301_a(12) != null && base.func_70301_a(12).func_77973_b() instanceof EfficiencyUpgradeItem) {
            efficiency = (float)((double)efficiency + ConfigHandler.getEfficiencyUpgradeBoostPercentage() * (double)base.func_70301_a((int)12).field_77994_a);
        }
        if (base.func_70301_a(11) != null && base.func_70301_a(11).func_77973_b() instanceof EfficiencyUpgradeItem) {
            efficiency = (float)((double)efficiency + ConfigHandler.getEfficiencyUpgradeBoostPercentage() * (double)base.func_70301_a((int)11).field_77994_a);
        }
        return efficiency;
    }

    public static float getFireRateUpgrades(TurretBase base) {
        float rof = 0.0f;
        int tier = base.getBaseTier();
        if (tier == 1) {
            return rof;
        }
        if (tier == 5 && base.func_70301_a(12) != null && base.func_70301_a(12).func_77973_b() instanceof FireRateUpgradeItem) {
            rof = (float)((double)rof + ConfigHandler.getFireRateUpgradeBoostPercentage() * (double)base.func_70301_a((int)12).field_77994_a);
        }
        if (base.func_70301_a(11) != null && base.func_70301_a(11).func_77973_b() instanceof FireRateUpgradeItem) {
            rof = (float)((double)rof + ConfigHandler.getFireRateUpgradeBoostPercentage() * (double)base.func_70301_a((int)11).field_77994_a);
        }
        return rof;
    }

    public static boolean hasRedstoneReactor(TurretBase base) {
        boolean found = false;
        if (base instanceof TurretBaseTierOneTileEntity) {
            return false;
        }
        if (base.func_70301_a(9) != null) {
            found = base.func_70301_a(9).func_77973_b() instanceof RedstoneReactorAddonItem;
        }
        if (base.func_70301_a(10) != null && !found) {
            found = base.func_70301_a(10).func_77973_b() instanceof RedstoneReactorAddonItem;
        }
        return found;
    }

    public static boolean hasDamageAmpAddon(TurretBase base) {
        boolean found = false;
        if (base instanceof TurretBaseTierOneTileEntity) {
            return false;
        }
        if (base.func_70301_a(9) != null) {
            found = base.func_70301_a(9).func_77973_b() instanceof DamageAmpAddonItem;
        }
        if (base.func_70301_a(10) != null && !found) {
            found = base.func_70301_a(10).func_77973_b() instanceof DamageAmpAddonItem;
        }
        return found;
    }

    public static boolean hasConcealmentAddon(TurretBase base) {
        boolean found = false;
        if (base instanceof TurretBaseTierOneTileEntity) {
            return false;
        }
        if (base.func_70301_a(9) != null) {
            found = base.func_70301_a(9).func_77973_b() instanceof ConcealerAddonItem;
        }
        if (base.func_70301_a(10) != null && !found) {
            found = base.func_70301_a(10).func_77973_b() instanceof ConcealerAddonItem;
        }
        return found;
    }

    public static boolean hasSolarPanelAddon(TurretBase base) {
        boolean found = false;
        if (base instanceof TurretBaseTierOneTileEntity) {
            return false;
        }
        if (base.func_70301_a(9) != null) {
            found = base.func_70301_a(9).func_77973_b() instanceof SolarPanelAddonItem;
        }
        if (base.func_70301_a(10) != null && !found) {
            found = base.func_70301_a(10).func_77973_b() instanceof SolarPanelAddonItem;
        }
        return found;
    }

    public static boolean hasPotentiaUpgradeAddon(TurretBase base) {
        boolean found = false;
        if (base instanceof TurretBaseTierOneTileEntity) {
            return false;
        }
        if (!ModCompatibility.ThaumcraftLoaded) {
            return false;
        }
        if (base.func_70301_a(9) != null) {
            found = base.func_70301_a(9).func_77973_b() instanceof PotentiaAddonItem;
        }
        if (base.func_70301_a(10) != null && !found) {
            found = base.func_70301_a(10).func_77973_b() instanceof PotentiaAddonItem;
        }
        return found;
    }

    public static boolean hasSerialPortAddon(TurretBase base) {
        boolean found = false;
        if (base instanceof TurretBaseTierOneTileEntity) {
            return false;
        }
        if (!ModCompatibility.OpenComputersLoaded && !ModCompatibility.ComputercraftLoaded) {
            return false;
        }
        if (base.func_70301_a(9) != null) {
            found = base.func_70301_a(9).func_77973_b() instanceof SerialPortAddonItem;
        }
        if (base.func_70301_a(10) != null && !found) {
            found = base.func_70301_a(10).func_77973_b() instanceof SerialPortAddonItem;
        }
        return found;
    }

    private static boolean hasRecyclerAddon(TurretBase base) {
        boolean found = false;
        if (base instanceof TurretBaseTierOneTileEntity) {
            return false;
        }
        if (base.func_70301_a(9) != null) {
            found = base.func_70301_a(9).func_77973_b() instanceof RecyclerAddonItem;
        }
        if (base.func_70301_a(10) != null && !found) {
            found = base.func_70301_a(10).func_77973_b() instanceof RecyclerAddonItem;
        }
        return found;
    }

    public static int getAmpLevel(TurretBase base) {
        int amp_level = 0;
        if (base == null) {
            return amp_level;
        }
        int tier = base.getBaseTier();
        if (tier == 1) {
            return amp_level;
        }
        if (base.func_70301_a(10) != null && base.func_70301_a(10).func_77973_b() instanceof DamageAmpAddonItem) {
            amp_level += base.func_70301_a((int)10).field_77994_a;
        }
        if (base.func_70301_a(9) != null && base.func_70301_a(9).func_77973_b() instanceof DamageAmpAddonItem) {
            amp_level += base.func_70301_a((int)9).field_77994_a;
        }
        return amp_level;
    }

    public static void updateSolarPanelAddon(TurretBase base) {
        if (!TurretHeadUtil.hasSolarPanelAddon(base)) {
            return;
        }
        if (base.func_145831_w().func_72935_r() && !base.func_145831_w().func_72896_J() && base.func_145831_w().func_72937_j(base.field_145851_c, base.field_145848_d + 2, base.field_145849_e)) {
            base.receiveEnergy(ForgeDirection.UNKNOWN, ConfigHandler.getSolarPanelAddonGen(), false);
        }
    }

    public static boolean canTurretSeeTarget(TurretHead turret, EntityLivingBase target) {
        Vec3 traceStart = Vec3.func_72443_a((double)((float)turret.field_145851_c + 0.5f), (double)((float)turret.field_145848_d + 0.5f), (double)((float)turret.field_145849_e + 0.5f));
        Vec3 traceEnd = Vec3.func_72443_a((double)target.field_70165_t, (double)(target.field_70163_u + (double)target.func_70047_e()), (double)target.field_70161_v);
        Vec3 vecDelta = Vec3.func_72443_a((double)(traceEnd.field_72450_a - traceStart.field_72450_a), (double)(traceEnd.field_72448_b - traceStart.field_72448_b), (double)(traceEnd.field_72449_c - traceStart.field_72449_c));
        double vecDeltaLength = MathHelper.func_76132_a((double)vecDelta.field_72450_a, (double)MathHelper.func_76132_a((double)vecDelta.field_72448_b, (double)vecDelta.field_72449_c));
        vecDelta.field_72450_a /= vecDeltaLength;
        vecDelta.field_72448_b /= vecDeltaLength;
        vecDelta.field_72449_c /= vecDeltaLength;
        for (int i = 0; i < 10; ++i) {
            Block hitBlock;
            traceStart.field_72450_a += vecDelta.field_72450_a;
            traceStart.field_72448_b += vecDelta.field_72448_b;
            traceStart.field_72449_c += vecDelta.field_72449_c;
            MovingObjectPosition traced = turret.func_145831_w().func_72933_a(Vec3.func_72443_a((double)traceStart.field_72450_a, (double)traceStart.field_72448_b, (double)traceStart.field_72449_c), Vec3.func_72443_a((double)traceEnd.field_72450_a, (double)traceEnd.field_72448_b, (double)traceEnd.field_72449_c));
            if (traced == null || traced.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK || (hitBlock = turret.func_145831_w().func_147439_a(traced.field_72311_b, traced.field_72312_c, traced.field_72309_d)) == null || hitBlock.func_149688_o().func_76220_a() || !(MathHelper.func_76132_a((double)MathHelper.func_76132_a((double)(traceStart.field_72450_a - traceEnd.field_72450_a), (double)(traceStart.field_72448_b - traceEnd.field_72448_b)), (double)(traceStart.field_72449_c - traceEnd.field_72449_c)) > 1.0)) {
                EntityLivingBase targeted = target != null && traced == null ? target : null;
                return targeted != null && targeted.equals((Object)target);
            }
            traceStart = traced.field_72307_f;
        }
        return false;
    }
}

