/*
 * Decompiled with CFR 0.152.
 */
package openmodularturrets.ucdefinitions;

import api.undercurrent.iface.UCCollection;
import api.undercurrent.iface.UCTileDefinition;
import api.undercurrent.iface.editorTypes.BooleanEditorType;
import api.undercurrent.iface.editorTypes.InfoEditorType;
import api.undercurrent.iface.editorTypes.IntegerEditorType;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.util.ForgeDirection;
import openmodularturrets.tileentity.turretbase.TurretBase;

public class TurretBaseUCDefinition
extends UCTileDefinition {
    public TurretBaseUCDefinition(TurretBase base) throws Exception {
        UCCollection info = new UCCollection("Turret Info");
        UCCollection ammo = new UCCollection("Turret Ammo");
        UCCollection targeting = new UCCollection("Targeting settings");
        UCCollection operations = new UCCollection("Base Operations");
        info.getEditableFields().add(new InfoEditorType("ownerName", "Owner Name", "This turret base's owner", base.getOwnerName()));
        info.getEditableFields().add(new InfoEditorType("storedEnergy", "Stored Energy", "Amount of power stored in this turret base", String.valueOf(base.getEnergyStored(ForgeDirection.UNKNOWN))));
        HashMap<String, Integer> totals = new HashMap<String, Integer>();
        for (int i = 0; i < base.func_70302_i_(); ++i) {
            if (base.func_70301_a(i) == null) continue;
            Integer totalSoFar = (Integer)totals.get(base.func_70301_a(i).func_82833_r());
            if (totalSoFar == null) {
                totals.put(base.func_70301_a(i).func_82833_r(), 0);
            }
            totals.put(base.func_70301_a(i).func_82833_r(), (Integer)totals.get(base.func_70301_a(i).func_82833_r()) + base.func_70301_a((int)i).field_77994_a);
        }
        for (Map.Entry entry : totals.entrySet()) {
            ammo.getEditableFields().add(new InfoEditorType((String)entry.getKey(), (String)entry.getKey(), "", String.valueOf(entry.getValue())));
        }
        targeting.getEditableFields().add(new BooleanEditorType("attacksMobs", "Attack Mobs", "If this turret base should target Mobs", base.isAttacksMobs()));
        targeting.getEditableFields().add(new BooleanEditorType("attacksNeutrals", "Attack Neutrals", "If this turret base should target Neutral Mobs", base.isAttacksNeutrals()));
        targeting.getEditableFields().add(new BooleanEditorType("attacksPlayers", "Attack Players", "If this turret base should target Players", base.isAttacksPlayers()));
        targeting.getEditableFields().add(new BooleanEditorType("multiTargeting", "Multi Targeting", "If this turret base should try to target multiple targets at once.", base.isMultiTargeting()));
        targeting.getEditableFields().add(new IntegerEditorType("yAxisDetect", base.getyAxisDetect(), "Y-Axis detect", "Amount of blocks below the base should serach for targets", 0, 9));
        operations.getEditableFields().add(new BooleanEditorType("active", "Active", "If this turret base is active", base.isActive()));
        this.getCollections().add(info);
        this.getCollections().add(ammo);
        this.getCollections().add(targeting);
        this.getCollections().add(operations);
    }
}

