/*
 * Decompiled with CFR 0.152.
 */
package openmods.structured;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Field;
import openmods.reflection.InstanceFieldAccess;
import openmods.reflection.TypeUtils;
import openmods.serializable.SerializerRegistry;
import openmods.structured.IStructureElement;
import openmods.utils.io.IStreamSerializer;

public class ElementField
extends InstanceFieldAccess<Object>
implements IStructureElement {
    public final IStreamSerializer<Object> serializer;

    public ElementField(Object parent, Field field) {
        super(parent, field);
        TypeToken<?> fieldType = TypeUtils.resolveFieldType(parent.getClass(), field);
        this.serializer = SerializerRegistry.instance.findSerializer(fieldType.getType());
        Preconditions.checkNotNull(this.serializer, (Object)"Invalid field type");
    }

    @Override
    public void writeToStream(DataOutput output) throws IOException {
        Object value = this.get();
        this.serializer.writeToStream(value, output);
    }

    @Override
    public void readFromStream(DataInput input) throws IOException {
        Object value = this.serializer.readFromStream(input);
        this.set(value);
    }
}

