/*
 * Decompiled with CFR 0.152.
 */
package openmods.gui.misc;

import com.google.common.collect.Maps;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;
import openmods.utils.render.ProjectionHelper;
import org.lwjgl.input.Mouse;

public class SidePicker {
    private static final ProjectionHelper projectionHelper = new ProjectionHelper();
    private final double negX;
    private final double negY;
    private final double negZ;
    private final double posX;
    private final double posY;
    private final double posZ;

    public SidePicker(double negX, double negY, double negZ, double posX, double posY, double posZ) {
        this.negX = negX;
        this.negY = negY;
        this.negZ = negZ;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
    }

    public SidePicker(double halfSize) {
        this.negY = this.negZ = -halfSize;
        this.negX = this.negZ;
        this.posY = this.posZ = halfSize;
        this.posX = this.posZ;
    }

    private static Vec3 getMouseVector(float z) {
        return projectionHelper.unproject(Mouse.getX(), Mouse.getY(), z);
    }

    private Vec3 calculateXPoint(Vec3 near, Vec3 diff, double x) {
        double p = (x - near.field_72450_a) / diff.field_72450_a;
        double y = near.field_72448_b + diff.field_72448_b * p;
        double z = near.field_72449_c + diff.field_72449_c * p;
        if (this.negY <= y && y <= this.posY && this.negZ <= z && z <= this.posZ) {
            return Vec3.func_72443_a((double)x, (double)y, (double)z);
        }
        return null;
    }

    private Vec3 calculateYPoint(Vec3 near, Vec3 diff, double y) {
        double p = (y - near.field_72448_b) / diff.field_72448_b;
        double x = near.field_72450_a + diff.field_72450_a * p;
        double z = near.field_72449_c + diff.field_72449_c * p;
        if (this.negX <= x && x <= this.posX && this.negZ <= z && z <= this.posZ) {
            return Vec3.func_72443_a((double)x, (double)y, (double)z);
        }
        return null;
    }

    private Vec3 calculateZPoint(Vec3 near, Vec3 diff, double z) {
        double p = (z - near.field_72449_c) / diff.field_72449_c;
        double x = near.field_72450_a + diff.field_72450_a * p;
        double y = near.field_72448_b + diff.field_72448_b * p;
        if (this.negX <= x && x <= this.posX && this.negY <= y && y <= this.posY) {
            return Vec3.func_72443_a((double)x, (double)y, (double)z);
        }
        return null;
    }

    private static void addPoint(Map<Side, Vec3> map, Side side, Vec3 value) {
        if (value != null) {
            map.put(side, value);
        }
    }

    private Map<Side, Vec3> calculateHitPoints(Vec3 near, Vec3 far) {
        Vec3 diff = far.func_72444_a(near);
        EnumMap result = Maps.newEnumMap(Side.class);
        SidePicker.addPoint(result, Side.XNeg, this.calculateXPoint(near, diff, this.negX));
        SidePicker.addPoint(result, Side.XPos, this.calculateXPoint(near, diff, this.posX));
        SidePicker.addPoint(result, Side.YNeg, this.calculateYPoint(near, diff, this.negY));
        SidePicker.addPoint(result, Side.YPos, this.calculateYPoint(near, diff, this.posY));
        SidePicker.addPoint(result, Side.ZNeg, this.calculateZPoint(near, diff, this.negZ));
        SidePicker.addPoint(result, Side.ZPos, this.calculateZPoint(near, diff, this.posZ));
        return result;
    }

    public Map<Side, Vec3> calculateMouseHits() {
        projectionHelper.updateMatrices();
        Vec3 near = SidePicker.getMouseVector(0.0f);
        Vec3 far = SidePicker.getMouseVector(1.0f);
        return this.calculateHitPoints(near, far);
    }

    public HitCoord getNearestHit() {
        projectionHelper.updateMatrices();
        Vec3 near = SidePicker.getMouseVector(0.0f);
        Vec3 far = SidePicker.getMouseVector(1.0f);
        Map<Side, Vec3> hits = this.calculateHitPoints(near, far);
        if (hits.isEmpty()) {
            return null;
        }
        Side minSide = null;
        double minDist = Double.MAX_VALUE;
        for (Map.Entry<Side, Vec3> e : hits.entrySet()) {
            double dist = e.getValue().func_72444_a(near).func_72433_c();
            if (!(dist < minDist)) continue;
            minDist = dist;
            minSide = e.getKey();
        }
        if (minSide == null) {
            return null;
        }
        return new HitCoord(minSide, hits.get((Object)minSide));
    }

    public static class HitCoord {
        public final Side side;
        public final Vec3 coord;

        public HitCoord(Side side, Vec3 coord) {
            this.side = side;
            this.coord = coord;
        }
    }

    public static enum Side {
        XNeg,
        XPos,
        YNeg,
        YPos,
        ZNeg,
        ZPos;


        public static Side fromForgeDirection(ForgeDirection dir) {
            switch (dir) {
                case WEST: {
                    return XNeg;
                }
                case EAST: {
                    return XPos;
                }
                case DOWN: {
                    return YNeg;
                }
                case UP: {
                    return YPos;
                }
                case NORTH: {
                    return ZNeg;
                }
                case SOUTH: {
                    return ZPos;
                }
            }
            return null;
        }

        public ForgeDirection toForgeDirection() {
            switch (this) {
                case XNeg: {
                    return ForgeDirection.WEST;
                }
                case XPos: {
                    return ForgeDirection.EAST;
                }
                case YNeg: {
                    return ForgeDirection.DOWN;
                }
                case YPos: {
                    return ForgeDirection.UP;
                }
                case ZNeg: {
                    return ForgeDirection.NORTH;
                }
                case ZPos: {
                    return ForgeDirection.SOUTH;
                }
            }
            return ForgeDirection.UNKNOWN;
        }
    }
}

