/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc.types.multi;

import gnu.trove.set.TCharSet;
import gnu.trove.set.hash.TCharHashSet;
import java.math.BigInteger;
import openmods.calc.Frame;
import openmods.calc.FrameFactory;
import openmods.calc.IValuePrinter;
import openmods.calc.PositionalNotationPrinter;
import openmods.calc.PrinterUtils;
import openmods.calc.parsing.StringEscaper;
import openmods.calc.types.bigint.BigIntPrinter;
import openmods.calc.types.fp.DoublePrinter;
import openmods.calc.types.multi.Cons;
import openmods.calc.types.multi.MetaObject;
import openmods.calc.types.multi.Symbol;
import openmods.calc.types.multi.TypedValue;
import openmods.config.simpler.Configurable;
import openmods.math.Complex;

public class TypedValuePrinter
implements IValuePrinter<TypedValue> {
    private static final TCharSet UNESCAPED_CHARS = new TCharHashSet(new char[]{'\''});
    @Configurable
    public int base = 10;
    @Configurable
    public boolean uniformBaseNotation = false;
    @Configurable
    public boolean allowStandardPrinter = false;
    @Configurable
    public boolean escapeStrings = false;
    @Configurable
    public boolean numericBool = false;
    @Configurable
    public boolean printTypes = false;
    @Configurable
    public boolean printLists = true;
    @Configurable
    public boolean printNilInLists = false;
    private final PositionalNotationPrinter<Double> doublePrinter = new DoublePrinter.Helper(8);
    private final PositionalNotationPrinter<BigInteger> bigIntPrinter = new BigIntPrinter.Helper(0);
    private final TypedValue nullValue;

    public TypedValuePrinter(TypedValue nullValue) {
        this.nullValue = nullValue;
    }

    @Override
    public String str(TypedValue value) {
        String contents;
        MetaObject.SlotStr slotStr = value.getMetaObject().slotStr;
        if (slotStr != null) {
            Frame<TypedValue> frame = FrameFactory.createTopFrame();
            contents = slotStr.str(value, frame);
        } else {
            contents = value.value.toString();
        }
        return this.printTypes ? "(" + value.type + ")" + contents : contents;
    }

    @Override
    public String repr(TypedValue value) {
        MetaObject.SlotRepr slotRepr = value.getMetaObject().slotRepr;
        if (slotRepr != null) {
            Frame<TypedValue> frame = FrameFactory.createTopFrame();
            return slotRepr.repr(value, frame);
        }
        return value.value.toString();
    }

    @Override
    public String str(boolean value) {
        return this.numericBool ? (value ? "1" : "0") : (value ? "true" : "false");
    }

    @Override
    public String repr(boolean value) {
        return value ? "true" : "false";
    }

    @Override
    public String str(String value) {
        return this.escapeStrings ? StringEscaper.escapeString(value, '\"', UNESCAPED_CHARS) : value;
    }

    @Override
    public String repr(String value) {
        return StringEscaper.escapeString(value, '\"', UNESCAPED_CHARS);
    }

    @Override
    public String str(BigInteger value) {
        if (this.base < 2) {
            return "invalid radix";
        }
        return PrinterUtils.decorateBase(!this.uniformBaseNotation, this.base, this.base <= 36 ? value.toString(this.base) : this.bigIntPrinter.toString(value, this.base));
    }

    @Override
    public String repr(BigInteger value) {
        return this.str(value);
    }

    @Override
    public String str(Double value) {
        if (this.base == 10 && !this.allowStandardPrinter && !this.uniformBaseNotation) {
            return value.toString();
        }
        if (value.isNaN()) {
            return "NaN";
        }
        if (value.isInfinite()) {
            return value > 0.0 ? "+Inf" : "-Inf";
        }
        String result = this.doublePrinter.toString(value, this.base);
        return PrinterUtils.decorateBase(!this.uniformBaseNotation, this.base, result);
    }

    @Override
    public String repr(Double value) {
        return this.str(value);
    }

    @Override
    public String str(Complex value) {
        return this.str(value.re) + "+" + this.str(value.im) + "I";
    }

    @Override
    public String repr(Complex value) {
        return this.str(value);
    }

    @Override
    public String str(Cons cons) {
        if (this.printLists) {
            final StringBuilder result = new StringBuilder();
            cons.visit(new Cons.BranchingVisitor(){

                @Override
                public void begin() {
                    result.append("[");
                }

                @Override
                public void value(TypedValue value, boolean isLast) {
                    result.append(TypedValuePrinter.this.str(value));
                    if (!isLast) {
                        result.append(" ");
                    }
                }

                @Override
                public Cons.BranchingVisitor nestedValue(TypedValue value) {
                    result.append("[");
                    return this;
                }

                @Override
                public void end(TypedValue terminator) {
                    if (terminator.value != TypedValuePrinter.this.nullValue || TypedValuePrinter.this.printNilInLists) {
                        result.append(" . ");
                        result.append(TypedValuePrinter.this.str(terminator));
                    }
                    result.append("]");
                }
            });
            return result.toString();
        }
        return "(" + this.str(cons.car) + " . " + this.str(cons.cdr) + ")";
    }

    @Override
    public String repr(Cons cons) {
        return this.repr(cons.car) + " : " + this.repr(cons.cdr);
    }

    @Override
    public String str(Symbol s) {
        return s.value;
    }

    @Override
    public String repr(Symbol s) {
        return '#' + s.value;
    }
}

