/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc.parsing;

import com.google.common.collect.Lists;
import com.google.common.collect.PeekingIterator;
import java.util.ArrayList;
import java.util.List;
import openmods.calc.parsing.IAstParser;
import openmods.calc.parsing.ICompilerState;
import openmods.calc.parsing.IExprNode;
import openmods.calc.parsing.IValueParser;
import openmods.calc.parsing.Token;
import openmods.calc.parsing.TokenType;
import openmods.calc.parsing.TokenUtils;

public class QuotedParser<E>
implements IAstParser<E> {
    private final IQuotedExprNodeFactory<E> exprNodeFactory;

    public QuotedParser(IValueParser<E> valueParser, IQuotedExprNodeFactory<E> exprNodeFactory) {
        this.exprNodeFactory = exprNodeFactory;
    }

    private IExprNode<E> parseQuotedNode(PeekingIterator<Token> input) {
        Token token = (Token)input.next();
        if (token.type == TokenType.LEFT_BRACKET) {
            return this.parseNestedQuotedNode(token.value, input, this.exprNodeFactory);
        }
        return this.exprNodeFactory.createValueNode(token);
    }

    private IExprNode<E> parseNestedQuotedNode(String openingBracket, PeekingIterator<Token> input, IQuotedExprNodeFactory<E> exprNodeFactory) {
        ArrayList children = Lists.newArrayList();
        while (true) {
            Token token = (Token)input.peek();
            if (token.type == TokenType.RIGHT_BRACKET) {
                TokenUtils.checkIsValidBracketPair(openingBracket, token.value);
                input.next();
                return exprNodeFactory.createBracketNode(openingBracket, token.value, children);
            }
            children.add(this.parseQuotedNode(input));
        }
    }

    @Override
    public IExprNode<E> parse(ICompilerState<E> state, PeekingIterator<Token> input) {
        return this.parseQuotedNode(input);
    }

    public static interface IQuotedExprNodeFactory<E> {
        public IExprNode<E> createValueNode(E var1);

        public IExprNode<E> createValueNode(Token var1);

        public IExprNode<E> createBracketNode(String var1, String var2, List<IExprNode<E>> var3);
    }
}

