/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.openglasses.surface;

import com.bymarcin.openglasses.surface.IRenderableWidget;
import com.bymarcin.openglasses.surface.Widget;
import com.bymarcin.openglasses.surface.widgets.component.face.Text;
import com.bymarcin.openglasses.utils.Location;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MovingObjectPosition;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ClientSurface {
    public static ClientSurface instances = new ClientSurface();
    public Map<Integer, IRenderableWidget> renderables = new HashMap<Integer, IRenderableWidget>();
    public Map<Integer, IRenderableWidget> renderablesWorld = new HashMap<Integer, IRenderableWidget>();
    boolean isPowered = false;
    public boolean haveGlasses = false;
    public Location lastBind;
    IRenderableWidget noPowerRender = this.getNoPowerRender();

    private ClientSurface() {
    }

    public void updateWigets(Set<Map.Entry<Integer, Widget>> widgets) {
        for (Map.Entry<Integer, Widget> widget : widgets) {
            IRenderableWidget r = widget.getValue().getRenderable();
            switch (r.getRenderType()) {
                case GameOverlayLocated: {
                    this.renderables.put(widget.getKey(), r);
                    break;
                }
                case WorldLocated: {
                    this.renderablesWorld.put(widget.getKey(), r);
                }
            }
        }
    }

    public void removeWidgets(List<Integer> ids) {
        for (Integer id : ids) {
            this.renderables.remove(id);
            this.renderablesWorld.remove(id);
        }
    }

    public void removeAllWidgets() {
        this.renderables.clear();
        this.renderablesWorld.clear();
    }

    @SubscribeEvent
    public void onRenderGameOverlay(RenderGameOverlayEvent evt) {
        if (evt.type == RenderGameOverlayEvent.ElementType.HELMET && evt instanceof RenderGameOverlayEvent.Post && this.haveGlasses) {
            if (!this.isPowered || !this.haveGlasses || this.lastBind == null) {
                this.noPowerRender.render(null, 0.0, 0.0, 0.0);
                return;
            }
            GL11.glPushMatrix();
            for (IRenderableWidget renderable : this.renderables.values()) {
                if (!renderable.shouldWidgetBeRendered()) continue;
                renderable.render(null, 0.0, 0.0, 0.0);
            }
            GL11.glPopMatrix();
        }
    }

    @SubscribeEvent
    public void renderWorldLastEvent(RenderWorldLastEvent event) {
        if (!this.isPowered || !this.haveGlasses || this.lastBind == null) {
            return;
        }
        GL11.glPushMatrix();
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        double playerX = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)event.partialTicks;
        double playerY = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)event.partialTicks;
        double playerZ = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)event.partialTicks;
        GL11.glTranslated((double)(-playerX), (double)(-playerY), (double)(-playerZ));
        GL11.glTranslated((double)this.lastBind.x, (double)this.lastBind.y, (double)this.lastBind.z);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glDepthMask((boolean)false);
        for (IRenderableWidget renderable : this.renderablesWorld.values()) {
            if (!renderable.shouldWidgetBeRendered()) continue;
            renderable.render((EntityPlayer)player, playerX - (double)this.lastBind.x, playerY - (double)this.lastBind.y, playerZ - (double)this.lastBind.z);
        }
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    public static MovingObjectPosition getBlockCoordsLookingAt(EntityPlayer player, int distance) {
        MovingObjectPosition objectMouseOver = player.func_70614_a((double)distance, 1.0f);
        if (objectMouseOver != null && objectMouseOver.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            return objectMouseOver;
        }
        return null;
    }

    public void setPowered(boolean isPowered) {
        this.isPowered = isPowered;
    }

    private IRenderableWidget getNoPowerRender() {
        Text t = new Text();
        t.setText("NO POWER");
        t.setAlpha(0.5);
        t.setScale(1.0);
        t.setColor(1.0, 0.0, 0.0);
        return t.getRenderable();
    }
}

