/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.openglasses.network.packet;

import com.bymarcin.openglasses.network.Packet;
import com.bymarcin.openglasses.surface.ClientSurface;
import com.bymarcin.openglasses.surface.Widget;
import com.bymarcin.openglasses.surface.WidgetType;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WidgetUpdatePacket
extends Packet<WidgetUpdatePacket, IMessage> {
    HashMap<Integer, Widget> widgetList;
    List<Integer> ids;
    Action type;

    public WidgetUpdatePacket() {
        this.type = Action.RemoveAllWidgets;
    }

    public WidgetUpdatePacket(HashMap<Integer, Widget> widgetList) {
        this.widgetList = widgetList;
        this.type = Action.AddWigets;
    }

    public WidgetUpdatePacket(List<Integer> l) {
        this.ids = l;
        this.type = Action.RemoveWidgets;
    }

    public WidgetUpdatePacket(int id) {
        this.ids = new ArrayList<Integer>();
        this.ids.add(id);
        this.type = Action.RemoveWidgets;
    }

    public WidgetUpdatePacket(int id, Widget widget) {
        this.widgetList = new HashMap();
        this.widgetList.put(id, widget);
        this.type = Action.AddWigets;
    }

    @Override
    protected void read() throws IOException {
        this.type = Action.values()[this.readInt()];
        switch (this.type) {
            case AddWigets: {
                this.readOnAddAction();
                break;
            }
            case RemoveWidgets: {
                this.readOnRemoveAction();
                break;
            }
            case RemoveAllWidgets: {
                break;
            }
        }
    }

    @Override
    protected void write() throws IOException {
        this.writeInt(this.type.ordinal());
        switch (this.type) {
            case AddWigets: {
                this.writeOnAddAction();
                break;
            }
            case RemoveWidgets: {
                this.writeOnRemoveAction();
                break;
            }
            case RemoveAllWidgets: {
                break;
            }
        }
    }

    private void readOnAddAction() throws IOException {
        this.widgetList = new HashMap();
        int size = this.readInt();
        for (int i = 0; i < size; ++i) {
            WidgetType wigetType = WidgetType.values()[this.readInt()];
            Widget w = wigetType.getNewInstance();
            w.read(this.read);
            this.widgetList.put(this.readInt(), w);
        }
    }

    private void readOnRemoveAction() throws IOException {
        this.ids = new ArrayList<Integer>();
        int size = this.readInt();
        for (int i = 0; i < size; ++i) {
            this.ids.add(this.readInt());
        }
    }

    private void writeOnAddAction() throws IOException {
        this.writeInt(this.widgetList.size());
        for (Map.Entry<Integer, Widget> w : this.widgetList.entrySet()) {
            this.writeInt(w.getValue().getType().ordinal());
            w.getValue().write(this.write);
            this.writeInt(w.getKey());
        }
    }

    private void writeOnRemoveAction() throws IOException {
        this.writeInt(this.ids.size());
        for (Integer i : this.ids) {
            this.writeInt(i);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected IMessage executeOnClient() {
        switch (this.type) {
            case AddWigets: {
                ClientSurface.instances.updateWigets(this.widgetList.entrySet());
                break;
            }
            case RemoveWidgets: {
                ClientSurface.instances.removeWidgets(this.ids);
                break;
            }
            case RemoveAllWidgets: {
                ClientSurface.instances.removeAllWidgets();
                break;
            }
        }
        return null;
    }

    @Override
    protected IMessage executeOnServer() {
        return null;
    }

    public static enum Action {
        AddWigets,
        RemoveWidgets,
        RemoveAllWidgets;

    }
}

