/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import openblocks.client.renderer.HeightMapRenderer;
import openblocks.common.HeightMapData;
import openblocks.common.MapDataManager;
import openblocks.common.container.ContainerProjector;
import openblocks.common.tileentity.TileEntityProjector;
import openblocks.rpc.IRotatable;
import openmods.container.ContainerBase;
import openmods.gui.BaseGuiContainer;
import openmods.gui.component.BaseComponent;
import openmods.gui.component.BaseComposite;
import openmods.gui.component.EmptyComposite;
import openmods.gui.component.GuiComponentIconButton;
import openmods.gui.listener.IMouseDownListener;
import openmods.gui.misc.Trackball;
import openmods.utils.MathUtils;
import openmods.utils.render.FakeIcon;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiProjector
extends BaseGuiContainer<ContainerProjector> {
    private static final ResourceLocation texture = new ResourceLocation("openblocks:textures/gui/projector.png");
    private static final int VIEW_HEIGHT = 138;
    private static final int VIEW_WIDTH = 160;
    private Trackball.TrackballWrapper trackball = new Trackball.TrackballWrapper(1, 150);
    private boolean isInitialized;
    private int scale = 90;
    private double mapHeight = 2.0;

    private static IMouseDownListener createRotationListener(final IRotatable proxy, final int direction) {
        return new IMouseDownListener(){

            public void componentMouseDown(BaseComponent component, int x, int y, int button) {
                proxy.rotate(direction);
            }
        };
    }

    public GuiProjector(ContainerProjector container) {
        super((ContainerBase)container, 176, 234, "");
        IRotatable proxy = (IRotatable)((TileEntityProjector)((ContainerProjector)this.getContainer()).getOwner()).createClientRpcProxy(IRotatable.class, new Class[0]);
        GuiComponentIconButton buttonLeft = new GuiComponentIconButton(7, 130, 0xFFFFFF, FakeIcon.createSheetIcon((int)176, (int)0, (int)13, (int)13), texture);
        buttonLeft.setListener(GuiProjector.createRotationListener(proxy, -1));
        this.root.addComponent((BaseComponent)buttonLeft);
        GuiComponentIconButton buttonRight = new GuiComponentIconButton(152, 130, 0xFFFFFF, FakeIcon.createSheetIcon((int)189, (int)0, (int)-13, (int)13), texture);
        buttonRight.setListener(GuiProjector.createRotationListener(proxy, 1));
        this.root.addComponent((BaseComponent)buttonRight);
    }

    protected BaseComposite createRoot() {
        return new EmptyComposite(0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected void func_146976_a(float partialTickTime, int mouseX, int mouseY) {
        World world;
        HeightMapData data;
        if (!this.isInitialized || Mouse.isButtonDown((int)2)) {
            this.trackball.setTransform(MathUtils.createEntityRotateMatrix((Entity)Minecraft.func_71410_x().field_71451_h));
            this.isInitialized = true;
        }
        this.mapHeight += (double)Mouse.getDWheel() / 1000.0;
        if (this.mapHeight > 10.0) {
            this.mapHeight = 10.0;
        }
        if (this.mapHeight < -5.0) {
            this.mapHeight = -5.0;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int left = (this.field_146294_l - this.field_146999_f) / 2;
        int top = (this.field_146295_m - this.field_147000_g) / 2;
        GL11.glClear((int)256);
        GL11.glPushMatrix();
        GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)999.0f);
        GuiProjector.func_73734_a((int)0, (int)0, (int)this.field_146294_l, (int)this.field_146295_m, (int)-16777216);
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-1998.0f);
        GL11.glDepthFunc((int)516);
        GuiProjector.func_73734_a((int)(left + 8), (int)(top + 8), (int)(left + 8 + 160), (int)(top + 8 + 138), (int)-16777216);
        GL11.glDepthFunc((int)515);
        GL11.glPopMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ContainerProjector container = (ContainerProjector)this.getContainer();
        Integer mapId = container.getMapId();
        if (mapId != null && (data = MapDataManager.getMapData(world = ((TileEntityProjector)container.getOwner()).func_145831_w(), mapId)).isValid()) {
            GL11.glPushMatrix();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int viewMiddleX = left + 8 + 80;
            int viewMiddleY = top + 8 + 69;
            GL11.glTranslatef((float)viewMiddleX, (float)viewMiddleY, (float)50.0f);
            GL11.glScalef((float)this.scale, (float)(-this.scale), (float)this.scale);
            this.trackball.update(mouseX - viewMiddleX, -(mouseY - viewMiddleY));
            GL11.glRotated((double)(90 * container.rotation()), (double)0.0, (double)1.0, (double)0.0);
            GL11.glTranslated((double)-0.5, (double)(-this.mapHeight), (double)-0.5);
            HeightMapRenderer.instance.render(mapId, data);
            GL11.glDisable((int)2896);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.drawLevels();
            GL11.glPopMatrix();
        }
        GL11.glClear((int)256);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(texture);
        GL11.glPushMatrix();
        GL11.glTranslated((double)this.field_147003_i, (double)this.field_147009_r, (double)0.0);
        this.func_73729_b(0, 0, 0, 0, this.field_146999_f, this.field_147000_g);
        this.root.render(this.field_146297_k, 0, 0, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        GL11.glPopMatrix();
    }

    private void drawLevels() {
        GL11.glDisable((int)2884);
        GL11.glDisable((int)3553);
        GL11.glPolygonMode((int)1032, (int)6913);
        GL11.glBegin((int)7);
        GL11.glColor3d((double)0.0, (double)1.0, (double)0.0);
        for (int i = 0; i <= 4; ++i) {
            GL11.glVertex3d((double)0.0, (double)i, (double)0.0);
            GL11.glVertex3d((double)0.0, (double)i, (double)1.0);
            GL11.glVertex3d((double)1.0, (double)i, (double)1.0);
            GL11.glVertex3d((double)1.0, (double)i, (double)0.0);
        }
        GL11.glColor3d((double)1.0, (double)0.0, (double)0.0);
        GL11.glVertex3d((double)0.0, (double)this.mapHeight, (double)0.0);
        GL11.glVertex3d((double)0.0, (double)this.mapHeight, (double)1.0);
        GL11.glVertex3d((double)1.0, (double)this.mapHeight, (double)1.0);
        GL11.glVertex3d((double)1.0, (double)this.mapHeight, (double)0.0);
        GL11.glEnd();
        GL11.glEnable((int)3553);
        GL11.glPolygonMode((int)1032, (int)6914);
        GL11.glEnable((int)2884);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
    }
}

