/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.lib.inventory.ContainerExtended;
import codechicken.lib.inventory.InventoryNBT;
import codechicken.lib.inventory.InventoryUtils;
import codechicken.lib.inventory.SlotHandleClicks;
import codechicken.lib.packet.PacketCustom;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.PotionEffect;

public class ContainerPotionCreator
extends ContainerExtended {
    final InventoryPlayer playerInv;
    final InventoryBasic potionInv;
    final IInventory potionStoreInv;

    public ContainerPotionCreator(InventoryPlayer inventoryPlayer, IInventory potionStoreInv) {
        this.playerInv = inventoryPlayer;
        this.potionInv = new InventoryBasic("Potion", true, 1);
        this.potionStoreInv = potionStoreInv;
        this.func_75146_a(new SlotPotion((IInventory)this.potionInv, 0, 25, 102));
        for (int i = 0; i < 9; ++i) {
            this.func_75146_a((Slot)new SlotPotionStore(potionStoreInv, i, 8 + i * 18, 14));
        }
        this.bindPlayerInventory(inventoryPlayer, 8, 125);
    }

    public boolean doMergeStackAreas(int slotIndex, ItemStack stack) {
        if (slotIndex < 10) {
            return this.func_75135_a(stack, 10, 46, true);
        }
        return this.func_75135_a(stack, 0, 1, false);
    }

    public boolean func_75145_c(EntityPlayer entityplayer) {
        return true;
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (!player.field_70170_p.field_72995_K) {
            InventoryUtils.dropOnClose((EntityPlayer)player, (IInventory)this.potionInv);
        }
    }

    public void handleServerPacket(PacketCustom packet) {
        ItemStack potion = this.potionInv.func_70301_a(0);
        if (potion == null) {
            return;
        }
        boolean add = packet.getType() == 3;
        short effectID = packet.readUByte();
        NBTTagList effects = potion.func_77978_p().func_150295_c("CustomPotionEffects", 10);
        NBTTagList newEffects = new NBTTagList();
        for (int i = 0; i < effects.func_74745_c(); ++i) {
            NBTTagCompound tag = effects.func_150305_b(i);
            PotionEffect e = PotionEffect.func_82722_b((NBTTagCompound)tag);
            if (e.func_76456_a() == effectID) continue;
            newEffects.func_74742_a((NBTBase)tag);
        }
        if (add) {
            newEffects.func_74742_a((NBTBase)new PotionEffect((int)effectID, packet.readInt(), (int)packet.readUByte()).func_82719_a(new NBTTagCompound()));
        }
        potion.func_77978_p().func_74782_a("CustomPotionEffects", (NBTBase)newEffects);
    }

    public void setPotionEffect(int effectID, int duration, int amplifier) {
        PacketCustom packet = this.getPacket(3);
        packet.writeByte(effectID);
        packet.writeInt(duration);
        packet.writeByte(amplifier);
        packet.sendToServer();
    }

    public void removePotionEffect(int effectID) {
        PacketCustom packet = this.getPacket(2);
        packet.writeByte(effectID);
        packet.sendToServer();
    }

    public static class InventoryPotionStore
    extends InventoryNBT {
        public InventoryPotionStore() {
            super(9, NEIClientConfig.global.nbt.func_74775_l("potionStore"));
        }

        public void func_70296_d() {
            super.func_70296_d();
            NEIClientConfig.global.nbt.func_74782_a("potionStore", (NBTBase)this.tag);
            NEIClientConfig.global.saveNBT();
        }
    }

    public class SlotPotionStore
    extends SlotHandleClicks {
        public SlotPotionStore(IInventory inv, int slotIndex, int x, int y) {
            super(inv, slotIndex, x, y);
        }

        public ItemStack slotClick(ContainerExtended container, EntityPlayer player, int button, int modifier) {
            ItemStack held = player.field_71071_by.func_70445_o();
            if (button == 0 && modifier == 1) {
                NEIClientUtils.cheatItem(this.func_75211_c(), button, -1);
            } else if (button == 1) {
                this.func_75215_d(null);
            } else if (held != null) {
                if (this.func_75214_a(held)) {
                    this.func_75215_d(InventoryUtils.copyStack((ItemStack)held, (int)1));
                    player.field_71071_by.func_70437_b(null);
                }
            } else if (this.func_75216_d()) {
                player.field_71071_by.func_70437_b(this.func_75211_c());
            }
            return null;
        }

        public boolean func_75214_a(ItemStack stack) {
            return stack.func_77973_b() instanceof ItemPotion;
        }
    }

    public class SlotPotion
    extends Slot {
        public SlotPotion(IInventory inv, int slotIndex, int x, int y) {
            super(inv, slotIndex, x, y);
        }

        public boolean func_75214_a(ItemStack stack) {
            return stack.func_77973_b() instanceof ItemPotion;
        }

        public void func_75218_e() {
            super.func_75218_e();
            if (this.func_75216_d()) {
                ItemStack stack = this.func_75211_c();
                if (!stack.func_77942_o()) {
                    stack.func_77982_d(new NBTTagCompound());
                }
                if (!stack.func_77978_p().func_74764_b("CustomPotionEffects")) {
                    stack.func_77978_p().func_74782_a("CustomPotionEffects", (NBTBase)new NBTTagList());
                }
            }
        }
    }
}

