/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.api.diagram.layout;

import com.github.dcysteine.neicustomdiagram.api.diagram.interactable.Interactable;
import com.github.dcysteine.neicustomdiagram.api.diagram.layout.$AutoValue_Layout;
import com.github.dcysteine.neicustomdiagram.api.diagram.layout.Layout;
import com.github.dcysteine.neicustomdiagram.api.diagram.layout.Lines;
import com.github.dcysteine.neicustomdiagram.api.diagram.layout.Slot;
import com.github.dcysteine.neicustomdiagram.api.diagram.layout.SlotGroup;
import com.github.dcysteine.neicustomdiagram.api.draw.Drawable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;

final class AutoValue_Layout
extends $AutoValue_Layout {
    AutoValue_Layout(ImmutableList<Lines> lines$, ImmutableList<Drawable> labels$, ImmutableList<Interactable> interactables$, ImmutableMap<Layout.SlotKey, Slot> slots$, ImmutableMap<Layout.SlotGroupKey, SlotGroup> slotGroups$) {
        super(lines$, labels$, interactables$, slots$, slotGroups$);
    }

    @Override
    public final String toPrettyString() {
        return "Layout {\n  lines = " + AutoValue_Layout.formatCollectionOfLines(this.lines(), 1) + ",\n  labels = " + AutoValue_Layout.formatCollectionOfDrawable(this.labels(), 1) + ",\n  interactables = " + AutoValue_Layout.formatCollectionOfInteractable(this.interactables(), 1) + ",\n  slots = " + AutoValue_Layout.formatMapOfSlotKeyToSlot(this.slots(), 1) + ",\n  slotGroups = " + AutoValue_Layout.formatMapOfSlotGroupKeyToSlotGroup(this.slotGroups(), 1) + ",\n}";
    }

    private static String formatLines(Lines value, int indentLevel) {
        if (value == null) {
            return "null";
        }
        return value.toPrettyString().replace("\n", "\n" + AutoValue_Layout.$indent(indentLevel));
    }

    private static String formatCollectionOfLines(Collection<Lines> value, int indentLevel) {
        if (value == null) {
            return "null";
        }
        StringBuilder builder = new StringBuilder().append("[");
        boolean hasElements = false;
        for (Lines element : value) {
            builder.append("\n").append(AutoValue_Layout.$indent(indentLevel + 1)).append(AutoValue_Layout.formatLines(element, indentLevel + 1)).append(",");
            hasElements = true;
        }
        if (hasElements) {
            builder.append("\n").append(AutoValue_Layout.$indent(indentLevel));
        }
        return builder.append("]").toString();
    }

    private static String format(Object value, int indentLevel) {
        if (value == null) {
            return "null";
        }
        return value.toString().replace("\n", "\n" + AutoValue_Layout.$indent(indentLevel));
    }

    private static String formatCollectionOfDrawable(Collection<Drawable> value, int indentLevel) {
        if (value == null) {
            return "null";
        }
        StringBuilder builder = new StringBuilder().append("[");
        boolean hasElements = false;
        for (Drawable element : value) {
            builder.append("\n").append(AutoValue_Layout.$indent(indentLevel + 1)).append(AutoValue_Layout.format(element, indentLevel + 1)).append(",");
            hasElements = true;
        }
        if (hasElements) {
            builder.append("\n").append(AutoValue_Layout.$indent(indentLevel));
        }
        return builder.append("]").toString();
    }

    private static String formatCollectionOfInteractable(Collection<Interactable> value, int indentLevel) {
        if (value == null) {
            return "null";
        }
        StringBuilder builder = new StringBuilder().append("[");
        boolean hasElements = false;
        for (Interactable element : value) {
            builder.append("\n").append(AutoValue_Layout.$indent(indentLevel + 1)).append(AutoValue_Layout.format(element, indentLevel + 1)).append(",");
            hasElements = true;
        }
        if (hasElements) {
            builder.append("\n").append(AutoValue_Layout.$indent(indentLevel));
        }
        return builder.append("]").toString();
    }

    private static String formatSlot(Slot value, int indentLevel) {
        if (value == null) {
            return "null";
        }
        return value.toPrettyString().replace("\n", "\n" + AutoValue_Layout.$indent(indentLevel));
    }

    private static String formatMapOfSlotKeyToSlot(Map<Layout.SlotKey, Slot> value, int indentLevel) {
        if (value == null) {
            return "null";
        }
        StringBuilder builder = new StringBuilder().append("{");
        boolean hasElements = false;
        for (Map.Entry<Layout.SlotKey, Slot> entry : value.entrySet()) {
            builder.append("\n").append(AutoValue_Layout.$indent(indentLevel + 1)).append(AutoValue_Layout.format(entry.getKey(), indentLevel + 1)).append(": ").append(AutoValue_Layout.formatSlot(entry.getValue(), indentLevel + 1)).append(",");
            hasElements = true;
        }
        if (hasElements) {
            builder.append("\n").append(AutoValue_Layout.$indent(indentLevel));
        }
        return builder.append("}").toString();
    }

    private static String formatSlotGroup(SlotGroup value, int indentLevel) {
        if (value == null) {
            return "null";
        }
        return value.toPrettyString().replace("\n", "\n" + AutoValue_Layout.$indent(indentLevel));
    }

    private static String formatMapOfSlotGroupKeyToSlotGroup(Map<Layout.SlotGroupKey, SlotGroup> value, int indentLevel) {
        if (value == null) {
            return "null";
        }
        StringBuilder builder = new StringBuilder().append("{");
        boolean hasElements = false;
        for (Map.Entry<Layout.SlotGroupKey, SlotGroup> entry : value.entrySet()) {
            builder.append("\n").append(AutoValue_Layout.$indent(indentLevel + 1)).append(AutoValue_Layout.format(entry.getKey(), indentLevel + 1)).append(": ").append(AutoValue_Layout.formatSlotGroup(entry.getValue(), indentLevel + 1)).append(",");
            hasElements = true;
        }
        if (hasElements) {
            builder.append("\n").append(AutoValue_Layout.$indent(indentLevel));
        }
        return builder.append("}").toString();
    }

    private static String $indent(int level) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < level; ++i) {
            builder.append("  ");
        }
        return builder.toString();
    }
}

