/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.exnihilo.handlers;

import exnihilo.registries.CrucibleRegistry;
import exnihilo.registries.helpers.Meltable;
import exnihilo.utils.ItemInfo;
import java.util.HashMap;
import java.util.Map;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.LogHelper;
import modtweaker2.helpers.StackHelper;
import modtweaker2.mods.exnihilo.ExNihiloHelper;
import modtweaker2.utils.BaseMapAddition;
import modtweaker2.utils.BaseMapRemoval;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.exnihilo.Crucible")
public class Crucible {
    public static final String nameMelting = "ExNihilo Crucible (Melting)";
    public static final String nameHeatSource = "ExNihilo Crucible (Heat source)";

    @ZenMethod
    public static void addRecipe(IItemStack input, ILiquidStack fluid) {
        if (input == null || fluid == null) {
            LogHelper.logError(String.format("Required parameters missing for %s recipe.", nameMelting));
            return;
        }
        if (!InputHelper.isABlock(input)) {
            LogHelper.logError(String.format("Input item for %s recipe must be a block.", nameMelting));
            return;
        }
        HashMap<String, Meltable> recipes = new HashMap<String, Meltable>();
        Block theBlock = Block.func_149634_a((Item)InputHelper.toStack(input).func_77973_b());
        int theMeta = InputHelper.toStack(input).func_77960_j();
        recipes.put(theBlock + ":" + theMeta, new Meltable(theBlock, theMeta, 2000.0f, InputHelper.toFluid(fluid).getFluid(), (float)InputHelper.toFluid((ILiquidStack)fluid).amount, theBlock));
        MineTweakerAPI.apply((IUndoableAction)new AddRecipe(recipes));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient output) {
        HashMap<String, Meltable> recipes = new HashMap<String, Meltable>();
        for (Map.Entry entry : CrucibleRegistry.entries.entrySet()) {
            FluidStack fluid = new FluidStack(((Meltable)entry.getValue()).fluid, (int)((Meltable)entry.getValue()).fluidVolume);
            if (!StackHelper.matches(output, InputHelper.toILiquidStack(fluid))) continue;
            recipes.put((String)entry.getKey(), (Meltable)entry.getValue());
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new RemoveRecipe(recipes));
        } else {
            LogHelper.logWarning(String.format("No %s recipe found for %s. Command ignored!", nameMelting, output.toString()));
        }
    }

    @ZenMethod
    public static void addHeatSource(IItemStack input, double value) {
        if (input == null) {
            LogHelper.logError(String.format("Required parameters missing for %s recipe.", nameMelting));
            return;
        }
        if (!InputHelper.isABlock(input)) {
            LogHelper.logError(String.format("Input item for %s recipe must be a block.", nameMelting));
            return;
        }
        HashMap<ItemInfo, Float> recipes = new HashMap<ItemInfo, Float>();
        recipes.put(new ItemInfo(InputHelper.toStack(input)), Float.valueOf((float)value));
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new AddHeatSource(recipes));
        }
    }

    @ZenMethod
    public static void removeHeatSource(IIngredient output) {
        HashMap<ItemInfo, Float> recipes = new HashMap<ItemInfo, Float>();
        for (Map.Entry<ItemInfo, Float> entry : ExNihiloHelper.getHeatMap().entrySet()) {
            if (!StackHelper.matches(output, InputHelper.toIItemStack(entry.getKey().getStack()))) continue;
            recipes.put(entry.getKey(), entry.getValue());
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new RemoveHeatSource(recipes));
        } else {
            LogHelper.logWarning(String.format("No %s recipe found for %s. Command ignored!", nameMelting, output.toString()));
        }
    }

    private static class RemoveHeatSource
    extends BaseMapRemoval<ItemInfo, Float> {
        public RemoveHeatSource(Map<ItemInfo, Float> recipes) {
            super(Crucible.nameHeatSource, ExNihiloHelper.getHeatMap(), recipes);
        }

        @Override
        protected String getRecipeInfo(Map.Entry<ItemInfo, Float> recipe) {
            return LogHelper.getStackDescription(recipe.getKey().getStack());
        }
    }

    private static class AddHeatSource
    extends BaseMapAddition<ItemInfo, Float> {
        public AddHeatSource(Map<ItemInfo, Float> recipes) {
            super(Crucible.nameHeatSource, ExNihiloHelper.getHeatMap(), recipes);
        }

        @Override
        protected String getRecipeInfo(Map.Entry<ItemInfo, Float> recipe) {
            return LogHelper.getStackDescription(recipe.getKey().getStack());
        }
    }

    private static class RemoveRecipe
    extends BaseMapRemoval<String, Meltable> {
        public RemoveRecipe(Map<String, Meltable> recipes) {
            super(Crucible.nameMelting, CrucibleRegistry.entries, recipes);
        }

        @Override
        protected String getRecipeInfo(Map.Entry<String, Meltable> recipe) {
            return LogHelper.getStackDescription(new ItemStack(recipe.getValue().block, 1, recipe.getValue().meta));
        }
    }

    private static class AddRecipe
    extends BaseMapAddition<String, Meltable> {
        public AddRecipe(Map<String, Meltable> recipes) {
            super(Crucible.nameMelting, CrucibleRegistry.entries, recipes);
        }

        @Override
        protected String getRecipeInfo(Map.Entry<String, Meltable> recipe) {
            return LogHelper.getStackDescription(new ItemStack(recipe.getValue().block, 1, recipe.getValue().meta));
        }
    }
}

