/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.world.structure.island.biome.feature.island.laboratory;

import chylex.hee.world.structure.island.biome.feature.island.laboratory.LaboratoryElement;
import chylex.hee.world.structure.island.biome.feature.island.laboratory.LaboratoryElementType;
import chylex.hee.world.structure.util.pregen.LargeStructureWorld;
import chylex.hee.world.util.Direction;
import gnu.trove.map.hash.TByteByteHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public final class LaboratoryPlan {
    private static TByteByteHashMap tryMap = new TByteByteHashMap(4);
    final List<LaboratoryElement> elements = new ArrayList<LaboratoryElement>();
    final List<LaboratoryElement> roomElements = new ArrayList<LaboratoryElement>();
    private int score;

    public boolean generate(LargeStructureWorld world, Random rand) {
        this.roomElements.clear();
        this.elements.clear();
        this.score = 0;
        for (int locAttempt = 0; locAttempt < 420; ++locAttempt) {
            int z;
            int x = rand.nextInt(208) - 104;
            LaboratoryElement element = LaboratoryPlan.trySpawnElement(world, LaboratoryElementType.SMALL_ROOM, x, z = rand.nextInt(208) - 104, 0);
            if (element == null) continue;
            this.elements.add(element);
            this.roomElements.add(element);
            break;
        }
        if (this.roomElements.isEmpty()) {
            return false;
        }
        int attempts = 100;
        int roomAmount = this.roomElements.size();
        while (--attempts >= 0 && (roomAmount <= 17 || roomAmount <= 17 + rand.nextInt(8))) {
            LaboratoryElement hall;
            if (roomAmount > 8 && roomAmount > 8 + rand.nextInt(5)) {
                attempts -= 15;
            }
            LaboratoryElement room = this.roomElements.get(rand.nextInt(roomAmount));
            int dir = rand.nextInt(4);
            if (room.connected[dir]) continue;
            int xx = room.x + room.type.halfSizeX * Direction.offsetX[dir];
            int zz = room.z + room.type.halfSizeZ * Direction.offsetZ[dir];
            int startY = room.y;
            int prevY = room.y;
            int dist = 0;
            while (++dist < 25 && (hall = LaboratoryPlan.trySpawnElement(world, dir == 0 || dir == 2 ? LaboratoryElementType.HALL_Z : LaboratoryElementType.HALL_X, xx + Direction.offsetX[dir] * dist, zz + Direction.offsetZ[dir] * dist, dir)) != null && Math.abs(hall.y - prevY) <= 1 && Math.abs(hall.y - startY) <= 3 && this.hasSpaceFor(hall, room)) {
            }
            if (dist <= 7) continue;
            boolean hasGenerated = false;
            for (int placeAttempt = 0; placeAttempt < dist + 5; ++placeAttempt) {
                int tmpDist = dist - 5 + (int)((float)rand.nextInt(dist - 6) * (0.4f + rand.nextFloat() * 0.6f));
                LaboratoryElementType type = rand.nextBoolean() ? LaboratoryElementType.LARGE_ROOM : LaboratoryElementType.SMALL_ROOM;
                LaboratoryElement newRoom = LaboratoryPlan.trySpawnElement(world, type, xx + tmpDist * Direction.offsetX[dir], zz + tmpDist * Direction.offsetZ[dir], dir);
                if (newRoom == null || Math.abs(newRoom.y - startY) > 4 || !this.hasSpaceFor(newRoom, null)) continue;
                room.connected[dir] = true;
                newRoom.connected[Direction.rotateOpposite[dir]] = true;
                this.elements.add(newRoom);
                this.roomElements.add(newRoom);
                roomAmount = this.roomElements.size();
                hasGenerated = true;
                tmpDist -= Math.abs(Direction.offsetX[dir] * (newRoom.type.halfSizeX + 1) + Direction.offsetZ[dir] * (newRoom.type.halfSizeZ + 1));
                LaboratoryElementType hallType = dir == 0 || dir == 2 ? LaboratoryElementType.HALL_Z : LaboratoryElementType.HALL_X;
                for (int path = 0; path < tmpDist; ++path) {
                    LaboratoryElement ele = LaboratoryPlan.trySpawnElement(world, hallType, xx += Direction.offsetX[dir], zz += Direction.offsetZ[dir], dir);
                    if (ele == null) continue;
                    this.elements.add(ele);
                }
                break;
            }
            if (!hasGenerated) continue;
            attempts = Math.min(100, attempts + 10);
        }
        this.score = this.elements.size() + this.roomElements.size() * 12;
        return true;
    }

    public LaboratoryPlan copy() {
        LaboratoryPlan copy = new LaboratoryPlan();
        copy.elements.addAll(this.elements);
        copy.roomElements.addAll(this.roomElements);
        copy.score = this.score;
        return copy;
    }

    public int getScore() {
        return this.score;
    }

    private boolean hasSpaceFor(LaboratoryElement testElement, LaboratoryElement exception) {
        for (LaboratoryElement element : this.elements) {
            if (element == exception || Math.abs(element.x - testElement.x) > element.type.sizeX || Math.abs(element.z - testElement.z) > element.type.sizeZ) continue;
            return false;
        }
        return true;
    }

    private static LaboratoryElement trySpawnElement(LargeStructureWorld world, LaboratoryElementType type, int x, int z, int dir) {
        int maxY;
        if (type == LaboratoryElementType.NONE) {
            return null;
        }
        tryMap.clear();
        int minY = maxY = world.getHighestY(x, z);
        for (int xx = x - type.halfSizeX; xx <= x + type.halfSizeX && maxY - minY <= 5; ++xx) {
            for (int zz = z - type.halfSizeZ; zz <= z + type.halfSizeZ; ++zz) {
                int yy = world.getHighestY(xx, zz);
                if (yy == 0) {
                    return null;
                }
                if (yy < minY) {
                    minY = yy;
                } else if (yy > maxY) {
                    maxY = yy;
                }
                tryMap.adjustOrPutValue((byte)(yy - 128), (byte)1, (byte)1);
            }
        }
        if (maxY - minY > 5) {
            return null;
        }
        int mostFrequentY = 0;
        byte mostFrequentYAmount = 0;
        for (byte y : tryMap.keys()) {
            byte amt = tryMap.get(y);
            if (amt <= mostFrequentYAmount) continue;
            mostFrequentYAmount = amt;
            mostFrequentY = y + 128;
        }
        if (maxY - mostFrequentY > 3 || mostFrequentY - minY > 2) {
            return null;
        }
        if ((float)mostFrequentYAmount * type.oneOverArea < 0.25f) {
            return null;
        }
        return new LaboratoryElement(type, x, mostFrequentY, z);
    }
}

