/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.world.structure.island.biome.feature.forest;

import chylex.hee.world.structure.island.biome.feature.AbstractIslandStructure;
import chylex.hee.world.structure.util.pregen.LargeStructureWorld;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;

public class StructureRuinPillar
extends AbstractIslandStructure {
    private boolean isDeep;
    private int forcedX;
    private int forcedY;
    private int forcedZ;

    public StructureRuinPillar setIsDeep(boolean isDeep) {
        this.isDeep = isDeep;
        return this;
    }

    public StructureRuinPillar setForcedCoords(int forcedX, int forcedY, int forcedZ) {
        this.forcedX = forcedX;
        this.forcedY = forcedY;
        this.forcedZ = forcedZ;
        return this;
    }

    @Override
    protected boolean generate(Random rand) {
        int y;
        int z;
        int x;
        if (this.forcedY != 0) {
            x = this.forcedX;
            z = this.forcedZ;
            y = this.forcedY;
        } else {
            x = this.getRandomXZ(rand, 0);
            z = this.getRandomXZ(rand, 0);
            y = this.world.getHighestY(x, z) + 1;
        }
        if (this.world.getBlock(x, y - 1, z) == this.surface()) {
            int py;
            int height = 1 + rand.nextInt(3 + rand.nextInt(10));
            for (py = y; py < y + height; ++py) {
                StructureRuinPillar.placeRandomPillarBlock(this.world, x, py, z, rand);
                if (rand.nextInt(5) == 0) break;
            }
            if (rand.nextInt(4) == 0) {
                StructureRuinPillar.placeRandomTopBlock(this.world, x, py, z, rand);
            }
            if (this.isDeep) {
                int bottomBlockY;
                int undergroundSpike = 4 + rand.nextInt(30);
                for (bottomBlockY = 0; bottomBlockY < 30 && this.world.isAir(x, bottomBlockY, z); ++bottomBlockY) {
                }
                for (py = y - 1; py > y - undergroundSpike && py > bottomBlockY; --py) {
                    StructureRuinPillar.placeRandomPillarBlock(this.world, x, py, z, rand);
                }
            }
            return true;
        }
        return false;
    }

    public static void placeRandomPillarBlock(LargeStructureWorld world, int x, int y, int z, Random rand) {
        int n = rand.nextInt(20);
        if (n < 15) {
            world.setBlock(x, y, z, Blocks.field_150417_aV, rand.nextInt(7) <= 4 ? 0 : (rand.nextBoolean() ? 1 : 2));
        } else if (n < 18) {
            world.setBlock(x, y, z, Blocks.field_150347_e);
        } else if (n < 20) {
            world.setBlock(x, y, z, Blocks.field_150348_b);
        }
    }

    public static void placeRandomTopBlock(LargeStructureWorld world, int x, int y, int z, Random rand) {
        if (rand.nextInt(6) == 0) {
            world.setBlock(x, y, z, (Block)Blocks.field_150333_U, rand.nextInt(4) == 0 ? 3 : 5);
        } else {
            world.setBlock(x, y, z, rand.nextInt(5) == 0 ? Blocks.field_150446_ar : Blocks.field_150390_bg, rand.nextInt(4));
        }
    }
}

