/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.world.structure.island.biome;

import chylex.hee.entity.mob.EntityMobFireGolem;
import chylex.hee.entity.mob.EntityMobHauntedMiner;
import chylex.hee.entity.mob.EntityMobScorchingLens;
import chylex.hee.system.achievements.AchievementManager;
import chylex.hee.world.structure.island.biome.IslandBiomeBase;
import chylex.hee.world.structure.island.biome.data.BiomeContentVariation;
import chylex.hee.world.structure.island.biome.data.BiomeRandomDeviation;
import chylex.hee.world.structure.island.biome.decorator.BiomeDecoratorBurningMountains;
import chylex.hee.world.structure.island.biome.decorator.IslandBiomeDecorator;
import chylex.hee.world.structure.util.pregen.LargeStructureWorld;
import chylex.hee.world.util.SpawnEntry;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.stats.Achievement;

public class IslandBiomeBurningMountains
extends IslandBiomeBase {
    public static final BiomeContentVariation SCORCHING = new BiomeContentVariation(1, 8);
    public static final BiomeContentVariation MINE = new BiomeContentVariation(5, 6);
    public static final BiomeRandomDeviation EXCESSIVE_CINDER = new BiomeRandomDeviation("ExcessiveCinder", SCORCHING);
    public static final BiomeRandomDeviation SINGLE_LAVA_ONLY = new BiomeRandomDeviation("SingleLava", SCORCHING);
    public static final BiomeRandomDeviation LIMITED_ORES = new BiomeRandomDeviation("LimitedOres", MINE);
    public static final BiomeRandomDeviation DEEP_RESOURCE_PITS = new BiomeRandomDeviation("DeepResPits", MINE);
    private final BiomeDecoratorBurningMountains decorator = new BiomeDecoratorBurningMountains();

    protected IslandBiomeBurningMountains(int biomeID) {
        super(biomeID);
        this.contentVariations.addAll(Arrays.asList(SCORCHING, MINE));
        this.randomDeviations.addAll(Arrays.asList(EXCESSIVE_CINDER, SINGLE_LAVA_ONLY, LIMITED_ORES, DEEP_RESOURCE_PITS));
        this.getSpawnEntries(SCORCHING).addAll(new SpawnEntry[]{new SpawnEntry(EntityMobFireGolem.class, 14, 10), new SpawnEntry(EntityMobScorchingLens.class, 10, 6)});
        this.getSpawnEntries(MINE).addAll(new SpawnEntry[]{new SpawnEntry(EntityMobHauntedMiner.class, 20, 10)});
    }

    @Override
    protected void decorate(LargeStructureWorld world, Random rand, int centerX, int centerZ) {
        if (this.data.content == SCORCHING) {
            this.decorator.genScorching();
        } else if (this.data.content == MINE) {
            this.decorator.genMine();
        }
    }

    @Override
    public float getIslandSurfaceHeightMultiplier() {
        return this.data.content == SCORCHING ? 6.5f : 7.5f;
    }

    @Override
    public float getIslandMassHeightMultiplier() {
        return this.data.content == SCORCHING ? 0.9f : 1.0f;
    }

    @Override
    public float getCaveAmountMultiplier() {
        return this.data.content == MINE ? 2.0f : 1.6f;
    }

    @Override
    public float getCaveBranchingChance() {
        return this.data.content == MINE ? 0.05f : 0.035f;
    }

    @Override
    public float getOreAmountMultiplier() {
        return this.data.content == MINE ? 1.4f : 1.15f;
    }

    @Override
    protected IslandBiomeDecorator getDecorator() {
        return this.decorator;
    }

    @Override
    protected Achievement getAchievement() {
        return AchievementManager.BIOME_BURNING_MOUNTAINS;
    }

    @Override
    public int getTopBlockMeta() {
        return 1;
    }
}

