/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.tileentity;

import chylex.hee.init.BlockList;
import chylex.hee.init.ItemList;
import chylex.hee.system.util.ItemDamagePair;
import chylex.hee.system.util.MathUtil;
import chylex.hee.tileentity.TileEntityAbstractTable;
import gnu.trove.map.hash.TObjectByteHashMap;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TileEntityExperienceTable
extends TileEntityAbstractTable {
    private static final int[] slotsTop = new int[]{0};
    private static final int[] slotsSides = new int[]{1};
    private static final int[] slotsBottom = new int[]{2};
    private static final TObjectByteHashMap<ItemDamagePair> direct = new TObjectByteHashMap();
    private byte expAmount;

    private static void addDirectConversion(Item item, int bottleAmount) {
        direct.put((Object)new ItemDamagePair(item, -1), (byte)bottleAmount);
    }

    private static void addDirectConversion(Item item, int damage, int bottleAmount) {
        direct.put((Object)new ItemDamagePair(item, damage), (byte)bottleAmount);
    }

    public static boolean addDirectConversion(ItemDamagePair pair, byte bottleAmount) {
        if (TileEntityExperienceTable.getDirectExperience(new ItemStack(pair.item, pair.damage == -1 ? 0 : pair.damage)) > 0) {
            return false;
        }
        direct.put((Object)pair, bottleAmount);
        return true;
    }

    public static byte getDirectExperience(ItemStack is) {
        for (ItemDamagePair idp : direct.keySet()) {
            if (!idp.check(is)) continue;
            return direct.get((Object)idp);
        }
        return 0;
    }

    private static boolean canConvertItem(ItemStack is, World world) {
        Block block;
        if (is.func_77973_b() instanceof ItemBlock && (block = Block.func_149634_a((Item)is.func_77973_b())) != null && block.getExpDrop((IBlockAccess)world, is.func_77960_j(), 0) > 0) {
            return true;
        }
        return TileEntityExperienceTable.getDirectExperience(is) > 0;
    }

    private static byte getExperience(ItemStack is, World world) {
        byte exp;
        Block block;
        if (is.func_77973_b() instanceof ItemBlock && (block = Block.func_149634_a((Item)is.func_77973_b())) != null && (exp = (byte)MathUtil.ceil(0.6 * (double)block.getExpDrop((IBlockAccess)world, is.func_77960_j(), 0))) > 0) {
            return exp;
        }
        return TileEntityExperienceTable.getDirectExperience(is);
    }

    @Override
    public void invalidateInventory() {
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            return;
        }
        this.expAmount = 0;
        if (this.items[0] != null) {
            if (TileEntityExperienceTable.canConvertItem(this.items[0], this.field_145850_b)) {
                this.expAmount = (byte)-1;
                this.timeStep = (short)12;
                this.requiredStardust = (byte)4;
                this.updateComparatorStatus();
            }
        } else {
            this.resetTable();
        }
    }

    @Override
    protected boolean onWorkFinished() {
        if (this.expAmount == -1) {
            this.expAmount = (byte)Math.min(64, TileEntityExperienceTable.getExperience(this.items[0], this.field_145850_b));
        }
        if (this.items[2] == null) {
            this.items[2] = new ItemStack(ItemList.exp_bottle, (int)this.expAmount);
        } else if (this.items[2].field_77994_a + this.expAmount <= this.items[2].func_77976_d()) {
            this.items[2].field_77994_a += this.expAmount;
        } else {
            return false;
        }
        if ((this.items[1].field_77994_a -= this.requiredStardust) <= 0) {
            this.items[1] = null;
        }
        if (--this.items[0].field_77994_a <= 0) {
            this.items[0] = null;
            this.expAmount = 0;
        }
        return true;
    }

    @Override
    public int getHoldingStardust() {
        return this.items[1] == null ? 0 : this.items[1].field_77994_a;
    }

    public int func_70302_i_() {
        return 3;
    }

    @Override
    public void func_70299_a(int slot, ItemStack is) {
        super.func_70299_a(slot, is);
        if (slot == 0) {
            this.invalidateInventory();
        }
    }

    public boolean func_94041_b(int slot, ItemStack is) {
        return slot == 1 ? is.func_77973_b() == ItemList.stardust : slot == 0;
    }

    public int[] func_94128_d(int side) {
        return side == 0 ? slotsBottom : (side == 1 ? slotsTop : slotsSides);
    }

    @Override
    protected String getContainerDefaultName() {
        return "container.experienceTable";
    }

    static {
        TileEntityExperienceTable.addDirectConversion(ItemList.end_powder, 1);
        TileEntityExperienceTable.addDirectConversion(Items.field_151137_ax, 1);
        TileEntityExperienceTable.addDirectConversion(Items.field_151100_aR, 4, 1);
        TileEntityExperienceTable.addDirectConversion(Items.field_151042_j, 1);
        TileEntityExperienceTable.addDirectConversion(ItemList.igneous_rock, 2);
        TileEntityExperienceTable.addDirectConversion(Items.field_151043_k, 2);
        TileEntityExperienceTable.addDirectConversion(Items.field_151128_bU, 2);
        TileEntityExperienceTable.addDirectConversion(Items.field_151166_bC, 3);
        TileEntityExperienceTable.addDirectConversion(Items.field_151045_i, 3);
        TileEntityExperienceTable.addDirectConversion(ItemList.endium_ingot, 4);
        TileEntityExperienceTable.addDirectConversion(Item.func_150898_a((Block)Blocks.field_150371_ca), 8);
        TileEntityExperienceTable.addDirectConversion(Item.func_150898_a((Block)Blocks.field_150339_S), 9);
        TileEntityExperienceTable.addDirectConversion(Item.func_150898_a((Block)Blocks.field_150451_bX), 9);
        TileEntityExperienceTable.addDirectConversion(Item.func_150898_a((Block)Blocks.field_150368_y), 9);
        TileEntityExperienceTable.addDirectConversion(Item.func_150898_a((Block)Blocks.field_150340_R), 18);
        TileEntityExperienceTable.addDirectConversion(Item.func_150898_a((Block)Blocks.field_150475_bE), 27);
        TileEntityExperienceTable.addDirectConversion(Item.func_150898_a((Block)Blocks.field_150484_ah), 27);
        TileEntityExperienceTable.addDirectConversion(Item.func_150898_a((Block)BlockList.endium_block), 36);
    }
}

